/*
 * Decompiled with CFR 0.152.
 */
package com.sas.svcs.authorization.client;

import com.sas.svcs.authorization.client.AuthorizationService;
import com.sas.svcs.authorization.client.ObjectIdentityUtilities;
import com.sas.svcs.commons.ObjectIdentity;
import java.io.Serializable;
import org.springframework.security.access.PermissionEvaluator;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.util.Assert;

public class AuthorizationServicePermissionEvaluator
implements PermissionEvaluator {
    private AuthorizationService authService;

    private void assertCurrentUser(Authentication authentication) {
        Assert.isTrue((boolean)authentication.equals((Object)SecurityContextHolder.getContext().getAuthentication()), (String)"The Authentication object passed into the the permission evaluator was different than the one currently set in the SecurityContext.  Only single person checks are supported in the permission evaluator.");
    }

    public boolean hasPermission(Authentication authentication, Object domainObject, Object permission) {
        this.assertCurrentUser(authentication);
        if (domainObject == null) {
            return true;
        }
        ObjectIdentity objectIdentity = ObjectIdentityUtilities.getSasObjectIdentity(domainObject);
        return this.authService.hasPermission(objectIdentity, permission);
    }

    public boolean hasPermission(Authentication authentication, Serializable targetId, String targetType, Object permission) {
        this.assertCurrentUser(authentication);
        ObjectIdentity objectIdentity = new ObjectIdentity(Long.parseLong(targetType), targetId.toString());
        return this.authService.hasPermission(objectIdentity, permission);
    }

    public AuthorizationService getAuthorizationService() {
        return this.authService;
    }

    public void setAuthorizationService(AuthorizationService authService) {
        this.authService = authService;
    }
}

