/*
 * Decompiled with CFR 0.152.
 */
package com.sas.svcs.authorization.acl.client;

import com.sas.svcs.authorization.acl.client.AccessControlEntry;
import com.sas.svcs.authorization.client.AuthorizationPrincipal;
import com.sas.svcs.commons.ObjectIdentity;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public class AccessControlList
implements Serializable {
    private static final long serialVersionUID = 1L;
    private ObjectIdentity parentId;
    private ObjectIdentity securedObjectId;
    private List<AccessControlEntry> aces = new ArrayList<AccessControlEntry>();
    private AuthorizationPrincipal owner;
    private boolean inheritable;

    public AccessControlList() {
    }

    public AccessControlList(List<AccessControlEntry> aces, AuthorizationPrincipal owner, ObjectIdentity parentId, boolean inheritable) {
        this.aces = aces;
        this.owner = owner;
        this.parentId = parentId;
        this.inheritable = inheritable;
    }

    public AccessControlList(ObjectIdentity securedObjectId, List<AccessControlEntry> aces, AuthorizationPrincipal owner, ObjectIdentity parentId, boolean inheritable) {
        this(aces, owner, parentId, inheritable);
        this.securedObjectId = securedObjectId;
    }

    public ObjectIdentity getSecuredObjectId() {
        return this.securedObjectId;
    }

    public void setSecuredObjectId(ObjectIdentity securedObjectId) {
        this.securedObjectId = securedObjectId;
    }

    public AuthorizationPrincipal getOwner() {
        return this.owner;
    }

    public void setOwner(AuthorizationPrincipal owner) {
        this.owner = owner;
    }

    public List<AccessControlEntry> getAces() {
        return this.aces;
    }

    public void setAces(List<AccessControlEntry> entries) {
        this.aces = entries;
    }

    public void setParentAclId(ObjectIdentity parentAclId) {
        this.parentId = parentAclId;
    }

    public ObjectIdentity getParentAclId() {
        return this.parentId;
    }

    public void setInheritable(boolean inheritable) {
        this.inheritable = inheritable;
    }

    public boolean isInheritable() {
        return this.inheritable;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.aces == null ? 0 : this.aces.hashCode());
        result = 31 * result + (this.inheritable ? 1231 : 1237);
        result = 31 * result + (this.owner == null ? 0 : this.owner.hashCode());
        result = 31 * result + (this.parentId == null ? 0 : this.parentId.hashCode());
        result = 31 * result + (this.securedObjectId == null ? 0 : this.securedObjectId.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AccessControlList other = (AccessControlList)obj;
        if (this.aces == null ? other.aces != null : !this.aces.equals(other.aces)) {
            return false;
        }
        if (this.inheritable != other.inheritable) {
            return false;
        }
        if (this.owner == null ? other.owner != null : !this.owner.equals(other.owner)) {
            return false;
        }
        if (this.parentId == null ? other.parentId != null : !this.parentId.equals((Object)other.parentId)) {
            return false;
        }
        return !(this.securedObjectId == null ? other.securedObjectId != null : !this.securedObjectId.equals((Object)other.securedObjectId));
    }
}

