/*
 * Decompiled with CFR 0.152.
 */
package com.sas.tools.installs.resource;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.Writer;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Enumeration;
import java.util.Locale;
import java.util.Vector;

public class SID {
    private File sidFile;
    private File formattedSidFile;
    private Vector<String> lines = new Vector();
    private Vector<StreamFile> files = new Vector();
    private SetinitFile setinit = null;
    private JMPPerFile jmpPer = null;
    private SPDSLicFile spdsLic = null;
    private TLetterFile tLetter = null;
    private String sidVersion = "";
    private String sidRevision = "";
    private String sidLongPlatform = "";
    private String sidShortPlatform = "";
    private String sidPlatform = "";
    private String sidOrder = "";
    private String sidSetnumid = "";
    private String sidPhoneHome = "";
    private String sidHeader = "";

    public SID(String file) throws FileNotFoundException, IOException {
        this(new File(file));
    }

    public SID(File file) throws FileNotFoundException, IOException {
        this(new FileInputStream(file));
        this.sidFile = file;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SID(InputStream inputStream) throws IOException {
        String error = null;
        try {
            StreamFile streamFile = null;
            String lcLine = null;
            boolean streaming = false;
            boolean NONE = false;
            boolean SID2 = true;
            int INFO = 2;
            int FILEDATA = 3;
            int EOF = 4;
            int section = 0;
            int lineNumber = 0;
            int extraBegins = 0;
            BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream));
            String line = reader.readLine();
            while (error == null && line != null) {
                ++lineNumber;
                this.lines.add(line);
                lcLine = line.toLowerCase(Locale.ENGLISH);
                if (section != 4) {
                    String value;
                    if (streaming) {
                        if (lcLine.startsWith("$_stream=") && (value = this.parseValue(lcLine)) != null) {
                            if (value.indexOf("begin") >= 0) {
                                ++extraBegins;
                            } else if (value.indexOf("end") >= 0) {
                                if (extraBegins > 0) {
                                    --extraBegins;
                                } else {
                                    streaming = false;
                                }
                            }
                        }
                        if (streaming) {
                            streamFile.addToStream(line);
                        } else {
                            streamFile.close();
                            this.files.add(streamFile);
                            streamFile = null;
                        }
                    } else if (lcLine.startsWith("[_sid_]")) {
                        section = 1;
                    } else if (lcLine.startsWith("[_info_]")) {
                        section = 2;
                    } else if (lcLine.startsWith("[_filedata_]")) {
                        section = 3;
                    } else if (lcLine.startsWith("[_eof_]")) {
                        section = 4;
                    } else if (section == 1) {
                        if (lcLine.startsWith("version=")) {
                            this.sidVersion = this.parseValue(line);
                        } else if (lcLine.startsWith("revision=")) {
                            this.sidRevision = this.parseValue(line);
                        } else if (lcLine.startsWith("platform_long=")) {
                            this.sidLongPlatform = this.parseValue(line);
                        } else if (lcLine.startsWith("platform_short=")) {
                            this.sidShortPlatform = this.parseValue(line);
                        } else if (lcLine.startsWith("platform=")) {
                            this.sidPlatform = this.parseValue(line);
                        } else if (lcLine.startsWith("order=")) {
                            this.sidOrder = this.parseValue(line);
                        } else if (lcLine.startsWith("setnumid=")) {
                            this.sidSetnumid = this.parseValue(line);
                        } else if (lcLine.startsWith("ph_agreement=")) {
                            this.sidPhoneHome = this.parseValue(line);
                        } else if (lcLine.startsWith("sid_header=")) {
                            this.sidHeader = this.parseValue(line);
                        }
                    } else if (section != 2 && section == 3) {
                        if (lcLine.startsWith("$_filename=")) {
                            if (streamFile != null) {
                                error = "Previous file stream not closed before beginning next file in SID";
                            } else {
                                value = this.parseValue(line);
                                streamFile = value.equalsIgnoreCase("setinit.sas") || value.equalsIgnoreCase("setinit.sss") ? new SetinitFile() : (value.equalsIgnoreCase("jmp.per") ? new JMPPerFile() : (value.equalsIgnoreCase("spds.lic") ? new SPDSLicFile() : (value.equalsIgnoreCase("tletter.txt") ? new TLetterFile() : new StreamFile())));
                                streamFile.setFile(this.parseValue(line));
                            }
                        } else if (lcLine.startsWith("$_path=")) {
                            if (streamFile != null) {
                                streamFile.setPath(this.parseValue(line));
                            } else {
                                error = "A filename must be specified prior to a path";
                            }
                        } else if (lcLine.startsWith("$_date=")) {
                            if (streamFile != null) {
                                streamFile.setDate(this.parseValue(line));
                            } else {
                                error = "A filename must be specified prior to a date";
                            }
                        } else if (lcLine.startsWith("$_time=")) {
                            if (streamFile != null) {
                                streamFile.setTime(this.parseValue(line));
                            } else {
                                error = "A filename must be specified prior to a time";
                            }
                        } else if (lcLine.startsWith("$_stream=") && (value = this.parseValue(lcLine)) != null) {
                            if (value.indexOf("begin") >= 0) {
                                if (streamFile != null) {
                                    streaming = true;
                                } else {
                                    error = "A filename must be specified prior to beginning of stream";
                                }
                            } else if (value.indexOf("end") >= 0) {
                                error = "File stream not begun before ending file in SID";
                            }
                        }
                    }
                }
                line = reader.readLine();
            }
            if (error == null && section != 4) {
                error = "End of file reached before EOF section in SID";
            }
            if (error != null) {
                throw new IOException("Error on line " + lineNumber + " - " + error);
            }
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private String parseValue(String line) {
        String value = null;
        int index = line.indexOf("=");
        if (index > 0) {
            value = line.substring(index + 1).trim();
        }
        return value;
    }

    private int getDayCount(Date startDate, Date endDate) {
        int days = 0;
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(endDate);
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        endDate = calendar.getTime();
        calendar.setTime(startDate);
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        int cmp = calendar.getTime().compareTo(endDate);
        int offset = 0;
        if (cmp < 0) {
            offset = 1;
        } else if (cmp > 0) {
            offset = -1;
        }
        while (cmp * offset < 0) {
            calendar.add(5, offset);
            days += offset;
            cmp = calendar.getTime().compareTo(endDate);
        }
        return days;
    }

    public SetinitFile getSetinit() {
        return this.setinit;
    }

    public JMPPerFile getJMPPer() {
        return this.jmpPer;
    }

    public SPDSLicFile getSPDSLic() {
        return this.spdsLic;
    }

    public TLetterFile getTLetter() {
        return this.tLetter;
    }

    public boolean isValidPlatform(String platform) {
        return platform == null || platform.equalsIgnoreCase(this.sidShortPlatform);
    }

    public boolean isValidVersion(String version) {
        return version == null || version.equalsIgnoreCase(this.sidVersion);
    }

    public boolean isValidRevision(String revision) {
        return revision == null || revision.equalsIgnoreCase(this.sidRevision);
    }

    public File getSIDFile() {
        return this.sidFile;
    }

    public String getOrder() {
        return this.sidOrder;
    }

    public String getSetnumid() {
        return this.sidSetnumid;
    }

    public String getPhoneHome() {
        return this.sidPhoneHome;
    }

    public String getSIDHeader() {
        return this.sidHeader;
    }

    public String getPlatformShort() {
        return this.sidShortPlatform;
    }

    public String getPlatformLong() {
        return this.sidLongPlatform;
    }

    public String getVersion() {
        return this.sidVersion;
    }

    public String getRevision() {
        return this.sidRevision;
    }

    public boolean extractAll(String target) throws IOException {
        return this.extractAll(new File(target));
    }

    public boolean extractAll(File target) throws IOException {
        boolean retVal = true;
        Enumeration<StreamFile> e = this.files.elements();
        while (e.hasMoreElements()) {
            if (e.nextElement().extract(target)) continue;
            retVal = false;
        }
        return retVal;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean write(File file) throws IOException {
        boolean retVal = false;
        try (PrintWriter writer = null;){
            writer = new PrintWriter(new BufferedWriter(new FileWriter(file)));
            Enumeration<String> e = this.lines.elements();
            while (e.hasMoreElements()) {
                writer.println(e.nextElement());
            }
            retVal = !writer.checkError();
        }
        return retVal;
    }

    public boolean write(String file) throws IOException {
        return this.write(new File(file));
    }

    public boolean writeFormattedSIDFile(File dir) {
        boolean retVal = false;
        if (dir.isDirectory()) {
            File file = new File(dir, this.sidFile.getName());
            try {
                retVal = this.write(file);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            if (retVal) {
                this.formattedSidFile = file;
            }
        }
        return retVal;
    }

    public boolean writeFormattedSIDFile(String dir) {
        return this.writeFormattedSIDFile(new File(dir));
    }

    public File getFormattedSIDFile() {
        return this.formattedSidFile;
    }

    public class TletterData {
        private String product = "";
        private String expiration = "";

        protected void setProduct(String product) {
            this.product = product;
        }

        public String getProduct() {
            return this.product;
        }

        protected void setExpiration(String expiration) {
            this.expiration = expiration;
        }

        public String getExpiration() {
            return this.expiration;
        }
    }

    public class TLetterFile
    extends StreamFile {
        private Vector list;

        public TLetterFile() {
            this.list = new Vector();
        }

        @Override
        protected void addToStream(String line) {
            super.addToStream(line);
            String[] parts = line.split("\t");
            if (parts.length == 2 && parts[0].length() > 0 && parts[1].length() > 0) {
                TletterData tletterData = new TletterData();
                tletterData.setProduct(parts[0]);
                tletterData.setExpiration(parts[1]);
                this.list.add(tletterData);
            }
        }

        @Override
        protected void close() {
            super.close();
            SID.this.tLetter = this;
        }

        public Vector getList() {
            return this.list;
        }
    }

    public class SPDSLicFile
    extends StreamFile {
        private String expire;
        private String grace;
        private String warn;
        private Date expireDate;
        private Date graceDate;
        private Date warnDate;
        private Date deathDate;
        private int daysToExpire;
        private int daysToDeath;

        public SPDSLicFile() {
            this.daysToExpire = 0;
            this.daysToDeath = 0;
        }

        @Override
        protected void addToStream(String line) {
            super.addToStream(line);
            String parseLine = line.replaceAll("\\s", "");
            if (parseLine.startsWith("EXPIRE=")) {
                this.expire = SID.this.parseValue(line);
            }
            if (parseLine.startsWith("GRACE=")) {
                this.grace = SID.this.parseValue(line);
            }
            if (parseLine.startsWith("WARN=")) {
                this.warn = SID.this.parseValue(line);
            }
        }

        @Override
        protected void close() {
            super.close();
            Calendar calendar = null;
            if (this.expire != null) {
                if (this.grace == null) {
                    this.grace = "0";
                }
                if (this.warn == null) {
                    this.warn = "0";
                }
                this.expireDate = new SimpleDateFormat("ddMMMyyyy", Locale.US).parse(this.expire, new ParsePosition(0));
                if (this.expireDate != null) {
                    calendar = Calendar.getInstance();
                    calendar.setTime(this.expireDate);
                }
                this.daysToExpire = SID.this.getDayCount(new Date(), this.expireDate);
            }
            if (calendar != null && this.grace != null) {
                calendar.add(5, 1);
                this.graceDate = calendar.getTime();
                calendar.add(5, Integer.parseInt(this.grace) - 1);
            }
            if (calendar != null && this.warn != null) {
                calendar.add(5, 1);
                this.warnDate = calendar.getTime();
                calendar.add(5, Integer.parseInt(this.warn) - 1);
            }
            if (calendar != null) {
                calendar.add(5, 1);
                this.deathDate = calendar.getTime();
                this.daysToDeath = this.daysToExpire + SID.this.getDayCount(this.expireDate, this.deathDate);
            }
            SID.this.spdsLic = this;
        }

        public int getDaysToExpire() {
            return this.daysToExpire;
        }

        public int getDaysToDeath() {
            return this.daysToDeath;
        }
    }

    public class JMPPerFile
    extends StreamFile {
        private String platform;
        private String architecture;
        private String release;
        private String siteID;
        private String start;
        private String expire;
        private Date startDate;
        private Date expireDate;
        private Date graceDate;
        private Date warnDate;
        private Date deathDate;
        private int daysToStart;
        private int daysToExpire;
        private int daysToDeath;

        public JMPPerFile() {
            this.daysToStart = 0;
            this.daysToExpire = 0;
            this.daysToDeath = 0;
        }

        @Override
        protected void addToStream(String line) {
            int endIndex;
            super.addToStream(line);
            int startIndex = line.indexOf("Platform=");
            if (startIndex >= 0) {
                endIndex = line.length();
                this.platform = line.substring(startIndex += 9, endIndex).trim();
            }
            if ((startIndex = line.indexOf("Architecture=")) >= 0) {
                endIndex = line.length();
                this.architecture = line.substring(startIndex += 13, endIndex).trim();
            }
            if ((startIndex = line.indexOf("Release=")) >= 0) {
                endIndex = line.length();
                this.release = line.substring(startIndex += 8, endIndex).trim();
            }
            if ((startIndex = line.indexOf("SiteID=")) >= 0) {
                endIndex = line.length();
                this.siteID = line.substring(startIndex += 7, endIndex).trim();
            }
            if ((startIndex = line.indexOf("Starts=")) >= 0) {
                endIndex = line.length();
                this.start = line.substring(startIndex += 7, endIndex).trim();
            }
            if ((startIndex = line.indexOf("Expires=")) >= 0) {
                endIndex = line.length();
                this.expire = line.substring(startIndex += 8, endIndex).trim();
            }
        }

        @Override
        protected void close() {
            super.close();
            Calendar calendar = null;
            if (this.start != null) {
                this.startDate = new SimpleDateFormat("ddMMMyyyy", Locale.US).parse(this.start, new ParsePosition(0));
                if (this.startDate != null) {
                    calendar = Calendar.getInstance();
                    calendar.setTime(this.startDate);
                }
                this.daysToStart = SID.this.getDayCount(new Date(), this.startDate);
            }
            calendar = null;
            if (this.expire != null) {
                this.expireDate = new SimpleDateFormat("ddMMMyyyy", Locale.US).parse(this.expire, new ParsePosition(0));
                if (this.expireDate != null) {
                    calendar = Calendar.getInstance();
                    calendar.setTime(this.expireDate);
                }
                this.daysToExpire = SID.this.getDayCount(new Date(), this.expireDate);
            }
            if (calendar != null) {
                calendar.add(5, 1);
                this.graceDate = calendar.getTime();
                calendar.add(5, 44);
            }
            if (calendar != null) {
                calendar.add(5, 1);
                this.warnDate = calendar.getTime();
                calendar.add(5, 44);
            }
            if (calendar != null) {
                calendar.add(5, 1);
                this.deathDate = calendar.getTime();
                this.daysToDeath = this.daysToExpire + SID.this.getDayCount(this.expireDate, this.deathDate);
            }
            SID.this.jmpPer = this;
        }

        public String getPlatform() {
            return this.platform;
        }

        public String getArchitecture() {
            return this.architecture;
        }

        public String getRelease() {
            return this.release;
        }

        public String getSiteID() {
            return this.siteID;
        }

        public int getDaysToStart() {
            return this.daysToStart;
        }

        public int getDaysToExpire() {
            return this.daysToExpire;
        }

        public int getDaysToDeath() {
            return this.daysToDeath;
        }
    }

    public class SetinitFile
    extends StreamFile {
        private String osName;
        private String expire;
        private String grace;
        private String warn;
        private Date expireDate;
        private Date graceDate;
        private Date warnDate;
        private Date deathDate;
        private int daysToExpire;
        private int daysToDeath;

        public SetinitFile() {
            this.daysToExpire = 0;
            this.daysToDeath = 0;
        }

        @Override
        protected void addToStream(String line) {
            int endIndex;
            super.addToStream(line);
            int startIndex = line.indexOf("OSNAME='");
            if (startIndex >= 0 && (endIndex = line.indexOf(39, startIndex += 8)) > 0) {
                this.osName = line.substring(startIndex, endIndex);
            }
            if ((startIndex = line.indexOf("EXPIRE='")) >= 0 && (endIndex = line.indexOf("'D", startIndex += 8)) > 0 && endIndex - startIndex == 9) {
                this.expire = line.substring(startIndex, endIndex);
            }
            if ((startIndex = line.indexOf("GRACE=")) >= 0) {
                endIndex = line.indexOf(32, startIndex += 6);
                if (endIndex < 0) {
                    endIndex = line.length();
                }
                this.grace = line.substring(startIndex, endIndex);
            }
            if ((startIndex = line.indexOf("WARN=")) >= 0) {
                endIndex = line.indexOf(32, startIndex += 5);
                if (endIndex < 0) {
                    endIndex = line.length();
                }
                this.warn = line.substring(startIndex, endIndex);
            }
        }

        @Override
        protected void close() {
            super.close();
            Calendar calendar = null;
            if (this.expire != null) {
                if (this.grace == null) {
                    this.grace = "62";
                }
                if (this.warn == null) {
                    this.warn = "31";
                }
                this.expireDate = new SimpleDateFormat("ddMMMyyyy", Locale.US).parse(this.expire, new ParsePosition(0));
                if (this.expireDate != null) {
                    calendar = Calendar.getInstance();
                    calendar.setTime(this.expireDate);
                }
                this.daysToExpire = SID.this.getDayCount(new Date(), this.expireDate);
            }
            if (calendar != null && this.grace != null) {
                calendar.add(5, 1);
                this.graceDate = calendar.getTime();
                calendar.add(5, Integer.parseInt(this.grace) - 1);
            }
            if (calendar != null && this.warn != null) {
                calendar.add(5, 1);
                this.warnDate = calendar.getTime();
                calendar.add(5, Integer.parseInt(this.warn) - 1);
            }
            if (calendar != null) {
                calendar.add(5, 1);
                this.deathDate = calendar.getTime();
                this.daysToDeath = this.daysToExpire + SID.this.getDayCount(this.expireDate, this.deathDate);
            }
            SID.this.setinit = this;
        }

        public boolean isValidOSNAME(String osName, String sasinstallPlat) {
            boolean valid = false;
            String[] osnames = new String[]{};
            if (osName == null || this.osName == null) {
                valid = true;
            } else if (this.osName.trim().length() == 0) {
                valid = true;
            } else if ("WIN_95".equals(osName)) {
                osnames = new String[]{"WIN", "WIN_NTE", "WIN_95"};
            } else if ("WIN_98".equals(osName)) {
                osnames = new String[]{"WIN", "WIN_NTE", "WIN_98"};
            } else if ("WIN_ME".equals(osName)) {
                osnames = new String[]{"WIN", "WIN_NTE", "WIN_ME"};
            } else if ("WIN_NT".equals(osName)) {
                osnames = new String[]{"WIN", "WIN_NTE", "WIN_NT"};
            } else if ("WIN_NTSV".equals(osName)) {
                osnames = new String[]{"WIN_NTSV", "WIN_NTE"};
            } else if ("WIN_PRO".equals(osName)) {
                osnames = new String[]{"WIN", "WIN_NTE", "WIN_PRO"};
            } else if ("WIN_SRV".equals(osName)) {
                osnames = new String[]{"WIN_NTSV", "WIN_NTE", "WIN_SRV"};
            } else if ("WIN_ASRV".equals(osName)) {
                osnames = new String[]{"WIN_NTSV", "WIN_NTE", "WIN_ASRV"};
            } else if ("WIN_DSRV".equals(osName)) {
                osnames = new String[]{"WIN_DCSV", "WIN_NTE", "WIN_DSRV"};
            } else if ("XP_HOME".equals(osName)) {
                osnames = new String[]{"W32_WKS", "W32_E", "WIN_NTE", "XP_HOME", "WIN"};
            } else if ("XP_PRO".equals(osName)) {
                osnames = new String[]{"W32_WKS", "W32_E", "WIN_NTE", "XP_PRO", "WIN"};
            } else if ("NET_SRV".equals(osName)) {
                osnames = new String[]{"W32_SV", "W32_E", "WIN_NTE", "NET_SRV", "WIN_NTSV"};
            } else if ("NET_ASRV".equals(osName)) {
                osnames = new String[]{"W32_SV", "W32_E", "WIN_NTE", "NET_ASRV", "WIN_NTSV"};
            } else if ("NET_DSRV".equals(osName)) {
                osnames = new String[]{"W32_SV", "W32_E", "WIN_NTE", "NET_DSRV", "WIN_DCSV"};
            } else if ("X64_HOME".equals(osName)) {
                osnames = sasinstallPlat == null ? new String[]{"WX64_WKS", "WX64_E", "WIN_NTE", "X64_HOME", "WIN"} : new String[]{"W32_WKS", "W32_E", "WIN_NTE", "XP_HOME", "WIN"};
            } else if ("X64_PRO".equals(osName)) {
                osnames = sasinstallPlat == null ? new String[]{"WX64_WKS", "WX64_E", "WIN_NTE", "X64_PRO", "WIN"} : new String[]{"W32_WKS", "W32_E", "WIN_NTE", "XP_PRO", "WIN"};
            } else if ("X64_SRV".equals(osName)) {
                osnames = sasinstallPlat == null ? new String[]{"WX64_SV", "WX64_E", "WIN_NTE", "X64_SRV", "WIN_NTSV"} : new String[]{"W32_SV", "W32_E", "WIN_NTE", "NET_SRV", "WIN_NTSV"};
            } else if ("X64_ESRV".equals(osName)) {
                osnames = sasinstallPlat == null ? new String[]{"WX64_SV", "WX64_E", "WIN_NTE", "X64_ESRV", "WIN_NTSV"} : new String[]{"W32_SV", "W32_E", "WIN_NTE", "NET_ASRV", "WIN_NTSV"};
            } else if ("X64_DSRV".equals(osName)) {
                osnames = sasinstallPlat == null ? new String[]{"WX64_SV", "WX64_E", "WIN_NTE", "X64_DSRV", "WIN_DCSV"} : new String[]{"W32_SV", "W32_E", "WIN_NTE", "NET_DSRV", "WIN_DCSV"};
            } else if ("W64_HOME".equals(osName)) {
                osnames = new String[]{"WIPF_WKS", "WIPF_E", "WIN_NTE", "W64_HOME", "WIN"};
            } else if ("W64_PRO".equals(osName)) {
                osnames = new String[]{"WIPF_WKS", "WIPF_E", "WIN_NTE", "W64_PRO", "WIN"};
            } else if ("W64_SRV".equals(osName)) {
                osnames = new String[]{"WIPF_SV", "WIPF_E", "WIN_NTE", "W64_SRV", "WIN_NTSV"};
            } else if ("W64_ASRV".equals(osName)) {
                osnames = new String[]{"WIPF_SV", "WIPF_E", "WIN_NTE", "W64_ASRV", "WIN_NTSV"};
            } else if ("W64_DSRV".equals(osName)) {
                osnames = new String[]{"WIPF_SV", "WIPF_E", "WIN_NTE", "W64_DSRV", "WIN_DCSV"};
            } else if ("W32_VSHOME".equals(osName)) {
                osnames = new String[]{"W32_WKS", "W32_E", "WIN_NTE", "WIN_VSHOME", "WIN"};
            } else if ("W32_VSPRO".equals(osName)) {
                osnames = new String[]{"W32_WKS", "W32_E", "WIN_NTE", "WIN_VSPRO", "WIN"};
            } else if ("W32_SRV08".equals(osName)) {
                osnames = new String[]{"W32_SV", "W32_E", "WIN_NTE", "WIN_SRV08", "WIN_NTSV"};
            } else if ("W32_ESRV08".equals(osName)) {
                osnames = new String[]{"W32_SV", "W32_E", "WIN_NTE", "WIN_ESRV08", "WIN_NTSV"};
            } else if ("W32_DSRV08".equals(osName)) {
                osnames = new String[]{"W32_SV", "W32_E", "WIN_NTE", "WIN_DSRV08", "WIN_DCSV"};
            } else if ("X64_VSHOME".equals(osName)) {
                osnames = sasinstallPlat == null ? new String[]{"WX64_WKS", "WX64_E", "WIN_NTE", "X64_VSHOME", "WIN"} : new String[]{"W32_WKS", "W32_E", "WIN_NTE", "WIN_VSHOME", "WIN"};
            } else if ("X64_VSPRO".equals(osName)) {
                osnames = sasinstallPlat == null ? new String[]{"WX64_WKS", "WX64_E", "WIN_NTE", "X64_VSPRO", "WIN"} : new String[]{"W32_WKS", "W32_E", "WIN_NTE", "WIN_VSPRO", "WIN"};
            } else if ("X64_SRV08".equals(osName)) {
                osnames = sasinstallPlat == null ? new String[]{"WX64_SV", "WX64_E", "WIN_NTE", "X64_SRV08", "WIN_NTSV"} : new String[]{"W32_SV", "W32_E", "WIN_NTE", "WIN_SRV08", "WIN_NTSV"};
            } else if ("X64_ESRV08".equals(osName)) {
                osnames = sasinstallPlat == null ? new String[]{"WX64_SV", "WX64_E", "WIN_NTE", "X64_ESRV08", "WIN_NTSV"} : new String[]{"W32_SV", "W32_E", "WIN_NTE", "WIN_ESRV08", "WIN_NTSV"};
            } else if ("X64_DSRV08".equals(osName)) {
                osnames = sasinstallPlat == null ? new String[]{"WX64_SV", "WX64_E", "WIN_NTE", "X64_DSRV08", "WIN_DCSV"} : new String[]{"W32_SV", "W32_E", "WIN_NTE", "WIN_DSRV08", "WIN_DCSV"};
            } else if ("W64_VSHOME".equals(osName)) {
                osnames = new String[]{"WIPF_WKS", "WIPF_E", "WIN_NTE", "W64_VSHOME", "WIN"};
            } else if ("W64_VSPRO".equals(osName)) {
                osnames = new String[]{"WIPF_WKS", "WIPF_E", "WIN_NTE", "W64_VSPRO", "WIN"};
            } else if ("W64_SRV08".equals(osName)) {
                osnames = new String[]{"WIPF_SV", "WIPF_E", "WIN_NTE", "W64_SRV08", "WIN_NTSV"};
            } else if ("W64_ESRV08".equals(osName)) {
                osnames = new String[]{"WIPF_SV", "WIPF_E", "WIN_NTE", "W64_ESRV08", "WIN_NTSV"};
            } else if ("W64_DSRV08".equals(osName)) {
                osnames = new String[]{"WIPF_SV", "WIPF_E", "WIN_NTE", "W64_DSRV08", "WIN_DCSV"};
            }
            for (int i = 0; !valid && i < osnames.length; ++i) {
                if (!osnames[i].equalsIgnoreCase(this.osName)) continue;
                valid = true;
            }
            return valid;
        }

        public int getDaysToExpire() {
            return this.daysToExpire;
        }

        public int getDaysToDeath() {
            return this.daysToDeath;
        }
    }

    private class StreamFile {
        private Vector<String> stream = new Vector();
        private String file = "";
        private String path = "";
        private String date = "";
        private String time = "";

        protected StreamFile() {
        }

        protected void setFile(String file) {
            this.file = file;
        }

        protected void setPath(String path) {
            this.path = path;
        }

        protected void setDate(String date) {
            this.date = date;
        }

        protected void setTime(String time) {
            this.time = time;
        }

        protected void addToStream(String line) {
            this.stream.add(line);
        }

        protected void close() {
        }

        public boolean extract(String target) throws IOException {
            return this.extract(new File(target));
        }

        public boolean extract(File target) throws IOException {
            boolean retVal = false;
            File file = new File(target, this.path.replace("\\".toCharArray()[0], File.separatorChar) + File.separator + this.file);
            file.getParentFile().mkdirs();
            return this.extract(new PrintWriter(file, "UTF-8"));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean extract(Writer writer) throws IOException {
            boolean retVal = false;
            try {
                PrintWriter pw = new PrintWriter(writer);
                Enumeration<String> e = this.stream.elements();
                while (e.hasMoreElements()) {
                    pw.println(e.nextElement());
                }
                retVal = !pw.checkError();
            }
            finally {
                if (writer != null) {
                    writer.close();
                }
            }
            return retVal;
        }
    }
}

