/*
 * Decompiled with CFR 0.152.
 */
package com.sas.tools.installs.it.vjr;

import com.sas.tools.installs.it.InstallException;
import com.sas.tools.installs.it.schema.install.gen.Extract;
import com.sas.tools.installs.it.tasks.ExtractTask;
import com.sas.tools.installs.it.vjr.SASVersion;
import com.sas.tools.installs.it.vjr.VJRException;
import com.sas.tools.installs.it.vjr.VJRManager;
import com.sas.tools.installs.it.vjr.VJRPluginZip;
import java.io.File;
import java.util.HashMap;

public class VJRExtractTask
extends ExtractTask {
    protected VJRPluginZip m_pluginZip = null;
    private int fileCount = 0;

    public VJRExtractTask(String vjrHome, VJRPluginZip pluginZip) {
        this.m_pluginZip = pluginZip;
        super.setAltSku(this.m_pluginZip.toString());
        Extract data = new Extract();
        data.setFilename(pluginZip.getFile().getName());
        data.setHome(vjrHome);
        data.setSource("vjr");
        super.setData(data);
    }

    @Override
    public String getSubType() {
        return "vjr";
    }

    @Override
    protected void loadMetaData(String metaFile) {
        this._installMap = new HashMap();
        this._directoryMap = new HashMap();
        this._deleteMap = new HashMap();
        try {
            this.setJaxbZip(this.m_pluginZip.getZipMetadata());
        }
        catch (Exception e) {
            throw new InstallException(2, this, this.getBundle().messageString("ZipExtractor.MetadataFileReadError", metaFile), "Error reading the " + metaFile + " package data file", e);
        }
        this.fileCount += this.getJaxbZip().getContents().getEntry().size();
        if (this.fileCount == 0) {
            this.log.warn("WARNING: fileCount for " + metaFile + ": " + this.fileCount);
        } else {
            this.log.info("DEBUG: fileCount for " + metaFile + ": " + this.fileCount);
        }
    }

    @Override
    public int getFileCount() {
        return this.fileCount;
    }

    public SASVersion getSASVersion() {
        return this.m_pluginZip.getSASVersion();
    }

    public VJRPluginZip getPluginZip() {
        return this.m_pluginZip;
    }

    @Override
    public void preExecute() throws Exception {
        this.log.info("Pre-processing VJR zip file: " + super.getFilename());
        super.preExecute();
    }

    @Override
    public void generateUninstall() {
    }

    @Override
    protected void openZipFile() {
        try {
            this._zip = this.m_pluginZip.getZipFile();
        }
        catch (Exception e) {
            throw new InstallException(2, this, this.getBundle().messageString("ZipExtractor.ErrorOpeningZip", this.getFilename()), "Error opening zip " + this.getFilename(), e);
        }
    }

    @Override
    protected void closeZipFile() {
        try {
            this.m_pluginZip.closeZipFile();
        }
        catch (Exception e) {
            throw new InstallException(2, this, this.getBundle().messageString("ZipExtractor.ErrorClosingZip", this.getFilename()), "Error closing zip " + this.getFilename(), e);
        }
    }

    @Override
    public String getFilename() {
        if (this.dataProperties.get("filename") == null) {
            String name = ((Extract)this.getData()).getFilename();
            if (this.isUndo()) {
                this.updateFilenameForUndo(name);
            } else {
                this._sourceFile = this.m_pluginZip.getFile().getAbsolutePath();
            }
            this.dataProperties.put("filename", this._sourceFile);
        }
        return (String)this.dataProperties.get("filename");
    }

    @Override
    protected File getZipFile() {
        return this.m_pluginZip.getFile();
    }

    @Override
    public void execute() throws InstallException {
        this.log.info("Processing VJR zip file: " + super.getFilename());
        super.execute();
        try {
            VJRManager.getInstance().notifyCompletedExtractTask(this);
        }
        catch (VJRException vjre) {
            throw new InstallException(2, this, this.getBundle().messageString("ZipExtractor.VJRPostProcessingError", vjre.getMessage()), "Error with post processing of SASVersionedJarRepository content: " + vjre.getMessage(), vjre);
        }
    }
}

