/*
 * Decompiled with CFR 0.152.
 */
package com.sas.tools.installs.it.vjr;

import com.sas.tools.installs.it.vjr.InvalidSASVersionException;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class SASVersion
implements Comparable<SASVersion> {
    protected String m_versionedName = null;
    protected String m_version = null;
    protected String m_pluginName = null;
    protected int major = 0;
    protected int minor = 0;
    protected int micro = 0;
    protected String sequence = "";
    protected int hotfix = 0;
    protected int date = 0;
    protected int time = 0;
    private String track = "";
    private boolean m_isStandardVersion = true;

    public SASVersion(String versionedName) throws InvalidSASVersionException {
        this.m_versionedName = versionedName;
        if (this.m_versionedName == null || this.m_versionedName.length() == 0) {
            throw new NullPointerException("Cannot construct SASVersion with a null or empty version string!");
        }
        this.parseVersionString(this.m_versionedName);
    }

    public String getVersion() {
        return this.m_version;
    }

    public String getPluginName() {
        return this.m_pluginName;
    }

    public int getMajorVersion() {
        return this.major;
    }

    public int getMinorVersion() {
        return this.minor;
    }

    public int getMicroVersion() {
        return this.micro;
    }

    public String getSequence() {
        return this.sequence;
    }

    public int getSequenceAsNum() {
        return Integer.parseInt(this.sequence);
    }

    public int getHotFixNum() {
        return this.hotfix;
    }

    public String getTrackSpecifier() {
        return this.track;
    }

    public int getDate() {
        return this.date;
    }

    public int getTime() {
        return this.time;
    }

    public boolean isStandardVersion() {
        return this.m_isStandardVersion;
    }

    public boolean containsVersion(String version) {
        boolean ret = true;
        if (version != null) {
            try {
                StringTokenizer st = new StringTokenizer(version, ".");
                if (st.hasMoreTokens()) {
                    int major = Integer.parseInt(st.nextToken());
                    if (major != this.getMajorVersion()) {
                        ret = false;
                    } else if (st.hasMoreTokens()) {
                        int minor = Integer.parseInt(st.nextToken());
                        if (minor != this.getMinorVersion()) {
                            ret = false;
                        } else if (st.hasMoreTokens()) {
                            String seq;
                            int micro = Integer.parseInt(st.nextToken());
                            if (micro != this.getMicroVersion()) {
                                ret = false;
                            } else if (st.hasMoreTokens() && !(seq = st.nextToken()).equalsIgnoreCase(this.getSequence())) {
                                ret = false;
                            }
                        }
                    }
                }
            }
            catch (NumberFormatException nfe) {
                ret = false;
            }
        }
        return ret;
    }

    public int hashCode() {
        return this.m_pluginName.hashCode();
    }

    public boolean equals(Object obj) {
        SASVersion anotherVersion;
        boolean ret = false;
        if (obj instanceof SASVersion && this.compareTo(anotherVersion = (SASVersion)obj) == 0) {
            ret = true;
        }
        return ret;
    }

    @Override
    public int compareTo(SASVersion anotherVersion) {
        int ret = this.m_pluginName.compareTo(anotherVersion.getPluginName());
        if (ret == 0) {
            int[] a = new int[]{this.getMajorVersion(), this.getMinorVersion(), this.getMicroVersion(), this.getDate(), this.getTime(), this.getHotFixNum()};
            int[] b = new int[]{anotherVersion.getMajorVersion(), anotherVersion.getMinorVersion(), anotherVersion.getMicroVersion(), anotherVersion.getDate(), anotherVersion.getTime(), anotherVersion.getHotFixNum()};
            for (int i = 0; i < a.length; ++i) {
                if (a[i] < b[i]) {
                    ret = -1;
                    break;
                }
                if (a[i] <= b[i]) continue;
                ret = 1;
                break;
            }
            if (ret == 0 && (ret = this.sequence.compareTo(anotherVersion.getSequence())) == 0) {
                ret = this.track.compareTo(anotherVersion.getTrackSpecifier());
            }
        }
        return ret;
    }

    private void parseVersionString(String version) throws InvalidSASVersionException {
        boolean foundSASVersion = false;
        try {
            String matchedGroup;
            Pattern pattern;
            Matcher matcher;
            if (!foundSASVersion && (matcher = (pattern = Pattern.compile("^(.*)_((\\d+)\\.(\\d+)\\.(\\d+)\\.(\\d{3})(\\d{3})_([-_a-zA-Z0-9]+)_(\\d{8})_(\\d+))$")).matcher(version)).find()) {
                foundSASVersion = true;
                this.m_pluginName = matcher.group(1);
                this.m_version = matcher.group(2);
                this.major = new Integer(matcher.group(3));
                this.minor = new Integer(matcher.group(4));
                this.micro = new Integer(matcher.group(5));
                this.sequence = matcher.group(6);
                this.hotfix = new Integer(matcher.group(7));
                this.track = matcher.group(8);
                this.date = new Integer(matcher.group(9));
                this.time = new Integer(matcher.group(10));
            }
            if (!foundSASVersion && (matcher = (pattern = Pattern.compile("^(.*)_((\\d+)(\\d{2})(\\d{3})\\.\\d+\\.\\d+\\.(\\d{8})(\\d+)_([-_a-zA-Z0-9]+))$")).matcher(version)).find()) {
                foundSASVersion = true;
                this.m_pluginName = matcher.group(1);
                this.m_version = matcher.group(2);
                this.major = new Integer(matcher.group(3));
                this.minor = new Integer(matcher.group(4));
                this.micro = new Integer(matcher.group(5));
                this.date = new Integer(matcher.group(6));
                this.time = new Integer(matcher.group(7));
                this.track = matcher.group(8);
            }
            if (!foundSASVersion && (matcher = (pattern = Pattern.compile("^(.*)_((\\d+)\\.(\\d+)\\.(\\d+)\\.([a-zA-Z0-9]+)_SAS_(\\d{8})(\\d+))$")).matcher(version)).find()) {
                foundSASVersion = true;
                this.m_pluginName = matcher.group(1);
                this.m_version = matcher.group(2);
                this.major = new Integer(matcher.group(3));
                this.minor = new Integer(matcher.group(4));
                this.micro = new Integer(matcher.group(5));
                this.sequence = matcher.group(6);
                this.date = new Integer(matcher.group(7));
                this.time = new Integer(matcher.group(8));
            }
            if (!foundSASVersion && (matcher = (pattern = Pattern.compile("^(.*)_((\\d+)\\.(\\d+)\\.(\\d+)\\.[vI]?(\\d{8})-?(\\d*)([a-zA-Z]?))$")).matcher(version)).find()) {
                foundSASVersion = true;
                this.m_pluginName = matcher.group(1);
                this.m_version = matcher.group(2);
                this.major = new Integer(matcher.group(3));
                this.minor = new Integer(matcher.group(4));
                this.micro = new Integer(matcher.group(5));
                this.date = new Integer(matcher.group(6));
                matchedGroup = matcher.group(7);
                if (matchedGroup != null && matchedGroup.length() > 0) {
                    this.time = new Integer(matchedGroup);
                }
                if ((matchedGroup = matcher.group(8)) != null && matchedGroup.length() > 0) {
                    this.sequence = matchedGroup;
                }
            }
            if (!foundSASVersion && (matcher = (pattern = Pattern.compile("^(.*)_((\\d+)\\.(\\d+)\\.(\\d+)\\.[vI]?([a-zA-Z0-9]+))$")).matcher(version)).find()) {
                foundSASVersion = true;
                this.m_isStandardVersion = false;
                this.m_pluginName = matcher.group(1);
                this.m_version = matcher.group(2);
                this.major = new Integer(matcher.group(3));
                this.minor = new Integer(matcher.group(4));
                this.micro = new Integer(matcher.group(5));
                matchedGroup = matcher.group(6);
                if (matchedGroup != null && matchedGroup.length() > 0) {
                    this.sequence = matchedGroup;
                }
            }
            if (!foundSASVersion && (matcher = (pattern = Pattern.compile("^(.*)_((\\d+)\\.(\\d+)\\.(\\d+))$")).matcher(version)).find()) {
                foundSASVersion = true;
                this.m_isStandardVersion = false;
                this.m_pluginName = matcher.group(1);
                this.m_version = matcher.group(2);
                this.major = new Integer(matcher.group(3));
                this.minor = new Integer(matcher.group(4));
                this.micro = new Integer(matcher.group(5));
            }
        }
        catch (Exception e) {
            throw new InvalidSASVersionException(version, e);
        }
        if (!foundSASVersion) {
            throw new InvalidSASVersionException(version);
        }
    }

    public String toString() {
        return this.m_versionedName;
    }
}

