/*
 * Decompiled with CFR 0.152.
 */
package com.sas.tools.installs.it.view;

import com.sas.tools.installs.it.Controller;
import com.sas.tools.installs.it.view.CustMsgBox;
import com.sas.tools.installs.it.view.MITView;
import com.sas.tools.installs.it.view.SSNResource;
import java.awt.Dimension;
import java.io.File;
import java.lang.reflect.Method;
import javax.swing.JEditorPane;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.core.Logger;

public class SwingView
extends MITView {
    protected static Logger log = (Logger)LogManager.getLogger((String)"com.sas.tools.installs.it.view.SwingView");
    private String _logReference = null;
    public static HyperlinkListener logfileHyperlinkListener = new HyperlinkListener(){

        @Override
        public void hyperlinkUpdate(HyperlinkEvent e) {
            if (e.getEventType().equals(HyperlinkEvent.EventType.ACTIVATED) && e.getURL() != null) {
                try {
                    String url = e.getURL().toString();
                    String osName = System.getProperty("os.name");
                    if (osName.startsWith("Mac OS")) {
                        Class<?> fileMgr = Class.forName("com.apple.eio.FileManager");
                        Method openURL = fileMgr.getDeclaredMethod("openURL", String.class);
                        openURL.invoke(null, url);
                    } else if (osName.startsWith("Windows")) {
                        Runtime.getRuntime().exec(new String[]{"rundll32", "url.dll,FileProtocolHandler", url});
                    } else {
                        String[] browsers = new String[]{"firefox", "opera", "konqueror", "epiphany", "mozilla", "netscape"};
                        String browser = null;
                        for (int count = 0; count < browsers.length && browser == null; ++count) {
                            if (Runtime.getRuntime().exec(new String[]{"which", browsers[count]}).waitFor() == 0) {
                                browser = browsers[count];
                            }
                            if (browser == null) {
                                CustMsgBox.showMessageDialog(null, "Could not determine appropriate viewer for log file", "No log viewer found");
                                continue;
                            }
                            Runtime.getRuntime().exec(new String[]{browser, url});
                        }
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    };

    public SwingView() {
        this.setBundle(new SSNResource(SwingView.class));
    }

    @Override
    public String logReference(boolean addLinkPrefix) {
        String logPath;
        if (this._logReference == null && addLinkPrefix && (logPath = System.getProperty("log4j.appender.LogFile.file")) != null && new File(logPath).isFile()) {
            this._logReference = this.getBundle().messageString("SwingView.SeeLog") + ":<BR><a href=\"file:\\\\" + System.getProperty("log4j.appender.LogFile.file") + "\">" + System.getProperty("log4j.appender.LogFile.file") + "</a>";
        }
        if (this._logReference == null) {
            this._logReference = new String();
        }
        return this._logReference;
    }

    @Override
    public void improperConfiguration(String message, Exception e) throws Exception {
        log.error("Improper configuration", (Throwable)e);
        this.packageVerificationFailure(message);
    }

    @Override
    public boolean rollbackFailurePrompt(String failureDescription, Throwable e) {
        Object[] options = new Object[]{this.getBundle().messageString("SwingView.Retry"), this.getBundle().messageString("SwingView.Cancel")};
        String message = this.getBundle().messageString("SwingView.ErrorOccurred") + ":<br><br>" + failureDescription + ".<br><br>" + this.getBundle().messageString("SwingView.RemediationOptions");
        int n = JOptionPane.showOptionDialog(null, message, this.getBundle().messageString("SwingView.InstallationError"), 1, 3, null, options, options[0]);
        return n != 0;
    }

    @Override
    public void applicationFailure(Exception e) {
        log.fatal("The following exception was thrown outside of package processing.  Installation halted\n");
        Controller.logStackTrace(e);
        String htmlFormatting = "<html><TABLE WIDTH=100% BORDER=0 CELLPADDING=0 CELLSPACING=0><TR><TD WIDTH=550><P ALIGN=LEFT>" + this.getBundle().messageString("SwingView.ErrorOccurred") + ".  " + this.getBundle().messageString("SwingView.NoChanges") + "<BR>" + this.logReference() + "</P></TD></TR></TABLE></html>";
        this.displayConfirmationMessage(htmlFormatting, 0, "Installation Halted", true, 1);
    }

    @Override
    public void setupFailure(String message, Exception e) {
        log.error("setup failure", (Throwable)e);
        this.displayStandardTermination(this.getBundle().messageString("SwingView.SetupFailure"), message);
    }

    @Override
    public void packageVerificationFailure(String message) {
        if (this.getController() != null) {
            this.getController().getSASController().recordInstallFailure();
        }
        this.displayStandardTermination(this.getBundle().messageString("SwingView.PackageVerificationFailure") + ":  ", message);
    }

    public void displayStandardTermination(String intro, String message) {
        StringBuffer finalMessage = null;
        if (intro != null) {
            finalMessage = new StringBuffer(intro);
            if (message != null) {
                finalMessage.append(":<BR><BR>" + message + ".<BR><BR>");
            }
            finalMessage.append(this.getBundle().messageString("SwingView.NoInstall") + ".  " + this.getBundle().messageString("SwingView.NoChanges") + ".  " + this.logReference());
        } else {
            finalMessage = new StringBuffer(message + ".<BR><BR>" + this.getBundle().messageString("SwingView.NoInstall") + ".  " + this.getBundle().messageString("SwingView.NoChanges") + ".  " + this.logReference());
        }
        String htmlFormatting = "<html><TABLE WIDTH=100% BORDER=0 CELLPADDING=0 CELLSPACING=0><TR><TD WIDTH=550><P ALIGN=LEFT>" + finalMessage.toString() + "</P></TD></TR></TABLE></html>";
        this.displayConfirmationMessage(htmlFormatting, 0, "Installation Halted", true, 1);
    }

    @Override
    public void displayConfirmationMessage(String message, int messageType) {
        this.displayConfirmationMessage(message, messageType, null, false, null);
    }

    @Override
    public void displayConfirmationMessage(String message, int messageType, String title, boolean exitUponConfirm, Integer exitCode) {
        JEditorPane content = new JEditorPane("text/html", message);
        content.setEditable(false);
        content.setPreferredSize(new Dimension(600, 200));
        content.addHyperlinkListener(logfileHyperlinkListener);
        CustMsgBox.showMessageDialog(null, new JScrollPane(content), title, 1);
        if (exitUponConfirm) {
            System.exit(exitCode);
        }
    }

    @Override
    public void exitWithoutRollback() {
        log.fatal("Failure occurred with no rollbacks.  Exiting...");
        this.displayStandardTermination(this.getBundle().messageString("SwingView.MVSError"), null);
        System.exit(1);
    }
}

