/*
 * Decompiled with CFR 0.152.
 */
package com.sas.tools.installs.it.tasks;

import com.sas.tools.installs.it.Controller;
import com.sas.tools.installs.it.InstallException;
import com.sas.tools.installs.it.ProcessingTask;
import com.sas.tools.installs.it.ProcessingTaskInfo;
import com.sas.tools.installs.it.Utils;
import com.sas.tools.installs.it.schema.install.gen.FileList;
import com.sas.tools.installs.it.schema.install.gen.RunSASJob;
import com.sas.tools.installs.it.schema.metadata.EntryData;
import com.sas.tools.installs.it.tasks.CommandLineArgTask;
import com.sas.tools.installs.it.tasks.InstallationTask;
import com.sas.tools.installs.it.tasks.TaskHelper;
import java.io.File;
import java.util.LinkedHashMap;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.core.Logger;

public class RunSASJobTask
extends CommandLineArgTask {
    private static final String TASK_NAME = "RunSASJob";
    private static Logger log = (Logger)LogManager.getLogger((String)"com.sas.tools.installs.it.tasks.RunSASJobTask");
    private File jobFile = null;
    private FileList modifiedFileList = null;
    private String sasJobLog = null;

    public RunSASJobTask() {
        String key = Controller.defaultController().getAltSku().concat(this.getClass().getName());
        Controller.defaultController().getPostProcessingTasks().put(key, new ProcessingTaskInfo(true, this.getClass().getName(), "postInstall"));
        Controller.defaultController().getPostProcessingQueue().add(new ProcessingTask(this, this.getClass(), "postInstall"));
    }

    @Override
    public String descriptionForLog() {
        if (this.jobFile == null) {
            return null;
        }
        LinkedHashMap<String, String> params = new LinkedHashMap<String, String>();
        params.put("sas job", this.jobFile.getAbsolutePath());
        if (this.modifiedFileList != null) {
            int i = 1;
            for (String modifiedFile : this.modifiedFileList.getFile()) {
                params.put("modified file" + i, this.resolveProperty(modifiedFile));
                ++i;
            }
        }
        return TaskHelper.getDescriptionForLog(TASK_NAME, params);
    }

    @Override
    public void preExecute() throws Exception {
        String job = ((RunSASJob)this.getData()).getJob();
        if (job == null || job.equals("")) {
            throw new InstallException(2, this, this.getBundle().messageString("RunSASJob.JobFileNotDefined"), this.getEnBundle().messageString("RunSASJob.JobFileNotDefined"), null);
        }
        this.jobFile = new File(this.resolveProperty(job));
        this.modifiedFileList = ((RunSASJob)this.getData()).getFileList();
        this.sasJobLog = "RunSASJob_" + this.jobFile.getName() + ".log";
        super.preExecute();
    }

    @Override
    public void execute() throws InstallException {
    }

    @Override
    public void postExecute() throws Exception {
    }

    @Override
    public void retry() throws InstallException {
    }

    @Override
    public void rollback() throws InstallException {
    }

    public int postInstall() {
        int returnCode = 0;
        if (this.jobFile == null) {
            log.error("The job file is not defined.");
            return -1;
        }
        if (!this.jobFile.exists()) {
            log.error("The SAS job file does not exist: " + this.jobFile.getAbsolutePath());
            return -1;
        }
        ProcessBuilder pb = null;
        if ((TaskHelper.isUnix() || TaskHelper.isWindows()) && this.getSASExe().exists()) {
            List<String> sasArgs = this.getSASBatchArgs(this.jobFile, this.sasJobLog);
            if (TaskHelper.isWindows()) {
                sasArgs.add("-config");
                sasArgs.add(Utils.joinPath(this.getSASFoundationRoot(), "nls\\en\\sasv9.cfg"));
            } else if (TaskHelper.isUnix()) {
                sasArgs.add("-config");
                sasArgs.add(this.getSASFoundationRoot() + "/sasv9.cfg");
            }
            sasArgs.addAll(this.getResolvedArgs((RunSASJob)this.getData()));
            log.info("Running the sas job: " + this.jobFile.getAbsolutePath());
            pb = new ProcessBuilder(sasArgs);
            if (pb != null) {
                int rc = 0;
                try {
                    rc = InstallationTask.executeProcess(pb, log);
                    if (rc != 0) {
                        returnCode = rc;
                    }
                    if (this.modifiedFileList != null) {
                        for (String modifiedFile : this.modifiedFileList.getFile()) {
                            File modifiedFilePath = new File(this.resolveProperty(modifiedFile));
                            String action = "Added";
                            if (modifiedFilePath.exists()) {
                                action = "Changed";
                            }
                            EntryData data = new EntryData(modifiedFilePath);
                            this.notifySetup(action, data, null);
                            this.notifyProgressComplete(action, data);
                        }
                    }
                }
                catch (Exception e) {
                    log.error(this.getEnBundle().messageString("InstallationTask.OperationFailedEx", pb.command()), (Throwable)e);
                    returnCode = -1;
                }
                this.processSASOutput(rc, this.getSASLog(this.sasJobLog));
            } else {
                log.info("Could not invoke SAS to run the SAS job.");
            }
        }
        this.deleteSASTempFiles();
        return returnCode;
    }
}

