/*
 * Decompiled with CFR 0.152.
 */
package com.sas.tools.installs.it.tasks;

import com.sas.tools.deployjni.JNIUtils;
import com.sas.tools.deployjni.saswin.SASWinAPI;
import com.sas.tools.installs.it.InstallException;
import com.sas.tools.installs.it.Utils;
import com.sas.tools.installs.it.schema.install.gen.FileList;
import com.sas.tools.installs.it.schema.install.gen.Removal;
import com.sas.tools.installs.it.schema.install.gen.RunFileUtility;
import com.sas.tools.installs.it.schema.install.gen.Substitution;
import com.sas.tools.installs.it.schema.metadata.EntryData;
import com.sas.tools.installs.it.tasks.InstallationTask;
import com.sas.tools.installs.it.tasks.TaskHelper;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class RunFileUtilityTask
extends InstallationTask {
    private StringBuffer _buffer = new StringBuffer();
    public static final String SUBSTITUTE = "substitute";
    public static final String COPY = "copy";
    public static final String MOVE = "move";
    public static final String DELETE = "delete";
    public static final String MAKE = "make";
    public static final String REMOVE = "remove";
    public static final String COPY64SYS32 = "copynoredirect";
    public static final String DELETE64SYS32 = "deletenoredirect";
    private static final String STARTS_WITH = "startsWith";
    private static final String ENDS_WITH = "endsWith";
    private static final String CONTAINS = "contains";
    private static final String DELETEFOLDER = "deletefolder";
    private static final String DELETEFOLDER_WITH_FILE_NOTIFICATIONS = "deleteFolderWithFileNotifications";
    private Set<File> allFilesToDelete = new HashSet<File>();

    @Override
    public String descriptionForLog() {
        return null;
    }

    @Override
    public void preExecute() throws InstallException {
        if (DELETEFOLDER_WITH_FILE_NOTIFICATIONS.equalsIgnoreCase(this.getAction())) {
            boolean preexecute = true;
            this.performDeleteFolderWithFileNotifications(preexecute);
        }
    }

    @Override
    public void execute() throws InstallException {
        if (this.executeOnCurrentHost()) {
            this.log.info("Executing RunFileUtility on hosts: " + ((RunFileUtility)this.getData()).getHostList());
            if (SUBSTITUTE.equalsIgnoreCase(this.getAction())) {
                this.performSubstitution();
            } else if (REMOVE.equalsIgnoreCase(this.getAction())) {
                this.performRemoval();
            } else if (COPY.equalsIgnoreCase(this.getAction())) {
                this.performCopy();
            } else if (MOVE.equalsIgnoreCase(this.getAction())) {
                this.performMove();
            } else if (DELETE.equalsIgnoreCase(this.getAction())) {
                this.performDelete();
            } else if (MAKE.equalsIgnoreCase(this.getAction())) {
                this.performMake();
            } else if (COPY64SYS32.equalsIgnoreCase(this.getAction())) {
                this.performCopyNoRedirect();
            } else if (DELETEFOLDER.equalsIgnoreCase(this.getAction())) {
                this.performDeleteFolder();
            } else if (DELETEFOLDER_WITH_FILE_NOTIFICATIONS.equalsIgnoreCase(this.getAction())) {
                boolean preexecute = false;
                this.performDeleteFolderWithFileNotifications(preexecute);
            }
        }
    }

    private void performRemoval() {
        File file = null;
        try {
            List<String> fileList = this.getFilelist().getFile();
            for (String sFile : fileList) {
                this._buffer = new StringBuffer();
                file = new File(this.resolveProperty(sFile));
                long lastModified = file.lastModified();
                this.log.debug("Removing lines on " + file.getAbsolutePath());
                if (file.exists()) {
                    BufferedReader in = new BufferedReader(new FileReader(file));
                    String line = null;
                    while ((line = in.readLine()) != null) {
                        if (this.processRemovalPatterns(line)) continue;
                        this._buffer.append(line);
                        this._buffer.append("\n");
                    }
                    in.close();
                    this.log.debug(this._buffer.toString());
                    File newFile = new File(this.resolveProperty(sFile));
                    FileWriter fw = new FileWriter(newFile);
                    EntryData enData = new EntryData(newFile);
                    this.notifySetup("Changed", enData, null);
                    if (this._buffer.length() > 0) {
                        fw.write(this._buffer.toString());
                    }
                    fw.flush();
                    fw.close();
                    newFile.setLastModified(lastModified);
                    this.notifyProgressComplete("Changed", enData);
                    continue;
                }
                if (this.isUndo()) {
                    this.log.info("File doesn't exist during uninstall, skipping removal: " + file);
                    continue;
                }
                this.log.warn("File not found.  Unable to remove lines from file: " + file);
            }
        }
        catch (IOException e) {
            throw new InstallException(1, this, this.getBundle().messageString("RunFileUtility.SubstitutionFailed", file), this.getEnBundle().messageString("RunFileUtility.SubstitutionFailed", file), e);
        }
    }

    private void performSubstitution() {
        File file = null;
        try {
            List<String> fileList = this.getFilelist().getFile();
            for (String sFile : fileList) {
                this._buffer = new StringBuffer();
                file = new File(this.resolveProperty(sFile));
                long lastModified = file.lastModified();
                this.log.debug("Substituting on " + file.getAbsolutePath());
                if (file.exists()) {
                    BufferedReader in = new BufferedReader(new FileReader(file));
                    String line = null;
                    while ((line = in.readLine()) != null) {
                        this._buffer.append(line);
                        this._buffer.append("\n");
                    }
                    in.close();
                    this.log.debug(this._buffer.toString());
                    File newFile = new File(this.resolveProperty(sFile));
                    FileWriter fw = new FileWriter(newFile);
                    EntryData enData = new EntryData(newFile);
                    this.notifySetup("Changed", enData, null);
                    if (this._buffer.length() > 0) {
                        fw.write(this.processSubstitutionPatterns(this._buffer.toString()));
                    }
                    fw.flush();
                    fw.close();
                    newFile.setLastModified(lastModified);
                    this.notifyProgressComplete("Changed", enData);
                    continue;
                }
                if (this.isUndo()) {
                    this.log.info("File doesn't exist during uninstall, skipping substitution: " + file);
                    continue;
                }
                this.log.warn("Unable to perform substitution. File \"" + file + "\" not found.");
            }
        }
        catch (IOException e) {
            throw new InstallException(1, this, this.getBundle().messageString("RunFileUtility.SubstitutionFailed", file), this.getEnBundle().messageString("RunFileUtility.SubstitutionFailed", file), e);
        }
    }

    private void performCopy() {
        String to;
        File toFile;
        String from = this.getCopyFromFile();
        File fromFile = new File(from);
        if (!this.checkExists(fromFile, toFile = new File(to = this.getCopyToFile()))) {
            File parentDir = new File(toFile.getParent());
            if (!parentDir.exists()) {
                parentDir.mkdirs();
            }
            EntryData enData = new EntryData(toFile);
            this.notifySetup("Added", enData, "Adding copied file " + toFile);
            try {
                this.log.info("Attempting to copy " + from + " to " + to);
                this.getController().getFS().copyFile(from, to);
                this.notifyProgressComplete("Added", enData);
            }
            catch (IOException e) {
                throw new InstallException(1, this, this.getBundle().messageString("InstallationTask.CopyFileError", from, to), this.getEnBundle().messageString("InstallationTask.CopyFileError", from, to), e);
            }
            this.log.info("Successfully copied " + from + " to " + to);
        }
    }

    private void performCopyNoRedirect() {
        String from = this.getCopyFromFile();
        String to = this.getCopyToFile();
        File toFile = new File(to);
        File fromFile = new File(from);
        if (!TaskHelper.getOS_Suffix().equals("wx6")) {
            this.log.warn("CopyNoRedirect is not valid for this OS");
            return;
        }
        if (!JNIUtils.libraryLoaded((String)JNIUtils.JNI_LIB_BASE, (HashMap)SASWinAPI.libNames)) {
            String missingLib = JNIUtils.getJniLib((HashMap)SASWinAPI.libNames);
            throw new InstallException(1, null, this.getBundle().messageString("Controller.MissingJNILib", missingLib), this.getEnBundle().messageString("Controller.MissingJNILib", missingLib), null);
        }
        if (this.isUndo()) {
            this.log.info("Removing: " + to);
            SASWinAPI.Delete64NoRedirect((String)to);
        } else {
            this.log.debug("Copy64NoRedirect: copy " + from + " to " + to);
            try {
                if (!new File(from).exists()) {
                    return;
                }
                if (!SASWinAPI.Copy64NoRedirect((String)from, (String)to)) {
                    this.log.error("Call to SASWinAPI.Copy64NoRedirect failed");
                }
            }
            catch (Exception e) {
                this.log.error("Unable to copy " + fromFile + " to " + toFile);
                this.log.error(e.getMessage());
            }
        }
    }

    private boolean checkExists(File from, File to) {
        boolean fromExists = from.exists();
        boolean toExists = to.exists();
        if (!fromExists) {
            if (this.isUndo()) {
                this.log.info("From file doesn't exist during uninstall, skipping copy: " + from);
            } else {
                throw new InstallException(1, this, this.getBundle().messageString("InstallationTask.CopyFileError", from, to), this.getEnBundle().messageString("InstallationTask.CopyFileError", from, to), null);
            }
        }
        if (this.isUndo()) {
            if (toExists) {
                this.log.info("To file exists during uninstall, deleting: " + to);
                to.delete();
            }
            toExists = true;
        }
        return toExists;
    }

    private void performMove() {
        File toFile = new File(this.getMoveToFile());
        File fromFile = new File(this.getMoveFromFile());
        EntryData enData = new EntryData(toFile);
        EntryData oldEnData = new EntryData(fromFile);
        if (!this.checkExists(fromFile, toFile)) {
            File parentDir = new File(toFile.getParent());
            if (!parentDir.exists()) {
                parentDir.mkdirs();
            }
            try {
                this.notifySetup("Changed", enData, "Moving file to new location.");
                this.log.info("Attempting to move " + this.getMoveFromFile() + " to " + this.getMoveToFile());
                this.getController().getFS().copyFile(this.getMoveFromFile(), this.getMoveToFile());
                fromFile.delete();
                this.log.info("The file " + this.getMoveFromFile() + " was successfully moved");
            }
            catch (IOException e) {
                throw new InstallException(1, this, this.getBundle().messageString("InstallationTask.MoveFileError", fromFile, toFile), this.getEnBundle().messageString("InstallationTask.MoveFileError", fromFile, toFile), e);
            }
            finally {
                this.notifyProgressComplete("Removed", oldEnData);
                this.notifyProgressComplete("Changed", enData);
            }
        }
    }

    private boolean isExceptedFile(File file) {
        if (this.getController().getProperty("12ByteCode").equals("base") && TaskHelper.isUnix() && this.getController().getProperty("ProductVersion").equals("9.4") && (this.getController().getProperty("MaintVersion").equals("3") || this.getController().getProperty("MaintVersion").equals("4")) && (file.toString().endsWith("SASFoundation/9.4/bin/sasenv_local") || file.toString().endsWith("SASFoundation/9.4/bin/sasenv_local.csh") || file.toString().endsWith("SASFoundation/9.4/bin/sasenv_local.ksh"))) {
            this.log.info(String.format("Skipping file: '%s'. Existing user config already detected on system.", file.toString()));
            return true;
        }
        return false;
    }

    private void performDelete() {
        File file = new File(this.getDeleteFile());
        EntryData enData = new EntryData(file);
        if (file.exists() && !this.isExceptedFile(file)) {
            this.notifySetup("Removed", enData, "Deleting file.");
            if (file.delete()) {
                this.notifyProgressComplete("Removed", enData);
                this.log.info(this.getDeleteFile() + " was removed");
            } else {
                this.notifyProgressFailure("Removed", enData);
                this.log.info(this.getDeleteFile() + " was not removed");
            }
        }
    }

    private void performDeleteFolder() {
        File folder = new File(this.getDeleteFolderPath());
        boolean deleteAtExit = false;
        EntryData enData = new EntryData(folder);
        this.processDeleteFolder(folder, deleteAtExit, enData);
    }

    private void processDeleteFolder(File folder, boolean deleteAtExit, EntryData enData) {
        if (folder.exists()) {
            this.notifySetup("Removed", enData, "Deleting folder");
            if (folder.getPath().contains(this.getController().getProperty("ProductHome")) || folder.getPath().contains(this.getController().getProperty("VJRHome"))) {
                this.log.info("Attempting to remove folder " + folder);
                if (Utils.deleteFolder(folder, deleteAtExit)) {
                    this.notifyProgressComplete("Removed", enData);
                    this.log.info(folder + " was removed");
                } else {
                    this.notifyProgressFailure("Removed", enData);
                    this.log.info(folder + " was not removed");
                }
            } else {
                this.notifyProgressFailure("Removed", enData);
                this.log.info(folder + " was not removed");
            }
        }
    }

    private void performDeleteFolderWithFileNotifications(boolean preexecute) {
        String folderPath = ((RunFileUtility)this.getData()).getDeleteFolderWithFileNotifications().getPath();
        if (folderPath != null) {
            String resolvedFolderPath = this.resolveProperty(folderPath);
            File folder = new File(resolvedFolderPath);
            if (folder.isDirectory()) {
                if (preexecute) {
                    String msg = String.format("Scanning folder %s for files to delete.", resolvedFolderPath);
                    this.log.info(msg);
                    Utils.getRecursiveListOfFilesFromFolder(folder, this.allFilesToDelete);
                } else {
                    Utils.getRecursiveListOfFilesFromFolder(folder, this.allFilesToDelete);
                    boolean deleteAtExit = false;
                    EntryData enData = new EntryData(folder);
                    this.processDeleteFolder(folder, deleteAtExit, enData);
                }
                this.sendFileDeleteNotifications(this.allFilesToDelete, preexecute);
            } else {
                String msg = String.format("Warning,  directory %s not found", folder.getAbsolutePath());
                this.log.warn(msg);
            }
        }
    }

    private void sendFileDeleteNotifications(Set<File> files, boolean preexecute) {
        for (File file : files) {
            EntryData entry = new EntryData(file);
            String action = "Removed";
            if (preexecute) {
                this.notifySetup("Removed", entry, null);
                continue;
            }
            this.notifyProgressComplete("Removed", entry);
        }
    }

    private void performMake() {
        File file = null;
        List<String> fileList = this.getFilelist().getFile();
        for (String sFile : fileList) {
            file = new File(this.resolveProperty(sFile));
            this.log.debug("Performing mkdir on " + file.getAbsolutePath());
            if (!file.exists()) {
                file.mkdirs();
                continue;
            }
            if (!this.isUndo()) continue;
            file.delete();
        }
    }

    private String processSubstitutionPatterns(String val) {
        for (Substitution s : this.getSubstitutions()) {
            String resolvedVal = this.resolveProperty(s.getValue().getValue());
            switch (s.getValue().getSlashes()) {
                case PLATFORM: {
                    resolvedVal = Utils.fixPathSlashes(resolvedVal);
                    break;
                }
                case UNIX: {
                    resolvedVal = resolvedVal.replace('\\', '/');
                    break;
                }
                case WINDOWS: {
                    resolvedVal = resolvedVal.replace('/', '\\');
                    break;
                }
                case DOUBLEWINDOWS: {
                    resolvedVal = resolvedVal.replace("\\", "\\\\");
                    break;
                }
            }
            val = val.replace(s.getPattern(), resolvedVal);
        }
        return this.resolveShortPaths(val);
    }

    private boolean processRemovalPatterns(String val) {
        boolean remove = false;
        for (Removal r : this.getRemovals()) {
            if (r.getLocation().equalsIgnoreCase(STARTS_WITH)) {
                if (!val.startsWith(r.getPattern())) continue;
                remove = true;
                continue;
            }
            if (r.getLocation().equalsIgnoreCase(ENDS_WITH)) {
                if (!val.endsWith(r.getPattern())) continue;
                remove = true;
                continue;
            }
            if (!r.getLocation().equalsIgnoreCase(CONTAINS) || !val.contains(r.getPattern())) continue;
            remove = true;
        }
        return remove;
    }

    @Override
    public void postExecute() throws Exception {
    }

    @Override
    public void retry() throws InstallException {
        this.execute();
    }

    @Override
    public void rollback() throws InstallException {
    }

    public List<Substitution> getSubstitutions() {
        return ((RunFileUtility)this.getData()).getSubstitution();
    }

    public List<Removal> getRemovals() {
        return ((RunFileUtility)this.getData()).getRemoval();
    }

    public String getAction() {
        return ((RunFileUtility)this.getData()).getAction();
    }

    public FileList getFilelist() {
        return ((RunFileUtility)this.getData()).getFileList();
    }

    public String getCopyToFile() {
        return this.resolveProperty(((RunFileUtility)this.getData()).getCopy().getTo());
    }

    public String getCopyFromFile() {
        return this.resolveProperty(((RunFileUtility)this.getData()).getCopy().getFrom());
    }

    public String getMoveToFile() {
        return this.resolveProperty(((RunFileUtility)this.getData()).getMove().getTo());
    }

    public String getMoveFromFile() {
        return this.resolveProperty(((RunFileUtility)this.getData()).getMove().getFrom());
    }

    public String getDeleteFile() {
        return this.resolveProperty(((RunFileUtility)this.getData()).getDelete().getFile());
    }

    public String getDeleteFolderPath() {
        return this.resolveProperty(((RunFileUtility)this.getData()).getDeleteFolder().getPath());
    }
}

