/*
 * Decompiled with CFR 0.152.
 */
package com.sas.tools.installs.it.tasks;

import com.sas.tools.deployjni.disk.DiskInfoAPI;
import com.sas.tools.installs.it.tasks.PicklistEntry;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.core.Logger;

public class Picklist {
    private final Logger log = (Logger)LogManager.getLogger((String)"com.sas.tools.installs.it.tasks.Picklist");
    private Integer version = null;
    private final Map<String, PicklistEntry> entryMap = new LinkedHashMap<String, PicklistEntry>();

    /*
     * Enabled aggressive block sorting
     */
    public Map<String, PicklistEntry> read(InputStream inputStream) throws IOException {
        BufferedReader br = new BufferedReader(new InputStreamReader(inputStream));
        String line = null;
        PicklistPart lastPart = null;
        PicklistEntry entry = null;
        String name = null;
        while ((line = br.readLine()) != null) {
            PicklistPart part;
            block15: {
                String value;
                block16: {
                    block17: {
                        if ((line = line.trim()).equals("")) continue;
                        String[] parts = line.split("=", 2);
                        if (parts.length != 2) {
                            throw new IllegalStateException("Invalid picklist line " + line);
                        }
                        String property = parts[0].trim();
                        value = parts[1].trim();
                        part = PicklistPart.parse(property);
                        if (this.version == null) break block16;
                        if (part != PicklistPart.NAME) break block17;
                        if (lastPart == PicklistPart.NAME) {
                            throw new IllegalStateException("name= not valid here: " + (Object)((Object)lastPart));
                        }
                        if (entry != null) {
                            this.entryMap.put(name, entry);
                        }
                        entry = new PicklistEntry(value);
                        name = value;
                        break block15;
                    }
                    if (part == PicklistPart.VERSION) {
                        if (lastPart != PicklistPart.NAME) {
                            throw new IllegalStateException("version= not valid here: " + (Object)((Object)lastPart));
                        }
                        entry.setVersion(value);
                        break block15;
                    } else if (part == PicklistPart.OPTIONAL) {
                        if (lastPart != PicklistPart.VERSION) {
                            throw new IllegalStateException("optional= not valid here: " + (Object)((Object)lastPart));
                        }
                        entry.setOptional(value);
                        break block15;
                    } else {
                        if (part != PicklistPart.DELETE) {
                            this.log.error("Found part " + (Object)((Object)part));
                            throw new IllegalStateException("Unexpected picklist entry part on " + line);
                        }
                        if (lastPart != PicklistPart.VERSION && lastPart != PicklistPart.OPTIONAL) {
                            throw new IllegalStateException("delete= not valid here: " + (Object)((Object)lastPart));
                        }
                        entry.setDelete(value);
                    }
                    break block15;
                }
                if (part != PicklistPart.PICKLIST_VERSION) {
                    this.log.error("Expected part " + (Object)((Object)PicklistPart.PICKLIST_VERSION) + ", found " + (Object)((Object)part));
                    throw new IllegalStateException("Expecting picklist version in " + line);
                }
                if (!value.equals("1")) {
                    throw new IllegalArgumentException("Unsupported picklist version " + value);
                }
                this.version = 1;
            }
            lastPart = part;
        }
        if (entry != null) {
            this.entryMap.put(name, entry);
        }
        return this.entryMap;
    }

    public void write(OutputStream outputStream) throws UnsupportedEncodingException {
        if (this.version == null) {
            throw new IllegalStateException("Picklist version can't be null");
        }
        PrintWriter pw = new PrintWriter(new OutputStreamWriter(outputStream, "US-ASCII"));
        pw.print("PickList-Version");
        pw.print("=");
        pw.println(this.version);
        for (String name : this.entryMap.keySet()) {
            pw.println("");
            pw.println(this.entryMap.get(name));
        }
        pw.flush();
    }

    public void mergeWith(Picklist merge) {
        this.version = merge.version;
        for (String jarName : merge.entryMap.keySet()) {
            boolean deleteRequested = false;
            PicklistEntry mergeEntry = merge.entryMap.get(jarName);
            String mergeVer = mergeEntry.getVersion();
            boolean bl = deleteRequested = mergeEntry.getDelete() != null;
            if (this.entryMap.keySet().contains(jarName)) {
                PicklistEntry entry = this.entryMap.get(jarName);
                String existingVer = entry.getVersion();
                if (deleteRequested) {
                    this.removeFromPicklist(existingVer, mergeVer, jarName);
                    continue;
                }
                if (DiskInfoAPI.compareFileVersionStrings((String)existingVer, (String)mergeVer) > 0) {
                    this.log.info("Updating picklist entry for " + jarName + " to " + mergeVer);
                    entry.setVersion(mergeVer);
                    entry.setOptional(mergeEntry.getOptional());
                    continue;
                }
                this.log.info("Keeping existing picklist entry for " + jarName + " at " + existingVer);
                continue;
            }
            if (deleteRequested) {
                this.log.info("Merge picklist entry for " + jarName + " at " + mergeVer + " ignored, entry not found in target picklist");
                continue;
            }
            this.log.info("Adding new picklist entry for " + jarName + " at " + mergeVer);
            this.entryMap.put(jarName, mergeEntry);
        }
    }

    public void removeFromPicklist(String existingVer, String mergeVer, String jarName) {
        if (DiskInfoAPI.compareFileVersionStrings((String)existingVer, (String)mergeVer) == 0) {
            this.entryMap.remove(jarName);
            this.log.info("Removing picklist entry for " + jarName + " at " + mergeVer);
            return;
        }
        this.log.info("Merge picklist entry for " + jarName + " at " + mergeVer + " does not match " + existingVer + " in target picklist");
    }

    public static enum PicklistPart {
        PICKLIST_VERSION,
        NAME,
        VERSION,
        OPTIONAL,
        DELETE;

        public static final String PICKLIST_VERSION_PROPERTY = "PickList-Version";
        public static final String NAME_V1_PROPERTY = "name";
        public static final String VERSION_V1_PROPERTY = "version";
        public static final String OPTIONAL_V1_PROPERTY = "optional";
        public static final String DELETE_V1_PROPERTY = "delete";

        public static PicklistPart parse(String property) {
            PicklistPart part;
            if (property.equals(NAME_V1_PROPERTY)) {
                part = NAME;
            } else if (property.equals(VERSION_V1_PROPERTY)) {
                part = VERSION;
            } else if (property.equals(OPTIONAL_V1_PROPERTY)) {
                part = OPTIONAL;
            } else if (property.equals(DELETE_V1_PROPERTY)) {
                part = DELETE;
            } else if (property.equals(PICKLIST_VERSION_PROPERTY)) {
                part = PICKLIST_VERSION;
            } else {
                throw new IllegalArgumentException("Unknown picklist part: " + property);
            }
            return part;
        }
    }
}

