/*
 * Decompiled with CFR 0.152.
 */
package com.sas.tools.installs.it.tasks;

import com.ibm.jzos.AccessMethodServices;
import com.ibm.jzos.PdsDirectory;
import com.ibm.jzos.RcException;
import com.ibm.jzos.RecordReader;
import com.ibm.jzos.RecordWriter;
import com.ibm.jzos.ZFile;
import com.ibm.jzos.ZFileException;
import com.sas.tools.installs.it.Controller;
import com.sas.tools.installs.it.InstallException;
import com.sas.tools.installs.it.InstallationContext;
import com.sas.tools.installs.it.NotificationHandler;
import com.sas.tools.installs.it.ProcessingTask;
import com.sas.tools.installs.it.ProcessingTaskInfo;
import com.sas.tools.installs.it.Utils;
import com.sas.tools.installs.it.schema.install.gen.Mvsextract;
import com.sas.tools.installs.it.schema.mvsdsdata.gen.DatasetType;
import com.sas.tools.installs.it.tasks.ClearVjrCacheTask;
import com.sas.tools.installs.it.tasks.InstallationTask;
import com.sas.tools.installs.it.view.SSNResource;
import com.sas.tools.installs.it.zos.DataSetParamValidator;
import com.sas.tools.installs.it.zos.DynamicAllocate;
import com.sas.tools.installs.it.zos.FTPHelper;
import com.sas.tools.installs.it.zos.JESHelper;
import com.sas.tools.installs.it.zos.JavaEditX;
import com.sas.tools.installs.it.zos.JobHelper;
import com.sas.tools.installs.resource.FileSystem;
import com.sas.tools.installs.resource.JavaIOFileSystem;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.CharConversionException;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLDecoder;
import java.nio.charset.CharacterCodingException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.Vector;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathFactory;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.config.Configurator;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.NodeList;

public class MvsextractTask
extends InstallationTask {
    private static ArrayList<String> _logInfo = new ArrayList();
    protected String _filename;
    protected static Vector<String> _requiredBuckets;
    protected static Vector<Integer> _bucketContexts;
    public static final int ALL = 0;
    public static final int ONLY_BASE = 1;
    public static final int EXCLUDE_BASE = 2;
    protected static Vector<Integer> _promoteContexts;
    public static final int NOT_PROMOTE = 0;
    public static final int PROMOTE = 1;
    protected static boolean globalsInitialized;
    protected static HashMap<String, JavaEditX> _processedTemplates;
    public static HashMap<String, String> UserParams;
    public static Vector<String> finalJobs;
    protected static Vector<String> finalJobDescriptions;
    public static Vector<String> finalJobNames;
    protected static Map<String, String> jobStatus;
    public static HashSet<String> ChangedDatasets;
    public static HashSet<String> StagedConfigMembers;
    protected static String _jobNameBase;
    private static final String JOBNAME_INSTAL = "INSTAL";
    private static final String JOBNAME_MAINT = "MAINT";
    private static final String JOBNAME_HOTFIX = "HOTFIX";
    private static final String JOBNAME_PROMOT = "PROMOT";
    private static final String SASEDT = "SASEDT";
    private static final String SASEDT_SASEDTZ = "SASEDTZ";
    private static final String SASEDT_SASEDTX = "SASEDTX,PARM='-v9'";
    private static final String SASEDTZ = "SASEDTZ";
    private static final String XLUPDATED = "XLUPDATED";
    protected static String _cntlDSPostfix;
    protected static String _TEMPLATELOC;
    protected static SSNResource BUNDLE;
    protected static SSNResource EN_BUNDLE;
    protected static org.apache.logging.log4j.core.Logger log;
    public static Properties installProperties;
    public static Set<String> installedProducts;
    public static HashMap<String, String> productCodes;
    public static final String PROMOTE_KEY = "PROMOTE";
    protected static final String _zosPrefix = "zos.";
    protected static final String _z64Prefix = "z64.";
    protected static final String newline;
    protected static FileSystem _fs;
    protected static String smsalloc;
    protected static String smsallocPdse;
    protected static boolean _isZ64;
    protected static boolean _gotZostools;
    protected static boolean _skipZostools;
    protected static String _zostoolsAltSku;
    protected static int _maxBaseMaintVersion;
    protected static boolean _helpJobPresent;
    protected static boolean _jobFormInitialized;
    protected static boolean _setInitInitialized;
    protected static boolean _cntlDataSetCreated;
    protected static boolean _cntlDataSetPrepared;

    public static void main(String[] args) throws Exception {
        if (args.length < 1) {
            throw new IllegalArgumentException("Missing Stage Qualifier argument.");
        }
        boolean z64 = false;
        String stageQual = args[0];
        if (!MvsextractTask.isValidStageQualifier(stageQual)) {
            throw new IllegalArgumentException("Invalid argument value for Stage Qualifier: '" + stageQual + "'.");
        }
        UserParams.put("STAGEQUAL", stageQual);
        for (int i = 1; i < args.length; ++i) {
            if (!args[i].equalsIgnoreCase("-z64")) {
                throw new IllegalArgumentException("Unrecognized argument: '" + args[i] + "'.");
            }
            z64 = true;
        }
        MvsextractTask.setupLoggingForMain();
        String props = null;
        try {
            props = System.getProperty("SASHome") + "/install.properties";
            FileInputStream propsInput = new FileInputStream(new File(props));
            Properties installProps = new Properties();
            installProps.load(propsInput);
            ((InputStream)propsInput).close();
            installProps.put("zos.hotfix", "true");
            if (z64) {
                installProps.put("zos.bit.count", "64");
            } else {
                installProps.put("zos.bit.count", "31");
            }
            MvsextractTask.setInstallProperties(installProps);
        }
        catch (FileNotFoundException ex) {
            String msg = String.format("Unable to load install properties from '%s'. The file was not found.", props);
            throw new InstallException(3, null, msg, msg, ex);
        }
        File changedDatasetData = MvsextractTask.getChangedDatasetData();
        File stagedConfigMemberData = MvsextractTask.getStagedConfigMemberData();
        FileInputStream fis = new FileInputStream(stagedConfigMemberData);
        ObjectInputStream oo = new ObjectInputStream(fis);
        log.info("Reading staged config member data from " + stagedConfigMemberData);
        StagedConfigMembers = (HashSet)oo.readObject();
        fis.close();
        fis = new FileInputStream(changedDatasetData);
        oo = new ObjectInputStream(fis);
        log.info("Reading changed dataset data from " + changedDatasetData);
        ChangedDatasets = (HashSet)oo.readObject();
        fis.close();
        for (String cds : ChangedDatasets) {
            log.info("Dataset " + cds + " has changed");
        }
        boolean memberChanged = false;
        String fullStagePrefix = UserParams.get("CUSTPRODQUAL") + stageQual;
        String shortStagePrefix = "&hlq." + stageQual.toLowerCase();
        for (String stagedMember : StagedConfigMembers) {
            log.info("Scanning " + stagedMember + " for staged dataset references...");
            RecordReader reader = MvsextractTask.getDatasetReader(stagedMember);
            StringBuffer outputContent = new StringBuffer();
            String newline = System.getProperty("line.separator");
            String line = MvsextractTask.readLine(reader);
            while (line != null) {
                if (line.contains(fullStagePrefix) || line.toLowerCase().contains(shortStagePrefix)) {
                    String patternString = "((" + fullStagePrefix + "|\\&hlq\\.\\" + UserParams.get("STAGEQUAL") + ")([\\.A-Z0-9]*))";
                    Pattern p = Pattern.compile(patternString, 2);
                    Matcher m = p.matcher(line);
                    while (m.find()) {
                        String loqual = m.group(3);
                        if (loqual.length() <= 0) continue;
                        loqual = loqual.substring(1, loqual.length());
                        log.info("Found reference to " + loqual);
                        if (ChangedDatasets.contains(loqual)) continue;
                        log.info(loqual + " not in staged dataset list, removing staged reference");
                        memberChanged = true;
                        String exp = "\\".concat(stageQual);
                        line = line.replaceAll(exp, "");
                    }
                }
                outputContent.append(line + newline);
                line = MvsextractTask.readLine(reader);
            }
            reader.close();
            if (!memberChanged) continue;
            memberChanged = false;
            log.info("Updating " + stagedMember);
            MvsextractTask.writeTextToDatasetMember(outputContent.toString(), stagedMember);
        }
    }

    private static boolean isValidStageQualifier(String qual) {
        if (qual.length() < 3 || qual.length() > 7) {
            return false;
        }
        String stageQualifier = qual.toUpperCase();
        String patternString = "\\.[A-Z\\$\\#\\@][A-Z0-9\\-\\$\\#\\@]*";
        Pattern p = Pattern.compile(patternString);
        Matcher m = p.matcher(stageQualifier);
        return m.matches();
    }

    private static RecordReader getDatasetReader(String datasetName) {
        String quotedName = null;
        String fullName = null;
        if (datasetName.startsWith("//'")) {
            quotedName = datasetName.substring(2);
            fullName = datasetName;
        } else if (datasetName.startsWith("'")) {
            quotedName = datasetName;
            fullName = String.format("//%s", datasetName);
        } else {
            quotedName = String.format("'%s'", datasetName);
            fullName = String.format("//%s", quotedName);
        }
        RecordReader reader = null;
        try {
            reader = RecordReader.newReader((String)fullName, (int)4);
        }
        catch (ZFileException zfEx) {
            throw new InstallException(1, null, BUNDLE.messageString("AssembleMVSJobcode.FileOpenFailure", quotedName), EN_BUNDLE.messageString("AssembleMVSJobcode.FileOpenFailure", quotedName), zfEx);
        }
        catch (RcException rcEx) {
            throw new InstallException(1, null, BUNDLE.messageString("AssembleMVSJobcode.FileAllocateFailure", quotedName), EN_BUNDLE.messageString("AssembleMVSJobcode.FileWriteFailure", quotedName), rcEx);
        }
        return reader;
    }

    private static String readLine(RecordReader reader) {
        int bytes;
        int lrecl = reader.getLrecl();
        byte[] buffer = new byte[lrecl];
        try {
            bytes = reader.read(buffer);
        }
        catch (ZFileException zfEx) {
            String quotedName = String.format("'%s'", reader.getDsn());
            throw new InstallException(1, null, BUNDLE.messageString("AssembleMVSJobcode.FileReadFailure", quotedName), EN_BUNDLE.messageString("AssembleMVSJobcode.FileReadFailure", quotedName), zfEx);
        }
        if (bytes < 0) {
            return null;
        }
        return new String(buffer);
    }

    public static void setupLoggingForMain() throws UnsupportedEncodingException {
        URL url = MvsextractTask.class.getProtectionDomain().getCodeSource().getLocation();
        if (url != null) {
            String path = URLDecoder.decode(url.getFile(), "UTF-8");
            String dir = new File(path).getParent();
            String propertiesFile = new File(dir, "log4j_mvs.properties").getAbsolutePath();
            LoggerContext ctx = Configurator.initialize(null, (String)propertiesFile);
            ctx.reconfigure();
        }
    }

    public static void reset() {
        log.info("Resetting all job information");
        MvsextractTask.setJobFormInitialized(false);
        globalsInitialized = false;
        installProperties = new Properties();
        UserParams = new HashMap();
    }

    public static String getTemplateLoc() {
        if (_TEMPLATELOC != null) {
            return _TEMPLATELOC;
        }
        _TEMPLATELOC = System.getProperty("MVSTemplatesLocation") != null ? new File(System.getProperty("MVSTemplatesLocation")).getAbsolutePath() : new File(Controller.defaultController().getInstallAppLocation(), "MVSTemplates").getAbsolutePath();
        return _TEMPLATELOC;
    }

    private static void logProcessOutput(BufferedReader out, BufferedReader error) throws IOException {
        String line;
        log.info("====================output streams begin=====================");
        while ((line = out.readLine()) != null) {
            log.info("stdout:" + line);
        }
        while ((line = error.readLine()) != null) {
            log.info("stderr:" + line);
        }
        log.info("====================output streams end=====================");
    }

    public static boolean checkMvsDataSetParams(int function, String value, Properties dsProperties, String location, Logger sdwLog, boolean quiet, StringBuffer msgs) {
        DataSetParamValidator validator = new DataSetParamValidator(dsProperties, location, sdwLog, quiet);
        boolean result = false;
        switch (function) {
            case 1: {
                result = validator.cntlDsAvailable(msgs);
                break;
            }
            case 2: {
                result = validator.checkHighLevelQualifierUsed(value, msgs);
                break;
            }
            case 3: {
                result = validator.checkHighLevelQualifier(value, msgs);
                break;
            }
            case 4: {
                result = validator.checkSMS(msgs);
                break;
            }
            case 5: {
                result = validator.checkSMSPDSE(msgs);
                break;
            }
            case 6: {
                result = validator.checkDiskUnit(value, msgs);
                break;
            }
            case 7: {
                result = validator.checkTempUnit(value, msgs);
                break;
            }
            case 8: {
                result = validator.checkVolDisk(value, msgs);
            }
        }
        validator = null;
        return result;
    }

    private static void allocateControlDataset() {
        String datasetName = UserParams.get("CNTLDSN");
        if (MvsextractTask.checkForNoAlloc(datasetName)) {
            return;
        }
        MvsextractTask.deleteCNTL(datasetName);
        String storclas = null;
        String mgmtclas = null;
        String dataclas = null;
        String voldisk = null;
        String diskunit = null;
        String value = null;
        String prefix = "";
        if (!"false".equalsIgnoreCase(MvsextractTask.getHostProperty("sms"))) {
            prefix = "sms";
        }
        if (!"false".equalsIgnoreCase(MvsextractTask.getHostProperty("sms.pdse"))) {
            prefix = "sms.pdse";
        }
        if (!prefix.isEmpty()) {
            value = MvsextractTask.getHostProperty(prefix.concat(".sc"));
            if (value != null && value.trim().length() > 0) {
                storclas = value.trim();
            }
            if ((value = MvsextractTask.getHostProperty(prefix.concat(".mc"))) != null && value.trim().length() > 0) {
                mgmtclas = value.trim();
            }
            if ((value = MvsextractTask.getHostProperty(prefix.concat(".dc"))) != null && value.trim().length() > 0) {
                dataclas = value.trim();
            }
        } else {
            value = MvsextractTask.getHostProperty("job.voldisk");
            if (value != null && value.trim().length() > 0) {
                voldisk = value.trim();
            }
            if ((value = MvsextractTask.getHostProperty("job.diskunit")) != null && value.trim().length() > 0) {
                diskunit = value.trim();
            }
        }
        smsalloc = (value = MvsextractTask.getHostProperty("sms")) != null && value.equalsIgnoreCase("false") || value == null && voldisk != null ? "" : "%SMS.";
        value = MvsextractTask.getHostProperty("sms.pdse");
        smsallocPdse = value != null && value.equalsIgnoreCase("false") || value == null && voldisk != null ? smsalloc : "%SMS-PDSE.";
        log.info("Creating new control data set '" + datasetName + "'");
        DynamicAllocate da = new DynamicAllocate(Controller.defaultController());
        if (!da.allocateDataset(datasetName, storclas, mgmtclas, dataclas, voldisk, diskunit)) {
            throw new InstallException(1, null, BUNDLE.messageString("AssembleMVSJobcode.ControlDSAddError", datasetName), EN_BUNDLE.messageString("AssembleMVSJobcode.ControlDSAddError", datasetName), null);
        }
    }

    private static boolean checkForNoAlloc(String datasetName) {
        String noalloc = System.getenv("SASNOALLOC");
        if ("TRUE".equalsIgnoreCase(noalloc)) {
            log.info("Control dataset allocation skipped because environment variable SASNOALLOC was set to " + noalloc);
            if (!MvsextractTask.datasetExists(datasetName)) {
                throw new InstallException(1, null, BUNDLE.messageString("MvsextractTask.ControlDSNotFound", datasetName), EN_BUNDLE.messageString("MvsextractTask.ControlDSNotFound", datasetName), null);
            }
            return true;
        }
        return false;
    }

    private static void deleteCNTL(String datasetName) {
        if (MvsextractTask.datasetExists(datasetName)) {
            log.info("Removing existing control data set '" + datasetName + "'");
            String dsn = String.format("//'%s'", datasetName);
            try {
                ZFile.remove((String)dsn);
            }
            catch (ZFileException zfEx) {
                throw new InstallException(1, null, BUNDLE.messageString("AssembleMVSJobcode.ControlDSRemoveError", datasetName), EN_BUNDLE.messageString("AssembleMVSJobcode.ControlDSRemoveError", datasetName), zfEx);
            }
        }
    }

    public static boolean datasetExists(String datasetName) {
        if (null == datasetName) {
            throw new IllegalArgumentException("datasetName cannot be null");
        }
        String quotedName = String.format("'%s'", datasetName);
        String formattedName = String.format("//%s", quotedName);
        try {
            return ZFile.exists((String)formattedName);
        }
        catch (ZFileException zfEx) {
            throw new InstallException(1, null, BUNDLE.messageString("MvsextractTask.DatasetExistsCheckError", quotedName), EN_BUNDLE.messageString("MvsextractTask.DatasetExistsCheckError", quotedName), zfEx);
        }
    }

    public static void removeInstallJobs(String baseName) {
        String datasetName = UserParams.get("CNTLDSN");
        MvsextractTask.removeMembers(datasetName, baseName);
    }

    private static void removeMembers(String datasetName, String baseName) {
        String fullName = String.format("//'%s'", datasetName);
        String pattern = String.format("%s[0-9]+", baseName);
        List<String> members = MvsextractTask.getMembers(fullName, pattern);
        if (members.isEmpty()) {
            return;
        }
        AccessMethodServices ams = new AccessMethodServices();
        for (String member : members) {
            log.info(String.format("Removing member '%s' from dataset '%s'", member, datasetName));
            String input = String.format(" DELETE %s(%s)", datasetName, member);
            ams.addInputLine(input);
        }
        int rc = ams.execute();
        String output = ams.getOutputLines();
        log.info("IDCAMS output:");
        log.info(output);
        if (rc > 4) {
            throw new InstallException(1, null, BUNDLE.messageString("MvsextractTask.InstallJobRemoveError"), EN_BUNDLE.messageString("MvsextractTask.InstallJobRemoveError"), null);
        }
    }

    private static List<String> getMembers(String datasetName, String pattern) {
        ArrayList<String> members = new ArrayList<String>();
        try {
            PdsDirectory dir = new PdsDirectory(datasetName);
            for (PdsDirectory.MemberInfo info : dir) {
                String name = info.getName();
                Pattern memberPattern = Pattern.compile(pattern);
                Matcher m = memberPattern.matcher(name);
                if (!m.matches()) continue;
                members.add(name);
            }
            dir.close();
        }
        catch (IOException ioEx) {
            log.error("Error accessing PDS directory for " + datasetName, (Throwable)ioEx);
            throw new InstallException(1, null, BUNDLE.messageString("MvsextractTask.InstallJobRemoveError"), EN_BUNDLE.messageString("MvsextractTask.InstallJobRemoveError"), ioEx);
        }
        return members;
    }

    private static void copyProperties() throws Exception {
        StringBuffer content = new StringBuffer();
        MvsextractTask.addInstallPropertiesToOvrpcfe(content);
        String installAction = MvsextractTask.addActionPropertiesToOvrpcfe(content);
        log.info("copying properties to OVRPCFE member of " + UserParams.get("CNTLDSN"));
        MvsextractTask.writeTextToDatasetMember(content.toString(), UserParams.get("CNTLDSN"), "OVRPCFE", true);
        content = null;
        HashMap<String, String> keyRef = new HashMap<String, String>();
        MvsextractTask.addInstallPropertiesToSymlist(keyRef);
        MvsextractTask.addDBCSProperiesToSymlist(keyRef);
        MvsextractTask.addUserParamsToSymlist(keyRef);
        StringBuffer symbollistOutput = new StringBuffer();
        String symbollistPromote = null;
        MvsextractTask.readSymbollistTxtFile(keyRef, symbollistOutput);
        if (installAction.equals("A")) {
            symbollistOutput.append("A$=A\nB$=\nC$=\nD$=\n");
        } else if (installAction.equals("B")) {
            symbollistOutput.append("A$=\nB$=B\nC$=\nD$=\n");
        } else if (installAction.equals("C")) {
            symbollistPromote = new String(symbollistOutput.toString() + "A$=A\nB$=\nC$=\nD$=\n");
            symbollistOutput.append("A$=\nB$=\nC$=C\nD$=\n");
            String exp = "\\".concat(UserParams.get("STAGEQUAL"));
            symbollistPromote = symbollistPromote.replaceAll(exp, "");
        }
        MvsextractTask.writeTextToDatasetMember(symbollistOutput.toString(), UserParams.get("CNTLDSN"), "SYMLIST", true);
        if (null != symbollistPromote) {
            MvsextractTask.writeTextToDatasetMember(symbollistPromote, UserParams.get("CNTLDSN"), "SYMLISTP", true);
        }
    }

    private static void addInstallPropertiesToOvrpcfe(StringBuffer content) {
        Enumeration<Object> propertyEnum = installProperties.keys();
        while (propertyEnum.hasMoreElements()) {
            String key = (String)propertyEnum.nextElement();
            String line = key + "=" + installProperties.get(key);
            line = line.replaceAll("\"\"", "\"");
            line = line.replaceAll("\"'", "\"");
            line = line.replaceAll("'\"", "\"");
            line = line.replaceAll("\\=", "=");
            if (MvsextractTask.isZ64()) {
                if (key.equals("z64.high.level.qualifier")) {
                    line = line.replace("z64.high.level.qualifier", "CPFX");
                } else if (key.equals("z64.sms.sc")) {
                    line = line.replace("z64.sms.sc", "SMS-STORCLAS");
                } else if (key.equals("z64.sms.mc")) {
                    line = line.replace("z64.sms.mc", "SMS-MGMTCLAS");
                } else if (key.equals("z64.sms.dc")) {
                    line = line.replace("z64.sms.dc", "SMS-DATACLAS");
                } else if (key.equals("z64.sms.pdse.sc")) {
                    line = line.replace("z64.sms.pdse.sc", "SMS-PDSE-STORCLAS");
                } else if (key.equals("z64.sms.pdse.mc")) {
                    line = line.replace("z64.sms.pdse.mc", "SMS-PDSE-MGMTCLAS");
                } else if (key.equals("z64.sms.pdse.dc")) {
                    line = line.replace("z64.sms.pdse.dc", "SMS-PDSE-DATACLAS");
                } else if (key.equals("z64.job.voldisk")) {
                    line = line.replace("z64.job.voldisk", "VOLDISK");
                } else if (key.equals("z64.job.diskunit")) {
                    line = line.replace("z64.job.diskunit", "DISKUNIT");
                }
            } else if (key.equals("zos.high.level.qualifier")) {
                line = line.replace("zos.high.level.qualifier", "CPFX");
            } else if (key.equals("zos.sms.sc")) {
                line = line.replace("zos.sms.sc", "SMS-STORCLAS");
            } else if (key.equals("zos.sms.mc")) {
                line = line.replace("zos.sms.mc", "SMS-MGMTCLAS");
            } else if (key.equals("zos.sms.dc")) {
                line = line.replace("zos.sms.dc", "SMS-DATACLAS");
            } else if (key.equals("zos.sms.pdse.sc")) {
                line = line.replace("zos.sms.pdse.sc", "SMS-PDSE-STORCLAS");
            } else if (key.equals("zos.sms.pdse.mc")) {
                line = line.replace("zos.sms.pdse.mc", "SMS-PDSE-MGMTCLAS");
            } else if (key.equals("zos.sms.pdse.dc")) {
                line = line.replace("zos.sms.pdse.dc", "SMS-PDSE-DATACLAS");
            } else if (key.equals("zos.job.voldisk")) {
                line = line.replace("zos.job.voldisk", "VOLDISK");
            } else if (key.equals("zos.job.diskunit")) {
                line = line.replace("zos.job.diskunit", "DISKUNIT");
            }
            if (key.equals("zos.job.cards.job1")) {
                line = line.replace("zos.job.cards.job1", "JOBCARD1");
            } else if (key.equals("zos.job.cards.job2")) {
                line = line.replace("zos.job.cards.job2", "JOBCARD2");
            } else if (key.equals("zos.job.cards.job3")) {
                line = line.replace("zos.job.cards.job3", "JOBCARD3");
            } else if (key.equals("zos.job.cards.job4")) {
                line = line.replace("zos.job.cards.job4", "JOBCARD4");
            } else if (key.equals("zos.job.cards.job5")) {
                line = line.replace("zos.job.cards.job5", "JOBCARD5");
            } else if (key.equals("zos.job.sysout")) {
                line = line.replace("zos.job.sysout", "SYSOUT");
            } else if (key.equals("zos.job.intrdr")) {
                line = line.replace("zos.job.intrdr", "INTREADR");
            } else if (key.equals("zos.job.tmpuni")) {
                line = line.replace("zos.job.tmpuni", "TMPUNI");
            } else if (key.equals("zos.job.workspc")) {
                line = line.replace("zos.job.workspc", "WORKSPC");
            } else if (key.equals("ssd.dir1")) {
                line = line.replace("ssd.dir1", "SSDDIR1");
            } else if (key.equals("ssd.dir2")) {
                line = line.replace("ssd.dir2", "SSDDIR2");
            } else {
                if (!key.equals("ssd.dir3")) continue;
                line = line.replace("ssd.dir3", "SSDDIR3");
            }
            while (line.length() > 79) {
                content.append(line.substring(0, 79) + "\\" + newline);
                line = line.substring(79, line.length());
            }
            content.append(line + newline);
        }
    }

    private static String addActionPropertiesToOvrpcfe(StringBuffer content) {
        String installAction = null;
        String installActionProperty = null;
        String installPrefixProperty = null;
        if (MvsextractTask.getHostProperty("install.action").equals("A")) {
            installAction = "A";
            installActionProperty = "INSTALL-NEW=%SASINST-ACT-A.";
            installPrefixProperty = "NEW-SAS-PREFIX=" + MvsextractTask.getHostProperty("high.level.qualifier");
        } else if (MvsextractTask.getHostProperty("install.action").equals("B")) {
            installAction = "B";
            installActionProperty = "INSTALL-DIRECT=%SASINST-ACT-B.";
            installPrefixProperty = "EXISTING-SAS-PFX=" + MvsextractTask.getHostProperty("high.level.qualifier");
        } else if (MvsextractTask.getHostProperty("install.action").equals("C")) {
            installAction = "C";
            installActionProperty = "INSTALL-TO-STAGE=%SASINST-ACT-C.";
            installPrefixProperty = "FINAL-SASLIB-PFX=" + MvsextractTask.getHostProperty("high.level.qualifier");
        }
        content.append(installActionProperty + newline);
        content.append(installPrefixProperty + newline);
        content.append("VIAFTP=" + newline);
        content.append("FTPSFX=FTP" + _cntlDSPostfix + newline);
        content.append("TAPEUNIT=" + newline);
        content.append("CNTLDSN=" + UserParams.get("CNTLDSN") + newline);
        content.append("SMS-ALLOC=" + smsalloc + newline);
        content.append("SMS-ALLOC-PDSE=" + smsallocPdse + newline);
        content.append("RUNAFTERMAKER=" + newline);
        content.append("AUTOUSSLOAD=" + newline);
        content.append("AUTOVALID=" + newline);
        content.append("VIADIR=X" + newline);
        content.append("SASHOME=" + System.getProperty("SASHome") + newline);
        content.append("HFSROOT=" + newline);
        content.append("ENTRY=" + installProperties.getProperty("zos.entry.point"));
        content.append(newline + "GENDONOTRUN=X");
        return installAction;
    }

    private static void addInstallPropertiesToSymlist(HashMap<String, String> keyRef) {
        keyRef.put("STAGEQUAL", UserParams.get("STAGEQUAL"));
        keyRef.put("Install_HLQ", MvsextractTask.getHostProperty("high.level.qualifier") + UserParams.get("STAGEQUAL"));
        keyRef.put("Final_HLQ", MvsextractTask.getHostProperty("high.level.qualifier"));
        keyRef.put("SASHOME", System.getProperty("SASHome"));
        keyRef.put("SASROOT", System.getProperty("SASHome") + "/SASFoundation/" + "9.4");
        keyRef.put("BANGCHAR", MvsextractTask.setExclamationPoint(UserParams.get("ORDERENCODING")));
        keyRef.put("LCLANG", UserParams.get("LC-LANGCODE"));
        keyRef.put("LCENCO", UserParams.get("LC-ORDERENCODING"));
        keyRef.put("USER_LOCALE", (String)installProperties.get("sashome.locale.name"));
        keyRef.put("USER_ENCODING_TYPE", (String)installProperties.get("sashome.zos.encoding.type"));
        keyRef.put("ENCODING_NAME", installProperties.getProperty("sashome.encoding.name"));
        keyRef.put("CNTLDSN", UserParams.get("CNTLDSN_SUFFIX") + ".CNTL");
        keyRef.put("TKOPT_SVCNO", UserParams.get("TKOPT_SVCNO"));
        keyRef.put("TKOPT_SVCR15", UserParams.get("TKOPT_SVCR15"));
        keyRef.put("JREHOME", UserParams.get("JREHOME"));
        if (UserParams.get("SMS-ALLOC") != null && UserParams.get("SMS-ALLOC").equalsIgnoreCase("true")) {
            keyRef.put("SMS_SELECTED", "X");
        } else {
            keyRef.put("SMS_SELECTED", "");
        }
        if (UserParams.get("SMS-ALLOC-PDSE") != null && UserParams.get("SMS-ALLOC-PDSE").equalsIgnoreCase("true")) {
            keyRef.put("SMS_PDSE_SELECTED", "X");
        } else if ("X".equals(keyRef.get("SMS_SELECTED"))) {
            keyRef.put("SMS_PDSE_SELECTED", "X");
        } else {
            keyRef.put("SMS_PDSE_SELECTED", "");
        }
        keyRef.put(SASEDT, UserParams.get(SASEDT));
        if (UserParams.get(XLUPDATED) == null) {
            keyRef.put(XLUPDATED, "");
        } else {
            keyRef.put(XLUPDATED, UserParams.get(XLUPDATED));
        }
    }

    private static void addDBCSProperiesToSymlist(HashMap<String, String> keyRef) {
        if ("DBCS".equalsIgnoreCase((String)installProperties.get("sashome.zos.encoding.type"))) {
            log.info("sashome.zos.encoding.type is DBCS, setting up DBCS symbols");
            String encname = (String)installProperties.get("sashome.zos.encoding.ibm.name");
            String langname = encname.equalsIgnoreCase("IBM-939") ? "JAPANESE" : (encname.equalsIgnoreCase("IBM-933") ? "KOREAN" : (encname.equalsIgnoreCase("IBM-935") ? "CHINESE" : (encname.equalsIgnoreCase("IBM-937") ? "TAIWANESE" : "UNKNOWN")));
            keyRef.put("DBCSTYPE", "IBM");
            keyRef.put("DBENCODING", encname);
            keyRef.put("DBCSLANG", langname);
        }
    }

    private static void addUserParamsToSymlist(HashMap<String, String> keyRef) {
        HashMap<String, String> formattedParams = new HashMap<String, String>();
        for (String key : UserParams.keySet()) {
            String value = UserParams.get(key);
            if (value != null) {
                while (value.startsWith("\"\"") && value.endsWith("\"\"")) {
                    value = value.substring(1, value.length() - 1);
                }
            }
            if (value == null) continue;
            formattedParams.put(key, value);
        }
        keyRef.putAll(UserParams);
        keyRef.putAll(formattedParams);
        for (String key : keyRef.keySet()) {
            log.info(key + "=>'" + keyRef.get(key) + "'");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void readSymbollistTxtFile(HashMap<String, String> keyRef, StringBuffer symbollistOutput) throws IOException {
        BufferedReader reader = null;
        FileInputStream is = null;
        String templatePath = new File(MvsextractTask.getTemplateLoc(), "symbollist.txt").getAbsolutePath();
        try {
            is = new FileInputStream(templatePath);
            InputStreamReader isr = new InputStreamReader(is);
            reader = new BufferedReader(isr);
        }
        catch (FileNotFoundException e) {
            throw new InstallException(3, null, BUNDLE.messageString("AssembleMVSJobcode.TemplateLoadingError", templatePath), EN_BUNDLE.messageString("AssembleMVSJobcode.TemplateLoadingError", templatePath), e);
        }
        try {
            String line = "";
            while (line != null) {
                line = reader.readLine();
                if (line == null) {
                    break;
                }
                line = Utils.replaceProperty(line, keyRef, "\\$\\{", "\\}");
                symbollistOutput.append(line + "\n");
            }
        }
        finally {
            ((InputStream)is).close();
        }
    }

    private static String setExclamationPoint(String encoding) {
        byte[] b = new byte[]{90};
        if (encoding.equalsIgnoreCase("C0") || encoding.equalsIgnoreCase("D0") || encoding.equalsIgnoreCase("R0") || encoding.equalsIgnoreCase("W3") || encoding.equalsIgnoreCase("W4") || encoding.equalsIgnoreCase("W5") || encoding.equalsIgnoreCase("W6") || encoding.equalsIgnoreCase("W7") || encoding.equalsIgnoreCase("WA") || encoding.equalsIgnoreCase("WB")) {
            b[0] = 79;
        } else if (encoding.equalsIgnoreCase("W8")) {
            b[0] = -59;
        }
        return new String(b);
    }

    public static String getHostProperty(String propSuffix) {
        String value = null;
        value = MvsextractTask.isZ64() ? installProperties.getProperty(_z64Prefix + propSuffix) : installProperties.getProperty(_zosPrefix + propSuffix);
        return value;
    }

    public static void setHostProperty(String propSuffix, String propValue) {
        if (MvsextractTask.isZ64()) {
            installProperties.setProperty(_z64Prefix + propSuffix, propValue);
        } else {
            installProperties.setProperty(_zosPrefix + propSuffix, propValue);
        }
    }

    private static void initializeGlobals() {
        String hlq;
        if (globalsInitialized) {
            log.info("global data already initialized");
            return;
        }
        _logInfo.add("initializing global data");
        _logInfo.add("initializing job properties with the following data:\n");
        Enumeration<Object> propertyEnum = installProperties.keys();
        while (propertyEnum.hasMoreElements()) {
            String key = (String)propertyEnum.nextElement();
            if (key.startsWith("zos.host.logon.")) continue;
            _logInfo.add(key + ":  '" + installProperties.getProperty(key) + "'");
        }
        String bitness = installProperties.getProperty("zos.bit.count");
        if (null != bitness && bitness.equals("64")) {
            MvsextractTask.setIsZ64(true);
        }
        if ((hlq = MvsextractTask.getHostProperty("high.level.qualifier")) != null) {
            String cntldsn;
            _cntlDSPostfix = cntldsn = "INSTALL";
            UserParams.put("CNTLDSN", hlq + "." + cntldsn + ".CNTL");
            UserParams.put("CNTLDSN_SUFFIX", cntldsn);
        }
        UserParams.put("DISKUNIT", MvsextractTask.getHostProperty("job.diskunit"));
        UserParams.put("INTREADR", installProperties.getProperty("zos.job.intrdr"));
        UserParams.put("SMS-ALLOC", MvsextractTask.getHostProperty("sms"));
        UserParams.put("SMS-MGMTCLAS", MvsextractTask.getHostProperty("sms.mc"));
        UserParams.put("SMS-DATACLAS", MvsextractTask.getHostProperty("sms.dc"));
        UserParams.put("SMS-STORCLAS", MvsextractTask.getHostProperty("sms.sc"));
        String smsPdse = MvsextractTask.getHostProperty("sms.pdse");
        if (null == smsPdse || "false".equalsIgnoreCase(smsPdse)) {
            UserParams.put("SMS-ALLOC-PDSE", MvsextractTask.getHostProperty("sms"));
            UserParams.put("SMS-PDSE-MGMTCLAS", MvsextractTask.getHostProperty("sms.mc"));
            UserParams.put("SMS-PDSE-DATACLAS", MvsextractTask.getHostProperty("sms.dc"));
            UserParams.put("SMS-PDSE-STORCLAS", MvsextractTask.getHostProperty("sms.sc"));
        } else {
            UserParams.put("SMS-ALLOC-PDSE", MvsextractTask.getHostProperty("sms.pdse"));
            UserParams.put("SMS-PDSE-MGMTCLAS", MvsextractTask.getHostProperty("sms.pdse.mc"));
            UserParams.put("SMS-PDSE-DATACLAS", MvsextractTask.getHostProperty("sms.pdse.dc"));
            UserParams.put("SMS-PDSE-STORCLAS", MvsextractTask.getHostProperty("sms.pdse.sc"));
        }
        UserParams.put("CUSTPRODQUAL", MvsextractTask.getHostProperty("high.level.qualifier"));
        UserParams.put("ENTRY", installProperties.getProperty("zos.entry.point"));
        UserParams.put("TMPUNI", installProperties.getProperty("zos.job.tmpuni"));
        UserParams.put("WORKSPC", installProperties.getProperty("zos.job.workspc"));
        UserParams.put("SYSOUT", installProperties.getProperty("zos.job.sysout"));
        UserParams.put("VOLSER", MvsextractTask.getHostProperty("job.voldisk"));
        UserParams.put("JOBCARD1", installProperties.getProperty("zos.job.cards.job1"));
        UserParams.put("JOBCARD2", installProperties.getProperty("zos.job.cards.job2"));
        UserParams.put("JOBCARD3", installProperties.getProperty("zos.job.cards.job3"));
        UserParams.put("JOBCARD4", installProperties.getProperty("zos.job.cards.job4"));
        UserParams.put("JOBCARD5", installProperties.getProperty("zos.job.cards.job5"));
        UserParams.put("SUBMITJOBS", MvsextractTask.getHostProperty("job.submit"));
        UserParams.put("CHAINJOBS", MvsextractTask.getHostProperty("job.chain"));
        if (installProperties.getProperty("order.encoding") != null) {
            UserParams.put("ORDERENCODING", installProperties.getProperty("order.encoding"));
            UserParams.put("LC-ORDERENCODING", installProperties.getProperty("order.encoding").toLowerCase());
        } else if (installProperties.getProperty("zos.encoding2") != null) {
            UserParams.put("ORDERENCODING", installProperties.getProperty("zos.encoding2"));
            UserParams.put("LC-ORDERENCODING", installProperties.getProperty("zos.encoding2").toLowerCase());
        }
        UserParams.put("LANGCODE", installProperties.getProperty("zos.lang.code2"));
        if (installProperties.getProperty("zos.lang.code2") != null) {
            UserParams.put("LC-LANGCODE", installProperties.getProperty("zos.lang.code2").toLowerCase());
        }
        if (installProperties.getProperty("jre.home") != null) {
            UserParams.put("JREHOME", installProperties.getProperty("jre.home"));
        } else {
            UserParams.put("JREHOME", "JAVA-VER");
        }
        String jrehome = System.getProperty("java.home");
        MvsextractTask.splitProperty(jrehome, UserParams, "SDW_JREHOME", 4);
        String ostempdir = System.getProperty("java.io.tmpdir");
        MvsextractTask.splitProperty(ostempdir, UserParams, "OSTEMPDIR", 3);
        if (installProperties.getProperty("zos.svc.select") != null) {
            if (installProperties.getProperty("zos.svc.select").contains("ESR")) {
                UserParams.put("TKOPT_SVCNO", "109");
                UserParams.put("TKOPT_SVCR15", installProperties.getProperty("zos.svc.type4esr.number"));
            } else {
                UserParams.put("TKOPT_SVCNO", installProperties.getProperty("zos.svc.user.number"));
            }
        }
        if (MvsextractTask.isHotfix()) {
            log.info("Forcing update mode to false for hot fix install");
            UserParams.put("UPDATEMODE", "FALSE");
            UserParams.put(JOBNAME_HOTFIX, "TRUE");
            MvsextractTask.setHostProperty("install.action", "C");
        } else {
            UserParams.put(JOBNAME_HOTFIX, "FALSE");
            if (installProperties.getProperty("update.mode") == null) {
                log.info("No update.mode property received, defaulting update mode to false");
                UserParams.put("UPDATEMODE", "FALSE");
            } else {
                _logInfo.add("Setting update mode to " + installProperties.getProperty("update.mode"));
                UserParams.put("UPDATEMODE", installProperties.getProperty("update.mode").toUpperCase());
            }
        }
        UserParams.put("CATALOGUPDATES", "FALSE");
        if (MvsextractTask.getHostProperty("install.action") != null) {
            String installAction = MvsextractTask.getHostProperty("install.action");
            if (installAction.equals("A")) {
                UserParams.put("STAGEQUAL", "");
                UserParams.put("INSTALL-NEW", "%SASINST-ACT-A.");
            } else if (installAction.equals("B")) {
                UserParams.put("STAGEQUAL", "");
                UserParams.put("INSTALL-DIRECT", "%SASINST-ACT-B.");
            } else if (installAction.equals("C")) {
                if (!MvsextractTask.isHotfix()) {
                    UserParams.put("STAGEQUAL", ".SL");
                }
                UserParams.put("INSTALL-TO-STAGE", "%SASINST-ACT-C.");
            }
        }
        if (!MvsextractTask.isHotfix()) {
            _logInfo.add("globals initialized with the following values:\n");
            for (String key : UserParams.keySet()) {
                _logInfo.add("UserParams{" + key + "}:  '" + UserParams.get(key) + "'");
            }
        }
        globalsInitialized = true;
    }

    public static void setInstallProperties(Properties properties) {
        installProperties = properties;
        globalsInitialized = false;
        MvsextractTask.initializeGlobals();
    }

    public MvsextractTask() {
        if (_logInfo != null) {
            for (String line : _logInfo) {
                log.info(line);
            }
            _logInfo.clear();
        }
        log.debug("In MvsextractTask constructor");
        String key = Controller.defaultController().getAltSku().concat(this.getClass().getName());
        Controller.defaultController().getPostProcessingTasks().put(key, new ProcessingTaskInfo(this.getClass().getName(), "submitJobs"));
        Controller.defaultController().getPostProcessingQueue().add(new ProcessingTask(this.getClass(), "submitJobs"));
        if (null == UserParams.get("HOST")) {
            UserParams.put("HOST", Controller.defaultController().getProperty("Host"));
            log.info("HOST has been set to '" + Controller.defaultController().getProperty("Host") + "'");
        }
        if (null == UserParams.get("VJRHOME1")) {
            String vjrHome = System.getProperty("VJRHome");
            MvsextractTask.splitProperty(vjrHome, UserParams, "VJRHOME", 4);
        }
        if (null == UserParams.get("SDWPATH1")) {
            String runPath = this.getClass().getProtectionDomain().getCodeSource().getLocation().getFile();
            int lastSep = runPath.lastIndexOf("/");
            String itJar = runPath.substring(lastSep + 1);
            UserParams.put("ITJAR", itJar);
            String dwPath = MvsextractTask.isHotfix() ? runPath.substring(0, lastSep) : installProperties.getProperty("sdm.dir") + "/products/" + installProperties.getProperty("deploywiz.altsku") + "/deploywiz";
            MvsextractTask.splitProperty(dwPath, UserParams, "SDWPATH", 4);
        }
        if (MvsextractTask.isHotfix()) {
            String hlq;
            log.debug("setting up stage qualifier for hotfix");
            String stageQual = UserParams.get("STAGEQUAL");
            log.debug("UserParms.get(\"STAGEQUAL\"): '" + stageQual + "'");
            if (stageQual == null || stageQual.isEmpty() || stageQual.contains(" ")) {
                stageQual = Controller.defaultController().getProperty("HotFixVersion");
                log.debug("Controller.defaultController().getProperty(\"HotFixVersion\"): '" + stageQual + "'");
                if (stageQual == null || stageQual.isEmpty() || stageQual.contains(" ")) {
                    stageQual = "HF";
                }
                stageQual = "." + stageQual;
                log.debug("setting UserParams(\"STAGEQUAL\") to '" + stageQual + "'");
                UserParams.put("STAGEQUAL", stageQual);
            }
            if ((hlq = MvsextractTask.getHostProperty("high.level.qualifier")) != null) {
                String cntldsn;
                _cntlDSPostfix = cntldsn = "INSTALL";
                UserParams.put("CNTLDSN", hlq + stageQual + "." + cntldsn + ".CNTL");
                UserParams.put("CNTLDSN_SUFFIX", cntldsn);
            }
        }
        if (!MvsextractTask.isJobFormInitialized()) {
            this.populateBucketsInTemplate(MvsextractTask.templateName());
            MvsextractTask.setJobFormInitialized(true);
        }
    }

    public static int submitJobs() throws Exception {
        MvsextractTask.setJobNamePrefix();
        try {
            if (MvsextractTask.isHotfix()) {
                MvsextractTask.removeStagedRefs();
            }
            if (UserParams.get("INSTALL-NEW") != null || MvsextractTask.isHotfix()) {
                MvsextractTask.allocateControlDataset();
            } else {
                MvsextractTask.removeInstallJobs(_jobNameBase);
                if (MvsextractTask.isStagedInstall()) {
                    MvsextractTask.removeInstallJobs(JOBNAME_PROMOT);
                }
            }
            MvsextractTask.setSasedtProperty();
            MvsextractTask.copyProperties();
            MvsextractTask.createPrdmit();
        }
        catch (Exception e) {
            Controller.logStackTrace(e);
            return -4;
        }
        MvsextractTask.assembleFinalJobForm();
        MvsextractTask.prepareJobs();
        if (!finalJobs.isEmpty()) {
            if (MvsextractTask.shouldSubmitJobs()) {
                JobHelper jobHelper;
                if (MvsextractTask.useFtp()) {
                    String server = installProperties.getProperty("zos.host.logon.host");
                    String user = installProperties.getProperty("zos.host.logon.user");
                    String password = installProperties.getProperty("zos.host.logon.password");
                    jobHelper = new FTPHelper(server, user, password, MvsextractTask.isHotfix(), BUNDLE, EN_BUNDLE);
                } else {
                    jobHelper = new JESHelper(Controller.defaultController());
                }
                MvsextractTask.initializeJobStatus();
                int j = 0;
                for (String jclString : finalJobs) {
                    String jobName = finalJobNames.get(j);
                    log.info(EN_BUNDLE.messageString("MvsextractTask.SubmittingJob", UserParams.get("CNTLDSN"), jobName));
                    if (!jobHelper.submitJob(jobName, jclString)) {
                        log.info(EN_BUNDLE.messageString("MvsextractTask.JobFailure", jobName));
                        return -4;
                    }
                    ++j;
                }
            } else if (MvsextractTask.isHotfix()) {
                log.info(EN_BUNDLE.messageString("MvsextractTask.HotfixSummaryNJS", UserParams.get("CNTLDSN")));
                for (String jobName : finalJobNames) {
                    log.info(jobName);
                }
                log.info(EN_BUNDLE.messageString("MvsextractTask.HotfixInstructionsNJS"));
            }
        }
        return 0;
    }

    private static void setSasedtProperty() {
        String sasedt = UserParams.get(SASEDT);
        if (null != sasedt) {
            return;
        }
        DatasetType ds = JavaEditX.datasetMap.get("XL");
        String loqual = ds.getLOQUAL().trim();
        String suffix = UserParams.get("CNTLDSN_SUFFIX");
        loqual = loqual.replace("[CNTLDSN_SUFFIX]", suffix);
        String hlq = MvsextractTask.getHostProperty("high.level.qualifier");
        String utilib = hlq.concat(".").concat(loqual);
        log.info("Checking for existence of data set '" + utilib + "'");
        if (!MvsextractTask.datasetExists(utilib)) {
            log.info("Data set '" + utilib + "' not found, using SASEDTX");
            UserParams.put(SASEDT, SASEDT_SASEDTX);
            return;
        }
        log.info("Checking data set '" + utilib + "' for SASEDTZ");
        String fullDsn = String.format("//'%s'", utilib);
        List<String> sasedtz = MvsextractTask.getMembers(fullDsn, "SASEDTZ");
        if (sasedtz.isEmpty()) {
            log.info("SASEDTZ not found, will use SASEDTX");
            UserParams.put(SASEDT, SASEDT_SASEDTX);
        } else {
            log.info("SASEDTZ found, will use SASEDTZ");
            UserParams.put(SASEDT, "SASEDTZ");
        }
    }

    private static void setJobNamePrefix() {
        if (MvsextractTask.isHotfix()) {
            _jobNameBase = JOBNAME_HOTFIX;
            return;
        }
        if (UserParams.get("UPDATEMODE").equals("TRUE")) {
            _jobNameBase = JOBNAME_MAINT;
            return;
        }
        _jobNameBase = JOBNAME_INSTAL;
    }

    private static void prepareJobs() {
        String desc = BUNDLE.messageString("MvsextractTask.WritingJobs", UserParams.get("CNTLDSN"));
        NotificationHandler.defaultHandler().fireProgressCompleteNotification(desc);
        StringBuffer jobDescriptions = new StringBuffer();
        jobDescriptions.append("Index of install jobs\n---------------------\n\n");
        finalJobNames = new Vector();
        MvsextractTask.checkForHelpJob();
        int promoteJobNumber = 0;
        int promoteIndex = MvsextractTask.isHelpJobPresent() ? finalJobs.size() - 2 : finalJobs.size() - 1;
        String[] finalJobsCopy = finalJobs.toArray(new String[0]);
        int jobIndex = 0;
        for (String job : finalJobsCopy) {
            if (++jobIndex == finalJobs.size() && MvsextractTask.isHelpJobPresent()) {
                MvsextractTask.prepareHelpJob(jobDescriptions, jobIndex, job);
                break;
            }
            if (MvsextractTask.isStagedInstall() && jobIndex >= promoteIndex) {
                MvsextractTask.preparePromoteJob(jobDescriptions, jobIndex, job, ++promoteJobNumber);
                continue;
            }
            MvsextractTask.prepareInstallJob(jobDescriptions, jobIndex, job);
        }
        MvsextractTask.writeTextToDatasetMember(jobDescriptions.toString(), UserParams.get("CNTLDSN"), "JOBINDEX");
    }

    private static void checkForHelpJob() {
        log.debug("needHelpDoc initialized to true");
        log.debug(String.format("isHotfix() returned %s", MvsextractTask.isHotfix()));
        log.debug(String.format("isZ64() returned %s", MvsextractTask.isZ64()));
        boolean needHelpDoc = true;
        if (MvsextractTask.isHotfix() || MvsextractTask.isZ64()) {
            needHelpDoc = false;
            log.debug("needHelpDoc set to false");
        } else {
            int helpIndex = finalJobs.size() - 1;
            String lastJob = finalJobs.get(helpIndex);
            log.debug(String.format("checking last job at index %d", helpIndex));
            if (!lastJob.contains("docsetup")) {
                log.debug("string 'docsetup' not found, setting needHelpDoc to false");
                needHelpDoc = false;
            }
        }
        MvsextractTask.setHelpJobPresent(needHelpDoc);
    }

    private static void prepareHelpJob(StringBuffer jobDescriptions, int jobIndex, String job) {
        String helpName = _jobNameBase.substring(0, 4).concat("HELP");
        jobDescriptions.append(helpName);
        jobDescriptions.append("\n");
        jobDescriptions.append(finalJobDescriptions.get(jobIndex - 1));
        job = job.replaceFirst("%SYSNAME.", helpName);
        MvsextractTask.writeTextToDatasetMember(job, UserParams.get("CNTLDSN"), helpName);
        finalJobNames.add(helpName);
        finalJobs.remove(jobIndex - 1);
        if (MvsextractTask.isStagedInstall()) {
            finalJobs.remove(jobIndex - 2);
            finalJobs.remove(jobIndex - 3);
        }
    }

    private static void prepareInstallJob(StringBuffer jobDescriptions, int jobIndex, String job) {
        String jobName = _jobNameBase + String.format("%02d", jobIndex);
        jobDescriptions.append(jobName + "\n");
        jobDescriptions.append(finalJobDescriptions.get(jobIndex - 1));
        job = job.replaceFirst("%SYSNAME.", jobName);
        finalJobs.setElementAt(job, jobIndex - 1);
        job = job.replaceFirst("%NEXTJOB.", _jobNameBase + String.format("%02d", jobIndex + 1));
        MvsextractTask.writeTextToDatasetMember(job, UserParams.get("CNTLDSN"), jobName);
        finalJobNames.add(jobName);
    }

    private static void preparePromoteJob(StringBuffer jobDescriptions, int jobIndex, String job, int promoteJobNumber) {
        String jobNameBase = JOBNAME_PROMOT;
        String jobName = jobNameBase + String.format("%02d", promoteJobNumber);
        jobDescriptions.append(jobName + "\n");
        jobDescriptions.append(finalJobDescriptions.get(jobIndex - 1));
        job = job.replaceFirst("%SYSNAME.", jobName);
        job = job.replaceFirst("%NEXTJOB.", jobNameBase + String.format("%02d", promoteJobNumber + 1));
        MvsextractTask.writeTextToDatasetMember(job, UserParams.get("CNTLDSN"), jobName);
        finalJobNames.add(jobName);
        if (jobIndex == finalJobs.size()) {
            finalJobs.remove(jobIndex - 1);
            finalJobs.remove(jobIndex - 2);
        }
    }

    private static void createPrdmit() throws Exception {
        StringBuffer content = new StringBuffer("**** This file defines VALID job symbol info\n**** for installed products.  It may be empty\n");
        Vector<String> nonInstalledProducts = new Vector<String>(productCodes.values());
        for (String installedProduct : installedProducts) {
            content.append(">" + installedProduct + "=X\n");
            nonInstalledProducts.remove(installedProduct);
        }
        for (String productCode : nonInstalledProducts) {
            content.append(">" + productCode + "=\n");
        }
        JavaEditX util = new JavaEditX(MvsextractTask.templateName());
        File dataTable = new File(MvsextractTask.getTemplateLoc(), "MVSDSDataTable.xml");
        DocumentBuilder builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        Document doc = builder.parse(dataTable);
        if (doc == null) {
            throw new Exception();
        }
        String xpathString = "//Dataset[LOQUAL]/MVS2BDSCODE";
        XPathFactory factory = XPathFactory.newInstance();
        XPath xPath = factory.newXPath();
        NodeList codes = (NodeList)xPath.evaluate(xpathString, doc, XPathConstants.NODESET);
        NodeList loquals = doc.getElementsByTagName("LOQUAL");
        for (int i = 0; i < codes.getLength(); ++i) {
            String code = codes.item(i).getTextContent().trim();
            String loqual = loquals.item(i).getTextContent().trim();
            loqual = util.resolveSymbols(loqual, null);
            if (code.equals("TH") || code.equals("TM")) {
                content.append("@@" + code + "=%SP4." + loqual + "\n");
                continue;
            }
            content.append("@@" + code + "=" + loqual + "\n");
        }
        MvsextractTask.writeTextToDatasetMember(content.toString(), UserParams.get("CNTLDSN"), "PRDMIT", true);
    }

    private static void removeStagedRefs() throws IOException {
        int templateIndex = 0;
        for (String templateName : MvsextractTask.getRequiredBuckets()) {
            JavaEditX templateResolver = MvsextractTask.getProcessedTemplates().get(templateName + templateIndex);
            StringBuffer resolvedSection = templateResolver.getInstanceSummary();
            MvsextractTask.saveNonStagedReferences(templateName, resolvedSection, templateResolver);
            ++templateIndex;
        }
        File changedDatasetData = MvsextractTask.getChangedDatasetData();
        File stagedConfigMemberData = MvsextractTask.getStagedConfigMemberData();
        log.info("Serializing Staged config member data to " + stagedConfigMemberData);
        FileOutputStream fos = new FileOutputStream(stagedConfigMemberData);
        ObjectOutputStream o = new ObjectOutputStream(fos);
        o.writeObject(StagedConfigMembers);
        o.close();
        log.info("Serializing changed dataset data to " + changedDatasetData);
        fos = new FileOutputStream(changedDatasetData);
        o = new ObjectOutputStream(fos);
        o.writeObject(ChangedDatasets);
        o.close();
    }

    private static void initializeJobStatus() {
        jobStatus = new HashMap<String, String>(finalJobNames.size());
        for (String jobName : finalJobNames) {
            String status = String.format("-- %s", BUNDLE.getString("MvsextractTask.JobNotSubmitted"));
            jobStatus.put(jobName, status);
        }
    }

    public static void updateValidJobDrivers() throws Exception {
        String validJobsProps = MvsextractTask.getFS().append(System.getProperty("SASHome"), "SASFoundation", "9.4", "dtest", "valid", "validJobs.properties");
        if (Controller.defaultController().getFS().isFile(validJobsProps)) {
            MvsextractTask.processValidJobDriver(validJobsProps);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void processValidJobDriver(String driver) throws Exception {
        InputStream fis = MvsextractTask.getFS().getInputStream(driver);
        InputStreamReader reader = new InputStreamReader(fis);
        BufferedReader in = new BufferedReader(reader);
        String newline = System.getProperty("line.separator");
        StringBuffer outputContent = new StringBuffer();
        String line = null;
        try {
            try {
                line = in.readLine();
            }
            catch (CharConversionException e) {
                fis = MvsextractTask.getFS().getInputStream(driver);
                reader = new InputStreamReader(fis, "IBM-1047");
                in = new BufferedReader(reader);
                line = in.readLine();
            }
            catch (CharacterCodingException f) {
                fis = MvsextractTask.getFS().getInputStream(driver);
                reader = new InputStreamReader(fis, "IBM-1047");
                in = new BufferedReader(reader);
                line = in.readLine();
            }
            log.info("Performing substitutions in valid job driver '" + driver + "'");
            while (line != null) {
                if (line.contains("@")) {
                    line = Utils.stringReplaceAll(line, "@install.prefix@", UserParams.get("CUSTPRODQUAL"));
                    line = Utils.stringReplaceAll(line, "@language@", UserParams.get("LANGCODE"));
                    line = Utils.stringReplaceAll(line, "@encoding@", UserParams.get("ORDERENCODING"));
                }
                outputContent.append(line + newline);
                line = in.readLine();
            }
            log.info("Replaced '@install.prefix@' with '" + UserParams.get("CUSTPRODQUAL") + "'");
            log.info("Replaced '@language@' with '" + UserParams.get("LANGCODE") + "'");
            log.info("Replaced '@encoding@' with '" + UserParams.get("ORDERENCODING") + "'");
        }
        finally {
            in.close();
        }
        OutputStream fos = MvsextractTask.getFS().getOutputStream(driver);
        OutputStreamWriter writer = new OutputStreamWriter(fos);
        try (BufferedWriter out = new BufferedWriter(writer);){
            out.write(outputContent.toString());
        }
    }

    private static File getChangedDatasetData() {
        File installMisc = new File(System.getProperty("SASHome"), "InstallMisc");
        return new File(installMisc, "changedDatasetData" + UserParams.get("STAGEQUAL") + ".dat");
    }

    private static File getStagedConfigMemberData() {
        File installMisc = new File(System.getProperty("SASHome"), "InstallMisc");
        return new File(installMisc, "stagedConfigMemberData" + UserParams.get("STAGEQUAL") + ".dat");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean checkInterrupt() {
        Controller controller;
        Controller controller2 = controller = Controller.defaultController();
        synchronized (controller2) {
            try {
                while (controller.isInterrupt()) {
                    log.info("Pausing to wait for user verification with regard to cancellation");
                    controller.wait();
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (controller.isInstallCancelled()) {
                return true;
            }
        }
        return false;
    }

    public static void writeTextToDatasetMember(String text, String datasetName, String memberName) {
        MvsextractTask.writeTextToDatasetMember(text, datasetName, memberName, false);
    }

    public static void writeTextToDatasetMember(String text, String datasetName, String memberName, boolean keepFile) {
        String fullName = String.format("%s(%s)", datasetName, memberName);
        if (keepFile) {
            MvsextractTask.writeTextFile(text, memberName);
        }
        MvsextractTask.writeTextToDatasetMember(text, fullName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeTextToDatasetMember(String text, String datasetName) {
        String quotedName = String.format("'%s'", datasetName);
        String fullName = String.format("//%s", quotedName);
        String[] lines = text.split("\\n");
        log.info("Writing " + lines.length + " lines to " + quotedName);
        RecordWriter writer = null;
        try {
            try {
                writer = RecordWriter.newWriter((String)fullName, (int)4);
                int lrecl = writer.getLrecl();
                for (String line : lines) {
                    line = MvsextractTask.padRight(line, lrecl);
                    byte[] buffer = line.getBytes();
                    writer.write(buffer, 0, line.length());
                }
            }
            finally {
                if (writer != null) {
                    writer.close();
                }
            }
        }
        catch (ZFileException zfEx) {
            log.error("I/O error writing to " + quotedName, (Throwable)zfEx);
            throw new InstallException(1, null, BUNDLE.messageString("AssembleMVSJobcode.FileWriteFailure", quotedName), EN_BUNDLE.messageString("AssembleMVSJobcode.FileWriteFailure", quotedName), zfEx);
        }
        catch (RcException rcEx) {
            log.error("OS error writing to " + quotedName, (Throwable)rcEx);
            throw new InstallException(1, null, BUNDLE.messageString("AssembleMVSJobcode.FileWriteFailure", quotedName), EN_BUNDLE.messageString("AssembleMVSJobcode.FileWriteFailure", quotedName), rcEx);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void writeTextFile(String text, String fileName) {
        String sysoutPath = System.getProperty("SASHome") + "/InstallMisc/" + fileName + ".txt";
        File sysout = new File(sysoutPath);
        log.info("Writing content to '" + sysout.getAbsolutePath() + "'");
        try {
            FileOutputStream fos = new FileOutputStream(sysout);
            OutputStreamWriter writer = new OutputStreamWriter(fos);
            BufferedWriter out = null;
            try {
                out = new BufferedWriter(writer);
                out.write(text);
            }
            finally {
                if (null != out) {
                    out.close();
                }
            }
        }
        catch (IOException ioEx) {
            throw new InstallException(1, null, BUNDLE.messageString("AssembleMVSJobcode.FileCreationFailure", sysoutPath), EN_BUNDLE.messageString("AssembleMVSJobcode.FileCreationFailure", sysoutPath), ioEx);
        }
    }

    static String padRight(String s, int n) {
        String format = String.format("%s%ds", "%1$-", n);
        return String.format(format, s);
    }

    public static void clearVJRCache() {
        ClearVjrCacheTask clearCache = new ClearVjrCacheTask();
        File nonAPIJar = new File(System.getProperty("VJRHome"));
        nonAPIJar = new File(nonAPIJar, "eclipse");
        nonAPIJar = new File(nonAPIJar, "plugins");
        nonAPIJar = new File(nonAPIJar, "sas.launcher.jar");
        clearCache.setJar(nonAPIJar.getAbsolutePath());
        clearCache.execute();
    }

    public static void assembleFinalJobForm() {
        String desc = BUNDLE.messageString("MvsextractTask.CreatingJobs");
        NotificationHandler.defaultHandler().fireProgressCompleteNotification(desc);
        JavaEditX jobForm = new JavaEditX(MvsextractTask.templateName());
        HashMap<String, String> args = new HashMap<String, String>();
        log.info("\n***********************assembling overall job form START***********************\n");
        jobForm.processTemplateSection(null, args, null);
        log.info("\n***********************assembling overall job form END***********************\n");
        finalJobs = jobForm.getJobs();
        finalJobDescriptions = jobForm.getJobDescriptions();
    }

    @Override
    public String descriptionForLog() {
        return "MvsextractTask";
    }

    @Override
    public void execute() throws InstallException {
        this.checkForZosTools();
        InstallationContext ctx = this.getController().getCurrentContext();
        if (null == ctx) {
            throw new InstallException(3, this, this.getBundle().messageString("MvsextractTask.MissingContext"), this.getEnBundle().messageString("MvsextractTask.MissingContext"), null);
        }
        File payloadDir = ctx.getPayloadDir();
        if (null == payloadDir) {
            throw new InstallException(3, this, this.getBundle().messageString("MvsextractTask.MissingPayloadDir"), this.getEnBundle().messageString("MvsextractTask.MissingPayloadDir"), null);
        }
        String extractionDir = payloadDir.getAbsolutePath();
        MvsextractTask.splitProperty(extractionDir, UserParams, "SSDDIR", 4);
        if (this.getFilename() == null) {
            throw new InstallException(2, this, this.getBundle().messageString("AssembleMVSJobcode.MissingMetadata"), this.getEnBundle().messageString("AssembleMVSJobcode.MissingMetadata"), null);
        }
        NodeList entries = this.entries();
        HashSet<String> changedDatasetCodes = new HashSet<String>();
        for (int i = 0; i < entries.getLength(); ++i) {
            Element entry = (Element)entries.item(i);
            HashMap<String, String> entryParams = new HashMap<String, String>();
            NamedNodeMap attributes = entry.getAttributes();
            for (int j = 0; j < attributes.getLength(); ++j) {
                entryParams.put(attributes.item(j).getNodeName(), attributes.item(j).getNodeValue());
            }
            String dscode = (String)entryParams.get("MVS2BDSCODE");
            changedDatasetCodes.add(dscode);
            String product = (String)entryParams.get("PRODUCT");
            String twoByte = productCodes.get(product);
            if (twoByte != null) {
                installedProducts.add(twoByte);
            }
            if ("XL".equals(dscode)) {
                this.checkForSasedtz(entry);
            }
            if ("base".equals(entryParams.get("PRODUCT")) && !"NE".equals(entryParams.get("ENCODE"))) {
                String packageDir = this.getController().getCurrentContext().getPayloadDir().getAbsolutePath();
                if (!MvsextractTask.isHotfix()) {
                    File parent = new File(packageDir, "en");
                    parent = new File(parent, "setinexp.dir");
                    File core = new File(parent, "core.sas7bcat");
                    File host = new File(parent, "host.sas7bcat");
                    File locale = new File(parent, "locale.sas7bcat");
                    if (!MvsextractTask.isSetInitInitialized()) {
                        this.handleSetinit(core, host, locale);
                    } else {
                        this.handleUpdatedCatalogs(host, locale);
                    }
                }
            }
            if (!MvsextractTask.isSetInitInitialized()) {
                log.info("still looking for base encoded alt-sku:  " + entryParams.get("PRODUCT") + ", " + entryParams.get("ENCODE"));
            }
            if (this.skipBaseM0Registry(entryParams)) continue;
            int templateIndex = 0;
            for (String templateName : MvsextractTask.getRequiredBuckets()) {
                JavaEditX templateResolver = MvsextractTask.getProcessedTemplates().get(templateName + templateIndex);
                if (templateResolver == null) {
                    templateResolver = new JavaEditX(templateName);
                    MvsextractTask.getProcessedTemplates().put(templateName + templateIndex, templateResolver);
                    templateResolver.processTemplateSection("STATICINSTANCES", null, null);
                }
                if (MvsextractTask.getPromoteContexts().get(templateIndex) == 1) {
                    templateResolver.getOverriddenSymbols().put(PROMOTE_KEY, "TRUE");
                } else {
                    templateResolver.getOverriddenSymbols().put(PROMOTE_KEY, "FALSE");
                }
                if (MvsextractTask.getBucketContexts().get(templateIndex) == 0 || MvsextractTask.getBucketContexts().get(templateIndex) == 1 && MvsextractTask.containsBaseContent(entryParams.get("PRODUCT")) || MvsextractTask.getBucketContexts().get(templateIndex) == 2 && !MvsextractTask.containsBaseContent(entryParams.get("PRODUCT"))) {
                    log.info("\n***********************processing qualifiers for template " + templateName + ", entry " + entry.getAttribute("ARTIFACTNAME") + " START***********************\n");
                    templateResolver.processTemplateSection("INSTANCEQUALIFIERS", entryParams, entry);
                    log.info("\n***********************processing qualifiers for template " + templateName + ", entry " + entry.getAttribute("ARTIFACTNAME") + " END***********************\n");
                    if (templateResolver.isLastInstanceQualified()) {
                        log.info("\n***********************processing instance for template " + templateName + ", entry " + entry.getAttribute("ARTIFACTNAME") + " START***********************\n");
                        templateResolver.processTemplateSection("INSTANCE", entryParams, entry);
                        log.info("\n***********************processing instance for template " + templateName + ", entry " + entry.getAttribute("ARTIFACTNAME") + " END***********************\n");
                    }
                } else {
                    log.info("skipping processing of " + templateName + " for product " + entryParams.get("PRODUCT") + " due to base restriction/exclusion rules");
                }
                ++templateIndex;
            }
            log.info("\n***********************processing qualifiers for entries END***********************\n");
            for (String code : changedDatasetCodes) {
                String loqual = JavaEditX.datasetMap.get(code).getLOQUAL();
                if (loqual == null) continue;
                loqual = loqual.replaceAll("\\[CNTLDSN\\]", UserParams.get("CNTLDSN"));
                loqual = loqual.replaceAll("\\[ORDERENCODING\\]", UserParams.get("ORDERENCODING"));
                loqual = loqual.replaceAll("\\[DSLANGCODE\\]", entryParams.get("LANG2BCODE"));
                ChangedDatasets.add(loqual.trim());
            }
        }
    }

    @Override
    public void postExecute() throws Exception {
    }

    @Override
    public void retry() throws InstallException {
    }

    @Override
    public void rollback() throws InstallException {
    }

    private void checkForZosTools() {
        if (_gotZostools && !_skipZostools) {
            log.info("Checking for zostools");
            InstallationContext ctx = this.getController().getCurrentContext();
            if (null == ctx) {
                throw new InstallException(3, this, this.getBundle().messageString("MvsextractTask.MissingContext"), this.getEnBundle().messageString("MvsextractTask.MissingContext"), null);
            }
            File payloadDir = ctx.getPayloadDir();
            if (null == payloadDir) {
                throw new InstallException(3, this, this.getBundle().messageString("MvsextractTask.MissingPayloadDir"), this.getEnBundle().messageString("MvsextractTask.MissingPayloadDir"), null);
            }
            String packageDir = payloadDir.getAbsolutePath();
            int lastLevel = packageDir.lastIndexOf(MvsextractTask.getFS().separator()) + 1;
            if (this.copyZostools(packageDir = packageDir.substring(0, lastLevel).concat(_zostoolsAltSku))) {
                _skipZostools = true;
            }
        }
        if (!_gotZostools && !_skipZostools) {
            _skipZostools = true;
            log.info("Installing saved zostools");
            MvsextractTask mvsextract = new MvsextractTask();
            Mvsextract data = new Mvsextract();
            data.setFilename("zostools_ne.xml");
            mvsextract.setData(data);
            mvsextract.setController(this.getController());
            String dir = "zos";
            if (MvsextractTask.isZ64()) {
                dir = "z64";
            }
            String target = System.getProperty("SASHome") + MvsextractTask.getFS().separator() + "InstallMisc" + MvsextractTask.getFS().separator() + "zostools" + MvsextractTask.getFS().separator() + dir;
            String altSku = MvsextractTask.getFS().getChildren(target)[0];
            String dirPath = target + MvsextractTask.getFS().separator() + altSku;
            File saveInstallFile = this.getController().getInstallFile();
            this.getController().setInstallFile(new File(dirPath, "install.xml"));
            String saveAltSku = Controller.defaultController().getAltSku();
            this.getController().setAltSku("zostools");
            InstallationContext ctx = new InstallationContext(this.getController());
            this.getController().getInstallContexts().put("zostools", ctx);
            ctx.setPayloadDir(new File(dirPath));
            mvsextract.execute();
            this.getController().getInstallContexts().remove("zostools");
            this.getController().setAltSku(saveAltSku);
            this.getController().setInstallFile(saveInstallFile);
        }
    }

    private void checkForSasedtz(Element entry) {
        log.info("Checking UTILIB content for SASEDTZ");
        String sasedt = SASEDT_SASEDTX;
        NodeList members = entry.getElementsByTagName("entry");
        block0: for (int i = 0; i < members.getLength(); ++i) {
            Element member = (Element)members.item(i);
            NamedNodeMap attributes = member.getAttributes();
            for (int j = 0; j < attributes.getLength(); ++j) {
                String value;
                String name = attributes.item(j).getNodeName();
                if (!name.equalsIgnoreCase("MODULENAME") || !(value = attributes.item(j).getNodeValue()).equalsIgnoreCase("sasedtz")) continue;
                log.info("Found SASEDTZ, will use in place of SASEDTX");
                sasedt = "SASEDTZ";
                continue block0;
            }
        }
        UserParams.put(XLUPDATED, "true");
        UserParams.put(SASEDT, sasedt);
    }

    private boolean skipBaseM0Registry(HashMap<String, String> entryParams) {
        if (MvsextractTask.isHotfix()) {
            return false;
        }
        boolean skip = false;
        String product = entryParams.get("PRODUCT");
        String artifactType = entryParams.get("ARTIFACTTYPE");
        String maintVersionString = this.getController().getProperty("MaintVersion");
        if ("base".equals(product) && "XRG".equals(artifactType)) {
            log.info("Base registry content found: " + this.getController().getCurrentContext().getPayloadDir().getAbsolutePath());
            log.info("Base registry maintenance version is " + maintVersionString);
            int maintVersion = Integer.parseInt(maintVersionString);
            if (maintVersion < _maxBaseMaintVersion) {
                log.info("Base registry content skipped so that only latest maintenance version is installed");
                skip = true;
            }
        }
        return skip;
    }

    private void handleSetinit(File core, File host, File locale) {
        File tmpBase = null;
        try {
            boolean ok;
            tmpBase = new File(System.getProperty("SASHome") + "/InstallMisc/temp/basebcat");
            if (!tmpBase.exists() && !(ok = tmpBase.mkdirs())) {
                log.error("Unable to create directory '" + tmpBase + "' for setinit processing");
                throw new InstallException(1, this, BUNDLE.messageString("MvsextractTask.CatalogMkdirsError", tmpBase), EN_BUNDLE.messageString("MvsextractTask.CatalogMkdirsError", tmpBase), null);
            }
        }
        catch (SecurityException e) {
            log.error("Unable to create directory '" + tmpBase + "' for setinit processing");
            throw new InstallException(1, this, BUNDLE.messageString("MvsextractTask.CatalogMkdirsError", tmpBase), EN_BUNDLE.messageString("MvsextractTask.CatalogMkdirsError", tmpBase), e);
        }
        String from = null;
        String to = null;
        try {
            File coreCopy = new File(tmpBase, core.getName());
            from = core.getAbsolutePath();
            to = coreCopy.getAbsolutePath();
            JavaIOFileSystem.copy(from, to);
            File hostCopy = new File(tmpBase, host.getName());
            from = host.getAbsolutePath();
            to = hostCopy.getAbsolutePath();
            JavaIOFileSystem.copy(from, to);
            File localeCopy = new File(tmpBase, locale.getName());
            from = locale.getAbsolutePath();
            to = localeCopy.getAbsolutePath();
            JavaIOFileSystem.copy(from, to);
        }
        catch (Exception ioEx) {
            log.error("Error copying SAS catalog '" + from + "' for setinit processing", (Throwable)ioEx);
            throw new InstallException(1, this, BUNDLE.messageString("MvsextractTask.SetinitCopyError", from, to), EN_BUNDLE.messageString("MvsextractTask.SetinitCopyError", from, to), ioEx);
        }
        String tmpBasePath = tmpBase.getAbsolutePath().replace("#/", "#|");
        int tmpBaseLength = tmpBasePath.length();
        JavaEditX.defaults.setProperty("SETINITDIR1", tmpBasePath.substring(0, tmpBaseLength / 3));
        JavaEditX.defaults.setProperty("SETINITDIR2", tmpBasePath.substring(tmpBaseLength / 3, tmpBaseLength / 3 * 2));
        JavaEditX.defaults.setProperty("SETINITDIR3", tmpBasePath.substring(tmpBaseLength / 3 * 2, tmpBaseLength));
        MvsextractTask.setSetInitInitialized(true);
        log.info("base alt-sku found: " + this.getController().getCurrentContext().getPayloadDir().getAbsolutePath());
    }

    private void handleUpdatedCatalogs(File host, File locale) {
        boolean catalogUpdates = false;
        File tmpUpdt = null;
        try {
            boolean ok;
            tmpUpdt = new File(System.getProperty("SASHome") + "/InstallMisc/temp/updtbcat");
            if (!tmpUpdt.exists() && !(ok = tmpUpdt.mkdirs())) {
                log.error("Unable to create directory '" + tmpUpdt + "' for SAS catalog updates");
                throw new InstallException(1, this, BUNDLE.messageString("MvsextractTask.CatalogMkdirsError", tmpUpdt), EN_BUNDLE.messageString("MvsextractTask.CatalogMkdirsError", tmpUpdt), null);
            }
        }
        catch (SecurityException e) {
            log.error("Unable to create directory '" + tmpUpdt + "' for SAS catalog updates");
            throw new InstallException(1, this, BUNDLE.messageString("MvsextractTask.CatalogMkdirsError", tmpUpdt), EN_BUNDLE.messageString("MvsextractTask.CatalogMkdirsError", tmpUpdt), e);
        }
        String from = null;
        String to = null;
        try {
            if (host.exists()) {
                File hostCopy = new File(tmpUpdt, host.getName());
                from = host.getAbsolutePath();
                to = hostCopy.getAbsolutePath();
                JavaIOFileSystem.copy(from, to);
                catalogUpdates = true;
            }
            if (locale.exists()) {
                File localeCopy = new File(tmpUpdt, locale.getName());
                from = locale.getAbsolutePath();
                to = localeCopy.getAbsolutePath();
                JavaIOFileSystem.copy(locale.getAbsolutePath(), localeCopy.getAbsolutePath());
                catalogUpdates = true;
            }
        }
        catch (Exception e) {
            log.error("Error copying SAS catalog '" + from + "' for SAS catalog updates");
            throw new InstallException(1, this, BUNDLE.messageString("MvsextractTask.CatalogCopyError", from, to), EN_BUNDLE.messageString("MvsextractTask.CatalogCopyError", from, to), e);
        }
        if (catalogUpdates) {
            UserParams.put("CATALOGUPDATES", "TRUE");
            String tmpUpdtPath = tmpUpdt.getAbsolutePath();
            String tmpUpdtPath2 = tmpUpdtPath.replace("#/", "#|");
            int tmpUpdtLength = tmpUpdtPath2.length();
            JavaEditX.defaults.setProperty("CATALOGDIR1", tmpUpdtPath2.substring(0, tmpUpdtLength / 3));
            JavaEditX.defaults.setProperty("CATALOGDIR2", tmpUpdtPath2.substring(tmpUpdtLength / 3, tmpUpdtLength / 3 * 2));
            JavaEditX.defaults.setProperty("CATALOGDIR3", tmpUpdtPath2.substring(tmpUpdtLength / 3 * 2, tmpUpdtLength));
            log.info("Updated catalogs copied to: " + tmpUpdtPath);
        }
    }

    protected static void saveNonStagedReferences(String templateName, StringBuffer resolvedSection, JavaEditX templateResolver) {
        block7: {
            block6: {
                if (!templateName.equals("BucketDefXXCopyOut.txt")) break block6;
                Vector<String> sections = new Vector<String>(Arrays.asList(resolvedSection.toString().split("OUTDD")));
                for (String section : sections) {
                    String dataset;
                    String patternString = "^(=\\S*)(.*)";
                    Pattern p = Pattern.compile(patternString, 40);
                    Object m = p.matcher(section);
                    if (!((Matcher)m).matches() || (dataset = ((Matcher)m).group(1)).length() < 6) continue;
                    dataset = dataset.substring(5, 7);
                    String etc = ((Matcher)m).group(2);
                    patternString = "S M=\\(\\([^,]*,([^\\)]*)\\)\\)|S M=(\\S*)";
                    p = Pattern.compile(patternString, 8);
                    m = p.matcher(etc);
                    while (((Matcher)m).find()) {
                        for (int matchIndex = 1; matchIndex <= ((Matcher)m).groupCount(); ++matchIndex) {
                            String memberName = ((Matcher)m).group(matchIndex);
                            if (memberName == null) continue;
                            String loqual = templateResolver.shorthandTablefixValue(dataset + ":LOQUAL");
                            loqual = templateResolver.resolveSymbols(loqual, null);
                            StagedConfigMembers.add(UserParams.get("CUSTPRODQUAL") + UserParams.get("STAGEQUAL") + "." + loqual + "(" + memberName + ")");
                        }
                    }
                }
                String stageQual = UserParams.get("STAGEQUAL");
                String dsn = UserParams.get("CNTLDSN");
                dsn = dsn.replaceFirst(stageQual, "");
                String fullDsn = String.format("//'%s'", dsn);
                List<String> validJobs = MvsextractTask.getMembers(fullDsn, ".*VALID");
                for (String validJob : validJobs) {
                    StagedConfigMembers.add(String.format("%s(%s)", dsn, validJob));
                }
                break block7;
            }
            if (!templateName.equals("BucketDefXXCopyOutSAS.txt")) break block7;
            String patternString = "FILE DDOTTE\\(([^\\)]*)\\);INPUT;";
            Pattern p = Pattern.compile(patternString, 8);
            Matcher m = p.matcher(resolvedSection.toString());
            while (m.find()) {
                for (int matchIndex = 1; matchIndex <= m.groupCount(); ++matchIndex) {
                    String memberName = m.group(matchIndex);
                    if (memberName == null) continue;
                    String loqual = templateResolver.shorthandTablefixValue("TE:LOQUAL");
                    StagedConfigMembers.add(UserParams.get("CUSTPRODQUAL") + UserParams.get("STAGEQUAL") + "." + loqual + "(" + memberName + ")");
                }
            }
        }
    }

    private boolean copyZostools(String sourceDir) {
        int retval;
        BufferedReader error;
        BufferedReader input;
        Process p;
        String[] cmdArray;
        String target;
        block9: {
            String dir = "zos";
            if (MvsextractTask.isZ64()) {
                dir = "z64";
            }
            log.info("Preparing to copy zostools");
            target = System.getProperty("SASHome") + MvsextractTask.getFS().separator() + "InstallMisc" + MvsextractTask.getFS().separator() + "zostools" + MvsextractTask.getFS().separator() + dir;
            if (MvsextractTask.getFS().exists(target)) {
                cmdArray = new String[]{"/bin/rm", "-rf", target + MvsextractTask.getFS().separator() + "*"};
                try {
                    p = Runtime.getRuntime().exec(cmdArray, null, null);
                    input = new BufferedReader(new InputStreamReader(p.getInputStream()));
                    error = new BufferedReader(new InputStreamReader(p.getErrorStream()));
                    log.info("about to run /bin/rm -rf " + target + MvsextractTask.getFS().separator() + "*");
                    retval = p.waitFor();
                    if (retval != 0) {
                        log.error("Unable to remove contents of " + target + " due to errors:");
                        MvsextractTask.logProcessOutput(input, error);
                        return false;
                    }
                    break block9;
                }
                catch (Exception e) {
                    log.error("Unable to remove contents of " + target + " due to exception:");
                    Controller.logStackTrace(e);
                    return false;
                }
            }
            if (!MvsextractTask.getFS().mkdirs(target)) {
                log.error("Unable to create directory " + target + " for saving a copy of zostools");
                return false;
            }
        }
        cmdArray = new String[]{"/bin/cp", "-rL", sourceDir, target};
        try {
            p = Runtime.getRuntime().exec(cmdArray, null, null);
            input = new BufferedReader(new InputStreamReader(p.getInputStream()));
            error = new BufferedReader(new InputStreamReader(p.getErrorStream()));
            log.info("about to run /bin/cp -rL " + sourceDir + " " + target);
            retval = p.waitFor();
            if (retval != 0) {
                log.error("Unable to make local copy of zostools due to errors:");
                MvsextractTask.logProcessOutput(input, error);
                return false;
            }
        }
        catch (Exception e) {
            log.error("Unable to make local copy of zostools due to exception:");
            Controller.logStackTrace(e);
            return false;
        }
        log.info("Local copy of zostools made from " + sourceDir + " to " + target);
        return true;
    }

    public static boolean containsBaseContent(String twelveByte) {
        if ("base".equals(twelveByte)) {
            return true;
        }
        if ("baseui".equals(twelveByte)) {
            return true;
        }
        if (twelveByte.startsWith("tk")) {
            if ("tk".equals(twelveByte)) {
                return true;
            }
            if ("tkcore".equals(twelveByte)) {
                return true;
            }
            if ("tkfnc".equals(twelveByte)) {
                return true;
            }
            if ("tkformats".equals(twelveByte)) {
                return true;
            }
            if ("tkgrid".equals(twelveByte)) {
                return true;
            }
            if ("tkintr".equals(twelveByte)) {
                return true;
            }
            if ("tkiom".equals(twelveByte)) {
                return true;
            }
            if ("tkjava".equals(twelveByte)) {
                return true;
            }
            if ("tkl4sas".equals(twelveByte)) {
                return true;
            }
            if ("tkmeta".equals(twelveByte)) {
                return true;
            }
            if ("tknls".equals(twelveByte)) {
                return true;
            }
            if ("tkolap".equals(twelveByte)) {
                return true;
            }
            if ("tkoldoc".equals(twelveByte)) {
                return true;
            }
            if ("tksecure".equals(twelveByte)) {
                return true;
            }
        }
        return false;
    }

    public NodeList entries() {
        Document metadata = null;
        File metadataFile = new File(this.getFilename());
        try {
            DocumentBuilder builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            metadata = builder.parse(metadataFile);
        }
        catch (Exception e) {
            throw new InstallException(0, this, this.getBundle().messageString("AssembleMVSJobcode.FileReadFailure", metadataFile.getAbsolutePath()), "An error has occurred while trying to read " + metadataFile.getAbsolutePath(), e);
        }
        return metadata.getElementsByTagName("pkg");
    }

    public static String templateName() {
        if (UserParams.get("INSTALL-NEW") != null) {
            return "JobFormNewInst.txt";
        }
        if (UserParams.get("INSTALL-DIRECT") != null) {
            return "JobFormDirectInst.txt";
        }
        if (UserParams.get("INSTALL-TO-STAGE") != null) {
            return "JobFormStagedInst.txt";
        }
        return null;
    }

    public void populateBucketsInTemplate(String templateName) {
        MvsextractTask.setRequiredBuckets(new Vector<String>());
        MvsextractTask.setBucketContexts(new Vector<Integer>());
        MvsextractTask.setPromoteContexts(new Vector<Integer>());
        FileInputStream is = null;
        String templatePath = new File(MvsextractTask.getTemplateLoc(), templateName).getAbsolutePath();
        try {
            is = new FileInputStream(templatePath);
        }
        catch (FileNotFoundException fnfEx) {
            throw new InstallException(3, this, this.getBundle().messageString("AssembleMVSJobcode.TemplateLoadingError", templatePath), this.getEnBundle().messageString("AssembleMVSJobcode.TemplateLoadingError", templatePath), fnfEx);
        }
        InputStreamReader isr = new InputStreamReader(is);
        BufferedReader reader = new BufferedReader(isr);
        String line = "";
        Integer currentContext = 0;
        Integer promoteContext = 0;
        try {
            while (line != null) {
                line = reader.readLine();
                if (line == null) {
                    break;
                }
                if (line.startsWith("#BUCKETINSERT")) {
                    Pattern p = Pattern.compile("#BUCKETINSERT\\s*(\\S*)\\s*.*");
                    Matcher m = p.matcher(line);
                    if (!m.matches()) {
                        throw new InstallException(3, this, this.getBundle().messageString("AssembleMVSJobcode.BucketNameUnparseable", templatePath), this.getEnBundle().messageString("AssembleMVSJobcode.BucketNameUnparseable", templatePath), null);
                    }
                    String bucketFile = m.group(1);
                    MvsextractTask.getRequiredBuckets().add(bucketFile);
                    MvsextractTask.getBucketContexts().add(currentContext);
                    MvsextractTask.getPromoteContexts().add(promoteContext);
                    log.info(bucketFile + " added to required templates list");
                    continue;
                }
                if (line.startsWith("#ENDEXCLUDEBBSCONTENT")) {
                    currentContext = 0;
                    continue;
                }
                if (line.startsWith("#EXCLUDEBBSCONTENT")) {
                    currentContext = 2;
                    continue;
                }
                if (line.startsWith("#RESTRICTTOBASEZEROALTSKU")) {
                    currentContext = 1;
                    continue;
                }
                if (line.startsWith("#ENDRESTRICTTOBASEZEROALTSKU")) {
                    currentContext = 0;
                    continue;
                }
                if (line.startsWith("#PROMOTEPROCESSING")) {
                    promoteContext = 1;
                    log.info("=========== Begin PROMOTE=TRUE processing");
                    continue;
                }
                if (!line.startsWith("#ENDPROMOTEPROCESSING")) continue;
                promoteContext = 0;
                log.info("=========== End PROMOTE=TRUE processing");
            }
        }
        catch (IOException ioEx) {
            throw new InstallException(3, this, this.getBundle().messageString("AssembleMVSJobcode.FileReadFailure", templatePath), this.getEnBundle().messageString("AssembleMVSJobcode.FileReadFailure", templatePath), ioEx);
        }
        finally {
            MvsextractTask.closeQuietly(reader, templatePath);
        }
    }

    public static void splitProperty(String source, Map<String, String> targetMap, String baseName, int keyCount) {
        String newSource = source.replace("#/", "#|");
        int length = source.length();
        int splitLength = length / keyCount;
        for (int i = 0; i < keyCount; ++i) {
            int start = length / keyCount * i;
            int end = keyCount - i == 1 ? length : splitLength * (i + 1);
            String split = newSource.substring(start, end);
            String name = String.format("%s%d", baseName, i + 1);
            targetMap.put(name, split);
        }
    }

    @Override
    public synchronized void preExecute() throws Exception {
        String maintVersionString;
        int maintVersion;
        super.preExecute();
        String product = this.getController().getAltSku();
        if (product.startsWith("zostools")) {
            _gotZostools = true;
            _zostoolsAltSku = product;
        }
        if (product.startsWith("base_") && (maintVersion = Integer.parseInt(maintVersionString = this.getController().getProperty("MaintVersion"))) > _maxBaseMaintVersion) {
            log.info("Setting max Base maintenance version to " + maintVersionString);
            _maxBaseMaintVersion = maintVersion;
        }
    }

    private static void closeQuietly(Closeable closeable, String path) {
        if (closeable != null) {
            try {
                closeable.close();
            }
            catch (IOException ioEx) {
                String message = EN_BUNDLE.messageString("AssembleMVSJobcode.FileCloseFailure", path);
                log.warn(message, (Throwable)ioEx);
            }
        }
    }

    public String getFilename() {
        String retval = ((Mvsextract)this.getData()).getFilename();
        retval = this.resolveProperty(retval);
        return new File(this.getController().getPackageDir(), retval).getAbsolutePath();
    }

    public static Vector<String> getRequiredBuckets() {
        return _requiredBuckets;
    }

    public static void setRequiredBuckets(Vector<String> requiredBuckets) {
        _requiredBuckets = requiredBuckets;
    }

    public static HashMap<String, JavaEditX> getProcessedTemplates() {
        return _processedTemplates;
    }

    public static void setProcessedTemplates(HashMap<String, JavaEditX> processedTemplates) {
        _processedTemplates = processedTemplates;
    }

    public static Vector<Integer> getBucketContexts() {
        return _bucketContexts;
    }

    public static void setBucketContexts(Vector<Integer> bucketContexts) {
        _bucketContexts = bucketContexts;
    }

    public static Vector<Integer> getPromoteContexts() {
        return _promoteContexts;
    }

    public static void setPromoteContexts(Vector<Integer> promoteContexts) {
        _promoteContexts = promoteContexts;
    }

    public static FileSystem getFS() {
        return _fs;
    }

    public static void setFS(FileSystem fs) {
        _fs = fs;
    }

    public static boolean isHelpJobPresent() {
        return _helpJobPresent;
    }

    public static void setHelpJobPresent(boolean helpJobPresent) {
        _helpJobPresent = helpJobPresent;
    }

    public static boolean isJobFormInitialized() {
        return _jobFormInitialized;
    }

    public static void setJobFormInitialized(boolean jobFormInitialized) {
        _jobFormInitialized = jobFormInitialized;
    }

    public static boolean isSetInitInitialized() {
        return _setInitInitialized;
    }

    public static void setSetInitInitialized(boolean setInitInitialized) {
        _setInitInitialized = setInitInitialized;
    }

    public static boolean isZ64() {
        return _isZ64;
    }

    public static void setIsZ64(boolean z64) {
        _isZ64 = z64;
    }

    public static boolean isHotfix() {
        return null != installProperties.getProperty("zos.hotfix");
    }

    public static boolean isStagedInstall() {
        return null != UserParams.get("INSTALL-TO-STAGE");
    }

    public static boolean isNewInstall() {
        return null != UserParams.get("INSTALL-NEW");
    }

    public static boolean shouldSubmitJobs() {
        return "TRUE".equalsIgnoreCase(MvsextractTask.getHostProperty("job.submit"));
    }

    public static boolean useFtp() {
        return "TRUE".equalsIgnoreCase(MvsextractTask.getHostProperty("use.ftp"));
    }

    public static Map<String, String> getJobStatus() {
        return jobStatus;
    }

    static {
        globalsInitialized = false;
        _processedTemplates = new HashMap();
        UserParams = new HashMap();
        ChangedDatasets = new HashSet<String>(Arrays.asList("BAMISC", "CLIST", "CONFIG", "DQ.CONFIG", "INSTALL.CNTL", "PROCLIB", "SASRX", "SASRXCFG", "TKMVSENV"));
        StagedConfigMembers = new HashSet();
        _TEMPLATELOC = null;
        BUNDLE = new SSNResource(MvsextractTask.class);
        EN_BUNDLE = SSNResource.EnglishResource(MvsextractTask.class);
        log = (org.apache.logging.log4j.core.Logger)LogManager.getLogger((String)"com.sas.tools.installs.it.tasks.MvsextractTask");
        installProperties = new Properties();
        installedProducts = new HashSet<String>();
        productCodes = new HashMap();
        newline = System.getProperty("line.separator");
        _fs = new JavaIOFileSystem();
        smsalloc = "";
        smsallocPdse = "";
        _isZ64 = false;
        _gotZostools = false;
        _skipZostools = false;
        _zostoolsAltSku = null;
        _maxBaseMaintVersion = 0;
        _jobFormInitialized = false;
        _setInitInitialized = false;
        _cntlDataSetCreated = false;
        _cntlDataSetPrepared = false;
        productCodes.put("itmadaptsap", "AI");
        productCodes.put("ets", "ET");
        productCodes.put("graph", "GR");
        productCodes.put("sashpf", "HP");
        productCodes.put("itsvserver", "IS");
        productCodes.put("iml", "ML");
        productCodes.put("or", "OR");
        productCodes.put("qc", "QC");
        productCodes.put("dquality", "QL");
        productCodes.put("stat", "ST");
        productCodes.put("mxg", "XG");
        productCodes.put("itrmmvadata", "I8");
        productCodes.put("itmsmvadata", "I9");
        productCodes.put("mapsgfk", "MK");
        productCodes.put("mapsgeo", "MK");
        productCodes.put("mapssas", "MP");
    }
}

