/*
 * Decompiled with CFR 0.152.
 */
package com.sas.tools.installs.it.tasks;

import java.io.IOException;
import java.io.Writer;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.core.Logger;

public class LogLineWriter
extends Writer {
    private final Logger log;
    private final Level level;
    private final String prefix;
    private final StringBuffer buffer;

    public LogLineWriter(Logger log, Level level, String prefix) {
        if (log == null) {
            throw new IllegalArgumentException("log instance can't be null");
        }
        if (level == null) {
            throw new IllegalArgumentException("log level can't be null");
        }
        this.log = log;
        this.level = level;
        this.prefix = prefix != null ? prefix : "";
        this.buffer = new StringBuffer();
    }

    @Override
    public void write(char[] cbuf, int off, int len) throws IOException {
        assert (cbuf != null) : "character buffer can't be null";
        assert (cbuf.length >= off + len) : "offset + length must be valid indexes of cbuf";
        for (int i = 0; i < len; ++i) {
            char c = cbuf[off + i];
            if (c == '\n' || c == '\r') {
                this.flush();
                continue;
            }
            this.buffer.append(c);
        }
    }

    @Override
    public void flush() throws IOException {
        if (this.buffer.length() > 0) {
            this.log.log(this.level, this.prefix + this.buffer.toString());
            this.buffer.setLength(0);
        }
    }

    @Override
    public void close() throws IOException {
        this.flush();
    }
}

