/*
 * Decompiled with CFR 0.152.
 */
package com.sas.tools.installs.it.tasks;

import com.sas.tools.installs.it.Controller;
import com.sas.tools.installs.it.InstallException;
import com.sas.tools.installs.it.tasks.InstallationTask;
import com.sas.tools.installs.it.vjr.VJRExtractTask;
import com.sas.tools.installs.it.vjr.VJRList;
import com.sas.tools.installs.it.vjr.VJRManager;
import java.io.File;
import java.util.List;

public class ExtractVJRContentTask
extends InstallationTask {
    private List<VJRExtractTask> vjrExtractList;
    File vjrlistFile;

    public ExtractVJRContentTask() {
        block6: {
            this.vjrExtractList = null;
            this.vjrlistFile = null;
            if (Controller.uninstall_mode) {
                this.log.info("Uninstall mode, no action to perform");
            } else {
                Controller controller = Controller.defaultController();
                String packageDir = controller.getPackageDir();
                this.vjrlistFile = new File(packageDir, "vjrlist");
                this.log.info("Processing VJR list file for " + controller.getAltSku() + ": " + this.vjrlistFile.getAbsolutePath());
                try {
                    if (this.vjrlistFile.isFile()) {
                        VJRList vjrlist = VJRList.read(this.vjrlistFile);
                        this.vjrExtractList = VJRManager.getInstance().queueExtractTasksForVjrList(controller.getProperty("install_sas.startup.location"), controller.getProperty("SASHome"), vjrlist);
                        for (VJRExtractTask vjrExtractTask : this.vjrExtractList) {
                            this._fileCount += vjrExtractTask.getFileCount();
                        }
                        break block6;
                    }
                    String msg = "Vjrlist file  " + this.vjrlistFile.getAbsolutePath() + " is not found for  " + controller.getAltSku();
                    throw new InstallException(2, this, msg, msg, null);
                }
                catch (Exception e) {
                    String msg = "Error occurred processing vjr list file for " + controller.getAltSku() + ": " + this.vjrlistFile.getAbsolutePath();
                    throw new InstallException(2, this, msg, msg, e);
                }
            }
        }
    }

    @Override
    public String descriptionForLog() {
        return null;
    }

    @Override
    public void preExecute() throws InstallException {
        if (this.vjrExtractList != null) {
            try {
                for (VJRExtractTask vjrExtractTask : this.vjrExtractList) {
                    vjrExtractTask.preExecute();
                }
            }
            catch (Exception e) {
                String msg = "Error occurred performing preexecutes for " + this.getController().getAltSku() + ": " + this.vjrlistFile.getAbsolutePath();
                throw new InstallException(2, this, msg, msg, e);
            }
        }
    }

    @Override
    public void execute() throws InstallException {
        if (this.vjrExtractList != null) {
            for (VJRExtractTask vjrExtractTask : this.vjrExtractList) {
                try {
                    vjrExtractTask.execute();
                }
                catch (Exception e) {
                    String msg = "Error occurred while executing VJRExtractTask for: " + vjrExtractTask.getFilename();
                    throw new InstallException(2, this, msg, msg, e);
                }
            }
        }
    }

    @Override
    public void retry() throws InstallException {
    }

    @Override
    public void rollback() throws InstallException {
    }

    @Override
    public void postExecute() throws Exception {
        if (this.vjrExtractList != null) {
            for (VJRExtractTask vjrExtractTask : this.vjrExtractList) {
                try {
                    vjrExtractTask.postExecute();
                }
                catch (Exception e) {
                    String msg = "Error occurred while performing VJRExtractTask post execute for: " + vjrExtractTask.getFilename();
                    throw new InstallException(2, this, msg, msg, e);
                }
            }
        }
    }

    public static void reset() {
        VJRManager.getInstance().clearVJRExtractTasksQueue();
    }
}

