/*
 * Decompiled with CFR 0.152.
 */
package com.sas.tools.installs.it.tasks;

import com.sas.tools.installs.it.InstallException;
import com.sas.tools.installs.it.RegistryAccess;
import com.sas.tools.installs.it.schema.install.gen.EditDeploymentRegistry;
import com.sas.tools.installs.it.tasks.InstallationTask;

public class EditDeploymentRegistryTask
extends InstallationTask {
    @Override
    public String descriptionForLog() {
        return null;
    }

    @Override
    public void preExecute() {
    }

    @Override
    public void execute() throws InstallException {
        if (!this.isUndo()) {
            try {
                this.getRegistryAccess().open();
                if ("removeInstall".equalsIgnoreCase(this.getAction())) {
                    this.log.info("removing deployment registry key: " + this.getHost() + "/" + this.getProduct() + "/" + this.getVersion());
                    this.getRegistryAccess().removeInstall(this.getProduct(), this.getVersion(), this.getHost());
                } else {
                    this.log.warn("Deployment registry action " + this.getAction() + " not defined.");
                }
            }
            catch (Exception e) {
                this.log.error("Deployment registry failure", (Throwable)e);
            }
            finally {
                this.getRegistryAccess().close();
            }
        }
    }

    @Override
    public void postExecute() throws Exception {
    }

    @Override
    public void retry() throws InstallException {
    }

    @Override
    public void rollback() throws InstallException {
    }

    private RegistryAccess getRegistryAccess() {
        return this.getController().getSASController().getAccess();
    }

    private String getAction() {
        return ((EditDeploymentRegistry)this.getData()).getAction();
    }

    private String getProduct() {
        return this.resolveProperty(((EditDeploymentRegistry)this.getData()).getProduct());
    }

    private String getVersion() {
        return this.resolveProperty(((EditDeploymentRegistry)this.getData()).getVersion());
    }

    public String getHost() {
        return this.resolveProperty(((EditDeploymentRegistry)this.getData()).getHost());
    }
}

