/*
 * Decompiled with CFR 0.152.
 */
package com.sas.tools.installs.it.tasks;

import com.sas.tools.installs.it.Controller;
import com.sas.tools.installs.it.InstallException;
import com.sas.tools.installs.it.schema.install.gen.FileList;
import com.sas.tools.installs.it.schema.install.gen.RunFileUtility;
import com.sas.tools.installs.it.schema.install.gen.Substitution;
import com.sas.tools.installs.it.schema.install.gen.SubstitutionValue;
import com.sas.tools.installs.it.tasks.InstallationTask;
import com.sas.tools.installs.it.tasks.RunFileUtilityTask;
import java.io.File;

public class ConfigureUnixAuthenticationTask
extends InstallationTask {
    private static final String SAS_FOUNDATION = Controller.defaultController().getProperty("ProductHome");
    private static final String UNIX_SASAUTHCONF_PATH = "utilities/bin/sasauth.conf";

    @Override
    public String descriptionForLog() {
        return "Configure Unix Authentication";
    }

    @Override
    public void execute() throws InstallException {
        if (!Controller.uninstall_mode) {
            String sasauthConfPath = UNIX_SASAUTHCONF_PATH;
            File sasauthConf = new File(SAS_FOUNDATION + File.separator + sasauthConfPath);
            String authentication_default = "methods=pw";
            String pam_authentication = "methods=pam";
            String pam_setting = Controller.installProperties.getProperty("sasinstall.use.pam");
            if (pam_setting == null) {
                this.log.info("Property sasinstall.use.pam is not defined, defaulting property to false.");
                pam_setting = "false";
            }
            if (pam_setting.equals("true")) {
                this.log.info("Configuring for PAM authentication");
                this.updateSasAuth(sasauthConf, authentication_default, pam_authentication);
            } else {
                this.log.info("Configuring for standard password authentication");
            }
        }
    }

    protected void updateSasAuth(File sasauthConf, String oldstr, String newstr) {
        String sasauthConfPath = sasauthConf.getAbsolutePath();
        Substitution subst = new Substitution();
        SubstitutionValue newVal = new SubstitutionValue();
        subst.setPattern(oldstr);
        newVal.setValue(newstr);
        subst.setValue(newVal);
        FileList fileList = new FileList();
        fileList.getFile().add(sasauthConfPath);
        RunFileUtility runFileUtility = new RunFileUtility();
        runFileUtility.setAction("substitute");
        runFileUtility.getSubstitution().add(subst);
        runFileUtility.setFileList(fileList);
        RunFileUtilityTask runFileUtilityTask = new RunFileUtilityTask();
        runFileUtilityTask.setData(runFileUtility);
        runFileUtilityTask.setController(this.getController());
        runFileUtilityTask.execute();
    }

    @Override
    public void postExecute() throws Exception {
    }

    @Override
    public void retry() throws InstallException {
    }

    @Override
    public void rollback() throws InstallException {
    }
}

