/*
 * Decompiled with CFR 0.152.
 */
package com.sas.tools.installs.it.tasks;

import com.sas.tools.deployjni.JNIUtils;
import com.sas.tools.deployjni.winregistry.WinRegAPI;
import com.sas.tools.installs.it.InstallException;
import com.sas.tools.installs.it.WindowsRegistry;
import com.sas.tools.installs.it.tasks.InstallationTask;
import com.sas.tools.installs.it.tasks.TaskHelper;
import java.util.HashMap;

public class ConfigureODBCDriverTask
extends InstallationTask {
    WindowsRegistry _winReg = null;
    protected String _existingWQEDDE32Path = null;
    public static final boolean WINDOWS_OS = TaskHelper.getOS() == 1;
    public static final boolean WINDOWS_32 = TaskHelper.getOS_Suffix().equalsIgnoreCase("win");
    private static ConfigureODBCDriverTask _configureODBCDriverTask = null;

    public ConfigureODBCDriverTask() {
        _configureODBCDriverTask = this;
        this._winReg = new WindowsRegistry();
    }

    @Override
    public void preExecute() throws Exception {
        this._winReg.setUninstallLog(this.getController().metadataBackupDirectory(), "ConfigureODBCDriver");
        if (this.getController().getProperty("Host").equalsIgnoreCase("wx6")) {
            this._winReg.setBitMode(64);
        } else {
            this._winReg.setBitMode(32);
        }
        if (!JNIUtils.libraryLoaded((String)JNIUtils.JNI_LIB_BASE, (HashMap)WinRegAPI.libNames)) {
            String missingLib = JNIUtils.getJniLib((HashMap)WinRegAPI.libNames);
            throw new InstallException(2, null, this._bundle.messageString("Shared.MissingJNILib", missingLib), "Unable to load library:  " + missingLib, null);
        }
        if (this.isUndo()) {
            return;
        }
        this.notifySetup("Installing ODBCDriver");
        this.log.debug("in ODBCDriver preExecute");
        String subKey = "SOFTWARE\\ODBC\\ODBCINST.INI\\SAS\\FileList";
        String value = "WQEDDE32.DLL";
        if (this._winReg.keyExists(8, subKey)) {
            this._existingWQEDDE32Path = this._winReg.getValue(8, subKey, value);
        }
    }

    @Override
    public void execute() {
        if (this.isUndo()) {
            this._winReg.uninstallRegistryKeys();
            return;
        }
        this.log.info("Configuring ODBCDriver");
        String[] subKeyList = null;
        String[] serverDefs = new String[]{"SAS_x_SERV_", "SAS_x_SERVERS", "SAS_x_UNIQUE_IDS"};
        int hKey = 8;
        hKey = 8;
        String subKey = "SOFTWARE\\ODBC\\ODBC.INI\\SAS_x_METH32_tcp";
        if (!this._winReg.keyExists(hKey, subKey)) {
            this._winReg.createKey(hKey, subKey);
        }
        this._winReg.setValue(hKey, subKey, "SPDSCOMMDLL", "spds.dll", 109);
        this._winReg.setValue(hKey, subKey, "WQCOMMDLL", "wqetcp32.dll", 109);
        subKey = "SOFTWARE\\ODBC\\ODBC.INI\\SAS_x_METHODS";
        if (!this._winReg.keyExists(hKey, subKey)) {
            this._winReg.createKey(hKey, subKey);
        }
        this._winReg.setValue(hKey, subKey, "tcp", "", 109);
        subKey = "SOFTWARE\\ODBC\\ODBCINST.INI\\SAS";
        if (!this._winReg.keyExists(hKey, subKey)) {
            this._winReg.createKey(hKey, subKey);
        }
        this._winReg.setValue(hKey, subKey, "APILevel", "0", 109);
        this._winReg.setValue(hKey, subKey, "ConnectFunctions", "YYN", 109);
        this._winReg.setValue(hKey, subKey, "DriverODBCVer", "03.52", 109);
        this._winReg.setValue(hKey, subKey, "FileUsage", "0", 109);
        this._winReg.setValue(hKey, subKey, "SQLLevel", "0", 109);
        this._winReg.setValue(hKey, subKey, "UsageCount", "0x0001", 101);
        this._winReg.setValue(hKey, subKey, "Driver", this.resolveProperty("${ProductHome}\\sasdrv32.dll"), 109);
        this._winReg.setValue(hKey, subKey, "Setup", this.resolveProperty("${ProductHome}\\sasoc32.dll"), 109);
        subKey = "SOFTWARE\\ODBC\\ODBCINST.INI\\ODBC Drivers";
        if (!this._winReg.keyExists(hKey, subKey)) {
            this._winReg.createKey(hKey, subKey);
        }
        this._winReg.setValue(hKey, subKey, "SAS", "Installed", 109);
        subKey = "SOFTWARE\\ODBC\\ODBCINST.INI\\SAS\\FileList";
        if (!this._winReg.keyExists(hKey, subKey)) {
            this._winReg.createKey(hKey, subKey);
        }
        this._winReg.setValue(hKey, subKey, "WQETCP32.DLL", this.resolveProperty("${ProductHome}"), 109);
        this._winReg.setValue(hKey, subKey, "SASDRV32.DLL", this.resolveProperty("${ProductHome}"), 109);
        this._winReg.setValue(hKey, subKey, "SASOC32.DLL", this.resolveProperty("${ProductHome}"), 109);
        this._winReg.setValue(hKey, subKey, "SASODBC.CHM", this.resolveProperty("${ProductHome}"), 109);
        this._winReg.setValue(hKey, subKey, "SASODBC.GID", this.resolveProperty("${ProductHome}"), 109);
        this._winReg.setValue(hKey, subKey, "SHAREDRESOURCE.DLL", this.resolveProperty("${ProductHome}"), 109);
        hKey = 4;
        subKey = "SOFTWARE\\ODBC\\ODBC.INI\\SAS_x_METH32_tcp";
        if (!this._winReg.keyExists(hKey, subKey)) {
            this._winReg.createKey(hKey, subKey);
        }
        this._winReg.setValue(hKey, subKey, "SPDSCOMMDLL", "spds.dll", 109);
        this._winReg.setValue(hKey, subKey, "WQCOMMDLL", "wqetcp32.dll", 109);
        subKey = "SOFTWARE\\ODBC\\ODBC.INI\\SAS_x_METHODS";
        if (!this._winReg.keyExists(hKey, subKey)) {
            this._winReg.createKey(hKey, subKey);
        }
        this._winReg.setValue(hKey, subKey, "tcp", "", 109);
        subKey = "SOFTWARE\\ODBC\\ODBC.INI";
        hKey = 4;
        for (int i = 1; i < 3; ++i) {
            if (i == 2) {
                hKey = 8;
            }
            for (String key : subKeyList = this._winReg.getChildrenForKey(hKey, subKey)) {
                for (String srvr : serverDefs) {
                    if (!key.contains(srvr)) continue;
                    this._winReg.deleteKey(hKey, subKey.concat("\\" + key));
                }
            }
        }
        subKey = "SOFTWARE\\SAS\\SAS Drivers for ODBC";
        if (this._winReg.keyExists(8, subKey)) {
            this._winReg.deleteKey(8, subKey);
        }
        String prodname = this.getController().getProperty("ProductName");
        String prodversion = this.getController().getProperty("ProductVersion");
        subKey = "SOFTWARE\\SAS Institute Inc.";
        if (!this._winReg.keyExists(hKey, subKey)) {
            this._winReg.createKey(hKey, subKey);
        }
        subKey.concat("\\SAS Institute Inc.");
        if (!this._winReg.keyExists(hKey, subKey)) {
            this._winReg.createKey(hKey, subKey);
        }
        if (!this._winReg.keyExists(hKey, subKey = this.resolveProperty(subKey.concat("\\" + prodname)))) {
            this._winReg.createKey(hKey, subKey);
        }
        subKey = this.resolveProperty(subKey.concat("\\" + prodversion));
        String valueName = "InstallLocation";
        String value = this.resolveProperty("${ProductHome}");
        if (!this._winReg.keyExists(hKey, subKey)) {
            this._winReg.createKey(hKey, subKey);
        }
        this._winReg.setValue(hKey, subKey, valueName, value, 109);
        this._winReg.writeUninstallData();
    }

    @Override
    public void postExecute() throws Exception {
        this.log.debug("in ODBCDriver postExecute");
    }

    @Override
    public String descriptionForLog() {
        return "ODBCDriver";
    }

    @Override
    public void rollback() {
        this.log.debug("in ODBCDriver rollback");
        this._winReg.rollbackRegistryKeys();
    }

    @Override
    public void retry() throws InstallException {
        this.log.debug("in ODBCDriver retry");
    }
}

