/*
 * Decompiled with CFR 0.152.
 */
package com.sas.tools.installs.it.tasks;

import com.sas.tools.installs.it.Controller;
import com.sas.tools.installs.it.InstallException;
import com.sas.tools.installs.it.ProcessingTask;
import com.sas.tools.installs.it.ProcessingTaskInfo;
import com.sas.tools.installs.it.Utils;
import com.sas.tools.installs.it.schema.install.gen.ConcatenateCmacros;
import com.sas.tools.installs.it.tasks.InstallationTask;
import com.sas.tools.installs.it.tasks.TaskHelper;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

public class ConcatenateCmacrosTask
extends InstallationTask {
    private static final int LIBNAME_LENGTH_MAX = 8;
    private static final String TASK_NAME = "ConcatenateCmacros";
    private static final String CMACROS_LOG = "cmacros.log";
    private static Map<String, List<File>> cmacroPaths = new HashMap<String, List<File>>();
    private static final String CONFIG_FILE_NAME = "sasv9.cfg";

    @Override
    public void preExecute() {
        this.log.info("Compiled macros will be concatenated once installation is complete.");
        try {
            this.unserializeCmacros();
        }
        catch (Exception e) {
            this.log.warn("An error occurred while unserializing concatenateCmacro.ser file");
        }
    }

    @Override
    public void execute() {
        List<File> paths = this.getCmacroPaths();
        if (paths.size() > 0) {
            if (cmacroPaths.size() == 0) {
                String key = this.getController().getAltSku().concat(this.getClass().getName());
                this.getController().getPostProcessingTasks().put(key, new ProcessingTaskInfo(true, this.getClass().getName(), "postInstall"));
                this.getController().getPostProcessingQueue().add(new ProcessingTask(this, this.getClass(), "postInstall"));
            }
            cmacroPaths.put(this.getController().getProperty("12ByteCode"), paths);
            try {
                this.serializeCmacros();
            }
            catch (Exception e) {
                this.log.warn("An error occurred while serializing concatenateCmacro.ser file");
            }
        } else {
            this.log.info("No compiled macro paths were specified.");
        }
    }

    @Override
    public void postExecute() {
    }

    @Override
    public void retry() {
    }

    @Override
    public void rollback() {
    }

    public int postInstall() {
        HashSet<File> failedPaths = new HashSet<File>();
        if (cmacroPaths.size() > 0) {
            this.log.info("Starting extraction of compiled macro concatenator");
            File licenseSetinit = null;
            try {
                licenseSetinit = this.extractConcatenator();
            }
            catch (IOException e) {
                this.log.error("Can't extract cmacro concatenator program", (Throwable)e);
            }
            if (licenseSetinit != null) {
                for (String product : cmacroPaths.keySet()) {
                    List<File> paths = cmacroPaths.get(product);
                    this.log.info("Starting concatenation of cmacros for " + product);
                    for (File path : paths) {
                        try {
                            this.postInstallExecute(licenseSetinit, product, path);
                        }
                        catch (InstallException e) {
                            this.log.error("Concatenation of cmacros in " + path + " failed: " + e.getMessage());
                            failedPaths.add(path);
                        }
                    }
                }
            }
        }
        return failedPaths.size();
    }

    private void postInstallExecute(File cmacroConcatenator, String product, File path) {
        assert (product != null) : "getProperty(TWELVE_BYTE_CODE) can't realistically return null";
        ProcessBuilder pb = null;
        if (TaskHelper.isUnix() || TaskHelper.isWindows()) {
            String cfgFilePath = this.getController().getProperty("ProductHome");
            if (TaskHelper.isWindows()) {
                cfgFilePath = Utils.joinPath(cfgFilePath, "nls\\en");
            }
            String cfgFileName = Utils.joinPath(cfgFilePath, CONFIG_FILE_NAME);
            this.log.info("ConcatenateCmacrosTask - cfgFileName is " + cfgFileName);
            List<String> batchArgs = this.getSASBatchArgs(cmacroConcatenator, CMACROS_LOG);
            String libname = product.substring(0, Math.min(product.length(), 8));
            batchArgs.add("-config");
            batchArgs.add(cfgFileName);
            batchArgs.add("-debug");
            batchArgs.add("NOMSASHELP");
            batchArgs.add("-sysparm");
            batchArgs.add(libname + "," + path + "," + this.getSASHelp().getPath());
            pb = new ProcessBuilder(batchArgs);
            int rc = 0;
            try {
                rc = ConcatenateCmacrosTask.executeProcess(pb, this.log);
            }
            catch (Exception e) {
                throw new InstallException(1, this, this.getBundle().messageString("InstallationTask.OperationFailedEx", pb.command()), this.getEnBundle().messageString("InstallationTask.OperationFailedEx", pb.command()), e);
            }
            this.processSASOutput(rc, this.getSASLog(CMACROS_LOG));
        }
    }

    public File extractConcatenator() throws IOException {
        String packageName = "com/sas/tools/installs/it/tasks/";
        String programName = "ConcatenateCmacros.sas";
        File program = new File(this.getInstallMisc(), "ConcatenateCmacros.sas");
        TaskHelper.getResourceFile(this.getClass(), "com/sas/tools/installs/it/tasks/ConcatenateCmacros.sas", program);
        return program;
    }

    private List<File> getCmacroPaths() {
        ArrayList<File> paths = new ArrayList<File>();
        for (String path : ((ConcatenateCmacros)this.getData()).getPaths().getPath()) {
            paths.add(new File(Utils.fixPathSlashes(this.resolveProperty(path))));
        }
        return paths;
    }

    @Override
    public String descriptionForLog() {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("12ByteCode", this.getController().getProperty("12ByteCode"));
        return TaskHelper.getDescriptionForLog(TASK_NAME, params);
    }

    public static String getTaskName() {
        return TASK_NAME;
    }

    private void unserializeCmacros() throws IOException, ClassNotFoundException {
        if (Controller.installProperties.getProperty("sdw.resume.chain") == "TRUE") {
            FileInputStream fileInput = new FileInputStream(Utils.joinPath(Controller.installProperties.getProperty("sdw.log.path"), "concatenateCmacro.ser"));
            ObjectInputStream in = new ObjectInputStream(fileInput);
            cmacroPaths = (Map)in.readObject();
            in.close();
            fileInput.close();
        }
    }

    private void serializeCmacros() throws IOException {
        FileOutputStream fileOutput = new FileOutputStream(Utils.joinPath(Controller.installProperties.getProperty("sdw.log.path"), "concatenateCmacro.ser"));
        ObjectOutputStream out = new ObjectOutputStream(fileOutput);
        out.writeObject(cmacroPaths);
        out.close();
        fileOutput.close();
    }
}

