/*
 * Decompiled with CFR 0.152.
 */
package com.sas.tools.installs.it.schema.metadata;

import com.sas.tools.deployjni.JNIUtils;
import com.sas.tools.deployjni.Utilities;
import com.sas.tools.deployjni.disk.DiskInfoAPI;
import com.sas.tools.deployjni.saswin.SASWinAPI;
import com.sas.tools.installs.it.Controller;
import com.sas.tools.installs.it.InstallException;
import com.sas.tools.installs.it.Utils;
import com.sas.tools.installs.it.schema.metadata.gen.EntryType;
import com.sas.tools.installs.it.tasks.InstallationTask;
import com.sas.tools.installs.it.view.SSNResource;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.io.StringWriter;
import java.nio.channels.FileLock;
import java.nio.channels.OverlappingFileLockException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.zip.CRC32;
import java.util.zip.CheckedInputStream;
import java.util.zip.ZipEntry;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.core.Logger;

public class EntryData
extends EntryType
implements Comparable<EntryData> {
    protected static Logger log = (Logger)LogManager.getLogger((String)"com.sas.tools.installs.it.tasks.EntryData");
    public static final String EQUATE = "equate";
    public static final String VERSION = "version";
    public static final String YES = "true";
    public static final String NO = "false";
    public static final String NA = "na";
    public static String FILE = "file";
    public static String DIRECTORY = "directory";
    private static final long serialVersionUID = 11L;
    protected HashMap<String, String> _parameters;
    protected File _destination;
    protected EntryData _backupEntry;
    protected EntryData _originalEntry = null;
    protected ZipEntry _zipEntry = null;
    protected static SSNResource _bundle;
    protected static SSNResource _enBundle;
    public static final String CMP_NONE = "NONE";
    public static final String CMP_DATE = "DATE";
    public static final String CMP_VERSION = "VERSION";
    public static final String CMP_CHECKSUM = "CHECKSUM";
    public static final String CMP_DELETE = "DELETE";
    public static final String EQUALS = "equals";
    public static final String LESS_THAN = "lessthan";
    public static final String LESS_THAN_EQUALS = "lessthanequals";
    public static final String GREATER_THAN = "greaterthan";
    public static final String GREATER_THAN_EQUALS = "greaterthanequals";
    private boolean fileModeChanged = false;
    private boolean bChangeable = true;

    public EntryData() {
        this.setBackupEntry(null);
    }

    public boolean shouldDelete() {
        return this.getCompareby() != null && CMP_DELETE.equalsIgnoreCase(this.getCompareby());
    }

    public EntryData(String destination) {
        this(new File(destination), false);
    }

    public EntryData(File destination) {
        this(destination, false);
    }

    public EntryData(String destination, boolean initializeBackup) {
        this(new File(destination), initializeBackup);
    }

    public EntryData(File destination, boolean initializeBackup) {
        this._parameters = new HashMap();
        this.setName(destination.getName());
        this.setDestination(destination);
        if (destination.isFile()) {
            this.setSize(destination.length());
            this.setType(FILE);
        } else if (destination.isDirectory()) {
            this.setSize(new Long(0L));
            this.setType(DIRECTORY);
        }
        this.setLastModified(destination.lastModified());
        if (initializeBackup) {
            this.setCompareby(CMP_NONE);
            this.setBackup(true);
        }
    }

    public Integer getOwnerID() {
        if (this.getOwner() != null && this.getOwner().equals("default")) {
            return null;
        }
        if (this.getOwner().length() == 0) {
            return null;
        }
        return (int)this.getMode();
    }

    public void setOwnerID(Integer id) {
        if (id == null) {
            this.setOwner("");
        } else {
            this.setOwner(id.toString());
        }
    }

    public Integer getGroupID() {
        if (this.getGroup() != null && this.getGroup().equals("default")) {
            return null;
        }
        if (this.getGroup().length() == 0) {
            return null;
        }
        return (int)this.getMode();
    }

    public void setGroupID(Integer id) {
        if (id == null) {
            this.setGroup("");
        } else {
            this.setGroup(id.toString());
        }
    }

    public void addParameter(String attr, String val) {
        if (this._parameters == null) {
            this._parameters = new HashMap();
        }
        this._parameters.put(attr, val);
    }

    public void setOriginalEntryData(EntryData data) {
        this._originalEntry = data;
    }

    public EntryData getOriginalEntryData() {
        return this._originalEntry;
    }

    @Override
    public void setCompareby(String value) {
        super.setCompareby(value);
        this.initializeBackupData();
    }

    @Override
    public void setBackup(Boolean value) {
        super.setBackup(value);
        this.initializeBackupData();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean destinationLocked() {
        if (this.getDestination() == null) {
            return false;
        }
        String string = this.getDestination().getAbsolutePath().intern();
        synchronized (string) {
            File dest = this.getDestination();
            if (!dest.isFile()) {
                return false;
            }
            if (Utilities.getOS() == 1) {
                boolean retval = SASWinAPI.isFileLocked((String)dest.getAbsolutePath());
                if (retval) {
                    log.warn("Win JNI returned that File is locked (could not establish a delete lock): " + dest.getAbsolutePath());
                    for (int retries = 1; retval && retries < 4; ++retries) {
                        try {
                            Thread.sleep(3000L);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                        SimpleDateFormat formatter = new SimpleDateFormat("yyyy.MM.dd G hh:mm:ss");
                        Date now = new Date();
                        String dateString = formatter.format(now);
                        log.warn(dateString + "testing lock for " + dest + " failed, so retrying after garbage collection and waiting three seconds (just in case).  " + retries + " retries");
                        retval = SASWinAPI.isFileLocked((String)dest.getAbsolutePath());
                    }
                }
                return retval;
            }
            return !this.destinationChangeable();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean destinationChangeable() {
        File destination = this.getDestination();
        RandomAccessFile raf = null;
        FileLock lock = null;
        int origMode = DiskInfoAPI.GetFileMode((String)destination.getAbsolutePath());
        int origModeinOctal = DiskInfoAPI.GetOctalFileMode((String)destination.getAbsolutePath());
        if (origMode != -1) {
            if (origModeinOctal % 1000 < 600) {
                if (DiskInfoAPI.SetFileMode((String)destination.getAbsolutePath(), (int)493) == -1) {
                    log.warn("destinationChangeable - mode " + destination.getAbsolutePath() + " can not be set to 755.");
                    return false;
                }
                this.fileModeChanged = true;
                try {
                    raf = new RandomAccessFile(destination, "rw");
                    lock = raf.getChannel().tryLock();
                    if (lock == null) {
                        log.warn("destinationChangeable - A file lock was not created: " + destination.getAbsolutePath());
                        for (int retries = 1; lock == null && retries < 4; ++retries) {
                            try {
                                Thread.sleep(3000L);
                            }
                            catch (InterruptedException interruptedException) {
                                // empty catch block
                            }
                            SimpleDateFormat formatter = new SimpleDateFormat("yyyy.MM.dd G hh:mm:ss");
                            Date now = new Date();
                            log.warn("testing lock for " + destination + " failed, so retrying after garbage collection and waiting three seconds (just in case).  " + retries + " retries");
                            lock = raf.getChannel().tryLock();
                            if (lock == null) continue;
                            log.warn("lock acquired!");
                        }
                        this.bChangeable = false;
                    }
                    lock.release();
                }
                catch (FileNotFoundException ex) {
                    log.warn("destinationChangeable - A file lock was not found: " + destination.getAbsoluteFile());
                    this.bChangeable = false;
                }
                catch (IOException ex) {
                    log.warn("destinationChangeable - I/O exception trying to establish a file lock: " + destination.getAbsoluteFile());
                    this.bChangeable = false;
                }
                catch (OverlappingFileLockException ex) {
                    log.warn("destinationChangeable - Ignoring that the file is locked by the install (OverlappingFileLockException): " + destination.getAbsoluteFile());
                    this.bChangeable = false;
                }
                finally {
                    if (this.fileModeChanged) {
                        DiskInfoAPI.SetFileMode((String)destination.getAbsolutePath(), (int)origMode);
                    }
                    if (raf != null) {
                        try {
                            raf.close();
                            raf = null;
                        }
                        catch (IOException ex) {
                            log.error("destinationChangeable - Error closing the lock file:  " + ex.toString());
                        }
                    }
                }
            }
        } else {
            log.warn("destinationChangeable - mode " + origModeinOctal + " found for " + destination.getAbsolutePath() + " was invalid");
            this.bChangeable = false;
        }
        return this.bChangeable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean destinationWriteable() {
        if (this.getDestination() == null) {
            return true;
        }
        String string = this.getDestination().getAbsolutePath().intern();
        synchronized (string) {
            File destination = this.getDestination();
            if (destination.exists() && !destination.canWrite()) {
                return this.destinationChangeable();
            }
            if (destination.isDirectory()) {
                return Utils.canWriteToPath(destination, true);
            }
            File parent = destination.getParentFile();
            if (parent == null) {
                return Utils.canWriteToPath(destination, true);
            }
            while (!parent.exists()) {
                parent = parent.getParentFile();
            }
            return Utils.canWriteToPath(parent, true);
        }
    }

    public File getDestination() {
        return this._destination;
    }

    public void setDestination(File destination) {
        this._destination = destination;
        this.initializeBackupData();
    }

    @Override
    public Boolean isAltDestOnly() {
        if (super.isAltDestOnly() == null) {
            return false;
        }
        return super.isAltDestOnly();
    }

    @Override
    public Boolean isAlternateCopy() {
        if (super.isAlternateCopy() == null) {
            return false;
        }
        return super.isAlternateCopy();
    }

    @Override
    public Boolean isBackup() {
        if (super.isBackup() == null) {
            return false;
        }
        return super.isBackup();
    }

    @Override
    public Boolean isLink() {
        if (super.isLink() == null) {
            return false;
        }
        return super.isLink();
    }

    @Override
    public Boolean isNew() {
        if (super.isNew() == null) {
            return false;
        }
        return super.isNew();
    }

    @Override
    public Boolean isPatch() {
        if (super.isPatch() == null) {
            return false;
        }
        return super.isPatch();
    }

    @Override
    public Boolean isReboot() {
        if (super.isReboot() == null) {
            return false;
        }
        return super.isReboot();
    }

    @Override
    public Boolean isRegister() {
        if (super.isRegister() == null) {
            return false;
        }
        return super.isRegister();
    }

    @Override
    public Boolean isSetuid() {
        if (super.isSetuid() == null) {
            return false;
        }
        return super.isSetuid();
    }

    @Override
    public Boolean isShared() {
        if (super.isShared() == null) {
            return false;
        }
        return super.isShared();
    }

    @Override
    public Boolean isTkpatch() {
        if (super.isTkpatch() == null) {
            return false;
        }
        return super.isTkpatch();
    }

    @Override
    public Boolean isUninstall() {
        if (super.isUninstall() == null) {
            return false;
        }
        return super.isUninstall();
    }

    public void initializeBackupData() {
        if (this.getCompareby() == null || this.isBackup() == null || this.getDestination() == null) {
            return;
        }
        if (this.shouldDelete()) {
            this.setNew(false);
        } else if (this.getDestination().exists()) {
            this.setNew(false);
        } else {
            this.setNew(true);
        }
        Controller controller = Controller.defaultController();
        if (controller.getProperty("uninstallProvided") == null || !controller.getProperty("uninstallProvided").equals(YES)) {
            if (this.getDestination().isFile() && this.isBackup().booleanValue()) {
                if ((!this.getBackupLocation(false).exists() || this.shouldDelete()) && this.getDestination().exists()) {
                    this.setBackupEntry(new EntryData(this.getBackupLocation(true)));
                }
            } else if (this.isAltDestOnly().booleanValue()) {
                this.setBackupEntry(new EntryData(this.getBackupLocation(true)));
            }
        }
    }

    public File getBackupLocation(boolean createBackupDirectory) {
        return new File(Controller.defaultController().getBackupDestination(this.getDestination().getParent(), createBackupDirectory), this.getDestination().getName());
    }

    public void sendNotificationsForTask(InstallationTask task) {
        this.sendNotificationsForTask(task, null);
    }

    public void sendNotificationsForTask(InstallationTask task, String additionalMessage) {
        this.notifyBackupForTask(task);
        if (this.shouldDelete()) {
            task.notifySetup("Removed", this, additionalMessage);
        } else if (this.getDestination().exists()) {
            task.notifySetup("Changed", this, additionalMessage);
        } else {
            task.notifySetup("Added", this, additionalMessage);
        }
    }

    public void notifyBackupForTask(InstallationTask task) {
        if (NO.equalsIgnoreCase(Controller.defaultController().getProperty("CreateBackupLoc"))) {
            return;
        }
        if (this.getBackupEntry() != null) {
            task.notifySetup("Backed up", this.getBackupEntry(), null);
        }
    }

    public boolean performRestoreForTask(InstallationTask task) {
        File sharedFilesLoc = null;
        File sharedFilesLoc32 = null;
        if (this.getDestination() == null) {
            return false;
        }
        Controller controller = Controller.defaultController();
        if (!this.isBackup().booleanValue() || this.getDestination() == null || controller.getProperty("uninstallProvided") != null && controller.getProperty("uninstallProvided").equals(YES)) {
            return false;
        }
        if (!this.getBackupLocation(false).exists() || this.isDirectory()) {
            if (this.getDestination().exists() || Utils.isLink(this.getDestination())) {
                if (!this.getDestination().isDirectory()) {
                    long fileSize = this.getDestination().length();
                    if (task.isUndo()) {
                        task.notifyProgressStart("Removed", this);
                    } else {
                        task.notifyRollbackProgressStart("Removed", this);
                    }
                    if (this.getDestination().delete()) {
                        log.warn(this.getDestination().getAbsolutePath() + " removed successfully..");
                        if (task.isUndo()) {
                            task.notifyProgressComplete("Removed", this);
                        } else {
                            task.notifyRollbackProgressComplete("Removed", this, fileSize);
                        }
                        return false;
                    }
                    log.warn(this.getDestination().getAbsolutePath() + " was unable to be removed.");
                    Controller.getFileDeleteOnExit().push(this.getDestination());
                    return false;
                }
                String[] list = this.getDestination().list();
                if (task.isUndo()) {
                    task.notifyProgressStart("Removed", this);
                } else {
                    task.notifyRollbackProgressStart("Removed", this);
                }
                if (null != list && list.length == 0) {
                    if (this.getDestination().delete()) {
                        log.warn(this.getDestination().getAbsolutePath() + " removed successfully..");
                        if (task.isUndo()) {
                            task.notifyProgressComplete("Removed", this);
                        } else {
                            task.notifyRollbackProgressComplete("Removed", this, this.getDestination().length());
                        }
                    } else {
                        log.warn(this.getDestination().getAbsolutePath() + " was empty but unable to be removed.");
                    }
                } else {
                    log.warn(this.getDestination().getAbsolutePath() + " was marked to be deleted but the directory was not empty.");
                    String sasHome = controller.getProperty("SASHome");
                    if (Utilities.getOS() == 1) {
                        if (null == controller.getProperty("SHAREDFILES")) {
                            log.info("performRestoreForTask: SHAREDFILES property is not set.");
                        } else {
                            sharedFilesLoc = new File(controller.getProperty("SHAREDFILES"));
                        }
                        if (null == controller.getProperty("SHAREDFILES32")) {
                            log.info("performRestoreForTask: SHAREDFILES32 property is not set.");
                        } else {
                            sharedFilesLoc32 = new File(controller.getProperty("SHAREDFILES32"));
                        }
                    }
                    String prodDirName = new File(controller.getProperty("ProductHome")).getName();
                    String destination = "";
                    destination = this.getDestination().getPath().endsWith(".") ? this.getDestination().getParent() : this.getDestination().getPath();
                    String baseLoc = null;
                    if (Utils.isChildOf(destination, sasHome)) {
                        baseLoc = new String(sasHome);
                    } else if (sharedFilesLoc != null && Utilities.getOS() == 1 && Utils.isChildOf(destination, sharedFilesLoc.getPath())) {
                        baseLoc = new String(sharedFilesLoc.getPath());
                    } else if (sharedFilesLoc32 != null && Utilities.getOS() == 1 && Utils.isChildOf(destination, sharedFilesLoc32.getPath())) {
                        baseLoc = new String(sharedFilesLoc32.getPath());
                    }
                    if (baseLoc != null && new File(baseLoc).exists() && destination.endsWith(prodDirName)) {
                        File tmpPath = new File(this.getDestination().getParent());
                        while (tmpPath != null && !baseLoc.equals(tmpPath.getPath()) && tmpPath.exists()) {
                            Controller.getDirDeleteOnExit().push(tmpPath);
                            tmpPath = new File(tmpPath.getParent());
                        }
                    }
                    Controller.getDirDeleteOnExit().push(this.getDestination());
                }
            }
            return false;
        }
        File backupDestination = this.getBackupLocation(false);
        if (task.isUndo()) {
            if (this.shouldDelete()) {
                task.notifyProgressStart("Added", this);
            } else {
                task.notifyProgressStart("Changed", this);
            }
        } else if (this.shouldDelete()) {
            task.notifyRollbackProgressStart("Added", this);
        } else {
            task.notifyRollbackProgressStart("Changed", this);
        }
        if (this.getType().equals(DIRECTORY)) {
            if (Utilities.getOS() != 1 && this.getMode() != null) {
                if (Utilities.getOS() == 1 && !JNIUtils.libraryLoaded((String)JNIUtils.JNI_LIB_BASE, (HashMap)DiskInfoAPI.libNames)) {
                    String missingLib = JNIUtils.getJniLib((HashMap)DiskInfoAPI.libNames);
                    throw new InstallException(2, task, EntryData.getBundle().messageString("InstallationTask.MissingJNILib", missingLib), "Unable to load library:  " + missingLib, null);
                }
                try {
                    int success = DiskInfoAPI.SetOctalFileMode((String)this.getDestination().getAbsolutePath(), (int)this.getMode());
                    if (success != 0) {
                        throw new InstallException(1, task, EntryData.getBundle().messageString("ZipExtractor.FilePermissionRestorationFailure", this.getMode(), this.getDestination()), "Error restoring permissions to " + this.getMode() + " for file " + this.getDestination(), null);
                    }
                }
                catch (Exception e) {
                    throw new InstallException(1, task, EntryData.getBundle().messageString("ZipExtractor.FilePermissionRestorationFailure", this.getMode(), this.getDestination()), "Error restoring permissions to " + this.getMode() + " for file " + this.getDestination(), e);
                }
            }
        } else {
            File destination = this.getDestination();
            if (destination.exists() && !destination.delete()) {
                throw new InstallException(1, task, EntryData.getBundle().messageString("ZipExtractor.FileRemovalError", destination), "UnableToRemove " + destination, null);
            }
            File directory = new File(destination.getParent());
            if (!directory.exists()) {
                log.info("PerformRestoreForTask: Creating directory: " + directory.toString());
                directory.mkdirs();
            }
            log.info("PerformRestoreForTask: Moving " + backupDestination.toString() + " To " + destination.toString());
            if (!Utils.moveFile(backupDestination, destination)) {
                throw new InstallException(1, task, EntryData.getBundle().messageString("Shared.FileRestorationError", backupDestination, destination), "Failure restoring " + backupDestination + " to " + destination, null);
            }
        }
        log.warn(this.getDestination().getAbsolutePath() + " restored successfully.");
        if (!this.getDestination().isDirectory() || Utilities.getOS() != 1 && this.getMode() != null) {
            int filemode;
            if (this.getDestination().isDirectory() && (filemode = DiskInfoAPI.GetOctalFileMode((String)this.getDestination().getAbsolutePath())) == this.getMode()) {
                return true;
            }
            if (task.isUndo()) {
                if (this.shouldDelete()) {
                    task.notifyProgressComplete("Added", this);
                } else {
                    task.notifyProgressComplete("Changed", this);
                }
            } else if (this.shouldDelete()) {
                task.notifyRollbackProgressComplete("Added", this, this.getDestination().length());
            } else {
                task.notifyRollbackProgressComplete("Changed", this, backupDestination.length());
            }
        }
        return false;
    }

    private boolean isDirectory() {
        return DIRECTORY.equals(this.getType());
    }

    public void notifyRestoreForTask(InstallationTask task) {
        Controller controller = Controller.defaultController();
        if (this.isBackup().booleanValue() || this.getDestination() == null || controller.getProperty("uninstallProvided") != null && controller.getProperty("uninstallProvided").equals(YES)) {
            return;
        }
        if (this.getDestination().exists()) {
            if (this.getBackupLocation(false).exists()) {
                task.notifySetup("Changed", this, null);
            } else {
                task.notifySetup("Removed", this, null);
            }
        } else {
            task.notifySetup("Added", this, null);
        }
    }

    public void performBackupForTask(InstallationTask task) {
        if (NO.equalsIgnoreCase(Controller.defaultController().getProperty("CreateBackupLoc"))) {
            return;
        }
        if (this.getBackupEntry() != null) {
            if (this.getDestination().exists()) {
                File backupDestination = this.getBackupEntry().getDestination();
                if (!backupDestination.getParentFile().exists() && !backupDestination.getParentFile().mkdirs()) {
                    throw new InstallException(1, task, EntryData.getBundle().messageString("ZipExtractor.DirectoryCreationError", backupDestination.getParentFile().getAbsolutePath()), "Error creating directory:  " + backupDestination.getParentFile().getAbsolutePath(), null);
                }
                if (!Utils.moveFile(this.getDestination(), backupDestination)) {
                    throw new InstallException(1, task, EntryData.getBundle().messageString("InstallationTask.FileMoveError", this.getDestination(), backupDestination), "Failure moving " + this.getDestination() + " to " + backupDestination + " for backup purposes", null);
                }
                log.warn("backed up " + this.getDestination().getAbsolutePath() + " to " + backupDestination.getAbsolutePath());
                task.notifyProgressComplete("Backed up", this.getBackupEntry());
                if (this.shouldDelete()) {
                    task.notifyProgressComplete("Removed", this);
                }
            } else {
                log.warn("The file " + this.getDestination().getAbsolutePath() + " does not exist to backup");
            }
        }
    }

    @Override
    public int compareTo(EntryData o) {
        if (o == null) {
            return -1;
        }
        return this.nullSafeCompare(this.getName(), o.getName());
    }

    private int nullSafeCompare(String one, String two) {
        if (one == null) {
            return two == null ? 0 : 1;
        }
        if (two == null) {
            return -1;
        }
        return one.compareTo(two);
    }

    public EntryData getBackupEntry() {
        return this._backupEntry;
    }

    private void setBackupEntry(EntryData backupEntry) {
        this._backupEntry = backupEntry;
        if (this._backupEntry != null && this._backupEntry.getName() != null) {
            this._backupEntry.setName(this.getName());
        }
    }

    private static SSNResource getBundle() {
        return _bundle;
    }

    private static void setBundle(SSNResource bundle) {
        _bundle = bundle;
    }

    private static SSNResource getEnBundle() {
        return _enBundle;
    }

    private static void setEnBundle(SSNResource enBundle) {
        _enBundle = enBundle;
    }

    public void setZipEntry(ZipEntry zipEntry) {
        this._zipEntry = zipEntry;
    }

    public ZipEntry getZipEntry() {
        return this._zipEntry;
    }

    public boolean runtimeActionRequired(File file, ZipEntry zipEntry, InstallationTask task) {
        boolean pass = false;
        if (this.shouldDelete()) {
            return true;
        }
        if (Controller.defaultController().alwaysOverwrite()) {
            log.warn("File check skipped for " + this.getDestination().getAbsolutePath());
            return true;
        }
        if (!file.isDirectory()) {
            if (!this.isNew().booleanValue()) {
                if (CMP_NONE.equalsIgnoreCase(this.getCompareby())) {
                    log.warn("No comparisons requested for " + file.getAbsolutePath());
                    pass = true;
                } else if (CMP_DATE.equalsIgnoreCase(this.getCompareby())) {
                    long local = file.lastModified();
                    long remote = zipEntry.getTime();
                    pass = this.compareFiles(local, remote, this.getEquate());
                    String logEntry = "Date comparisons for " + file.getAbsolutePath() + ".  Installed file last modified:  " + local + "(" + new Date(local).toString() + "), zip entry last modified:  " + remote + "(" + new Date(remote).toString() + ")";
                    logEntry = pass ? logEntry + "  " + file.getAbsolutePath() + " will be installed" : logEntry + "  " + file.getAbsolutePath() + " will be skipped";
                    log.warn(logEntry);
                } else if (VERSION.equalsIgnoreCase(this.getCompareby())) {
                    String logEntry = "Version comparisons for " + file.getAbsolutePath() + ".  ";
                    if (Utilities.getOS() == 1 && !JNIUtils.libraryLoaded((String)JNIUtils.JNI_LIB_BASE, (HashMap)DiskInfoAPI.libNames)) {
                        String missingLib = JNIUtils.getJniLib((HashMap)DiskInfoAPI.libNames);
                        throw new InstallException(2, task, EntryData.getBundle().messageString("InstallationTask.MissingJNILib", missingLib), "Unable to load library:  " + missingLib, null);
                    }
                    try {
                        logEntry = logEntry + "Installed file version:  " + DiskInfoAPI.getFileVersion((File)file);
                    }
                    catch (Exception e) {
                        throw new InstallException(2, task, EntryData.getBundle().messageString("ZipExtractor.VersionFailure", file), "Error determining version for file " + file, e);
                    }
                    logEntry = logEntry + ", zip entry version:  " + this.getVersion();
                    int comparisonResult = 0;
                    try {
                        comparisonResult = DiskInfoAPI.compareFileVersionToString((File)file, (String)this.getVersion());
                    }
                    catch (Exception e) {
                        throw new InstallException(1, task, EntryData.getBundle().messageString("ZipExtractor.FileComparisonError"), EntryData.getEnBundle().messageString("ZipExtractor.FileComparisonError"), null);
                    }
                    if (comparisonResult == 0) {
                        logEntry = logEntry + "  File version unable to be used as method of comparison, so reverting to date/time check.\n\t\t";
                        long local = file.lastModified();
                        long remote = zipEntry.getTime();
                        logEntry = logEntry + "Date comparisons for " + file.getAbsolutePath() + ".  Installed file last modified:  " + local + "(" + new Date(local).toString() + "), zip entry last modified:  " + remote + "(" + new Date(remote).toString() + ")";
                        pass = this.compareFiles(local, remote, EQUATE);
                        logEntry = pass ? logEntry + "  " + file.getAbsolutePath() + " will be installed" : logEntry + "  " + file.getAbsolutePath() + " will be skipped";
                    } else if (comparisonResult == 1) {
                        logEntry = logEntry + "  " + file.getAbsolutePath() + " will be installed";
                        pass = true;
                    } else {
                        logEntry = logEntry + "  " + file.getAbsolutePath() + " will be skipped";
                        pass = false;
                    }
                    log.warn(logEntry);
                } else if (CMP_CHECKSUM.equalsIgnoreCase(this.getCompareby())) {
                    FilterInputStream cis = null;
                    try {
                        FileInputStream fis = new FileInputStream(file);
                        CRC32 crc32 = new CRC32();
                        cis = new CheckedInputStream(fis, crc32);
                        byte[] tempBuf = new byte[128];
                        while (cis.read(tempBuf) >= 0) {
                        }
                    }
                    catch (Exception e) {
                        try {
                            cis.close();
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                        throw new InstallException(2, task, EntryData.getBundle().messageString("ZipExtractor.ChecksumMatchingError"), EntryData.getEnBundle().messageString("ZipExtractor.ChecksumMatchingError"), null);
                    }
                    long local = ((CheckedInputStream)cis).getChecksum().getValue();
                    try {
                        cis.close();
                    }
                    catch (IOException tempBuf) {
                        // empty catch block
                    }
                    long remote = zipEntry.getCrc();
                    pass = this.compareFiles(local, remote, this.getEquate());
                    String logEntry = "Checksum comparisons for " + file.getAbsolutePath() + ".  Installed file checksum:  " + local + ", zip entry last modified:  " + remote;
                    logEntry = pass ? logEntry + "  " + file.getAbsolutePath() + " will be installed" : logEntry + "  " + file.getAbsolutePath() + " will be skipped";
                    log.warn(logEntry);
                }
            } else {
                pass = true;
                log.warn(file.getAbsolutePath() + " will be installed unconditionally because it is a new file");
            }
        } else {
            pass = true;
            log.warn(file.getAbsolutePath() + " will be installed unconditionally because it is a directory");
        }
        return pass;
    }

    private boolean compareFiles(long local, long remote, String equate) {
        return GREATER_THAN.equalsIgnoreCase(equate) ? remote > local : (GREATER_THAN_EQUALS.equalsIgnoreCase(equate) ? remote >= local : (LESS_THAN.equalsIgnoreCase(equate) ? remote < local : (LESS_THAN_EQUALS.equalsIgnoreCase(equate) ? remote <= local : EQUALS.equalsIgnoreCase(equate) && remote == local)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getMd5() {
        EntryData entryData = this;
        synchronized (entryData) {
            String md5 = super.getMd5();
            if (md5 == null || md5.isEmpty()) {
                md5 = Utils.getMd5sum(this.getDestination());
                super.setMd5(md5);
            }
        }
        return this.md5;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flushMd5() {
        EntryData entryData = this;
        synchronized (entryData) {
            this.setMd5(null);
        }
    }

    @Override
    public String toString() {
        StringWriter sw = new StringWriter();
        sw.append("EntryData[");
        sw.append(this._parameters.toString());
        sw.append(", destination=");
        sw.append(this._destination != null ? this._destination.getAbsolutePath() : "(not set)");
        sw.append("]");
        return sw.toString();
    }

    static {
        EntryData.setBundle(new SSNResource(EntryData.class));
        EntryData.setEnBundle(SSNResource.EnglishResource(EntryData.class));
    }
}

