/*
 * Decompiled with CFR 0.152.
 */
package com.sas.tools.installs.it;

import com.sas.tools.installs.it.InstallException;
import com.sas.tools.installs.it.PerfLog;
import com.sas.tools.installs.it.tasks.Globals;
import com.sas.tools.installs.it.tasks.InstallationTask;
import com.sas.tools.installs.it.view.SSNResource;
import java.lang.reflect.Method;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.core.Logger;

public class ProcessingTask
implements Comparable<ProcessingTask> {
    private Logger log = (Logger)LogManager.getLogger((String)this.getClass().getName());
    protected SSNResource bundle = new SSNResource(this.getClass());
    protected SSNResource enBundle = SSNResource.EnglishResource(this.getClass());
    private final Object instance;
    private final Method method;
    private final Priority priority;
    private Integer order = 0;

    public ProcessingTask(Object instance, Class<?> clazz, String methodName, Priority priority) {
        this.instance = instance;
        this.priority = priority;
        try {
            this.method = clazz.getMethod(methodName, new Class[0]);
        }
        catch (Exception e) {
            throw new InstallException(3, null, "", "", e);
        }
        if (!this.method.getReturnType().equals(Integer.TYPE)) {
            throw new InstallException(3, null, "", "", null);
        }
    }

    public ProcessingTask(Object instance, Class<?> clazz, String method) {
        this(instance, clazz, method, Priority.MID);
    }

    public ProcessingTask(Class<?> clazz, String method, Priority priority) {
        this(null, clazz, method, priority);
    }

    public ProcessingTask(Class<?> clazz, String method) {
        this(null, clazz, method, Priority.MID);
    }

    public int invoke() {
        if (Globals.g_debug && Globals.g_vjronly) {
            return 0;
        }
        try {
            if (Globals.g_debug) {
                if (this.instance != null) {
                    String prodCode = "";
                    String altsku = "";
                    if (this.instance != null && this.instance instanceof InstallationTask) {
                        InstallationTask task = (InstallationTask)this.instance;
                        prodCode = task.getProdCodeFromAltSku();
                        altsku = task.getAltsku();
                    }
                    PerfLog.getInstance().newEntry(this.instance, this.method.getName(), "", prodCode, altsku);
                } else {
                    PerfLog.getInstance().newEntry(this.method.getDeclaringClass(), this.method.getName());
                }
            }
            this.log.info("invoking " + this.method);
            int rc = (Integer)this.method.invoke(this.instance, new Object[0]);
            this.log.info(this.method + " returned " + rc);
            int n = rc;
            return n;
        }
        catch (Exception e) {
            throw new InstallException(3, null, this.bundle.messageString("ProcessingTask.InvocationError", this.method, this.instance), this.enBundle.messageString("ProcessingTask.InvocationError", this.method, this.instance), e);
        }
        finally {
            if (Globals.g_debug) {
                PerfLog.getInstance().finishLastEntry();
            }
        }
    }

    @Override
    public int compareTo(ProcessingTask o) {
        Integer other;
        Integer self = this.priority.ordinal();
        int comparison = self.compareTo(other = Integer.valueOf(o.priority.ordinal()));
        if (comparison == 0) {
            comparison = this.order.compareTo(o.order);
        }
        return comparison;
    }

    public Priority getPriority() {
        return this.priority;
    }

    public Method getMethod() {
        return this.method;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.instance == null ? 0 : this.instance.hashCode());
        result = 31 * result + (this.method == null ? 0 : this.method.hashCode());
        result = 31 * result + (this.priority == null ? 0 : this.priority.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ProcessingTask other = (ProcessingTask)obj;
        if (this.instance == null ? other.instance != null : !this.instance.equals(other.instance)) {
            return false;
        }
        if (this.method == null ? other.method != null : !this.method.equals(other.method)) {
            return false;
        }
        return !(this.priority == null ? other.priority != null : !this.priority.equals((Object)other.priority));
    }

    public String toString() {
        return this.method + "@" + (Object)((Object)this.priority) + (this.instance == null ? "" : " (" + this.instance + ")");
    }

    void setOrder(int order) {
        this.order = order;
    }

    public Object getInstance() {
        return this.instance;
    }

    public static enum Priority {
        HIGHEST,
        HIGH,
        MID,
        LOW,
        LOWEST;

    }
}

