/*
 * Decompiled with CFR 0.152.
 */
package com.sas.tools.installs.it;

import com.sas.tools.installs.it.Utils;
import com.sas.tools.installs.it.tasks.Globals;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.core.Logger;

public class PerfLog
implements Comparator<PerfLogEntry> {
    protected static Logger log = (Logger)LogManager.getLogger((String)"com.sas.tools.installs.it.PerfLog");
    private static Object singletonLock = new Object();
    protected static PerfLog perfLog = null;
    protected Map<Thread, PerfLogThreadStack> threadStackMap = Collections.synchronizedMap(new HashMap());
    protected DecimalFormat decimalFormat = new DecimalFormat("#.##");
    protected Object writeLock = new Object();
    protected BufferedWriter writer = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static PerfLog getInstance() {
        Object object = singletonLock;
        synchronized (object) {
            if (perfLog == null) {
                perfLog = new PerfLog();
            }
        }
        return perfLog;
    }

    protected PerfLog() {
        this.init();
    }

    public void init() {
        if (Globals.g_debug && this.writer == null && Globals.g_sdwDataLocation != null) {
            String perfLogCsv = "debug_perfLog.csv";
            File perfLogCsvFile = new File(Globals.g_sdwDataLocation, perfLogCsv);
            try {
                this.writer = this.openPerfLogForWrite(perfLogCsvFile);
            }
            catch (IOException ioe) {
                log.warn("Unable to open perf log: " + perfLogCsvFile);
                this.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        if (Globals.g_debug) {
            Object object = this.writeLock;
            synchronized (object) {
                if (this.writer != null) {
                    try {
                        this.writer.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    this.writer = null;
                }
            }
        }
    }

    public PerfLogEntry newEntry(Object o, String method) {
        PerfLogEntry entry = null;
        if (Globals.g_debug) {
            new PerfLogEntry(null, method, "", "", "");
        }
        return entry;
    }

    public PerfLogEntry newEntry(Object o, String method, String attributes) {
        PerfLogEntry entry = null;
        if (Globals.g_debug) {
            entry = new PerfLogEntry(o, method, attributes, "", "");
        }
        return entry;
    }

    public PerfLogEntry newEntry(Object o, String method, String attributes, String prodCode, String altsku) {
        PerfLogEntry entry = null;
        if (Globals.g_debug) {
            entry = new PerfLogEntry(o, method, attributes, prodCode, altsku);
        }
        return entry;
    }

    public PerfLogEntry newEntry(Class<?> aClass, String method) {
        PerfLogEntry entry = null;
        if (Globals.g_debug) {
            entry = new PerfLogEntry(aClass, method, "", "", "");
        }
        return entry;
    }

    public PerfLogEntry newEntry(Class<?> aClass, String method, String attributes) {
        PerfLogEntry entry = null;
        if (Globals.g_debug) {
            entry = new PerfLogEntry(aClass, method, attributes, "", "");
        }
        return entry;
    }

    public PerfLogEntry newEntry(Class<?> aClass, String method, String attributes, String prodCode, String altsku) {
        PerfLogEntry entry = null;
        if (Globals.g_debug) {
            entry = new PerfLogEntry(aClass, method, attributes, prodCode, altsku);
        }
        return entry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PerfLogEntry finishLastEntry() {
        PerfLogEntry entry = null;
        if (Globals.g_debug) {
            Thread thread = Thread.currentThread();
            Map<Thread, PerfLogThreadStack> map = this.threadStackMap;
            synchronized (map) {
                PerfLogThreadStack stack = this.threadStackMap.get(thread);
                if (stack != null) {
                    entry = stack.pop();
                    entry.finish();
                    this.writeEntry(entry);
                }
            }
        }
        return entry;
    }

    public void clear() {
        this.threadStackMap.clear();
    }

    @Override
    public int compare(PerfLogEntry arg0, PerfLogEntry arg1) {
        int ret = -1;
        long time0 = arg0.getDuration();
        long time1 = arg1.getDuration();
        if (arg0.equals(arg1)) {
            ret = 0;
        } else if (time0 > time1) {
            ret = 1;
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized void writeEntry(PerfLogEntry entry) {
        if (entry != null) {
            double sinceLast = (double)entry.getSinceLastEntry() / 1000.0;
            double duration = (double)entry.getDuration() / 1000.0;
            Object object = this.writeLock;
            synchronized (object) {
                if (this.writer != null) {
                    try {
                        this.writer.write(entry.getIndent() + entry.getThread().getName() + "," + this.decimalFormat.format(sinceLast) + "," + entry.getProdCode() + "," + entry.getAltsku() + "," + entry.getSource() + "," + entry.getMethod() + "," + entry.getAttributes() + "," + this.decimalFormat.format(duration) + "\n");
                        this.writer.flush();
                    }
                    catch (IOException ioe) {
                        this.close();
                    }
                }
            }
        }
    }

    private BufferedWriter openPerfLogForWrite(File perfLogFile) throws IOException {
        BufferedWriter ret = null;
        if (perfLogFile.isFile()) {
            SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd-HH.mm");
            Date my_time = new Date();
            String timestamp = formatter.format(my_time);
            String fileName = perfLogFile.getName();
            int iDot = fileName.indexOf(".");
            if (iDot != -1) {
                fileName = fileName.substring(0, iDot);
            }
            String backupInstallCsv = fileName + "_" + timestamp + ".bak";
            File backupInstallCsvFile = new File(Globals.g_sdwDataLocation, backupInstallCsv);
            try {
                Utils.copyFile(perfLogFile, backupInstallCsvFile);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        ret = new BufferedWriter(new FileWriter(perfLogFile));
        ret.write("Thread,SinceLast,ProdCode,AltSku,Class,Method,Attributes,Duration\n");
        return ret;
    }

    public class PerfLogEntry {
        protected long startTime = -1L;
        protected long endTime = -1L;
        protected long duration = -1L;
        protected long sinceLastEntry = 0L;
        protected Thread thread = Thread.currentThread();
        protected Class<?> source = null;
        protected String method = null;
        protected String attributes = null;
        protected String prodCode = null;
        protected String altsku = null;
        protected String indent = "";

        protected PerfLogEntry(Object source, String method, String attributes, String prodCode, String altsku) {
            this(source != null ? source.getClass() : null, method, attributes, prodCode, altsku);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected PerfLogEntry(Class<?> source, String method, String attributes, String prodCode, String altsku) {
            this.source = source;
            this.method = method;
            this.attributes = attributes;
            this.prodCode = prodCode;
            this.altsku = altsku;
            this.startTime = System.currentTimeMillis();
            Map<Thread, PerfLogThreadStack> map = PerfLog.this.threadStackMap;
            synchronized (map) {
                PerfLogThreadStack stack = PerfLog.this.threadStackMap.get(this.thread);
                if (stack == null) {
                    stack = new PerfLogThreadStack();
                    PerfLog.this.threadStackMap.put(this.thread, stack);
                }
                stack.push(this);
            }
        }

        protected void setIndent(String indent) {
            this.indent = indent;
        }

        protected String getIndent() {
            return this.indent;
        }

        protected void finish() {
            this.endTime = System.currentTimeMillis();
        }

        public long getSinceLastEntry() {
            return this.sinceLastEntry;
        }

        protected void setSinceLastEntry(long sinceLastEntry) {
            this.sinceLastEntry = sinceLastEntry;
        }

        public long getStartTime() {
            return this.startTime;
        }

        public long getEndTime() {
            return this.endTime;
        }

        public Thread getThread() {
            return this.thread;
        }

        public Class<?> getSource() {
            return this.source;
        }

        public String getMethod() {
            return this.method;
        }

        public String getAttributes() {
            return this.attributes;
        }

        public String getProdCode() {
            return this.prodCode;
        }

        public String getAltsku() {
            return this.altsku;
        }

        public long getDuration() {
            if (this.duration == -1L && this.endTime != -1L) {
                this.duration = this.endTime - this.startTime;
            }
            return this.duration;
        }
    }

    public class PerfLogThreadStack {
        LinkedList<PerfLogEntry> stack = new LinkedList();
        long lastTimeStamp = -1L;
        String indent = "";

        public synchronized PerfLogEntry pop() {
            PerfLogEntry entry = null;
            if (this.stack.size() > 0 && (entry = this.stack.removeLast()) != null) {
                entry.finish();
                long l = this.lastTimeStamp = this.stack.size() == 0 ? -1L : entry.getEndTime();
                if (this.indent.length() > 0) {
                    this.indent = this.indent.substring(0, this.indent.length() - 1);
                }
            }
            if (entry == null) {
                this.lastTimeStamp = -1L;
                this.indent = "";
            }
            return entry;
        }

        public synchronized void push(PerfLogEntry entry) {
            if (entry != null) {
                entry.setSinceLastEntry(this.lastTimeStamp == -1L ? 0L : entry.getStartTime() - this.lastTimeStamp);
                entry.setIndent(this.indent);
                this.indent = this.indent + " ";
                this.stack.addLast(entry);
            }
        }
    }
}

