/*
 * Decompiled with CFR 0.152.
 */
package com.sas.tools.installs.it;

import com.sas.tools.installs.it.tasks.InstallationTask;
import java.text.NumberFormat;
import java.util.HashMap;

public class InstallationSummary {
    protected HashMap<String, Long> _willAdd = new HashMap();
    protected HashMap<String, Long> _willRemove = new HashMap();
    protected HashMap<String, Long> _willChange = new HashMap();

    public void evaluateTask(InstallationTask task) {
        this.getWillAdd().putAll(task.getFilesToAdd());
        this.getWillRemove().putAll(task.getFilesToRemove());
        this.getWillChange().putAll(task.getFilesToChange());
    }

    public String filesToAddDisplay(String prefix) {
        return this.fileDisplay(this.getWillAdd(), prefix);
    }

    public String filesToRemoveDisplay(String prefix) {
        return this.fileDisplay(this.getWillRemove(), prefix);
    }

    public String filesToChangeDisplay(String prefix) {
        return this.fileDisplay(this.getWillChange(), prefix);
    }

    public String fileDisplay(HashMap<String, Long> map, String prefix) {
        if (map.size() == 0) {
            return "";
        }
        StringBuffer retval = new StringBuffer(prefix);
        retval.append("<ul>");
        for (String key : map.keySet()) {
            NumberFormat format = NumberFormat.getIntegerInstance();
            retval.append("<li>" + key + " (" + format.format(map.get(key)) + " bytes)</li>");
        }
        retval.append("</ul>");
        return retval.toString();
    }

    public HashMap<String, Long> getWillAdd() {
        return this._willAdd;
    }

    public void setWillAdd(HashMap<String, Long> willAdd) {
        this._willAdd = willAdd;
    }

    public HashMap<String, Long> getWillRemove() {
        return this._willRemove;
    }

    public void setWillRemove(HashMap<String, Long> willRemove) {
        this._willRemove = willRemove;
    }

    public HashMap<String, Long> getWillChange() {
        return this._willChange;
    }

    public void setWillChange(HashMap<String, Long> willChange) {
        this._willChange = willChange;
    }
}

