/*
 * Decompiled with CFR 0.152.
 */
package com.sas.tools.installs.it;

import com.sas.tools.installs.it.Controller;
import com.sas.tools.installs.it.InstallException;
import com.sas.tools.installs.it.listener.InstallationProgressListener;
import com.sas.tools.installs.it.listener.InstallationSetupListener;
import com.sas.tools.installs.it.schema.metadata.EntryData;
import com.sas.tools.installs.it.tasks.InstallationTask;
import com.sas.tools.installs.it.view.SSNResource;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.GregorianCalendar;
import java.util.Vector;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.core.Logger;

public class AuditLogger
implements InstallationProgressListener,
InstallationSetupListener {
    protected Vector<EntryData> _adds;
    protected Vector<EntryData> _removes;
    protected Vector<EntryData> _changes;
    protected Vector<EntryData> _backups;
    protected Vector<EntryData> _checkedFiles;
    protected Vector<EntryData> _actualAdds;
    protected Vector<EntryData> _actualRemoves;
    protected Vector<EntryData> _actualChanges;
    protected Vector<EntryData> _actualBackups;
    protected Controller _controller;
    protected SSNResource _bundle = new SSNResource(this.getClass());
    public static final String prePrefix = "pre";
    public static final String postPrefix = "post";
    public final File preExecutionLog;
    public final File postExecutionLog;
    protected static Logger log = (Logger)LogManager.getLogger((String)AuditLogger.class.getName());

    public AuditLogger(Controller controller) {
        this.setController(controller);
        this.setAdds(new Vector<EntryData>());
        this.setActualAdds(new Vector<EntryData>());
        this.setChanges(new Vector<EntryData>());
        this.setActualChanges(new Vector<EntryData>());
        this.setRemoves(new Vector<EntryData>());
        this.setActualRemoves(new Vector<EntryData>());
        this.setBackups(new Vector<EntryData>());
        this.setActualBackups(new Vector<EntryData>());
        this.setCheckedFiles(new Vector<EntryData>());
        if (Controller.uninstall_mode) {
            this.preExecutionLog = new File(controller.getLogPath(), this.getController().getPackageIdentifier() + "_" + this.getController().getProperty("ProductLanguage") + "_Uninstall_" + prePrefix + "exec.log");
            this.postExecutionLog = new File(controller.getLogPath(), this.getController().getPackageIdentifier() + "_" + this.getController().getProperty("ProductLanguage") + "_Uninstall_" + postPrefix + "exec.log");
        } else {
            this.preExecutionLog = new File(controller.getLogPath(), this.getController().getPackageIdentifier() + "_" + this.getController().getProperty("ProductLanguage") + "_Install_" + prePrefix + "exec.log");
            this.postExecutionLog = new File(controller.getLogPath(), this.getController().getPackageIdentifier() + "_" + this.getController().getProperty("ProductLanguage") + "_Install_" + postPrefix + "exec.log");
        }
    }

    public String preExecutionLogLink() {
        return "<a href=\"file://" + this.preExecutionLog.getAbsolutePath() + "\">" + this.preExecutionLog.getAbsolutePath() + "</a>";
    }

    public String postExecutionLogLink() {
        return "<a href=\"file://" + this.postExecutionLog.getAbsolutePath() + "\">" + this.postExecutionLog.getAbsolutePath() + "</a>";
    }

    public String preExecutionLogPath() {
        return this.preExecutionLog.getAbsolutePath();
    }

    public String postExecutionLogPath() {
        return this.postExecutionLog.getAbsolutePath();
    }

    public void writePreExecutionLog() {
        this.writeAuditLog(prePrefix, this.preExecutionLog, this.getAdds(), this.getBackups(), this.getChanges(), this.getRemoves(), this.getSkippedFiles());
    }

    public void writePostExecutionLog() {
        this.writeAuditLog(postPrefix, this.postExecutionLog, this.getActualAdds(), this.getActualBackups(), this.getActualChanges(), this.getActualRemoves(), null);
    }

    public void writeAuditLog(String logPrefix, File output, Vector<EntryData> adds, Vector<EntryData> backups, Vector<EntryData> changes, Vector<EntryData> removes, Vector<EntryData> skips) {
        try {
            InetAddress i;
            if (!output.getParentFile().isDirectory() && !output.getParentFile().mkdirs()) {
                throw new Exception("Failure to create directory:  " + output.getParent());
            }
            BufferedWriter out = new BufferedWriter(new FileWriter(output, false));
            out.write("Installation Date ");
            GregorianCalendar now = new GregorianCalendar();
            SimpleDateFormat format = new SimpleDateFormat();
            out.write(format.format(now.getTime()));
            String username = System.getProperty("user.name");
            if (username != null) {
                out.write(" / User ID " + username);
            }
            if ((i = this.getLocalHost()) != null) {
                out.write(" / IP Address " + i.getHostAddress());
                out.write(" / Host " + i.getHostName());
            } else {
                out.write(" / IP Address 127.0.0.1");
                out.write(" / Host localhost");
            }
            out.newLine();
            out.newLine();
            if (skips != null) {
                out.write("Skipped Files");
                out.newLine();
                if (skips.size() > 0) {
                    for (EntryData entryData : skips) {
                        out.write(entryData.getDestination().getCanonicalPath());
                        out.newLine();
                    }
                } else {
                    this.writeNoFiles(out, logPrefix);
                }
                out.newLine();
            }
            out.write("Added Files");
            out.newLine();
            if (adds.size() > 0) {
                for (EntryData entryData : adds) {
                    out.write(entryData.getDestination().getCanonicalPath());
                    out.newLine();
                }
            } else {
                this.writeNoFiles(out, logPrefix);
            }
            out.newLine();
            out.write("Backup Files");
            out.newLine();
            if (backups.size() > 0) {
                for (EntryData entryData : backups) {
                    out.write(entryData.getDestination().getCanonicalPath());
                    out.newLine();
                }
            } else {
                this.writeNoFiles(out, logPrefix);
            }
            out.newLine();
            out.write("Changed Files");
            out.newLine();
            if (changes.size() > 0) {
                for (EntryData entryData : changes) {
                    out.write(entryData.getDestination().getCanonicalPath());
                    out.newLine();
                }
            } else {
                this.writeNoFiles(out, logPrefix);
            }
            out.newLine();
            out.write("Removed Files");
            out.newLine();
            if (removes.size() > 0) {
                for (EntryData entryData : removes) {
                    out.write(entryData.getDestination().getCanonicalPath());
                    out.newLine();
                }
            } else {
                this.writeNoFiles(out, logPrefix);
            }
            out.close();
        }
        catch (Exception e) {
            throw new InstallException(1, null, this.getBundle().messageString("AuditLogger." + logPrefix + "ExecutionWriteFailure"), "Error writing " + logPrefix + "-execution file audit log", e);
        }
    }

    private InetAddress getLocalHost() {
        try {
            return InetAddress.getLocalHost();
        }
        catch (UnknownHostException e) {
            log.info("System can't resolve its own hostname: " + e);
            log.info("Choosing first non-loopback address instead");
            try {
                return this.getFirstNonLoopbackAddress();
            }
            catch (SocketException se) {
                log.info("Can't enumerate network interfaces to find a non-loopback address", (Throwable)se);
                return null;
            }
        }
    }

    private InetAddress getFirstNonLoopbackAddress() throws SocketException {
        Enumeration<NetworkInterface> nets = NetworkInterface.getNetworkInterfaces();
        while (nets != null && nets.hasMoreElements()) {
            NetworkInterface i = nets.nextElement();
            Enumeration<InetAddress> addresses = i.getInetAddresses();
            while (addresses.hasMoreElements()) {
                InetAddress addr = addresses.nextElement();
                if (addr.isLoopbackAddress()) continue;
                return addr;
            }
        }
        log.info("No non-loopback network interfaces present on the system");
        return null;
    }

    private void writeNoFiles(BufferedWriter out, String logPrefix) {
        try {
            out.write("There were no files to be processed.");
            out.newLine();
        }
        catch (Exception e) {
            throw new InstallException(1, null, this.getBundle().messageString("AuditLogger." + logPrefix + "ExecutionWriteFailure"), "Error writing " + logPrefix + "-execution file audit log", e);
        }
    }

    private Vector<EntryData> getSkippedFiles() {
        Vector<EntryData> skippedFiles = new Vector<EntryData>();
        ArrayList<String> addedFiles = new ArrayList<String>();
        for (EntryData entryData : this.getAdds()) {
            addedFiles.add(entryData.getDestination().getAbsolutePath());
        }
        ArrayList<String> changedFiles = new ArrayList<String>();
        for (EntryData changedFile : this.getChanges()) {
            changedFiles.add(changedFile.getDestination().getAbsolutePath());
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        for (EntryData removedFile : this.getRemoves()) {
            arrayList.add(removedFile.getDestination().getAbsolutePath());
        }
        for (EntryData checkedFile : this.getCheckedFiles()) {
            String destination = checkedFile.getDestination().getAbsolutePath();
            if (addedFiles.contains(destination) || changedFiles.contains(destination) || arrayList.contains(destination)) continue;
            skippedFiles.add(checkedFile);
        }
        return skippedFiles;
    }

    @Override
    public void bytesMoved(long numBytes) {
    }

    @Override
    public void progressBeginningAction(String action, EntryData metaData) {
    }

    @Override
    public void progressBeginningAction(String description) {
    }

    @Override
    public void progressCompleteAction(String action, EntryData metaData) {
        if (action.equals("Added")) {
            this.getActualAdds().add(metaData);
        } else if (action.equals("Changed")) {
            this.getActualChanges().add(metaData);
        } else if (action.equals("Removed")) {
            this.getActualRemoves().add(metaData);
        } else if (action.equals("Backed up")) {
            this.getActualBackups().add(metaData);
        }
    }

    @Override
    public void progressCompleteAction(String description) {
    }

    @Override
    public void progressFailedAction(String action, EntryData metaData) {
    }

    @Override
    public void setupAction(String action, EntryData metaData) {
        if (action.equals("Added")) {
            this.getAdds().add(metaData);
        } else if (action.equals("Changed")) {
            this.getChanges().add(metaData);
        } else if (action.equals("Removed")) {
            this.getRemoves().add(metaData);
        } else if (action.equals("Backed up")) {
            this.getBackups().add(metaData);
        } else if (action.equals("Checked")) {
            this.getCheckedFiles().add(metaData);
        }
    }

    @Override
    public void setupAction(String description) {
    }

    protected Vector<EntryData> getAdds() {
        return this._adds;
    }

    protected void setAdds(Vector<EntryData> adds) {
        this._adds = adds;
    }

    protected Vector<EntryData> getRemoves() {
        return this._removes;
    }

    protected void setRemoves(Vector<EntryData> removes) {
        this._removes = removes;
    }

    protected Vector<EntryData> getChanges() {
        return this._changes;
    }

    protected void setChanges(Vector<EntryData> changes) {
        this._changes = changes;
    }

    public Vector<EntryData> getActualAdds() {
        return this._actualAdds;
    }

    public void setActualAdds(Vector<EntryData> actualAdds) {
        this._actualAdds = actualAdds;
    }

    public Vector<EntryData> getActualRemoves() {
        return this._actualRemoves;
    }

    public void setActualRemoves(Vector<EntryData> actualRemoves) {
        this._actualRemoves = actualRemoves;
    }

    public Vector<EntryData> getActualChanges() {
        return this._actualChanges;
    }

    public void setActualChanges(Vector<EntryData> actualChanges) {
        this._actualChanges = actualChanges;
    }

    public Controller getController() {
        return this._controller;
    }

    public void setController(Controller controller) {
        this._controller = controller;
    }

    public SSNResource getBundle() {
        return this._bundle;
    }

    public void setBundle(SSNResource bundle) {
        this._bundle = bundle;
    }

    public Vector<EntryData> getBackups() {
        return this._backups;
    }

    public void setBackups(Vector<EntryData> backups) {
        this._backups = backups;
    }

    public Vector<EntryData> getActualBackups() {
        return this._actualBackups;
    }

    public void setActualBackups(Vector<EntryData> actualBackups) {
        this._actualBackups = actualBackups;
    }

    public void setCheckedFiles(Vector<EntryData> checkedFiles) {
        this._checkedFiles = checkedFiles;
    }

    public Vector<EntryData> getCheckedFiles() {
        return this._checkedFiles;
    }

    @Override
    public void installStartedAction() {
    }

    @Override
    public void installCompletedAction() {
    }

    @Override
    public void taskStartedAction(InstallationTask task) {
    }
}

