/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.cli.shell;

import com.healthmarketscience.rmiio.RemoteOutputStream;
import com.healthmarketscience.rmiio.RemoteOutputStreamClient;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringWriter;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceNotFoundException;
import javax.management.JMX;
import javax.management.MBeanException;
import javax.management.MBeanServerConnection;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.QueryExp;
import javax.management.ReflectionException;
import javax.management.remote.JMXConnector;
import javax.management.remote.JMXConnectorFactory;
import javax.management.remote.JMXServiceURL;
import org.apache.commons.io.IOUtils;
import org.apache.geode.internal.net.SSLConfig;
import org.apache.geode.internal.net.SSLConfigurationFactory;
import org.apache.geode.internal.security.SecurableCommunicationChannel;
import org.apache.geode.logging.internal.log4j.api.LogService;
import org.apache.geode.management.DistributedSystemMXBean;
import org.apache.geode.management.MemberMXBean;
import org.apache.geode.management.internal.ContextAwareSSLRMIClientSocketFactory;
import org.apache.geode.management.internal.MBeanJMXAdapter;
import org.apache.geode.management.internal.beans.FileUploader;
import org.apache.geode.management.internal.beans.FileUploaderMBean;
import org.apache.geode.management.internal.cli.CommandRequest;
import org.apache.geode.management.internal.cli.shell.JMXConnectionException;
import org.apache.geode.management.internal.cli.shell.JMXConnectionListener;
import org.apache.geode.management.internal.cli.shell.JMXInvocationException;
import org.apache.geode.management.internal.cli.shell.OperationInvoker;
import org.apache.logging.log4j.Logger;

public class JmxOperationInvoker
implements OperationInvoker {
    private static final Logger logger = LogService.getLogger();
    private static final String JMX_URL_FORMAT = "service:jmx:rmi://{0}/jndi/rmi://{0}:{1}/jmxrmi";
    private final JMXConnector connector;
    private final JMXServiceURL url;
    private final MBeanServerConnection mbsc;
    private final String endpoints;
    private final DistributedSystemMXBean distributedSystemMXBeanProxy;
    private final MemberMXBean memberMXBeanProxy;
    private final FileUploaderMBean fileUploadMBeanProxy;
    private final ObjectName managerMemberObjectName;
    final AtomicBoolean isConnected = new AtomicBoolean(false);
    final AtomicBoolean isSelfDisconnect = new AtomicBoolean(false);
    private int clusterId = -1;

    public JmxOperationInvoker(String host, int port, Properties gfProperties) throws Exception {
        this.endpoints = host + "[" + port + "]";
        HashMap<String, Object> env = new HashMap<String, Object>();
        env.put("jmx.remote.x.client.connection.check.period", 1000L);
        String token = gfProperties.getProperty("security-token");
        String username = gfProperties.getProperty("security-username");
        String password = gfProperties.getProperty("security-password");
        if (token != null) {
            env.put("jmx.remote.credentials", token);
        } else if (username != null) {
            env.put("jmx.remote.credentials", new String[]{username, password});
        }
        SSLConfig sslConfig = SSLConfigurationFactory.getSSLConfigForComponent((Properties)gfProperties, (SecurableCommunicationChannel)SecurableCommunicationChannel.JMX);
        if (sslConfig.isEnabled()) {
            StringWriter propertiesWriter = new StringWriter();
            gfProperties.store(propertiesWriter, null);
            System.setProperty("org.apache.geode.internal.net.ssl.config", propertiesWriter.toString());
            env.put("com.sun.jndi.rmi.factory.socket", new ContextAwareSSLRMIClientSocketFactory());
        }
        String hostName = JmxOperationInvoker.checkAndConvertToCompatibleIPv6Syntax(host);
        this.url = new JMXServiceURL(MessageFormat.format(JMX_URL_FORMAT, hostName, String.valueOf(port)));
        this.connector = JMXConnectorFactory.connect(this.url, env);
        this.mbsc = this.connector.getMBeanServerConnection();
        this.connector.addConnectionNotificationListener(new JMXConnectionListener(this), null, null);
        this.distributedSystemMXBeanProxy = JMX.newMXBeanProxy(this.mbsc, MBeanJMXAdapter.getDistributedSystemName(), DistributedSystemMXBean.class);
        if (this.distributedSystemMXBeanProxy == null) {
            logger.info("DistributedSystemMXBean is not present on member with endpoints : " + this.endpoints);
            throw new JMXConnectionException(2);
        }
        this.managerMemberObjectName = this.distributedSystemMXBeanProxy.getMemberObjectName();
        if (this.managerMemberObjectName == null || !JMX.isMXBeanInterface(MemberMXBean.class)) {
            logger.info("MemberMXBean with ObjectName " + String.valueOf(this.managerMemberObjectName) + " is not present on member with endpoints : " + this.endpoints);
            throw new JMXConnectionException(2);
        }
        this.memberMXBeanProxy = JMX.newMXBeanProxy(this.mbsc, this.managerMemberObjectName, MemberMXBean.class);
        this.fileUploadMBeanProxy = JMX.newMBeanProxy(this.mbsc, new ObjectName("GemFire:service=FileUploader,type=Distributed"), FileUploaderMBean.class);
        this.isConnected.set(true);
        this.clusterId = this.distributedSystemMXBeanProxy.getDistributedSystemId();
    }

    @Override
    public Object getAttribute(String resourceName, String attributeName) throws JMXInvocationException {
        try {
            return this.mbsc.getAttribute(ObjectName.getInstance(resourceName), attributeName);
        }
        catch (AttributeNotFoundException e) {
            throw new JMXInvocationException(attributeName + " not found for " + resourceName, e);
        }
        catch (InstanceNotFoundException e) {
            throw new JMXInvocationException(resourceName + " is not registered in the MBean server.", e);
        }
        catch (IOException | MalformedObjectNameException e) {
            throw new JMXInvocationException(resourceName + " is not a valid resource name.", e);
        }
        catch (MBeanException e) {
            throw new JMXInvocationException("Exception while fetching " + attributeName + " for " + resourceName, e);
        }
        catch (ReflectionException e) {
            throw new JMXInvocationException("Couldn't find " + attributeName + " for " + resourceName, e);
        }
        catch (NullPointerException e) {
            throw new JMXInvocationException("Given resourceName is null.", e);
        }
    }

    @Override
    public String getRemoteVersion() {
        return this.memberMXBeanProxy.getReleaseVersion();
    }

    @Override
    public String getRemoteGeodeSerializationVersion() {
        return this.memberMXBeanProxy.getGeodeReleaseVersion();
    }

    @Override
    public Object invoke(String resourceName, String operationName, Object[] params, String[] signature) throws JMXInvocationException {
        try {
            return this.invoke(ObjectName.getInstance(resourceName), operationName, params, signature);
        }
        catch (MalformedObjectNameException e) {
            throw new JMXInvocationException(resourceName + " is not a valid resource name.", e);
        }
        catch (NullPointerException e) {
            throw new JMXInvocationException("Given resourceName is null.", e);
        }
    }

    protected Object invoke(ObjectName resource, String operationName, Object[] params, String[] signature) throws JMXInvocationException {
        try {
            return this.mbsc.invoke(resource, operationName, params, signature);
        }
        catch (InstanceNotFoundException e) {
            throw new JMXInvocationException(String.valueOf(resource) + " is not registered in the MBean server.", e);
        }
        catch (MBeanException e) {
            throw new JMXInvocationException("Exception while invoking " + operationName + " on " + String.valueOf(resource), e);
        }
        catch (ReflectionException e) {
            throw new JMXInvocationException("Couldn't find " + operationName + " on " + String.valueOf(resource) + " with arguments " + Arrays.toString(signature), e);
        }
        catch (IOException e) {
            throw new JMXInvocationException("Couldn't communicate with remote server at " + String.valueOf(this), e);
        }
    }

    @Override
    public Set<ObjectName> queryNames(ObjectName objectName, QueryExp queryExpression) {
        try {
            return this.getMBeanServerConnection().queryNames(objectName, queryExpression);
        }
        catch (IOException e) {
            throw new JMXInvocationException(String.format("Failed to communicate with the remote MBean server at (%1$s)!", this), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String processCommand(CommandRequest commandRequest) {
        ArrayList<String> stagedFilePaths;
        block17: {
            stagedFilePaths = null;
            try {
                if (!commandRequest.hasFileList()) break block17;
                stagedFilePaths = new ArrayList<String>();
                for (File file : commandRequest.getFileList()) {
                    FileUploader.RemoteFile remote = this.fileUploadMBeanProxy.uploadFile(file.getName());
                    try (FileInputStream source = new FileInputStream(file);){
                        OutputStream target = RemoteOutputStreamClient.wrap((RemoteOutputStream)remote.getOutputStream());
                        try {
                            IOUtils.copyLarge((InputStream)source, (OutputStream)target);
                            stagedFilePaths.add(remote.getFilename());
                        }
                        finally {
                            if (target == null) continue;
                            target.close();
                        }
                    }
                }
            }
            catch (IOException e) {
                throw new JMXInvocationException("Unable to upload file", e);
            }
        }
        try {
            String string = this.memberMXBeanProxy.processCommand(commandRequest.getUserInput(), commandRequest.getEnvironment(), stagedFilePaths);
            return string;
        }
        finally {
            if (stagedFilePaths != null) {
                this.fileUploadMBeanProxy.deleteFiles(stagedFilePaths);
            }
        }
    }

    @Override
    public void stop() {
        try {
            this.isSelfDisconnect.set(true);
            this.connector.close();
            this.isConnected.set(false);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public boolean isConnected() {
        return this.isConnected.get();
    }

    @Override
    public DistributedSystemMXBean getDistributedSystemMXBean() {
        if (this.distributedSystemMXBeanProxy == null) {
            throw new IllegalStateException("The DistributedSystemMXBean proxy was not initialized properly!");
        }
        return this.distributedSystemMXBeanProxy;
    }

    public JMXServiceURL getJmxServiceUrl() {
        return this.url;
    }

    @Override
    public <T> T getMBeanProxy(ObjectName objectName, Class<T> mbeanInterface) {
        if (DistributedSystemMXBean.class.equals(mbeanInterface) && "GemFire:service=System,type=Distributed".equals(objectName.toString())) {
            return mbeanInterface.cast(this.getDistributedSystemMXBean());
        }
        if (JMX.isMXBeanInterface(mbeanInterface)) {
            return JMX.newMXBeanProxy(this.getMBeanServerConnection(), objectName, mbeanInterface);
        }
        return JMX.newMBeanProxy(this.getMBeanServerConnection(), objectName, mbeanInterface);
    }

    public MBeanServerConnection getMBeanServerConnection() {
        if (this.mbsc == null) {
            throw new IllegalStateException("Gfsh is not connected to the GemFire Manager.");
        }
        return this.mbsc;
    }

    @Override
    public boolean isReady() {
        try {
            return this.mbsc.isRegistered(this.managerMemberObjectName);
        }
        catch (IOException e) {
            return false;
        }
    }

    public String toString() {
        return this.endpoints;
    }

    @Override
    public int getClusterId() {
        return this.clusterId;
    }

    void resetClusterId() {
        this.clusterId = -1;
    }

    private static String checkAndConvertToCompatibleIPv6Syntax(String hostAddress) {
        if (((String)hostAddress).contains(":")) {
            logger.debug("IPv6 host address detected, using IPv6 syntax for host in JMX connection URL");
            hostAddress = "[" + (String)hostAddress + "]";
            logger.debug("Compatible host address is : " + (String)hostAddress);
        }
        return hostAddress;
    }
}

