/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.cli.shell;

import java.io.File;
import java.util.logging.Level;
import org.apache.commons.lang3.StringUtils;
import org.apache.geode.annotations.Immutable;
import org.apache.geode.internal.util.IOUtils;
import org.apache.geode.management.internal.cli.shell.Gfsh;

public class GfshConfig {
    public static final String INIT_FILE_PROPERTY = "gfsh.init-file";
    private static final String LOG_DIR_PROPERTY = "gfsh.log-dir";
    private static final String LOG_LEVEL_PROPERTY = "gfsh.log-level";
    private static final String LOG_FILE_SIZE_LIMIT_PROPERTY = "gfsh.log-file-size-limit";
    private static final String LOG_DISK_SPACE_LIMIT_PROPERTY = "gfsh.log-disk-space-limit";
    private static final File HISTORY_FILE = new File(GfshConfig.getHomeGemFireDirectory(), ".gfsh.history");
    private static final int MAX_HISTORY_SIZE = 500;
    public static final String DEFAULT_INIT_FILE_NAME = ".gfsh2rc";
    @Immutable
    private static final Level DEFAULT_LOGLEVEL = Level.OFF;
    private static final int DEFAULT_LOGFILE_SIZE_LIMIT = 0xA00000;
    private static final int DEFAULT_LOGFILE_DISK_USAGE = 0xA00000;
    private static final String DEFAULT_PROMPT = "{0}gfsh{1}>";
    private final String historyFileName;
    private final String initFileName;
    private final String defaultPrompt;
    private final int historySize;
    private final String logDir;
    private final Level logLevel;
    private final int logFileSizeLimit;
    private final int logFileDiskLimit;

    public GfshConfig() {
        this(HISTORY_FILE.getAbsolutePath(), DEFAULT_PROMPT, 500, null, null, null, null, null);
    }

    public boolean deleteHistoryFile() {
        if (this.historyFileName == null) {
            return true;
        }
        File file = new File(this.historyFileName);
        if (!file.exists()) {
            return true;
        }
        return file.delete();
    }

    public GfshConfig(String historyFileName, String defaultPrompt, int historySize, String logDir, Level logLevel, Integer logLimit, Integer logCount, String initFileName) {
        this.historyFileName = historyFileName;
        this.defaultPrompt = defaultPrompt;
        this.historySize = historySize;
        this.initFileName = initFileName == null ? this.searchForInitFileName() : initFileName;
        this.logDir = logDir == null ? System.getProperty(LOG_DIR_PROPERTY, ".") : logDir;
        this.logLevel = logLevel == null ? GfshConfig.getLogLevel(System.getProperty(LOG_LEVEL_PROPERTY, DEFAULT_LOGLEVEL.getName())) : logLevel;
        this.logFileSizeLimit = logLimit == null ? GfshConfig.getParsedOrDefault(System.getProperty(LOG_FILE_SIZE_LIMIT_PROPERTY), LOG_FILE_SIZE_LIMIT_PROPERTY, 0xA00000) : logLimit;
        this.logFileDiskLimit = logCount == null ? GfshConfig.getParsedOrDefault(System.getProperty(LOG_DISK_SPACE_LIMIT_PROPERTY), LOG_DISK_SPACE_LIMIT_PROPERTY, 0xA00000) : logCount;
    }

    public String getHistoryFileName() {
        return this.historyFileName;
    }

    public String getInitFileName() {
        return this.initFileName;
    }

    public String getDefaultPrompt() {
        return this.defaultPrompt;
    }

    public int getHistorySize() {
        return this.historySize;
    }

    public String getLogFilePath() {
        return IOUtils.tryGetCanonicalPathElseGetAbsolutePath((File)new File(this.logDir, "gfsh-%u_%g.log"));
    }

    public Level getLogLevel() {
        return this.logLevel;
    }

    public int getLogFileSizeLimit() {
        return this.logFileSizeLimit;
    }

    protected int getLogFileDiskLimit() {
        return this.logFileDiskLimit;
    }

    public int getLogFileCount() {
        int logCount;
        try {
            logCount = this.getLogFileSizeLimit() / this.getLogFileDiskLimit();
            logCount = logCount >= 1 ? logCount : 1;
        }
        catch (ArithmeticException e) {
            logCount = 1;
        }
        return logCount;
    }

    public boolean isLoggingEnabled() {
        return !Level.OFF.equals(this.getLogLevel());
    }

    private String getLoggerConfig() {
        return "init-file=" + (this.getInitFileName() == null ? "" : this.getInitFileName()) + Gfsh.LINE_SEPARATOR + "log-file=" + this.getLogFilePath() + Gfsh.LINE_SEPARATOR + "log-level=" + this.getLogLevel().getName() + Gfsh.LINE_SEPARATOR + "log-file-size-limit=" + this.getLogFileSizeLimit() + Gfsh.LINE_SEPARATOR + "log-disk-space-limit=" + this.getLogFileDiskLimit() + Gfsh.LINE_SEPARATOR + "log-count=" + this.getLogFileCount() + Gfsh.LINE_SEPARATOR;
    }

    public boolean isTestConfig() {
        return false;
    }

    public boolean isANSISupported() {
        return !Boolean.getBoolean("gfsh.disable.color");
    }

    private static Level getLogLevel(String logLevelString) {
        try {
            String logLevelAsString;
            String string = logLevelAsString = StringUtils.isBlank((CharSequence)logLevelString) ? "" : logLevelString.trim();
            if ("NONE".equalsIgnoreCase(logLevelAsString)) {
                logLevelAsString = Level.OFF.getName();
            }
            if ("ERROR".equalsIgnoreCase(logLevelAsString)) {
                logLevelAsString = Level.WARNING.getName();
            }
            return Level.parse(logLevelAsString.toUpperCase());
        }
        catch (IllegalArgumentException e) {
            System.out.println(e.getMessage());
            return DEFAULT_LOGLEVEL;
        }
    }

    private static String getHomeGemFireDirectory() {
        String userHome = System.getProperty("user.home");
        Object homeDirPath = userHome + "/.geode";
        File alternateDir = new File((String)homeDirPath);
        if (!alternateDir.exists() && !alternateDir.mkdirs()) {
            homeDirPath = ".";
        }
        return homeDirPath;
    }

    private static int getParsedOrDefault(String numberString, String parseValueFor, int defaultValue) {
        if (numberString == null) {
            return defaultValue;
        }
        try {
            return Integer.parseInt(numberString);
        }
        catch (NumberFormatException e) {
            System.err.println("Invalid value \"" + numberString + "\" specified for: \"" + parseValueFor + "\". Using default value: \"" + defaultValue + "\".");
            return defaultValue;
        }
    }

    public String toString() {
        return this.getClass().getSimpleName() + " [initFileName=" + (this.getInitFileName() == null ? "" : this.getInitFileName()) + ", historyFileName=" + this.getHistoryFileName() + ", historySize=" + this.getHistorySize() + ", loggerConfig={" + this.getLoggerConfig() + "}, isANSISupported=" + this.isANSISupported() + "]";
    }

    private String searchForInitFileName() {
        String[] initFileNames;
        String homeDirectoryInitFileName = System.getProperty("user.home") + File.separatorChar + DEFAULT_INIT_FILE_NAME;
        String currentDirectoryInitFileName = System.getProperty("user.dir") + File.separatorChar + DEFAULT_INIT_FILE_NAME;
        String systemPropertyInitFileName = System.getProperty(INIT_FILE_PROPERTY);
        for (String initFileName : initFileNames = new String[]{systemPropertyInitFileName, currentDirectoryInitFileName, homeDirectoryInitFileName}) {
            if (!IOUtils.isExistingPathname((String)initFileName)) continue;
            return initFileName;
        }
        return null;
    }
}

