/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.cli.result;

import java.util.ArrayList;
import java.util.List;
import org.apache.geode.management.internal.cli.result.Row;
import org.apache.geode.management.internal.cli.result.RowGroup;
import org.apache.geode.management.internal.cli.result.Screen;

class Table {
    private final List<RowGroup> rowGroups = new ArrayList<RowGroup>();
    private final Screen screen;
    private String columnSeparator = "   ";
    private boolean isTabularResult;

    Table(Screen screen) {
        this.screen = screen;
    }

    public String toString() {
        return "Table{rowGroups=" + String.valueOf(this.rowGroups) + "}";
    }

    void setTabularResult(boolean isTabularResult) {
        this.isTabularResult = isTabularResult;
    }

    void setColumnSeparator(String columnSeparator) {
        this.columnSeparator = columnSeparator;
    }

    String getColumnSeparator() {
        return this.columnSeparator;
    }

    RowGroup newRowGroup() {
        RowGroup rowGroup = new RowGroup(this, this.screen);
        this.rowGroups.add(rowGroup);
        return rowGroup;
    }

    Row newRow() {
        RowGroup rowGroup = this.newRowGroup();
        return rowGroup.newRow();
    }

    void newBlankRow() {
        RowGroup rowGroup = this.newRowGroup();
        rowGroup.newBlankRow();
    }

    RowGroup getLastRowGroup() {
        if (this.rowGroups.isEmpty()) {
            return null;
        }
        return this.rowGroups.get(this.rowGroups.size() - 1);
    }

    int getMaxLength() {
        int rowGroupMaxTotalLength = 0;
        for (RowGroup rowGroup : this.rowGroups) {
            List<Row> rows = rowGroup.getRows();
            int rowMaxTotalLength = 0;
            for (Row row : rows) {
                int rowTotalLength = 0;
                for (int i = 0; i < row.getNumCols(); ++i) {
                    rowTotalLength += row.getMaxColLength(i);
                }
                if (rowGroup.getColumnSeparator() != null) {
                    rowTotalLength += row.getNumCols() * rowGroup.getColumnSeparator().length();
                }
                if (rowMaxTotalLength >= rowTotalLength) continue;
                rowMaxTotalLength = rowTotalLength;
            }
            int rowGroupTotalLength = 0;
            if (rowGroupMaxTotalLength >= (rowGroupTotalLength += rowMaxTotalLength)) continue;
            rowGroupMaxTotalLength = rowGroupTotalLength;
        }
        return (int)((double)rowGroupMaxTotalLength * 1.1);
    }

    String buildTable() {
        StringBuilder StringBuilder2 = new StringBuilder();
        for (RowGroup rowGroup : this.rowGroups) {
            StringBuilder2.append(rowGroup.buildRowGroup(this.isTabularResult));
        }
        return StringBuilder2.toString();
    }

    List<String> buildTableList() {
        ArrayList<String> list = new ArrayList<String>();
        for (RowGroup rowGroup : this.rowGroups) {
            list.add(rowGroup.buildRowGroup(this.isTabularResult));
        }
        return list;
    }
}

