/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.cli.result;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.geode.management.internal.cli.GfshParser;
import org.apache.geode.management.internal.cli.result.ComparableColumn;
import org.apache.geode.management.internal.cli.result.Row;
import org.apache.geode.management.internal.cli.result.Screen;
import org.apache.geode.management.internal.cli.result.Table;
import org.apache.geode.management.internal.cli.result.TooManyColumnsException;

class RowGroup {
    private static final int SCREEN_WIDTH_MARGIN_BUFFER = 5;
    private final Table table;
    private final List<Row> rows = new ArrayList<Row>();
    private final Screen screen;
    private int[] colSizes;
    private String columnSeparator;

    RowGroup(Table table, Screen screen) {
        this.table = table;
        this.screen = screen;
    }

    public String toString() {
        return "RowGroup [rows=" + String.valueOf(this.rows) + "]";
    }

    Table getTable() {
        return this.table;
    }

    Row newRow() {
        Row row = new Row(this, this.screen);
        this.rows.add(row);
        return row;
    }

    void newRowSeparator(Character character, boolean isTableWideSeparator) {
        Row row = new Row(this, this.screen, character, isTableWideSeparator);
        this.rows.add(row);
    }

    void newBlankRow() {
        this.newRow().newCenterCol("").setBlank(true);
    }

    String buildRowGroup(boolean isTabularResult) {
        this.colSizes = this.computeColSizes(isTabularResult);
        StringBuilder stringBuilder = new StringBuilder();
        for (Row row : this.rows) {
            String builtRow = row.buildRow(isTabularResult);
            stringBuilder.append(builtRow);
            if (!StringUtils.isNotBlank((CharSequence)builtRow) && !row.isBlank()) continue;
            stringBuilder.append(GfshParser.LINE_SEPARATOR);
        }
        return stringBuilder.toString();
    }

    int getColSize(int colNum) {
        return this.colSizes[colNum];
    }

    int getNumCols() {
        int maxNumCols = 0;
        for (Row row : this.rows) {
            int numCols = row.getNumCols();
            if (numCols <= maxNumCols) continue;
            maxNumCols = numCols;
        }
        return maxNumCols;
    }

    void setColumnSeparator(String columnSeparator) {
        this.columnSeparator = columnSeparator;
    }

    String getColumnSeparator() {
        return this.columnSeparator != null ? this.columnSeparator : this.table.getColumnSeparator();
    }

    List<Row> getRows() {
        return Collections.unmodifiableList(this.rows);
    }

    private int[] computeColSizes(boolean isTabularResult) {
        int[] localColSizes = new int[this.getNumCols()];
        for (int i = 0; i < localColSizes.length; ++i) {
            localColSizes[i] = this.getMaxColLength(i);
        }
        if (isTabularResult) {
            localColSizes = this.recalculateColSizesForScreen(this.screen.getScreenWidth(), localColSizes, this.getColumnSeparator());
        }
        return localColSizes;
    }

    private int getMaxColLength(int colNum) {
        int maxLength = 0;
        for (Row row : this.rows) {
            int colLength = row.getMaxColLength(colNum);
            if (colLength <= maxLength) continue;
            maxLength = colLength;
        }
        return maxLength;
    }

    private int[] recalculateColSizesForScreen(int screenWidth, int[] colSizes, String colSeparators) {
        if (!this.screen.shouldTrimColumns()) {
            return colSizes;
        }
        screenWidth -= (colSizes.length - 1) * colSeparators.length();
        ArrayList<ComparableColumn> stringList = new ArrayList<ComparableColumn>();
        int index = 0;
        int totalLength = 0;
        for (int k : colSizes) {
            ComparableColumn cs = new ComparableColumn();
            cs.originalIndex = index++;
            cs.length = k;
            stringList.add(cs);
            totalLength += k;
        }
        if (totalLength <= screenWidth) {
            return colSizes;
        }
        Collections.sort(stringList);
        totalLength = 0;
        int spaceLeft = 0;
        int totalExtra = 0;
        for (ComparableColumn s : stringList) {
            int newLength = totalLength + s.length;
            if (newLength + 5 > screenWidth) {
                s.markForTrim = true;
                totalExtra += s.length;
                if (spaceLeft == 0) {
                    spaceLeft = screenWidth - totalLength;
                }
            }
            totalLength = newLength;
        }
        stringList.sort(Comparator.comparingInt(o -> o.originalIndex));
        int[] finalColSizes = new int[colSizes.length];
        int i = 0;
        for (ComparableColumn s : stringList) {
            s.trimmedLength = totalLength > screenWidth ? (s.markForTrim ? (int)Math.floor((double)spaceLeft * ((double)s.length / (double)totalExtra)) : s.length) : s.length;
            finalColSizes[i] = s.trimmedLength;
            ++i;
        }
        totalLength = 0;
        index = 0;
        for (Object colSize : (Object)finalColSizes) {
            if (colSize != colSizes[index] && colSize < 2) {
                throw new TooManyColumnsException("Computed ColSize=" + (int)colSize + " Set RESULT_VIEWER to external. This uses the 'less' command (with horizontal scrolling) to see wider results");
            }
            totalLength += colSize;
            ++index;
        }
        return finalColSizes;
    }
}

