/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.cli.functions;

import java.lang.invoke.CallSite;
import java.util.HashMap;
import org.apache.geode.cache.execute.FunctionContext;
import org.apache.geode.internal.cache.InternalCache;
import org.apache.geode.internal.cache.execute.InternalFunction;
import org.apache.geode.internal.logging.log4j.LogMarker;
import org.apache.geode.logging.internal.log4j.LogLevel;
import org.apache.geode.logging.internal.log4j.api.LogService;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.Logger;

public class ChangeLogLevelFunction
implements InternalFunction<Object[]> {
    private static final Logger logger = LogService.getLogger();
    private static final long serialVersionUID = 1L;
    private static final String ID = "org.apache.geode.management.internal.cli.functions.ChangeLogLevelFunction";

    public String getId() {
        return ID;
    }

    public void execute(FunctionContext<Object[]> context) {
        InternalCache cache = (InternalCache)context.getCache();
        HashMap<String, CallSite> result = new HashMap<String, CallSite>();
        try {
            Object[] args = (Object[])context.getArguments();
            String logLevel = (String)args[0];
            Level log4jLevel = LogLevel.getLevel((String)logLevel);
            int logWriterLevel = LogLevel.getLogWriterLevel((String)logLevel);
            cache.getInternalDistributedSystem().getConfig().setLogLevel(logWriterLevel);
            System.setProperty("gemfire.log-level", logLevel);
            logger.info(LogMarker.CONFIG_MARKER, "GFSH Changed log level to {}", (Object)log4jLevel);
            result.put(cache.getDistributedSystem().getDistributedMember().getId(), (CallSite)((Object)("New log level is " + String.valueOf(log4jLevel))));
            context.getResultSender().lastResult(result);
        }
        catch (Exception ex) {
            logger.info(LogMarker.CONFIG_MARKER, "GFSH Changing log level exception {}", (Object)ex.getMessage(), (Object)ex);
            result.put(cache.getDistributedSystem().getDistributedMember().getId(), (CallSite)((Object)("ChangeLogLevelFunction exception " + ex.getMessage())));
            context.getResultSender().lastResult(result);
        }
    }

    public boolean hasResult() {
        return true;
    }

    public boolean optimizeForWrite() {
        return false;
    }

    public boolean isHA() {
        return false;
    }
}

