/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.cli.commands.lifecycle;

import java.io.File;
import java.io.IOException;
import java.util.Properties;
import org.apache.commons.lang3.StringUtils;
import org.apache.geode.distributed.AbstractLauncher;
import org.apache.geode.distributed.LocatorLauncher;
import org.apache.geode.management.MemberMXBean;
import org.apache.geode.management.cli.CliMetaData;
import org.apache.geode.management.internal.cli.commands.OfflineGfshCommand;
import org.apache.geode.management.internal.cli.result.model.InfoResultModel;
import org.apache.geode.management.internal.cli.result.model.ResultModel;
import org.apache.geode.management.internal.cli.shell.MXBeanProvider;
import org.apache.geode.management.internal.configuration.utils.ClusterConfigurationStatusRetriever;
import org.apache.geode.management.internal.i18n.CliStrings;
import org.springframework.shell.core.annotation.CliCommand;
import org.springframework.shell.core.annotation.CliOption;

public class StatusLocatorCommand
extends OfflineGfshCommand {
    private static final String SECURITY_PROPERTIES__HELP = "The gfsecurity.properties file for configuring SSL to connect to the Locator. The file's path can be absolute or relative to gfsh directory.";

    @CliCommand(value={"status locator"}, help="Display the status of a Locator. Possible statuses are: started, online, offline or not responding.")
    @CliMetaData(shellOnly=true, relatedTopic={"Locator", "Lifecycle"})
    public ResultModel statusLocator(@CliOption(key={"name"}, optionContext="geode.converter.locatormember.idOrName:disable-string-converter", help="Member name or ID of the Locator in the Geode cluster.") String member, @CliOption(key={"host"}, help="Hostname or IP address on which the Locator is running.") String locatorHost, @CliOption(key={"port"}, help="Port on which the Locator is listening. The default is 10334.") Integer locatorPort, @CliOption(key={"pid"}, help="Process ID (PID) of the running Locator. Deprecated: Since Geode 1.2. Requires the JDK tools.jar which is not included on the classpath by default. Use --dir instead.") Integer pid, @CliOption(key={"dir"}, help="Working directory in which the Locator is running. The default is the current directory.") String workingDirectory, @CliOption(key={"security-properties-file"}, optionContext="geode.converter.file", help="The gfsecurity.properties file for configuring SSL to connect to the Locator. The file's path can be absolute or relative to gfsh directory.") File gfSecurityPropertiesFile) throws Exception {
        Properties properties = new Properties();
        if (gfSecurityPropertiesFile != null) {
            properties = this.loadProperties(gfSecurityPropertiesFile);
        }
        if (StringUtils.isNotBlank((CharSequence)member)) {
            if (this.isConnectedAndReady()) {
                MemberMXBean locatorProxy = MXBeanProvider.getMemberMXBean(member);
                if (locatorProxy != null) {
                    LocatorLauncher.LocatorState state = LocatorLauncher.LocatorState.fromJson((String)locatorProxy.status());
                    return this.createStatusLocatorResult(state, properties);
                }
                return ResultModel.createError(CliStrings.format((String)"No Locator with member name or ID {0} could be found.", (Object)member));
            }
            return ResultModel.createError(CliStrings.format((String)"Gfsh must be connected in order to get the status of a {0} by member name or ID.", (Object)"Locator"));
        }
        LocatorLauncher locatorLauncher = new LocatorLauncher.Builder().setCommand(LocatorLauncher.Command.STATUS).setBindAddress(locatorHost).setDebug(Boolean.valueOf(this.isDebugging())).setPid(pid).setPort(locatorPort).set(properties).setWorkingDirectory(workingDirectory).build();
        LocatorLauncher.LocatorState status = locatorLauncher.status();
        if (status.getStatus().equals((Object)AbstractLauncher.Status.NOT_RESPONDING) || status.getStatus().equals((Object)AbstractLauncher.Status.STOPPED)) {
            return ResultModel.createError(status.toString());
        }
        return this.createStatusLocatorResult(status, properties);
    }

    protected ResultModel createStatusLocatorResult(LocatorLauncher.LocatorState state, Properties properties) throws NumberFormatException, IOException, ClassNotFoundException {
        ResultModel result = new ResultModel();
        InfoResultModel info = result.addInfo();
        info.addLine(state.toString());
        info.addLine(ClusterConfigurationStatusRetriever.fromLocator((LocatorLauncher.LocatorState)state, (Properties)properties));
        return result;
    }
}

