/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.cli.commands.lifecycle;

import java.io.BufferedReader;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Arrays;
import javax.management.remote.JMXServiceURL;
import org.apache.commons.lang3.StringUtils;
import org.apache.geode.internal.process.ProcessStreamReader;
import org.apache.geode.internal.util.IOUtils;
import org.apache.geode.management.cli.CliMetaData;
import org.apache.geode.management.internal.cli.commands.OfflineGfshCommand;
import org.apache.geode.management.internal.cli.result.model.InfoResultModel;
import org.apache.geode.management.internal.cli.result.model.ResultModel;
import org.apache.geode.management.internal.cli.util.JdkTool;
import org.springframework.shell.core.annotation.CliCommand;
import org.springframework.shell.core.annotation.CliOption;

public class StartJConsoleCommand
extends OfflineGfshCommand {
    @CliCommand(value={"start jconsole"}, help="Start the JDK's JConsole tool in a separate process. JConsole will be launched, but connecting to Geode must be done manually.")
    @CliMetaData(shellOnly=true, relatedTopic={"Manager", "JMX", "Management-Monitoring"})
    public ResultModel startJConsole(@CliOption(key={"interval"}, unspecifiedDefaultValue="4", help="Update internal (in seconds). This parameter is passed as -interval to JConsole.") int interval, @CliOption(key={"notile"}, specifiedDefaultValue="true", unspecifiedDefaultValue="false", help="Whether to initially tile windows for two or more connections. This parameter is passed as -notile to JConsole.") boolean notile, @CliOption(key={"pluginpath"}, help="Directories or JAR files which are searched for JConsole plugins. The path should contain a provider-configuration file named:\n    META-INF/services/com.sun.tools.jconsole.JConsolePlugin\ncontaining one line for each plugin specifying the fully qualified class name of the class implementing the com.sun.tools.jconsole.JConsolePlugin class.") String pluginpath, @CliOption(key={"version"}, specifiedDefaultValue="true", unspecifiedDefaultValue="false", help="Display the JConsole version information. This parameter is passed as -version to JConsole.") boolean version, @CliOption(key={"J"}, optionContext="splittingRegex=\u001f", help="Arguments passed to the JVM on which JConsole will run.") String[] jvmArgs) throws InterruptedException, IOException {
        StringBuilder message;
        Object[] jconsoleCommandLine = this.createJConsoleCommandLine(interval, notile, pluginpath, version, jvmArgs);
        ResultModel resultModel = new ResultModel();
        InfoResultModel infoResult = resultModel.addInfo();
        if (this.isDebugging()) {
            this.getGfsh().printAsInfo(String.format("JConsole command-line ($1%s)", Arrays.toString(jconsoleCommandLine)));
        }
        Process jconsoleProcess = this.getProcess((String[])jconsoleCommandLine);
        if (version) {
            jconsoleProcess.waitFor();
            message = this.getErrorStringBuilder(jconsoleProcess);
        } else {
            message = new StringBuilder();
            this.getGfsh().printAsInfo("Launched JConsole");
            String jconsoleProcessOutput = this.getProcessOutput(jconsoleProcess);
            if (StringUtils.isNotBlank((CharSequence)jconsoleProcessOutput)) {
                message.append(System.lineSeparator());
                message.append(jconsoleProcessOutput);
            }
        }
        infoResult.addLine(message.toString());
        return resultModel;
    }

    StringBuilder getErrorStringBuilder(Process jconsoleProcess) throws IOException {
        StringBuilder message = new StringBuilder();
        BufferedReader reader = new BufferedReader(new InputStreamReader(jconsoleProcess.getErrorStream()));
        String line = reader.readLine();
        while (line != null) {
            message.append(line);
            message.append(System.lineSeparator());
            line = reader.readLine();
        }
        IOUtils.close((Closeable)reader);
        return message;
    }

    String getProcessOutput(Process jconsoleProcess) {
        return ProcessStreamReader.waitAndCaptureProcessStandardErrorStream((Process)jconsoleProcess);
    }

    Process getProcess(String[] jconsoleCommandLine) throws IOException {
        return Runtime.getRuntime().exec(jconsoleCommandLine);
    }

    protected String[] createJConsoleCommandLine(int interval, boolean notile, String pluginpath, boolean version, String[] jvmArgs) {
        ArrayList<Object> commandLine = new ArrayList<Object>();
        commandLine.add(JdkTool.getJConsolePathname());
        if (version) {
            commandLine.add("-version");
        } else {
            commandLine.add("-interval=" + interval);
            if (notile) {
                commandLine.add("-notile");
            }
            if (StringUtils.isNotBlank((CharSequence)pluginpath)) {
                commandLine.add("-pluginpath " + pluginpath);
            }
            if (jvmArgs != null) {
                for (String arg : jvmArgs) {
                    commandLine.add("-J" + arg);
                }
            }
            JMXServiceURL jmxServiceUrl = this.getJmxServiceUrl();
            if (this.isConnectedAndReady() && jmxServiceUrl != null) {
                commandLine.add(jmxServiceUrl.toString());
            }
        }
        return commandLine.toArray(new String[0]);
    }
}

