/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.cli.commands;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import javax.management.MalformedObjectNameException;
import javax.net.ssl.SSLException;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.geode.distributed.AbstractLauncher;
import org.apache.geode.distributed.LocatorLauncher;
import org.apache.geode.distributed.ServerLauncher;
import org.apache.geode.internal.lang.SystemUtils;
import org.apache.geode.internal.process.ProcessStreamReader;
import org.apache.geode.internal.process.signal.SignalListener;
import org.apache.geode.internal.util.IOUtils;
import org.apache.geode.management.cli.CliMetaData;
import org.apache.geode.management.internal.cli.commands.ConnectCommand;
import org.apache.geode.management.internal.cli.commands.LauncherSignalListener;
import org.apache.geode.management.internal.cli.commands.MemberJvmOptions;
import org.apache.geode.management.internal.cli.commands.OfflineGfshCommand;
import org.apache.geode.management.internal.cli.commands.StartMemberUtils;
import org.apache.geode.management.internal.cli.domain.ConnectToLocatorResult;
import org.apache.geode.management.internal.cli.result.model.InfoResultModel;
import org.apache.geode.management.internal.cli.result.model.ResultModel;
import org.apache.geode.management.internal.cli.shell.Gfsh;
import org.apache.geode.management.internal.cli.shell.JmxOperationInvoker;
import org.apache.geode.management.internal.cli.util.CommandStringBuilder;
import org.apache.geode.management.internal.cli.util.ConnectionEndpoint;
import org.apache.geode.management.internal.configuration.utils.ClusterConfigurationStatusRetriever;
import org.apache.geode.management.internal.i18n.CliStrings;
import org.apache.geode.management.internal.util.HostUtils;
import org.apache.geode.security.AuthenticationFailedException;
import org.springframework.shell.core.annotation.CliCommand;
import org.springframework.shell.core.annotation.CliOption;

public class StartLocatorCommand
extends OfflineGfshCommand {
    @CliCommand(value={"start locator"}, help="Start a Locator.")
    @CliMetaData(shellOnly=true, relatedTopic={"Locator", "Lifecycle"})
    public ResultModel startLocator(@CliOption(key={"name"}, help="The member name to give this Locator in the Geode cluster.") String memberName, @CliOption(key={"bind-address"}, help="IP address on which the Locator will be bound.  By default, the Locator is bound to all local addresses.") String bindAddress, @CliOption(key={"classpath"}, help="Location of user application classes required by the Locator. The user classpath is prepended to the Locator's classpath.") String classpath, @CliOption(key={"force"}, unspecifiedDefaultValue="false", specifiedDefaultValue="true", help="Whether to allow the PID file from a previous Locator run to be overwritten.") Boolean force, @CliOption(key={"group", "groups"}, optionContext="geode.converter.member.groups:disable-string-converter", help="Group(s) the Locator will be a part of.") String group, @CliOption(key={"hostname-for-clients"}, help="Hostname or IP address that will be sent to clients so they can connect to this Locator. The default is the bind-address of the Locator.") String hostnameForClients, @CliOption(key={"jmx-manager-hostname-for-clients"}, help="Hostname provided to clients by the locator for the location of a JMX Manager.") String jmxManagerHostnameForClients, @CliOption(key={"include-system-classpath"}, specifiedDefaultValue="true", unspecifiedDefaultValue="false", help="Includes the System CLASSPATH on the Locator's CLASSPATH. The System CLASSPATH is not included by default.") Boolean includeSystemClasspath, @CliOption(key={"locators"}, optionContext="geode.converter.locators.discovery.config:disable-string-converter", help="Sets the list of Locators used by this Locator to join the appropriate Geode cluster.") String locators, @CliOption(key={"log-level"}, optionContext="geode.converter.log.levels:disable-string-converter", help="Sets the level of output logged to the Locator log file.  Possible values for log-level include: ALL, TRACE, DEBUG, INFO, WARN, ERROR, FATAL, OFF.") String logLevel, @CliOption(key={"mcast-address"}, help="The IP address or hostname used to bind the UPD socket for multi-cast networking so the Locator can communicate with other members in the Geode cluster using a common multicast address and port.  If mcast-port is zero, then mcast-address is ignored.") String mcastBindAddress, @CliOption(key={"mcast-port"}, help="Sets the port used for multi-cast networking so the Locator can communicate with other members of the Geode cluster.  A zero value disables mcast.") Integer mcastPort, @CliOption(key={"port"}, help="Port the Locator will listen on.") Integer port, @CliOption(key={"dir"}, help="Directory in which the Locator will be started and ran. The default is ./<locator-member-name>") String workingDirectory, @CliOption(key={"properties-file"}, optionContext="geode.converter.file", help="The gemfire.properties file for configuring the Locator's distributed system. The file's path can be absolute or relative to the gfsh working directory (--dir=).") File gemfirePropertiesFile, @CliOption(key={"security-properties-file"}, optionContext="geode.converter.file", help="The gfsecurity.properties file for configuring the Locator's security configuration in the distributed system. The file's path can be absolute or relative to gfsh directory (--dir=).") File gemfireSecurityPropertiesFile, @CliOption(key={"initial-heap"}, help="Initial size of the heap in the same format as the JVM -Xms parameter.") String initialHeap, @CliOption(key={"max-heap"}, help="Maximum size of the heap in the same format as the JVM -Xmx parameter.") String maxHeap, @CliOption(key={"J"}, optionContext="splittingRegex=\u001f", help="Argument passed to the JVM on which the Locator will run. For example, --J=-Dfoo.bar=true will set the property \"foo.bar\" to \"true\".") String[] jvmArgsOpts, @CliOption(key={"connect"}, unspecifiedDefaultValue="true", specifiedDefaultValue="true", help="When connect is set to false or when locator is started with a security manager using --J=-Dgemfire.security-manager option, Gfsh does not automatically connect to the locator which is started using this command.") boolean connect, @CliOption(key={"enable-cluster-configuration"}, unspecifiedDefaultValue="true", specifiedDefaultValue="true", help="When enable-cluster-configuration is set to true, locator hosts and serves cluster configuration.") boolean enableSharedConfiguration, @CliOption(key={"load-cluster-configuration-from-dir"}, unspecifiedDefaultValue="false", help="Deprecated: Since Geode 1.6, use import cluster-configuration command instead. When \" load-cluster-configuration-from-dir \" is set to true, the locator loads the cluster configuration from the \"cluster_config\" directory.") boolean loadSharedConfigurationFromDirectory, @CliOption(key={"cluster-config-dir"}, unspecifiedDefaultValue="", help="Deprecated: Since Geode 1.14, use import/export cluster-configuration command instead. This option has no effect since 1.12.") String clusterConfigDir, @CliOption(key={"http-service-port"}, help="Port on which HTTP Service will listen on") Integer httpServicePort, @CliOption(key={"http-service-bind-address"}, help="The IP address on which the HTTP Service will be bound.  By default, the Server is bound to all local addresses.") String httpServiceBindAddress, @CliOption(key={"redirect-output"}, unspecifiedDefaultValue="false", specifiedDefaultValue="true", help="Causes the member to redirect standard out and standard error to its own log file") Boolean redirectOutput) throws Exception {
        if (StringUtils.isBlank((CharSequence)memberName)) {
            memberName = StartMemberUtils.getNameGenerator().generate('-');
        }
        String resolvedWorkingDirectory = StartMemberUtils.resolveWorkingDirectory(workingDirectory, memberName);
        return this.doStartLocator(memberName, bindAddress, classpath, force, group, hostnameForClients, jmxManagerHostnameForClients, includeSystemClasspath, locators, logLevel, mcastBindAddress, mcastPort, port, resolvedWorkingDirectory, gemfirePropertiesFile, gemfireSecurityPropertiesFile, initialHeap, maxHeap, jvmArgsOpts, connect, enableSharedConfiguration, loadSharedConfigurationFromDirectory, clusterConfigDir, httpServicePort, httpServiceBindAddress, redirectOutput);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ResultModel doStartLocator(String memberName, String bindAddress, String classpath, Boolean force, String group, String hostnameForClients, String jmxManagerHostnameForClients, Boolean includeSystemClasspath, String locators, String logLevel, String mcastBindAddress, Integer mcastPort, Integer port, String workingDirectory, File gemfirePropertiesFile, File gemfireSecurityPropertiesFile, String initialHeap, String maxHeap, String[] jvmArgsOpts, boolean connect, boolean enableSharedConfiguration, boolean loadSharedConfigurationFromDirectory, String clusterConfigDir, Integer httpServicePort, String httpServiceBindAddress, Boolean redirectOutput) throws MalformedObjectNameException, IOException, InterruptedException, ClassNotFoundException {
        LocatorLauncher.LocatorState locatorState;
        if (gemfirePropertiesFile != null && !gemfirePropertiesFile.exists()) {
            return ResultModel.createError(CliStrings.format((String)"Warning: The Geode {0}properties file {1} could not be found.", (Object[])new Object[]{"", gemfirePropertiesFile.getAbsolutePath()}));
        }
        if (gemfireSecurityPropertiesFile != null && !gemfireSecurityPropertiesFile.exists()) {
            return ResultModel.createError(CliStrings.format((String)"Warning: The Geode {0}properties file {1} could not be found.", (Object[])new Object[]{"Security ", gemfireSecurityPropertiesFile.getAbsolutePath()}));
        }
        Properties gemfireProperties = new Properties();
        StartMemberUtils.setPropertyIfNotNull(gemfireProperties, "groups", group);
        StartMemberUtils.setPropertyIfNotNull(gemfireProperties, "locators", locators);
        StartMemberUtils.setPropertyIfNotNull(gemfireProperties, "log-level", logLevel);
        StartMemberUtils.setPropertyIfNotNull(gemfireProperties, "mcast-address", mcastBindAddress);
        StartMemberUtils.setPropertyIfNotNull(gemfireProperties, "mcast-port", mcastPort);
        StartMemberUtils.setPropertyIfNotNull(gemfireProperties, "enable-cluster-configuration", enableSharedConfiguration);
        StartMemberUtils.setPropertyIfNotNull(gemfireProperties, "load-cluster-configuration-from-dir", loadSharedConfigurationFromDirectory);
        StartMemberUtils.setPropertyIfNotNull(gemfireProperties, "http-service-port", httpServicePort);
        StartMemberUtils.setPropertyIfNotNull(gemfireProperties, "http-service-bind-address", httpServiceBindAddress);
        StartMemberUtils.setPropertyIfNotNull(gemfireProperties, "jmx-manager-hostname-for-clients", jmxManagerHostnameForClients);
        LocatorLauncher.Builder locatorLauncherBuilder = new LocatorLauncher.Builder().setBindAddress(bindAddress).setForce(force).setPort(port).setRedirectOutput(redirectOutput).setWorkingDirectory(workingDirectory);
        if (hostnameForClients != null) {
            locatorLauncherBuilder.setHostnameForClients(hostnameForClients);
        }
        if (memberName != null) {
            locatorLauncherBuilder.setMemberName(memberName);
        }
        LocatorLauncher locatorLauncher = locatorLauncherBuilder.build();
        String[] locatorCommandLine = this.createStartLocatorCommandLine(locatorLauncher, gemfirePropertiesFile, gemfireSecurityPropertiesFile, gemfireProperties, classpath, includeSystemClasspath, jvmArgsOpts, initialHeap, maxHeap);
        Process locatorProcess = this.getProcess(locatorLauncher.getWorkingDirectory(), locatorCommandLine);
        locatorProcess.getInputStream().close();
        locatorProcess.getOutputStream().close();
        ProcessStreamReader.ReadingMode readingMode = SystemUtils.isWindows() ? ProcessStreamReader.ReadingMode.NON_BLOCKING : ProcessStreamReader.ReadingMode.BLOCKING;
        StringBuilder message = new StringBuilder();
        ProcessStreamReader.InputListener inputListener = line -> {
            message.append(line);
            if (readingMode == ProcessStreamReader.ReadingMode.BLOCKING) {
                message.append(System.lineSeparator());
            }
        };
        ProcessStreamReader stderrReader = new ProcessStreamReader.Builder(locatorProcess).inputStream(locatorProcess.getErrorStream()).inputListener(inputListener).readingMode(readingMode).continueReadingMillis(2000L).build().start();
        String previousLocatorStatusMessage = null;
        LauncherSignalListener locatorSignalListener = new LauncherSignalListener();
        boolean registeredLocatorSignalListener = this.getGfsh().getSignalHandler().registerListener((SignalListener)locatorSignalListener);
        try {
            this.getGfsh().logInfo(String.format("Starting a Geode Locator in %1$s...", IOUtils.tryGetCanonicalPathElseGetAbsolutePath((File)new File(locatorLauncher.getWorkingDirectory()))), null);
            do {
                if (locatorProcess.isAlive()) {
                    Gfsh.print(".");
                    StartLocatorCommand startLocatorCommand = this;
                    synchronized (startLocatorCommand) {
                        TimeUnit.MILLISECONDS.timedWait(this, 500L);
                    }
                    locatorState = LocatorLauncher.LocatorState.fromDirectory((String)workingDirectory, (String)memberName);
                    String currentLocatorStatusMessage = locatorState.getStatusMessage();
                    if (!locatorState.isStartingOrNotResponding() || StringUtils.isBlank((CharSequence)currentLocatorStatusMessage) || currentLocatorStatusMessage.equalsIgnoreCase(previousLocatorStatusMessage) || currentLocatorStatusMessage.trim().equalsIgnoreCase("null")) continue;
                    Gfsh.println();
                    Gfsh.println(currentLocatorStatusMessage);
                    previousLocatorStatusMessage = currentLocatorStatusMessage;
                    continue;
                }
                int exitValue = locatorProcess.exitValue();
                ResultModel resultModel = ResultModel.createError(String.format("The Locator process terminated unexpectedly with exit status %1$d. Please refer to the log file in %2$s for full details.%n%n%3$s", exitValue, locatorLauncher.getWorkingDirectory(), message));
                return resultModel;
            } while ((!registeredLocatorSignalListener || !locatorSignalListener.isSignaled()) && locatorState.isStartingOrNotResponding());
        }
        finally {
            stderrReader.stopAsync(5000L);
            this.getGfsh().getSignalHandler().unregisterListener((SignalListener)locatorSignalListener);
        }
        Gfsh.println();
        boolean asyncStart = registeredLocatorSignalListener && locatorSignalListener.isSignaled() && ServerLauncher.ServerState.isStartingNotRespondingOrNull((AbstractLauncher.ServiceState)locatorState);
        ResultModel result = new ResultModel();
        InfoResultModel infoResult = result.addInfo();
        if (loadSharedConfigurationFromDirectory) {
            infoResult.addLine("Warning: Option --load-cluster-config-from-dir is deprecated, use 'import cluster-configuration' command instead to import any existing configuration.\n");
        }
        if (asyncStart) {
            infoResult.addLine(String.format("Broken out of wait... the %1$s process will continue to startup in the background.%n", "Locator"));
            return result;
        }
        infoResult.addLine(locatorState.toString());
        String bindAddr = locatorLauncher.getBindAddressString();
        String locatorHostName = bindAddr != null ? bindAddr : (String)StringUtils.defaultIfBlank((CharSequence)locatorLauncher.getHostnameForClients(), (CharSequence)HostUtils.getLocalHost());
        int locatorPort = Integer.parseInt(locatorState.getPort());
        ConnectCommand connectCommand = new ConnectCommand();
        Properties configProperties = connectCommand.resolveSslProperties(this.getGfsh(), false, gemfirePropertiesFile, gemfireSecurityPropertiesFile, new String[0]);
        if (this.shouldAutoConnect(connect)) {
            boolean connected = this.doAutoConnect(locatorHostName, locatorPort, configProperties, infoResult);
            if (enableSharedConfiguration && connected) {
                infoResult.addLine(ClusterConfigurationStatusRetriever.fromLocator((String)locatorHostName, (int)locatorPort, (Properties)configProperties));
            }
        }
        return result;
    }

    Process getProcess(String workingDir, String[] locatorCommandLine) throws IOException {
        return new ProcessBuilder(locatorCommandLine).directory(new File(workingDir)).start();
    }

    private boolean shouldAutoConnect(boolean connect) {
        return connect && !this.isConnectedAndReady();
    }

    private boolean doAutoConnect(String locatorHostname, int locatorPort, Properties configurationProperties, InfoResultModel infoResult) {
        boolean connectSuccess = false;
        boolean jmxManagerAuthEnabled = false;
        boolean jmxManagerSslEnabled = false;
        Object responseFailureMessage = null;
        for (int attempts = 0; attempts < 10 && !connectSuccess; ++attempts) {
            try {
                ConnectToLocatorResult connectToLocatorResult = ConnectCommand.connectToLocator(locatorHostname, locatorPort, 15000, configurationProperties);
                ConnectionEndpoint memberEndpoint = connectToLocatorResult.getMemberEndpoint();
                jmxManagerSslEnabled = connectToLocatorResult.isJmxManagerSslEnabled();
                this.getGfsh().setOperationInvoker(new JmxOperationInvoker(memberEndpoint.getHost(), memberEndpoint.getPort(), configurationProperties));
                String shellAndLogMessage = CliStrings.format((String)"Successfully connected to: {0}", (Object)("JMX Manager " + memberEndpoint.toString(false)));
                infoResult.addLine("\n");
                infoResult.addLine(shellAndLogMessage);
                this.getGfsh().logToFile(shellAndLogMessage, null);
                connectSuccess = true;
                responseFailureMessage = null;
                continue;
            }
            catch (SecurityException | AuthenticationFailedException e) {
                this.getGfsh().logToFile(e.getMessage(), e);
                jmxManagerAuthEnabled = true;
                break;
            }
            catch (SSLException e) {
                this.getGfsh().logToFile(e.getMessage(), e);
                responseFailureMessage = "Check your SSL configuration and try again.";
                continue;
            }
            catch (Exception e) {
                this.getGfsh().logToFile(e.getMessage(), e);
                responseFailureMessage = "Failed to connect; unknown cause: " + e.getMessage();
            }
        }
        if (!connectSuccess) {
            this.doOnConnectionFailure(locatorHostname, locatorPort, jmxManagerAuthEnabled, jmxManagerSslEnabled, infoResult);
        }
        if (StringUtils.isNotBlank(responseFailureMessage)) {
            infoResult.addLine("\n");
            infoResult.addLine((String)responseFailureMessage);
        }
        return connectSuccess;
    }

    private void doOnConnectionFailure(String locatorHostName, int locatorPort, boolean jmxManagerAuthEnabled, boolean jmxManagerSslEnabled, InfoResultModel infoResult) {
        infoResult.addLine("\n");
        CommandStringBuilder commandUsage = new CommandStringBuilder("connect").addOption("locator", locatorHostName + "[" + locatorPort + "]");
        StringBuilder message = new StringBuilder();
        if (jmxManagerAuthEnabled) {
            commandUsage.addOption("user").addOption("password");
            message.append("Authentication");
        }
        if (jmxManagerSslEnabled) {
            message.append(jmxManagerAuthEnabled ? " and " : "").append("SSL configuration");
        }
        infoResult.addLine(CliStrings.format((String)"Unable to auto-connect (Security Manager may be enabled). Please use \"{0}\" to connect Gfsh to the locator.", (Object)commandUsage.toString()));
        if (jmxManagerAuthEnabled || jmxManagerSslEnabled) {
            message.append(" required to connect to the Manager.");
            infoResult.addLine("\n");
            infoResult.addLine(message.toString());
        }
    }

    String[] createStartLocatorCommandLine(LocatorLauncher launcher, File gemfirePropertiesFile, File gemfireSecurityPropertiesFile, Properties gemfireProperties, String userClasspath, Boolean includeSystemClasspath, String[] jvmArgsOpts, String initialHeap, String maxHeap) throws MalformedObjectNameException {
        ArrayList<String> commandLine = new ArrayList<String>();
        commandLine.add(StartMemberUtils.getJavaPath());
        commandLine.add("-server");
        commandLine.add("-classpath");
        commandLine.add(this.getLocatorClasspath(Boolean.TRUE.equals(includeSystemClasspath), userClasspath));
        commandLine.addAll(MemberJvmOptions.getMemberJvmOptions());
        StartMemberUtils.addCurrentLocators(this, commandLine, gemfireProperties);
        StartMemberUtils.addGemFirePropertyFile(commandLine, gemfirePropertiesFile);
        StartMemberUtils.addGemFireSecurityPropertyFile(commandLine, gemfireSecurityPropertiesFile);
        StartMemberUtils.addGemFireSystemProperties(commandLine, gemfireProperties);
        StartMemberUtils.addJvmArgumentsAndOptions(commandLine, jvmArgsOpts);
        StartMemberUtils.addInitialHeap(commandLine, initialHeap);
        StartMemberUtils.addMaxHeap(commandLine, maxHeap);
        commandLine.add("-D".concat("gemfire.launcher.registerSignalHandlers".concat("=true")));
        commandLine.add("-Djava.awt.headless=true");
        commandLine.add("-Dsun.rmi.dgc.server.gcInterval".concat("=").concat(Long.toString(0x7FFFFFFFFFFFFFFEL)));
        if (launcher.isRedirectingOutput()) {
            commandLine.add("-D".concat("gemfire.OSProcess.DISABLE_REDIRECTION_CONFIGURATION").concat("=true"));
        }
        commandLine.add(LocatorLauncher.class.getName());
        commandLine.add(LocatorLauncher.Command.START.getName());
        if (StringUtils.isNotBlank((CharSequence)launcher.getMemberName())) {
            commandLine.add(launcher.getMemberName());
        }
        if (launcher.getBindAddressString() != null) {
            commandLine.add("--bind-address=" + launcher.getBindAddressString());
        }
        if (launcher.isDebugging() || this.isDebugging()) {
            commandLine.add("--debug");
        }
        if (launcher.isForcing()) {
            commandLine.add("--force");
        }
        if (StringUtils.isNotBlank((CharSequence)launcher.getHostnameForClients())) {
            commandLine.add("--hostname-for-clients=" + launcher.getHostnameForClients());
        }
        if (launcher.getPort() != null) {
            commandLine.add("--port=" + launcher.getPort());
        }
        if (launcher.isRedirectingOutput()) {
            commandLine.add("--redirect-output");
        }
        return commandLine.toArray(new String[0]);
    }

    String getLocatorClasspath(boolean includeSystemClasspath, String userClasspath) {
        ArrayList<String> jarFilePathnames = new ArrayList<String>();
        jarFilePathnames.add(StartMemberUtils.CORE_DEPENDENCIES_JAR_PATHNAME);
        for (String extensionsJarPathname : this.getExtensionsJars()) {
            if (!StringUtils.isNotBlank((CharSequence)extensionsJarPathname)) continue;
            jarFilePathnames.add(extensionsJarPathname);
        }
        return StartMemberUtils.toClasspath(includeSystemClasspath, jarFilePathnames.toArray(new String[0]), userClasspath);
    }

    private String[] getExtensionsJars() {
        File extensionsDirectory = new File(StartMemberUtils.EXTENSIONS_PATHNAME);
        File[] extensionsJars = extensionsDirectory.listFiles();
        if (extensionsJars != null) {
            return (String[])Arrays.stream(extensionsJars).filter(File::isFile).map(file -> IOUtils.appendToPath((String)StartMemberUtils.GEODE_HOME, (String[])new String[]{"extensions", file.getName()})).toArray(String[]::new);
        }
        return ArrayUtils.EMPTY_STRING_ARRAY;
    }
}

