/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.cli.commands;

import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.geode.cache.execute.Execution;
import org.apache.geode.cache.execute.Function;
import org.apache.geode.cache.execute.FunctionException;
import org.apache.geode.cache.execute.FunctionService;
import org.apache.geode.distributed.DistributedMember;
import org.apache.geode.internal.cache.InternalCache;
import org.apache.geode.logging.internal.executors.LoggingExecutors;
import org.apache.geode.logging.internal.log4j.api.LogService;
import org.apache.geode.management.cli.CliMetaData;
import org.apache.geode.management.cli.GfshCommand;
import org.apache.geode.management.internal.cli.AbstractCliAroundInterceptor;
import org.apache.geode.management.internal.cli.GfshParseResult;
import org.apache.geode.management.internal.cli.functions.ShutDownFunction;
import org.apache.geode.management.internal.cli.result.model.ResultModel;
import org.apache.geode.management.internal.security.ResourceOperation;
import org.apache.geode.security.ResourcePermission;
import org.apache.logging.log4j.Logger;
import org.springframework.shell.core.annotation.CliCommand;
import org.springframework.shell.core.annotation.CliOption;

public class ShutdownCommand
extends GfshCommand {
    private static final String DEFAULT_TIME_OUT = "10";
    private static final Logger logger = LogService.getLogger();

    @CliCommand(value={"shutdown"}, help="Stop all members.")
    @CliMetaData(relatedTopic={"Lifecycle"}, interceptor="org.apache.geode.management.internal.cli.commands.ShutdownCommand$ShutdownCommandInterceptor")
    @ResourceOperation(resource=ResourcePermission.Resource.CLUSTER, operation=ResourcePermission.Operation.MANAGE)
    public ResultModel shutdown(@CliOption(key={"time-out"}, unspecifiedDefaultValue="10", help="Time to wait (in seconds) for a graceful shutdown. Should be at least 10 sec") int userSpecifiedTimeout, @CliOption(key={"include-locators"}, unspecifiedDefaultValue="false", specifiedDefaultValue="true", help="To shutdown locators specify this option as true. Default is false") boolean shutdownLocators) throws InterruptedException, ExecutionException, TimeoutException {
        if (userSpecifiedTimeout < Integer.parseInt(DEFAULT_TIME_OUT)) {
            return ResultModel.createInfo("time-out should not be less than 10 sec.");
        }
        long timeout = (long)userSpecifiedTimeout * 1000L;
        InternalCache cache = (InternalCache)this.getCache();
        int numDataNodes = this.getAllNormalMembers().size();
        Set<DistributedMember> locators = this.getAllMembers();
        Set<DistributedMember> dataNodes = this.getAllNormalMembers();
        locators.removeAll(dataNodes);
        if (!shutdownLocators && numDataNodes == 0) {
            return ResultModel.createInfo("No data node found for stopping. Please specify --include-locators option if you want locators to be stopped");
        }
        String managerName = cache.getJmxManagerAdvisor().getDistributionManager().getId().getId();
        DistributedMember manager = this.getMember(managerName);
        dataNodes.remove(manager);
        long timeElapsed = this.shutDownNodeWithTimeOut(timeout, dataNodes);
        timeout -= timeElapsed;
        if (shutdownLocators) {
            if (manager == null) {
                return ResultModel.createError("Could not locate Manager.");
            }
            locators.remove(manager);
            for (DistributedMember locator : locators) {
                HashSet<DistributedMember> lsSet = new HashSet<DistributedMember>();
                lsSet.add(locator);
                long elapsedTime = this.shutDownNodeWithTimeOut(timeout, lsSet);
                timeout -= elapsedTime;
            }
        }
        if (locators.contains(manager) && !shutdownLocators) {
            return ResultModel.createInfo("Shutdown is triggered");
        }
        HashSet<DistributedMember> mgrSet = new HashSet<DistributedMember>();
        mgrSet.add(manager);
        this.shutDownNodeWithTimeOut(timeout, mgrSet);
        return ResultModel.createInfo("Shutdown is triggered");
    }

    private long shutDownNodeWithTimeOut(long timeout, Set<DistributedMember> nodesToBeStopped) throws TimeoutException, InterruptedException, ExecutionException {
        long shutDownTimeStart = System.currentTimeMillis();
        this.shutdownNode(timeout, nodesToBeStopped);
        long shutDownTimeEnd = System.currentTimeMillis();
        long timeElapsed = shutDownTimeEnd - shutDownTimeStart;
        if (timeElapsed > timeout || Boolean.getBoolean("ThrowTimeoutException")) {
            throw new TimeoutException();
        }
        return timeElapsed;
    }

    private void shutdownNode(long timeout, Set<DistributedMember> includeMembers) throws TimeoutException, InterruptedException, ExecutionException {
        ExecutorService exec = LoggingExecutors.newSingleThreadExecutor((String)"ShutdownCommand", (boolean)false);
        try {
            ShutDownFunction shutDownFunction = new ShutDownFunction();
            logger.info("Gfsh executing shutdown on members " + String.valueOf(includeMembers));
            Callable<String> shutdownNodes = () -> ShutdownCommand.lambda$shutdownNode$0(includeMembers, (Function)shutDownFunction);
            Future<String> result = exec.submit(shutdownNodes);
            result.get(timeout, TimeUnit.MILLISECONDS);
        }
        catch (TimeoutException te) {
            logger.error("TimeoutException in shutting down members." + String.valueOf(includeMembers));
            throw te;
        }
        catch (InterruptedException e) {
            logger.error("InterruptedException in shutting down members." + String.valueOf(includeMembers));
            throw e;
        }
        catch (ExecutionException e) {
            logger.error("ExecutionException in shutting down members." + String.valueOf(includeMembers));
            throw e;
        }
        finally {
            exec.shutdownNow();
        }
    }

    private static /* synthetic */ String lambda$shutdownNode$0(Set includeMembers, Function shutDownFunction) throws Exception {
        try {
            Execution execution = FunctionService.onMembers((Set)includeMembers);
            execution.execute(shutDownFunction);
        }
        catch (FunctionException functionException) {
            // empty catch block
        }
        return "SUCCESS";
    }

    public static class ShutdownCommandInterceptor
    extends AbstractCliAroundInterceptor {
        @Override
        public ResultModel preExecution(GfshParseResult parseResult) {
            if (Boolean.getBoolean("ignoreInterceptors")) {
                return ResultModel.createInfo("Shutting down entire distributed system");
            }
            AbstractCliAroundInterceptor.Response response = this.readYesNo("As a lot of data in memory will be lost, including possibly events in queues, do you really want to shutdown the entire distributed system?", AbstractCliAroundInterceptor.Response.YES);
            if (response == AbstractCliAroundInterceptor.Response.NO) {
                return ResultModel.createError("Aborting shutdown of the entire distributed system");
            }
            return ResultModel.createInfo("Shutting down entire distributed system");
        }
    }
}

