/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.cli.commands;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.geode.cache.execute.Execution;
import org.apache.geode.cache.execute.Function;
import org.apache.geode.cache.execute.ResultCollector;
import org.apache.geode.internal.cache.execute.AbstractExecution;
import org.apache.geode.management.cli.CliMetaData;
import org.apache.geode.management.cli.GfshCommand;
import org.apache.geode.management.internal.cli.domain.IndexDetails;
import org.apache.geode.management.internal.cli.functions.ListIndexFunction;
import org.apache.geode.management.internal.cli.result.model.ResultModel;
import org.apache.geode.management.internal.cli.result.model.TabularResultModel;
import org.apache.geode.management.internal.security.ResourceOperation;
import org.apache.geode.security.ResourcePermission;
import org.springframework.shell.core.annotation.CliCommand;
import org.springframework.shell.core.annotation.CliOption;

public class ListIndexCommand
extends GfshCommand {
    @CliCommand(value={"list indexes"}, help="Display the list of indexes created for all members.")
    @CliMetaData(relatedTopic={"Region", "Data"})
    @ResourceOperation(resource=ResourcePermission.Resource.CLUSTER, operation=ResourcePermission.Operation.READ, target=ResourcePermission.Target.QUERY)
    public ResultModel listIndex(@CliOption(key={"with-stats"}, specifiedDefaultValue="true", unspecifiedDefaultValue="false", help="Whether statistics should also be displayed.") boolean showStats) {
        ResultModel result = new ResultModel();
        TabularResultModel indexTable = result.addTable("indices");
        List<IndexDetails> indexDetailsList = this.getIndexListing();
        if (indexDetailsList.isEmpty()) {
            return ResultModel.createInfo("No Indexes Found");
        }
        for (IndexDetails indexDetails : indexDetailsList) {
            indexTable.accumulate("Member Name", StringUtils.defaultString((String)indexDetails.getMemberName()));
            indexTable.accumulate("Member ID", indexDetails.getMemberId());
            indexTable.accumulate("Region Path", indexDetails.getRegionPath());
            indexTable.accumulate("Name", indexDetails.getIndexName());
            if (indexDetails.getIndexType() == null) {
                indexTable.accumulate("Type", "");
            } else {
                indexTable.accumulate("Type", indexDetails.getIndexType().getName());
            }
            indexTable.accumulate("Indexed Expression", indexDetails.getIndexedExpression());
            indexTable.accumulate("From Clause", indexDetails.getFromClause());
            indexTable.accumulate("Valid Index", "" + indexDetails.getIsValid());
            if (!showStats) continue;
            IndexStatisticsDetailsAdapter adapter = new IndexStatisticsDetailsAdapter(indexDetails.getIndexStatisticsDetails());
            indexTable.accumulate("Uses", adapter.getTotalUses());
            indexTable.accumulate("Updates", adapter.getNumberOfUpdates());
            indexTable.accumulate("Update Time", adapter.getTotalUpdateTime());
            indexTable.accumulate("Keys", adapter.getNumberOfKeys());
            indexTable.accumulate("Values", adapter.getNumberOfValues());
        }
        return result;
    }

    List<IndexDetails> getIndexListing() {
        Execution functionExecutor = this.getMembersFunctionExecutor(this.getAllMembers());
        if (functionExecutor instanceof AbstractExecution) {
            ((AbstractExecution)functionExecutor).setIgnoreDepartedMembers(true);
        }
        ResultCollector resultsCollector = functionExecutor.execute((Function)new ListIndexFunction());
        List results = (List)resultsCollector.getResult();
        ArrayList<IndexDetails> indexDetailsList = new ArrayList<IndexDetails>(results.size());
        for (Object result : results) {
            if (!(result instanceof Set)) continue;
            Set set = (Set)result;
            indexDetailsList.addAll(set);
        }
        Collections.sort(indexDetailsList);
        return indexDetailsList;
    }

    protected static class IndexStatisticsDetailsAdapter {
        private final IndexDetails.IndexStatisticsDetails indexStatisticsDetails;

        protected IndexStatisticsDetailsAdapter(IndexDetails.IndexStatisticsDetails indexStatisticsDetails) {
            this.indexStatisticsDetails = indexStatisticsDetails;
        }

        public IndexDetails.IndexStatisticsDetails getIndexStatisticsDetails() {
            return this.indexStatisticsDetails;
        }

        public String getNumberOfKeys() {
            return this.getIndexStatisticsDetails() != null ? Objects.toString(this.getIndexStatisticsDetails().getNumberOfKeys(), "") : "";
        }

        public String getNumberOfUpdates() {
            return this.getIndexStatisticsDetails() != null ? Objects.toString(this.getIndexStatisticsDetails().getNumberOfUpdates(), "") : "";
        }

        public String getNumberOfValues() {
            return this.getIndexStatisticsDetails() != null ? Objects.toString(this.getIndexStatisticsDetails().getNumberOfValues(), "") : "";
        }

        public String getTotalUpdateTime() {
            return this.getIndexStatisticsDetails() != null ? Objects.toString(this.getIndexStatisticsDetails().getTotalUpdateTime(), "") : "";
        }

        public String getTotalUses() {
            return this.getIndexStatisticsDetails() != null ? Objects.toString(this.getIndexStatisticsDetails().getTotalUses(), "") : "";
        }
    }
}

