/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.cli.commands;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.PrintStream;
import org.apache.geode.SystemFailure;
import org.apache.geode.internal.cache.DiskStoreImpl;
import org.apache.geode.management.cli.CliMetaData;
import org.apache.geode.management.cli.GfshCommand;
import org.apache.geode.management.internal.cli.commands.DiskStoreCommandsUtils;
import org.apache.geode.management.internal.cli.result.model.ResultModel;
import org.springframework.shell.core.annotation.CliCommand;
import org.springframework.shell.core.annotation.CliOption;

public class DescribeOfflineDiskStoreCommand
extends GfshCommand {
    @CliCommand(value={"describe offline-disk-store"}, help="Display information about an offline disk store.")
    @CliMetaData(shellOnly=true, relatedTopic={"Disk Store"})
    public ResultModel describeOfflineDiskStore(@CliOption(key={"name"}, mandatory=true, help="Name of the disk store to be described.") String diskStoreName, @CliOption(key={"disk-dirs"}, mandatory=true, help="Directories which contain the disk store files.") String[] diskDirs, @CliOption(key={"pdx"}, help="Display all the pdx types stored in the disk store") Boolean listPdxTypes, @CliOption(key={"region"}, help="Name/Path of the region in the disk store to be described.") String regionName) {
        String validatedDirectories = DiskStoreCommandsUtils.validatedDirectories(diskDirs);
        if (validatedDirectories != null) {
            throw new IllegalArgumentException("Could not find disk-dirs: \"" + validatedDirectories + "\"");
        }
        try {
            File[] dirs = new File[diskDirs.length];
            for (int i = 0; i < diskDirs.length; ++i) {
                dirs[i] = new File(diskDirs[i]);
            }
            if ("/".equals(regionName)) {
                return ResultModel.createError("Invalid region name");
            }
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            PrintStream printStream = new PrintStream(outputStream);
            DiskStoreImpl.dumpInfo((PrintStream)printStream, (String)diskStoreName, (File[])dirs, (String)regionName, (Boolean)listPdxTypes);
            return ResultModel.createInfo(outputStream.toString());
        }
        catch (VirtualMachineError e) {
            SystemFailure.initiateFailure((Error)e);
            throw e;
        }
        catch (Throwable th) {
            SystemFailure.checkFailure();
            if (th.getMessage() == null) {
                return ResultModel.createError("An error occurred while describing offline disk stores: " + String.valueOf(th));
            }
            return ResultModel.createError("An error occurred while describing offline disk stores: " + th.getMessage());
        }
    }
}

