/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.cli.commands;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import joptsimple.internal.Strings;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.geode.cache.Cache;
import org.apache.geode.cache.EvictionAction;
import org.apache.geode.cache.ExpirationAction;
import org.apache.geode.cache.RegionShortcut;
import org.apache.geode.cache.configuration.CacheConfig;
import org.apache.geode.cache.configuration.ClassNameType;
import org.apache.geode.cache.configuration.DeclarableType;
import org.apache.geode.cache.configuration.EnumActionDestroyOverflow;
import org.apache.geode.cache.configuration.RegionAttributesScope;
import org.apache.geode.cache.configuration.RegionAttributesType;
import org.apache.geode.cache.configuration.RegionConfig;
import org.apache.geode.cache.execute.Function;
import org.apache.geode.distributed.DistributedMember;
import org.apache.geode.distributed.internal.InternalConfigurationPersistenceService;
import org.apache.geode.internal.cache.InternalCache;
import org.apache.geode.internal.config.JAXBService;
import org.apache.geode.logging.internal.log4j.api.LogService;
import org.apache.geode.management.DistributedRegionMXBean;
import org.apache.geode.management.DistributedSystemMXBean;
import org.apache.geode.management.ManagementService;
import org.apache.geode.management.cli.CliMetaData;
import org.apache.geode.management.cli.SingleGfshCommand;
import org.apache.geode.management.configuration.ClassName;
import org.apache.geode.management.internal.cli.AbstractCliAroundInterceptor;
import org.apache.geode.management.internal.cli.GfshParseResult;
import org.apache.geode.management.internal.cli.commands.DiskStoreCommandsUtils;
import org.apache.geode.management.internal.cli.commands.RegionCommandsUtils;
import org.apache.geode.management.internal.cli.functions.CreateRegionFunctionArgs;
import org.apache.geode.management.internal.cli.functions.FetchRegionAttributesFunction;
import org.apache.geode.management.internal.cli.functions.RegionCreateFunction;
import org.apache.geode.management.internal.cli.result.model.ResultModel;
import org.apache.geode.management.internal.configuration.converters.RegionConverter;
import org.apache.geode.management.internal.exceptions.EntityExistsException;
import org.apache.geode.management.internal.functions.CliFunctionResult;
import org.apache.geode.management.internal.i18n.CliStrings;
import org.apache.geode.management.internal.security.ResourceOperation;
import org.apache.geode.management.internal.util.RegionPath;
import org.apache.geode.security.ResourcePermission;
import org.springframework.shell.core.annotation.CliCommand;
import org.springframework.shell.core.annotation.CliOption;

public class CreateRegionCommand
extends SingleGfshCommand {
    private static final String[] PARTITION_ATTRIBUTES = new String[]{"colocated-with", "local-max-memory", "recovery-delay", "redundant-copies", "startup-recovery-delay", "total-max-memory", "total-num-buckets", "partition-listener", "partition-resolver"};

    @CliCommand(value={"create region"}, help="Create a region with the given path and configuration. Specifying a --key-constraint and --value-constraint makes object type information available during querying and indexing.")
    @CliMetaData(relatedTopic={"Region"}, interceptor="org.apache.geode.management.internal.cli.commands.CreateRegionCommand$Interceptor")
    @ResourceOperation(resource=ResourcePermission.Resource.DATA, operation=ResourcePermission.Operation.MANAGE)
    public ResultModel createRegion(@CliOption(key={"name"}, mandatory=true, optionContext="geode.converter.region.path:disable-string-converter", help="Name/Path of the region to be created.") String regionPath, @CliOption(key={"type"}, help="Type of region to create. The following types are pre-defined by the product (see RegionShortcut javadocs for more information): PARTITION, PARTITION_REDUNDANT, PARTITION_PERSISTENT, PARTITION_REDUNDANT_PERSISTENT, PARTITION_OVERFLOW, PARTITION_REDUNDANT_OVERFLOW, PARTITION_PERSISTENT_OVERFLOW, PARTITION_REDUNDANT_PERSISTENT_OVERFLOW, PARTITION_HEAP_LRU, PARTITION_REDUNDANT_HEAP_LRU, REPLICATE, REPLICATE_PERSISTENT, REPLICATE_OVERFLOW, REPLICATE_PERSISTENT_OVERFLOW, REPLICATE_HEAP_LRU, LOCAL, LOCAL_PERSISTENT, LOCAL_HEAP_LRU, LOCAL_OVERFLOW, LOCAL_PERSISTENT_OVERFLOW, PARTITION_PROXY, PARTITION_PROXY_REDUNDANT, and REPLICATE_PROXY.") RegionShortcut regionShortcut, @CliOption(key={"template-region"}, optionContext="geode.converter.region.path:disable-string-converter", help="Name/Path of the region whose attributes should be duplicated when creating this region. Deprecated: Since Geode 1.5, regions should be created explicitly so that undesirable attributes are not copied inadvertently.") String templateRegion, @CliOption(key={"group", "groups"}, optionContext="geode.converter.member.groups:disable-string-converter", help="Group(s) of members on which the region will be created.") String[] groups, @CliOption(key={"if-not-exists", "skip-if-exists"}, specifiedDefaultValue="true", unspecifiedDefaultValue="false", help="By default, an attempt to create a duplicate region is reported as an error. If this option is specified without a value or is specified with a value of true, then gfsh displays a \"Skipping...\" acknowledgement, but does not throw an error. Deprecated: the alias --skip-if-exists is deprecated since Geode 1.5.") boolean ifNotExists, @CliOption(key={"async-event-queue-id"}, help="IDs of the Async Event Queues that will be used for write-behind operations.") String[] asyncEventQueueIds, @CliOption(key={"cache-listener"}, optionContext="splittingRegex=,(?![^{]*\\})", help="Fully qualified class name of a plug-in to be instantiated for receiving after-event notification of changes to the region and its entries. Append json string for initialization properties. Any number of cache listeners can be configured.") ClassName[] cacheListener, @CliOption(key={"cache-loader"}, help="Fully qualified class name of a plug-in to be instantiated for receiving notification of cache misses in the region. Append json string for initialization properties. At most, one cache loader can be defined in each member for the region. For distributed regions, a cache loader may be invoked remotely from other members that have the region defined.") ClassName cacheLoader, @CliOption(key={"cache-writer"}, help="Fully qualified class name of a plug-in to be instantiated for receiving before-event notification of changes to the region and its entries. Append json string for initialization properties. The plug-in may cancel the event. At most, one cache writer can be defined in each member for the region.") ClassName cacheWriter, @CliOption(key={"colocated-with"}, optionContext="geode.converter.region.path:disable-string-converter", help="Central Region with which this region should be colocated.") String prColocatedWith, @CliOption(key={"compressor"}, help="The fully-qualified class name of the Compressor to use when compressing region entry values.  The default is no compression.") String compressor, @CliOption(key={"concurrency-level"}, help="An estimate of the maximum number of application threads that will concurrently access a region entry at one time. This attribute does not apply to partitioned regions.") Integer concurrencyLevel, @CliOption(key={"disk-store"}, help="Disk Store to be used by this region. \"list disk-store\" can be used to display existing disk stores.") String diskStore, @CliOption(key={"enable-async-conflation"}, specifiedDefaultValue="true", help="Whether to allow aggregation of asynchronous TCP/IP messages sent by the producer member of the region. A false value causes all asynchronous messages to be sent individually.") Boolean enableAsyncConflation, @CliOption(key={"enable-cloning"}, specifiedDefaultValue="true", help="Determines how fromDelta applies deltas to the local cache for delta propagation. When true, the updates are applied to a clone of the value and then the clone is saved to the cache. When false, the value is modified in place in the cache.") Boolean cloningEnabled, @CliOption(key={"enable-concurrency-checks"}, specifiedDefaultValue="true", help="Enables a versioning system that detects concurrent modifications and ensures that region contents are consistent across the distributed system.") Boolean concurrencyChecksEnabled, @CliOption(key={"enable-multicast"}, specifiedDefaultValue="true", help="Enables multicast messaging on the region.  Multicast must also be enabled in the cache distributed system properties.  This is primarily useful for replicated regions that are in all servers.") Boolean mcastEnabled, @CliOption(key={"enable-statistics"}, specifiedDefaultValue="true", help="Whether to gather statistics for the region. Must be true to use expiration on the region.") Boolean statisticsEnabled, @CliOption(key={"enable-subscription-conflation"}, specifiedDefaultValue="true", help="Whether the server should conflate its messages to the client. A false value causes all server-client messages to be sent individually.") Boolean enableSubscriptionConflation, @CliOption(key={"enable-synchronous-disk"}, specifiedDefaultValue="true", help="Whether writes are done synchronously for regions that persist data to disk.") Boolean diskSynchronous, @CliOption(key={"entry-idle-time-expiration"}, help="How long the region's entries can remain in the cache without being accessed. The default is no expiration of this type.") Integer entryExpirationIdleTime, @CliOption(key={"entry-idle-time-expiration-action"}, help="Action to be taken on an entry that has exceeded the idle expiration.") ExpirationAction entryExpirationIdleTimeAction, @CliOption(key={"entry-time-to-live-expiration"}, help="How long the region's entries can remain in the cache without being accessed or updated. The default is no expiration of this type.") Integer entryExpirationTTL, @CliOption(key={"entry-time-to-live-expiration-action"}, help="Action to be taken on an entry that has exceeded the TTL expiration.") ExpirationAction entryExpirationTTLAction, @CliOption(key={"entry-idle-time-custom-expiry"}, help="The name of the class implementing CustomExpiry for entry idle time. Append json string for initialization properties.") ClassName entryIdleTimeCustomExpiry, @CliOption(key={"entry-time-to-live-custom-expiry"}, help="The name of the class implementing CustomExpiry for entry time to live. Append json string for initialization properties.") ClassName entryTTLCustomExpiry, @CliOption(key={"eviction-action"}, help="The eviction action to apply. Must be either 'local-destroy' or 'overflow-to-disk'") String evictionAction, @CliOption(key={"eviction-entry-count"}, help="Activates LRU eviction based on the region's entry count specified by this value.") Integer evictionEntryCount, @CliOption(key={"eviction-max-memory"}, help="Activates LRU eviction based on the region's memory usage specified by this value (in megabytes).") Integer evictionMaxMemory, @CliOption(key={"eviction-object-sizer"}, help="A custom class which implements ObjectSizer in order to perform max memory eviction.") String evictionObjectSizer, @CliOption(key={"gateway-sender-id"}, help="IDs of the Gateway Senders to which data will be routed.") String[] gatewaySenderIds, @CliOption(key={"key-constraint"}, help="Fully qualified class name of the objects allowed as region keys. Ensures that keys for region entries are all of the same class.") String keyConstraint, @CliOption(key={"local-max-memory"}, help="Sets the maximum amount of memory, in megabytes, to be used by the region in this process. (Default: 90% of available heap)") Integer prLocalMaxMemory, @CliOption(key={"off-heap"}, specifiedDefaultValue="true", help="Causes the values of the region to be stored in off-heap memory. The default is on heap.") Boolean offHeap, @CliOption(key={"partition-listener"}, optionContext="splittingRegex=,(?![^{]*\\})", help="The fully-qualified class name of a partition listener") ClassName[] partitionListener, @CliOption(key={"partition-resolver"}, help="The fully-qualified class name of the region's partition resolver") String partitionResolver, @CliOption(key={"region-idle-time-expiration"}, help="How long the region can remain in the cache without being accessed. The default is no expiration of this type.") Integer regionExpirationIdleTime, @CliOption(key={"region-idle-time-expiration-action"}, help="Action to be taken on a region that has exceeded the idle expiration.") ExpirationAction regionExpirationIdleTimeAction, @CliOption(key={"region-time-to-live-expiration"}, help="How long the region can remain in the cache without being accessed or updated. The default is no expiration of this type.") Integer regionExpirationTTL, @CliOption(key={"region-time-to-live-expiration-action"}, help="Action to be taken on a region that has exceeded the TTL expiration.") ExpirationAction regionExpirationTTLAction, @CliOption(key={"recovery-delay"}, help="Sets the delay in milliseconds that existing members will wait before satisfying redundancy after another member crashes. -1 (the default) indicates that redundancy will not be recovered after a failure.") Long prRecoveryDelay, @CliOption(key={"redundant-copies"}, help="Sets the number of extra copies of buckets desired. Extra copies allow for both high availability in the face of VM departure (intended or unintended) and and load balancing read operations. (Allowed values: 0, 1, 2 and 3)") Integer prRedundantCopies, @CliOption(key={"startup-recovery-delay"}, help="Sets the delay in milliseconds that new members will wait before satisfying redundancy. -1 indicates that adding new members will not trigger redundancy recovery. The default is to recover redundancy immediately when a new member is added.") Long prStartupRecoveryDelay, @CliOption(key={"total-max-memory"}, help="Sets the maximum amount of memory, in megabytes, to be used by the region in all processes.") Long prTotalMaxMemory, @CliOption(key={"total-num-buckets"}, help="Sets the total number of hash buckets to be used by the region in all processes. (Default: 113).") Integer prTotalNumBuckets, @CliOption(key={"value-constraint"}, help="Fully qualified class name of the objects allowed as region values. If not specified then region values can be of any class.") String valueConstraint, @CliOption(key={"scope"}, help="Sets the scope of the region. Scope cannot be set for Partitioned regions") RegionAttributesScope scope) {
        Set<DistributedMember> membersToCreateRegionOn;
        RegionAttributesType.EvictionAttributes evictionAttributes;
        if (regionShortcut != null && templateRegion != null) {
            return ResultModel.createError("Only one of type & template-region can be specified.");
        }
        if (regionShortcut == null && templateRegion == null) {
            return ResultModel.createError("One of \"type\" or \"template-region\" is required.");
        }
        try {
            this.failIfRegionAlreadyExists(regionPath, regionShortcut, groups);
        }
        catch (EntityExistsException e) {
            return ifNotExists ? ResultModel.createInfo("Skipping: " + e.getMessage()) : ResultModel.createError(e.getMessage());
        }
        InternalCache cache = (InternalCache)this.getCache();
        RegionPath regionPathData = new RegionPath(regionPath);
        if (!regionPathData.isRoot() && !this.regionExists(regionPathData.getParent())) {
            return ResultModel.createError(CliStrings.format((String)"Parent region for \"{0}\" does not exist. ", (Object[])new Object[]{regionPath}));
        }
        RegionConfig regionConfig = new RegionConfig();
        InternalConfigurationPersistenceService persistenceService = (InternalConfigurationPersistenceService)this.getConfigurationPersistenceService();
        if (regionShortcut != null) {
            regionConfig.setType(regionShortcut.name());
            regionConfig.setRegionAttributes(new RegionConverter().createRegionAttributesByType(regionShortcut.name()));
            RegionAttributesType regionAttributesType = regionConfig.getRegionAttributes();
            if (scope != null && regionShortcut.isReplicate()) {
                regionAttributesType.setScope(scope);
            }
        } else {
            List<Object> templateRegionConfigs = new ArrayList();
            if (persistenceService != null) {
                templateRegionConfigs = persistenceService.getGroups().stream().flatMap(g -> persistenceService.getCacheConfig(g, true).getRegions().stream()).filter(c -> c.getName().equals(templateRegion.substring(1))).collect(Collectors.toList());
            } else {
                Set<DistributedMember> regionAssociatedMembers = this.findMembersForRegion(templateRegion);
                if (!regionAssociatedMembers.isEmpty()) {
                    List<CliFunctionResult> regionXmlResults = this.executeAndGetFunctionResult((Function<?>)FetchRegionAttributesFunction.INSTANCE, templateRegion, regionAssociatedMembers);
                    JAXBService jaxbService = new JAXBService(new Class[]{CacheConfig.class});
                    templateRegionConfigs = regionXmlResults.stream().filter(CliFunctionResult::isSuccessful).map(CliFunctionResult::getResultObject).map(String.class::cast).map(s -> (RegionConfig)jaxbService.unMarshall(s, RegionConfig.class)).collect(Collectors.toList());
                }
            }
            if (templateRegionConfigs.isEmpty()) {
                return ResultModel.createError("Template region " + templateRegion + " does not exist.");
            }
            if (templateRegionConfigs.size() == 1) {
                regionConfig = (RegionConfig)templateRegionConfigs.get(0);
            } else {
                RegionConfig first = (RegionConfig)templateRegionConfigs.get(0);
                for (int i = 1; i < templateRegionConfigs.size(); ++i) {
                    if (EqualsBuilder.reflectionEquals((Object)first, (Object)templateRegionConfigs.get(i), (boolean)false, null, (boolean)true, (String[])new String[0])) continue;
                    return ResultModel.createError("Multiple types of template region " + templateRegion + " exist. Can not resolve template region attributes.");
                }
                regionConfig = first;
            }
        }
        regionConfig.setName(regionPathData.getName());
        List partitionListeners = partitionListener == null ? Collections.emptyList() : Arrays.stream(partitionListener).map(ClassName::getClassName).collect(Collectors.toList());
        RegionAttributesType regionAttributes = regionConfig.getRegionAttributes();
        RegionAttributesType.PartitionAttributes delta = RegionAttributesType.PartitionAttributes.generate((String)partitionResolver, partitionListeners, (Integer)prLocalMaxMemory, (Long)prRecoveryDelay, (Integer)prRedundantCopies, (Long)prStartupRecoveryDelay, (Long)prTotalMaxMemory, (Integer)prTotalNumBuckets, (String)prColocatedWith);
        RegionAttributesType.PartitionAttributes partitionAttributes = RegionAttributesType.PartitionAttributes.combine((RegionAttributesType.PartitionAttributes)regionAttributes.getPartitionAttributes(), (RegionAttributesType.PartitionAttributes)delta);
        regionAttributes.setPartitionAttributes(partitionAttributes);
        if (!regionAttributes.getDataPolicy().isPartition() && partitionAttributes != null) {
            return ResultModel.createError(String.format("Parameters %s can be used only for creating a Partitioned Region", Strings.join((String[])PARTITION_ATTRIBUTES, (String)", ")));
        }
        if (prColocatedWith != null) {
            DistributedRegionMXBean colocatedRegionBean = this.getManagementService().getDistributedRegionMXBean(prColocatedWith);
            if (colocatedRegionBean == null) {
                return ResultModel.createError(CliStrings.format((String)"Specify a valid region path for {0}. Region {1} not found.", (Object[])new Object[]{"colocated-with", prColocatedWith}));
            }
            if (!colocatedRegionBean.getRegionType().equals("PARTITION") && !colocatedRegionBean.getRegionType().equals("PERSISTENT_PARTITION")) {
                return ResultModel.createError(CliStrings.format((String)"colocated-with \"{0}\" is not a Partitioned Region.", (Object)prColocatedWith));
            }
        }
        if (gatewaySenderIds != null) {
            Set existingGatewaySenders = Arrays.stream(this.getDSMBean().listGatewaySenders()).collect(Collectors.toSet());
            if (existingGatewaySenders.isEmpty()) {
                return ResultModel.createError("There are no GatewaySenders defined currently in the system.");
            }
            if (Arrays.stream(gatewaySenderIds).anyMatch(id -> !existingGatewaySenders.contains(id))) {
                return ResultModel.createError(CliStrings.format((String)"Specify valid gateway-sender-id. Unknown Gateway Sender(s): \"{0}\".", (Object[])gatewaySenderIds));
            }
            regionAttributes.setGatewaySenderIds(StringUtils.join((Object[])gatewaySenderIds, (String)","));
        }
        if ((evictionAttributes = RegionAttributesType.EvictionAttributes.generate((String)evictionAction, (Integer)evictionMaxMemory, (Integer)evictionEntryCount, (String)evictionObjectSizer)) != null) {
            regionAttributes.setEvictionAttributes(evictionAttributes);
        }
        if (diskStore != null) {
            if (regionShortcut != null) {
                if (!regionShortcut.isPersistent() && !regionShortcut.isOverflow()) {
                    String subMessage = "Only regions with persistence or overflow to disk can specify DiskStore";
                    String message = subMessage + ". " + CliStrings.format((String)"Use one of these shortcuts: {0}", (Object[])new Object[]{String.valueOf(RegionCommandsUtils.PERSISTENT_OVERFLOW_SHORTCUTS)});
                    return ResultModel.createError(message);
                }
            } else {
                EnumActionDestroyOverflow tempEvictionAction = EnumActionDestroyOverflow.LOCAL_DESTROY;
                RegionAttributesType.EvictionAttributes tempEvictionAttributes = regionAttributes.getEvictionAttributes();
                if (tempEvictionAttributes != null) {
                    if (tempEvictionAttributes.getLruMemorySize() != null) {
                        tempEvictionAction = tempEvictionAttributes.getLruMemorySize().getAction();
                    } else if (tempEvictionAttributes.getLruEntryCount() != null) {
                        tempEvictionAction = tempEvictionAttributes.getLruEntryCount().getAction();
                    } else if (tempEvictionAttributes.getLruHeapPercentage() != null) {
                        tempEvictionAction = tempEvictionAttributes.getLruHeapPercentage().getAction();
                    }
                }
                if (!regionAttributes.getDataPolicy().isPersistent() && tempEvictionAction != EnumActionDestroyOverflow.OVERFLOW_TO_DISK) {
                    String subMessage = "Only regions with persistence or overflow to disk can specify DiskStore";
                    String message = subMessage + ". " + CliStrings.format((String)"template-region region \"{0}\" is not persistent or overflow to disk.", (Object[])new Object[]{templateRegion});
                    return ResultModel.createError(message);
                }
            }
            if (!this.diskStoreExists(diskStore)) {
                return ResultModel.createError(CliStrings.format((String)"Specify valid disk-store. Unknown Disk Store : \"{0}\".", (Object[])new Object[]{diskStore}));
            }
            regionAttributes.setDiskStoreName(diskStore);
        }
        if (regionAttributes.getDataPolicy().isPersistent()) {
            this.authorize(ResourcePermission.Resource.CLUSTER, ResourcePermission.Operation.WRITE, ResourcePermission.Target.DISK);
        }
        if ((membersToCreateRegionOn = this.findMembers(groups, null)).isEmpty()) {
            if (groups == null || groups.length == 0) {
                return ResultModel.createError("No Members Found");
            }
            return ResultModel.createError(CliStrings.format((String)"Group(s) \"{0}\" are invalid.", (Object[])groups));
        }
        if (cacheListener != null) {
            regionAttributes.getCacheListeners().clear();
            Arrays.stream(cacheListener).map(cl -> new DeclarableType(cl.getClassName(), cl.getInitProperties())).forEach(regionAttributes.getCacheListeners()::add);
        }
        if (cacheLoader != null) {
            regionAttributes.setCacheLoader(new DeclarableType(cacheLoader.getClassName(), cacheLoader.getInitProperties()));
        }
        if (cacheWriter != null) {
            regionAttributes.setCacheWriter(new DeclarableType(cacheWriter.getClassName(), cacheWriter.getInitProperties()));
        }
        if (compressor != null) {
            regionAttributes.setCompressor(new ClassNameType(compressor));
        }
        if (keyConstraint != null) {
            regionAttributes.setKeyConstraint(keyConstraint);
        }
        if (valueConstraint != null) {
            regionAttributes.setValueConstraint(valueConstraint);
        }
        if (asyncEventQueueIds != null) {
            regionAttributes.setAsyncEventQueueIds(Strings.join((String[])asyncEventQueueIds, (String)","));
        }
        if (offHeap != null) {
            regionAttributes.setOffHeap(offHeap);
        }
        if (concurrencyLevel != null) {
            regionAttributes.setConcurrencyLevel(concurrencyLevel.toString());
        }
        if (enableAsyncConflation != null) {
            regionAttributes.setEnableAsyncConflation(enableAsyncConflation);
        }
        if (cloningEnabled != null) {
            regionAttributes.setCloningEnabled(cloningEnabled);
        }
        if (concurrencyChecksEnabled != null) {
            regionAttributes.setConcurrencyChecksEnabled(concurrencyChecksEnabled);
        }
        if (mcastEnabled != null) {
            regionAttributes.setMulticastEnabled(mcastEnabled);
        }
        if (statisticsEnabled != null) {
            regionAttributes.setStatisticsEnabled(statisticsEnabled);
        }
        if (enableSubscriptionConflation != null) {
            regionAttributes.setEnableSubscriptionConflation(enableSubscriptionConflation);
        }
        if (diskSynchronous != null) {
            regionAttributes.setDiskSynchronous(diskSynchronous);
        }
        regionAttributes.updateEntryIdleTime(entryExpirationIdleTime, entryExpirationIdleTimeAction == null ? null : entryExpirationIdleTimeAction.toXmlString(), entryIdleTimeCustomExpiry);
        regionAttributes.updateEntryTimeToLive(entryExpirationTTL, entryExpirationTTLAction == null ? null : entryExpirationTTLAction.toXmlString(), entryTTLCustomExpiry);
        regionAttributes.updateRegionIdleTime(regionExpirationIdleTime, regionExpirationIdleTimeAction == null ? null : regionExpirationIdleTimeAction.toXmlString(), null);
        regionAttributes.updateRegionTimeToLive(regionExpirationTTL, regionExpirationTTLAction == null ? null : regionExpirationTTLAction.toXmlString(), null);
        CreateRegionFunctionArgs functionArgs = new CreateRegionFunctionArgs(regionPath, regionConfig, ifNotExists);
        List<CliFunctionResult> regionCreateResults = this.executeAndGetFunctionResult((Function<?>)RegionCreateFunction.INSTANCE, functionArgs, membersToCreateRegionOn);
        ResultModel resultModel = ResultModel.createMemberStatusResult(regionCreateResults);
        InternalConfigurationPersistenceService service = (InternalConfigurationPersistenceService)this.getConfigurationPersistenceService();
        if (service == null) {
            return resultModel;
        }
        if (resultModel.isSuccessful() && regionCreateResults.stream().anyMatch(res -> res.getStatusMessage() != null && res.getStatusMessage().contains("Skipping"))) {
            return resultModel;
        }
        if (resultModel.isSuccessful()) {
            this.verifyDistributedRegionMbean(cache, regionPath);
            String regionXml = (String)regionCreateResults.stream().filter(CliFunctionResult::isSuccessful).findFirst().get().getResultObject();
            RegionConfig regionConfigFromServer = (RegionConfig)service.getJaxbService().unMarshall(regionXml, RegionConfig.class);
            List extensions = regionConfigFromServer.getCustomRegionElements();
            regionConfig.getCustomRegionElements().addAll(extensions);
            resultModel.setConfigObject(new CreateRegionResult(regionConfig, regionPath));
        }
        return resultModel;
    }

    @Override
    public boolean updateConfigForGroup(String group, CacheConfig config, Object configObject) {
        if (configObject == null) {
            return false;
        }
        CreateRegionResult regionResultConfigObject = (CreateRegionResult)configObject;
        RegionConfig regionConfig = regionResultConfigObject.getRegionConfig();
        String regionPath = regionResultConfigObject.getFullRegionPath();
        RegionPath regionPathData = new RegionPath(regionPath);
        if (regionPathData.getParent() == null) {
            config.getRegions().add(regionConfig);
            return true;
        }
        String[] regionsOnPath = regionPathData.getRegionsOnParentPath();
        RegionConfig currentConfig = config.getRegions().stream().filter(r1 -> r1.getName().equals(regionsOnPath[0])).findFirst().get();
        for (int i = 1; i < regionsOnPath.length; ++i) {
            String curRegionName = regionsOnPath[i];
            currentConfig = currentConfig.getRegions().stream().filter(r -> r.getName().equals(curRegionName)).findFirst().get();
        }
        currentConfig.getRegions().add(regionConfig);
        return true;
    }

    boolean verifyDistributedRegionMbean(InternalCache cache, String regionName) {
        int federationInterval = cache.getInternalDistributedSystem().getConfig().getJmxManagerUpdateRate();
        long timeEnd = System.currentTimeMillis() + (long)federationInterval + 50L;
        while (System.currentTimeMillis() <= timeEnd) {
            try {
                DistributedRegionMXBean bean = ManagementService.getManagementService((Cache)cache).getDistributedRegionMXBean(regionName);
                if (bean == null) {
                    bean = ManagementService.getManagementService((Cache)cache).getDistributedRegionMXBean("/" + regionName);
                }
                if (bean != null) {
                    return true;
                }
                Thread.sleep(2L);
            }
            catch (Exception exception) {}
        }
        return false;
    }

    RegionConfig findNonProxyRegionsInClusterConfigurationByName(String regionName, InternalConfigurationPersistenceService persistenceService) {
        for (String group : persistenceService.getGroups()) {
            RegionConfig regionConfig;
            CacheConfig config = persistenceService.getCacheConfig(group);
            if (config == null || (regionConfig = (RegionConfig)config.getRegions().stream().filter(region -> region.getName().equals(regionName) && !region.getType().contains("PROXY")).findFirst().orElse(null)) == null) continue;
            return regionConfig;
        }
        return null;
    }

    boolean isRegionExistsInGroup(String regionName, String group, InternalConfigurationPersistenceService persistenceService) {
        CacheConfig config = persistenceService.getCacheConfig(group);
        RegionConfig regionConfig = null;
        if (config != null) {
            regionConfig = config.getRegions().stream().filter(region -> region.getName().equals(regionName)).findFirst().orElse(null);
        }
        return regionConfig != null;
    }

    private void failIfRegionExistsInClusterConfiguration(String regionPathFull, String[] groups, RegionShortcut regionShortcut) {
        boolean existingRegionIsNotProxy;
        InternalConfigurationPersistenceService persistenceService = (InternalConfigurationPersistenceService)this.getConfigurationPersistenceService();
        if (persistenceService == null) {
            return;
        }
        RegionPath regionPath = new RegionPath(regionPathFull);
        RegionConfig regionConfig = this.findNonProxyRegionsInClusterConfigurationByName(regionPath.getName(), persistenceService);
        if (regionConfig == null) {
            return;
        }
        String existingDataPolicy = regionConfig.getType();
        boolean bl = existingRegionIsNotProxy = !existingDataPolicy.contains("PROXY");
        if (regionShortcut.isLocal() || existingDataPolicy.equals("NORMAL") || !regionShortcut.isProxy() && existingRegionIsNotProxy) {
            throw new EntityExistsException(String.format("Region %s already exists on the cluster.", regionPath.getRegionPath()));
        }
        if (regionShortcut.isPartition() && !existingDataPolicy.contains("PARTITION")) {
            LogService.getLogger().info("Create region command: got EntityExists exception");
            throw new EntityExistsException("The existing region is not a partitioned region");
        }
        if (regionShortcut.isReplicate() && !existingDataPolicy.equals("EMPTY") && !existingDataPolicy.contains("REPLICATE") && !existingDataPolicy.contains("PRELOADED")) {
            throw new EntityExistsException("The existing region is not a replicate region");
        }
        if (groups == null) {
            if (this.isRegionExistsInGroup(regionPath.getName(), null, persistenceService)) {
                throw new EntityExistsException(String.format("Region %s already exists on the cluster.", regionPath.getRegionPath()));
            }
        } else {
            ArrayList<String> groupsExists = new ArrayList<String>();
            for (String group : groups) {
                if (!this.isRegionExistsInGroup(regionPath.getName(), group, persistenceService)) continue;
                groupsExists.add(group);
            }
            if (!groupsExists.isEmpty()) {
                throw new EntityExistsException(String.format("Region %s already exists in groups: %s.", regionPath.getRegionPath(), StringUtils.join(groupsExists, (String)",")));
            }
        }
    }

    private void failIfRegionAlreadyExists(String regionPath, RegionShortcut regionShortcut, String[] groups) throws EntityExistsException {
        boolean toBeCreatedIsNotProxy;
        this.failIfRegionExistsInClusterConfiguration(regionPath, groups, regionShortcut);
        DistributedRegionMXBean regionBean = this.getManagementService().getDistributedRegionMXBean(regionPath);
        if (regionBean == null || regionShortcut == null) {
            return;
        }
        String existingDataPolicy = regionBean.getRegionType();
        boolean existingRegionIsNotProxy = regionBean.getMemberCount() > regionBean.getEmptyNodes();
        boolean bl = toBeCreatedIsNotProxy = !regionShortcut.isProxy();
        if (regionShortcut.isLocal() || existingDataPolicy.equals("NORMAL") || toBeCreatedIsNotProxy && existingRegionIsNotProxy) {
            throw new EntityExistsException(String.format("Region %s already exists on the cluster.", regionPath));
        }
        if (regionShortcut.isPartition() && !existingDataPolicy.contains("PARTITION")) {
            LogService.getLogger().info("Create region command: got EntityExists exception");
            throw new EntityExistsException("The existing region is not a partitioned region");
        }
        if (regionShortcut.isReplicate() && !existingDataPolicy.equals("EMPTY") && !existingDataPolicy.contains("REPLICATE") && !existingDataPolicy.contains("PRELOADED")) {
            throw new EntityExistsException("The existing region is not a replicate region");
        }
        Set membersWithThisRegion = Arrays.stream(regionBean.getMembers()).collect(Collectors.toSet());
        Set membersWithinGroup = this.findMembers(groups, null).stream().map(DistributedMember::getName).collect(Collectors.toSet());
        if (!Collections.disjoint(membersWithinGroup, membersWithThisRegion)) {
            throw new EntityExistsException(String.format("Region %s already exists on these members: %s.", regionPath, StringUtils.join(membersWithThisRegion, (String)",")));
        }
    }

    boolean regionExists(String regionPath) {
        if (regionPath == null || "/".equals(regionPath)) {
            return false;
        }
        Object managementService = this.getManagementService();
        DistributedSystemMXBean dsMBean = managementService.getDistributedSystemMXBean();
        String[] allRegionPaths = dsMBean.listAllRegionPaths();
        return Arrays.asList(allRegionPaths).contains(regionPath);
    }

    private boolean diskStoreExists(String diskStoreName) {
        Object managementService = this.getManagementService();
        DistributedSystemMXBean dsMXBean = managementService.getDistributedSystemMXBean();
        return Arrays.stream(dsMXBean.listMembers()).anyMatch(member -> DiskStoreCommandsUtils.diskStoreBeanAndMemberBeanDiskStoreExists(dsMXBean, member, diskStoreName));
    }

    DistributedSystemMXBean getDSMBean() {
        Object managementService = this.getManagementService();
        return managementService.getDistributedSystemMXBean();
    }

    private class CreateRegionResult {
        private final RegionConfig regionConfig;
        private final String fullRegionPath;

        RegionConfig getRegionConfig() {
            return this.regionConfig;
        }

        String getFullRegionPath() {
            return this.fullRegionPath;
        }

        CreateRegionResult(RegionConfig regionConfig, String fullRegionPath) {
            this.regionConfig = regionConfig;
            this.fullRegionPath = fullRegionPath;
        }
    }

    public static class Interceptor
    extends AbstractCliAroundInterceptor {
        @Override
        public ResultModel preExecution(GfshParseResult parseResult) {
            String regionShortcut;
            Integer localMaxMemory = (Integer)parseResult.getParamValue("local-max-memory");
            if (localMaxMemory != null && localMaxMemory < 0) {
                return ResultModel.createError("PartitionAttributes localMaxMemory must not be negative.");
            }
            Long totalMaxMemory = (Long)parseResult.getParamValue("total-max-memory");
            if (totalMaxMemory != null && totalMaxMemory <= 0L) {
                return ResultModel.createError("Total size of partition region must be > 0.");
            }
            Integer redundantCopies = (Integer)parseResult.getParamValue("redundant-copies");
            if (redundantCopies != null && (redundantCopies < 0 || redundantCopies > 3)) {
                return ResultModel.createError(CliStrings.format((String)"redundant-copies \"{0}\" is not valid. It should be one of 0, 1, 2, 3.", (Object[])new Object[]{redundantCopies}));
            }
            Integer concurrencyLevel = (Integer)parseResult.getParamValue("concurrency-level");
            if (concurrencyLevel != null && concurrencyLevel < 0) {
                return ResultModel.createError(CliStrings.format((String)"Specify positive integer value for concurrency-level.  \"{0}\" is not valid.", (Object[])new Object[]{concurrencyLevel}));
            }
            String keyConstraint = parseResult.getParamValueAsString("key-constraint");
            if (keyConstraint != null && !ClassName.isClassNameValid((String)keyConstraint)) {
                return ResultModel.createError(CliStrings.format((String)"Specify a valid class name for key-constraint. \"{0}\" is not valid.", (Object[])new Object[]{keyConstraint}));
            }
            String valueConstraint = parseResult.getParamValueAsString("value-constraint");
            if (valueConstraint != null && !ClassName.isClassNameValid((String)valueConstraint)) {
                return ResultModel.createError(CliStrings.format((String)"Specify a valid class name for value-constraint. \"{0}\" is not valid.", (Object[])new Object[]{valueConstraint}));
            }
            String compressor = parseResult.getParamValueAsString("compressor");
            if (compressor != null && !ClassName.isClassNameValid((String)compressor)) {
                return ResultModel.createError(CliStrings.format((String)"{0} is an invalid Compressor.", (Object[])new Object[]{compressor}));
            }
            Boolean cloningEnabled = (Boolean)parseResult.getParamValue("enable-cloning");
            if (compressor != null && cloningEnabled != null && !cloningEnabled.booleanValue()) {
                return ResultModel.createError(CliStrings.format((String)"Cannot set enable-cloning to false when compressor is provided", (Object[])new Object[]{compressor}));
            }
            String diskStore = parseResult.getParamValueAsString("disk-store");
            if (diskStore != null && (regionShortcut = parseResult.getParamValueAsString("type")) != null && !RegionCommandsUtils.PERSISTENT_OVERFLOW_SHORTCUTS.contains(RegionShortcut.valueOf((String)regionShortcut))) {
                String subMessage = "Only regions with persistence or overflow to disk can specify DiskStore";
                String message = subMessage + ". " + CliStrings.format((String)"Use one of these shortcuts: {0}", (Object[])new Object[]{String.valueOf(RegionCommandsUtils.PERSISTENT_OVERFLOW_SHORTCUTS)});
                return ResultModel.createError(message);
            }
            Boolean statisticsEnabled = (Boolean)parseResult.getParamValue("enable-statistics");
            Integer entryIdle = (Integer)parseResult.getParamValue("entry-idle-time-expiration");
            Integer entryTtl = (Integer)parseResult.getParamValue("entry-time-to-live-expiration");
            Integer regionIdle = (Integer)parseResult.getParamValue("region-idle-time-expiration");
            Integer regionTtl = (Integer)parseResult.getParamValue("region-time-to-live-expiration");
            ExpirationAction entryIdleAction = (ExpirationAction)parseResult.getParamValue("entry-idle-time-expiration-action");
            ExpirationAction entryTtlAction = (ExpirationAction)parseResult.getParamValue("entry-time-to-live-expiration-action");
            ExpirationAction regionIdleAction = (ExpirationAction)parseResult.getParamValue("region-idle-time-expiration-action");
            ExpirationAction regionTtlAction = (ExpirationAction)parseResult.getParamValue("region-time-to-live-expiration-action");
            ClassName entryIdleExpiry = (ClassName)parseResult.getParamValue("entry-idle-time-custom-expiry");
            ClassName entryTTTLExpiry = (ClassName)parseResult.getParamValue("entry-time-to-live-custom-expiry");
            if (!(entryIdle == null && entryTtl == null && regionIdle == null && regionTtl == null && entryIdleAction == null && entryTtlAction == null && regionIdleAction == null && regionTtlAction == null && entryIdleExpiry == null && entryTTTLExpiry == null || statisticsEnabled != null && statisticsEnabled.booleanValue())) {
                String message = "Statistics must be enabled for expiration";
                return ResultModel.createError(message + ".");
            }
            String maxMemory = parseResult.getParamValueAsString("eviction-max-memory");
            String maxEntry = parseResult.getParamValueAsString("eviction-entry-count");
            String evictionAction = parseResult.getParamValueAsString("eviction-action");
            String evictionSizer = parseResult.getParamValueAsString("eviction-object-sizer");
            if (maxEntry != null && maxMemory != null) {
                return ResultModel.createError("eviction-max-memory and eviction-entry-count cannot both be specified.");
            }
            if ((maxEntry != null || maxMemory != null) && evictionAction == null) {
                return ResultModel.createError("eviction-action must be specified.");
            }
            if (evictionSizer != null && maxEntry != null) {
                return ResultModel.createError("eviction-object-sizer cannot be specified with eviction-entry-count");
            }
            if (evictionAction != null && EvictionAction.parseAction((String)evictionAction) == EvictionAction.NONE) {
                return ResultModel.createError("eviction-action must be 'local-destroy' or 'overflow-to-disk'");
            }
            RegionAttributesScope scope = (RegionAttributesScope)parseResult.getParamValue("scope");
            RegionShortcut regionShortcut2 = (RegionShortcut)parseResult.getParamValue("type");
            if (scope != null && regionShortcut2 == null) {
                return ResultModel.createError("Scope cannot be used if --type is not set in the command");
            }
            if (scope != null && !regionShortcut2.isReplicate()) {
                return ResultModel.createError("Scope cannot be set on non Replicated region types");
            }
            return ResultModel.createInfo("");
        }
    }
}

