/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.cli.commands;

import java.util.Set;
import org.apache.geode.cache.execute.Function;
import org.apache.geode.distributed.DistributedMember;
import org.apache.geode.management.cli.CliMetaData;
import org.apache.geode.management.cli.GfshCommand;
import org.apache.geode.management.internal.cli.commands.IndexDefinition;
import org.apache.geode.management.internal.cli.functions.ManageIndexDefinitionFunction;
import org.apache.geode.management.internal.cli.result.model.ResultModel;
import org.apache.geode.management.internal.security.ResourceOperation;
import org.apache.geode.security.ResourcePermission;
import org.springframework.shell.core.annotation.CliCommand;

public class ClearDefinedIndexesCommand
extends GfshCommand {
    @CliCommand(value={"clear defined indexes"}, help="Clears all the defined indexes.")
    @CliMetaData(relatedTopic={"Region", "Data"})
    @ResourceOperation(resource=ResourcePermission.Resource.CLUSTER, operation=ResourcePermission.Operation.MANAGE, target=ResourcePermission.Target.QUERY)
    public ResultModel clearDefinedIndexes() {
        IndexDefinition.indexDefinitions.clear();
        Set<DistributedMember> allOtherLocators = this.findAllOtherLocators();
        if (allOtherLocators.size() > 0) {
            this.executeAndGetFunctionResult((Function<?>)new ManageIndexDefinitionFunction(), null, allOtherLocators);
        }
        return ResultModel.createInfo("Index definitions successfully cleared");
    }
}

