/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.cli;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.ServiceLoader;
import java.util.Set;
import org.apache.geode.annotations.Immutable;
import org.apache.geode.cache.Cache;
import org.apache.geode.internal.cache.InternalCache;
import org.apache.geode.internal.classloader.ClassPathLoader;
import org.apache.geode.management.cli.Disabled;
import org.apache.geode.management.cli.GfshCommand;
import org.apache.geode.management.internal.cli.CommandManagerAware;
import org.apache.geode.management.internal.cli.LogWrapper;
import org.apache.geode.management.internal.cli.help.Helper;
import org.apache.geode.management.internal.cli.shell.Gfsh;
import org.apache.geode.management.internal.util.ClasspathScanLoadHelper;
import org.springframework.shell.converters.EnumConverter;
import org.springframework.shell.converters.SimpleFileConverter;
import org.springframework.shell.core.CommandMarker;
import org.springframework.shell.core.Converter;
import org.springframework.shell.core.MethodTarget;
import org.springframework.shell.core.annotation.CliAvailabilityIndicator;
import org.springframework.shell.core.annotation.CliCommand;

public class CommandManager {
    private static final String USER_CMD_PACKAGES_PROPERTY = "gemfire.user-command-packages";
    private static final String USER_CMD_PACKAGES_ENV_VARIABLE = "GEMFIRE_USER_COMMAND_PACKAGES";
    private static final String SPRING_CONVERTER_PACKAGE = "org.springframework.shell.converters";
    @Immutable
    private static final List<Class<?>> SPRING_CONVERTERS_TO_SKIP = Collections.unmodifiableList(Arrays.asList(SimpleFileConverter.class, EnumConverter.class));
    private final Helper helper = new Helper();
    private final List<Converter<?>> converters = new ArrayList();
    private final List<CommandMarker> commandMarkers = new ArrayList<CommandMarker>();
    private final Properties cacheProperties = new Properties();
    private final LogWrapper logWrapper;
    private final InternalCache cache;

    public CommandManager() {
        this(null, null);
    }

    public CommandManager(Properties newCacheProperties, InternalCache cache) {
        if (newCacheProperties != null) {
            this.cacheProperties.putAll((Map<?, ?>)newCacheProperties);
        }
        this.cache = cache;
        this.logWrapper = LogWrapper.getInstance((Cache)cache);
        this.loadCommands();
        this.loadConverters();
    }

    private static void raiseExceptionIfEmpty(Set<?> foundClasses, String errorFor) throws IllegalStateException {
        if (foundClasses == null || foundClasses.isEmpty()) {
            throw new IllegalStateException("Required " + errorFor + " classes were not loaded. Check logs for errors.");
        }
    }

    private Set<String> getUserCommandPackages() {
        String cacheUserCmdPackages;
        HashSet<String> userCommandPackages = new HashSet<String>();
        ArrayList<String> userCommandSources = new ArrayList<String>();
        if (System.getProperty(USER_CMD_PACKAGES_PROPERTY) != null) {
            userCommandSources.add(System.getProperty(USER_CMD_PACKAGES_PROPERTY));
        }
        if (System.getenv().containsKey(USER_CMD_PACKAGES_ENV_VARIABLE)) {
            userCommandSources.add(System.getenv().get(USER_CMD_PACKAGES_ENV_VARIABLE));
        }
        if (!(cacheUserCmdPackages = this.cacheProperties.getProperty("user-command-packages", "")).isEmpty()) {
            userCommandSources.add(cacheUserCmdPackages);
        }
        for (String source : userCommandSources) {
            userCommandPackages.addAll(Arrays.asList(source.split(",")));
        }
        return userCommandPackages;
    }

    private void loadUserDefinedCommands() {
        String[] userCommandPackages = this.getUserCommandPackages().toArray(new String[0]);
        if (userCommandPackages.length == 0) {
            return;
        }
        try (ClasspathScanLoadHelper scanner = new ClasspathScanLoadHelper(userCommandPackages);){
            Set foundClasses = scanner.scanPackagesForClassesImplementing(CommandMarker.class, userCommandPackages);
            for (Class klass : foundClasses) {
                try {
                    this.add((CommandMarker)klass.newInstance());
                }
                catch (Exception e) {
                    this.logWrapper.warning("Could not load User Commands from: " + String.valueOf(klass) + " due to " + e.getLocalizedMessage());
                }
            }
            CommandManager.raiseExceptionIfEmpty(foundClasses, "User Command");
        }
        catch (IllegalStateException e) {
            this.logWrapper.warning(e.getMessage(), e);
            throw e;
        }
    }

    private void loadGeodeCommands() {
        ServiceLoader<CommandMarker> commandMarkers = ServiceLoader.load(CommandMarker.class, ClassPathLoader.getLatest().asClassLoader());
        boolean loadedAtLeastOneCommand = false;
        for (CommandMarker commandMarker : commandMarkers) {
            this.add(commandMarker);
            loadedAtLeastOneCommand = true;
        }
        if (!loadedAtLeastOneCommand) {
            throw new IllegalStateException("Required Command classes were not loaded. Check logs for errors.");
        }
    }

    private void loadConverters() {
        this.loadGeodeDefinedConverters();
        this.loadSpringDefinedConverters();
    }

    private void loadCommands() {
        this.loadGeodeCommands();
        this.loadUserDefinedCommands();
    }

    private void loadSpringDefinedConverters() {
        try (ClasspathScanLoadHelper scanner = new ClasspathScanLoadHelper(new String[]{SPRING_CONVERTER_PACKAGE});){
            Set foundClasses = scanner.scanPackagesForClassesImplementing(Converter.class, new String[]{SPRING_CONVERTER_PACKAGE});
            for (Class klass : foundClasses) {
                if (SPRING_CONVERTERS_TO_SKIP.contains(klass)) continue;
                try {
                    this.add((Converter)klass.newInstance());
                }
                catch (Exception e) {
                    this.logWrapper.warning("Could not load Converter from: " + String.valueOf(klass) + " due to " + e.getLocalizedMessage());
                }
            }
            CommandManager.raiseExceptionIfEmpty(foundClasses, "Spring Converter");
        }
        catch (IllegalStateException e) {
            this.logWrapper.warning(e.getMessage(), e);
            throw e;
        }
    }

    private void loadGeodeDefinedConverters() {
        ServiceLoader<Converter> converters = ServiceLoader.load(Converter.class, ClassPathLoader.getLatestAsClassLoader());
        boolean loadedAtLeastOneConverter = false;
        for (Converter converter : converters) {
            this.add(converter);
            loadedAtLeastOneConverter = true;
        }
        if (!loadedAtLeastOneConverter) {
            throw new IllegalStateException("Required Converter classes were not loaded. Check logs for errors.");
        }
    }

    public List<Converter<?>> getConverters() {
        return this.converters;
    }

    public List<CommandMarker> getCommandMarkers() {
        return this.commandMarkers;
    }

    private void add(Converter<?> converter) {
        if (CommandManagerAware.class.isAssignableFrom(converter.getClass())) {
            ((CommandManagerAware)converter).setCommandManager(this);
        }
        this.converters.add(converter);
    }

    void add(CommandMarker commandMarker) {
        Disabled classDisabled = commandMarker.getClass().getAnnotation(Disabled.class);
        if (classDisabled != null && (classDisabled.unlessPropertyIsSet().isEmpty() || System.getProperty(classDisabled.unlessPropertyIsSet()) == null)) {
            return;
        }
        if (GfshCommand.class.isAssignableFrom(commandMarker.getClass())) {
            ((GfshCommand)commandMarker).setCache((Cache)this.cache);
        }
        if (CommandManagerAware.class.isAssignableFrom(commandMarker.getClass())) {
            ((CommandManagerAware)commandMarker).setCommandManager(this);
        }
        this.commandMarkers.add(commandMarker);
        for (Method method : commandMarker.getClass().getMethods()) {
            CliCommand cliCommand = method.getAnnotation(CliCommand.class);
            CliAvailabilityIndicator availability = method.getAnnotation(CliAvailabilityIndicator.class);
            if (cliCommand == null && availability == null) continue;
            if (cliCommand != null) {
                this.helper.addCommand(cliCommand, method);
            }
            if (availability == null) continue;
            this.helper.addAvailabilityIndicator(availability, new MethodTarget(method, (Object)commandMarker));
        }
    }

    public Helper getHelper() {
        return this.helper;
    }

    public String obtainHelp(String buffer) {
        int terminalWidth = -1;
        Gfsh gfsh = Gfsh.getCurrentInstance();
        if (gfsh != null) {
            terminalWidth = gfsh.getTerminalWidth();
        }
        return this.helper.getHelp(buffer, terminalWidth);
    }

    public String obtainHint(String topic) {
        return this.helper.getHint(topic);
    }
}

