/*
 * Decompiled with CFR 0.152.
 */
package com.sas.commons.rest.util;

import edu.umd.cs.findbugs.annotations.NonNull;

public class UrlEncoding {
    public static final String FS = "~fs~";
    public static final String RS = "~rs~";
    public static final String SC = "~sc~";
    public static final String TL = "~~";

    private UrlEncoding() {
    }

    @NonNull
    public static String encodePathSegment(@NonNull String pathSegment) {
        int length = pathSegment.length();
        int stringBuilderLength = 0;
        block10: for (int i = 0; i < length; ++i) {
            char c = pathSegment.charAt(i);
            switch (c) {
                case '/': 
                case ';': 
                case '\\': {
                    stringBuilderLength += 4;
                    continue block10;
                }
                case '~': {
                    stringBuilderLength += 2;
                    continue block10;
                }
                default: {
                    ++stringBuilderLength;
                }
            }
        }
        if (stringBuilderLength == length) {
            return pathSegment;
        }
        StringBuilder sb = new StringBuilder(stringBuilderLength);
        block11: for (int i = 0; i < length; ++i) {
            char c = pathSegment.charAt(i);
            switch (c) {
                case '/': {
                    sb.append(FS);
                    continue block11;
                }
                case '\\': {
                    sb.append(RS);
                    continue block11;
                }
                case ';': {
                    sb.append(SC);
                    continue block11;
                }
                case '~': {
                    sb.append(TL);
                    continue block11;
                }
                default: {
                    sb.append(c);
                }
            }
        }
        return sb.toString();
    }

    @NonNull
    public static String decodePathSegment(@NonNull String pathSegment) throws IllegalArgumentException {
        if (pathSegment.indexOf(126) == -1) {
            return pathSegment;
        }
        int length = pathSegment.length();
        StringBuilder sb = new StringBuilder(length);
        for (int i = 0; i < length; ++i) {
            char c = pathSegment.charAt(i);
            if (c == '~') {
                int indexOfTilde = i;
                if (i + 1 < length) {
                    if (pathSegment.charAt(i + 1) == '~') {
                        sb.append('~');
                        ++i;
                        continue;
                    }
                    if (i + 3 < length) {
                        i += 3;
                        if (pathSegment.regionMatches(indexOfTilde, FS, 0, 4)) {
                            sb.append('/');
                            continue;
                        }
                        if (pathSegment.regionMatches(indexOfTilde, RS, 0, 4)) {
                            sb.append('\\');
                            continue;
                        }
                        if (pathSegment.regionMatches(indexOfTilde, SC, 0, 4)) {
                            sb.append(';');
                            continue;
                        }
                    }
                }
                throw new IllegalArgumentException("Invalid '~' escape sequence specified at position " + indexOfTilde);
            }
            sb.append(c);
        }
        return sb.toString();
    }
}

