/*
 * Decompiled with CFR 0.152.
 */
package com.sas.commons.rest.util;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.sas.commons.rest.links.Link;
import com.sas.commons.rest.links.Links;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import jakarta.xml.bind.annotation.XmlAnyElement;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlElementWrapper;
import jakarta.xml.bind.annotation.XmlMixed;
import jakarta.xml.bind.annotation.XmlRootElement;
import java.util.List;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.lang.builder.ToStringBuilder;

@XmlRootElement(name="collection")
public class ResourceCollection<T> {
    public static final String MEDIA_TYPE_BASE_VALUE = "application/vnd.sas.collection";
    public static final String MEDIA_TYPE_JSON_VALUE = "application/vnd.sas.collection+json";
    public static final String MEDIA_TYPE_XML_VALUE = "application/vnd.sas.collection+xml";
    public static final int SCHEMA_VERSION = 2;
    public static final String COLLECTION_NAME = "items";
    public static final int DEFAULT_LIMIT = 10;
    @JsonIgnore
    @Nullable
    private Links links;
    @Nullable
    private String name = "items";
    @Nullable
    private String accept;
    @Nullable
    private Long start;
    @Nullable
    private Long count;
    @Nullable
    private List<T> items;
    @Nullable
    private Integer limit;
    private int version = 2;

    public ResourceCollection() {
    }

    public ResourceCollection(@Nullable List<T> items, @Nullable Long start, @Nullable Integer limit, @Nullable Long count, @Nullable Links links, @Nullable String accept) {
        this(items, start, limit, count, links, accept, COLLECTION_NAME);
    }

    public ResourceCollection(@Nullable List<T> items, @Nullable Long start, @Nullable Integer limit, @Nullable Long count, @Nullable Links links, @NonNull String accept, @Nullable String name) {
        this.setName(name);
        this.setAccept(accept);
        this.setItems(items);
        this.setLinks(links);
        this.setStart(start);
        this.setLimit(limit);
        this.setCount(count);
        this.setName(name);
    }

    @XmlAttribute(name="version")
    public int getVersion() {
        return this.version;
    }

    public void setVersion(int version) {
        this.version = version;
    }

    @XmlElementWrapper(name="items")
    @XmlAnyElement(lax=true)
    @XmlMixed
    @Nullable
    public List<T> getItems() {
        return this.items;
    }

    public void setItems(@Nullable List<T> items) {
        this.items = items;
    }

    @XmlAttribute(name="start", required=false)
    public Long getStart() {
        return this.start;
    }

    public void setStart(Long start) {
        this.start = start;
    }

    @XmlAttribute(name="limit", required=false)
    public Integer getLimit() {
        return this.limit;
    }

    public void setLimit(Integer limit) {
        this.limit = limit;
    }

    @XmlAttribute(name="accept", required=true)
    @Nullable
    public String getAccept() {
        return this.accept;
    }

    public void setAccept(@Nullable String accept) {
        this.accept = accept;
    }

    @NonNull
    public static String accepts(String ... mediaTypes) {
        if (mediaTypes == null) {
            return "";
        }
        int len = mediaTypes.length - 1;
        for (String type : mediaTypes) {
            len += type.length();
        }
        StringBuilder b = new StringBuilder(len);
        String delim = "";
        for (String type : mediaTypes) {
            b.append(delim);
            b.append(type);
            delim = " ";
        }
        return b.toString();
    }

    @XmlElementWrapper(name="links")
    @XmlElement(name="link")
    @JsonProperty
    @NonNull
    public List<Link> getLinks() {
        if (this.links == null) {
            this.links = new Links();
        }
        return this.links.getLinks();
    }

    public Links links() {
        return this.links;
    }

    public void setLinks(@Nullable List<Link> links) {
        this.links = links == null ? null : new Links(links);
    }

    @JsonIgnore
    public void setLinks(@Nullable Links links) {
        this.links = links;
    }

    @XmlAttribute(required=true)
    @Nullable
    public String getName() {
        return this.name;
    }

    public void setName(@Nullable String name) {
        this.name = name;
    }

    @XmlAttribute(name="count")
    @Nullable
    public Long getCount() {
        return this.count;
    }

    public void setCount(@Nullable Long count) {
        this.count = count;
    }

    public boolean equals(Object obj) {
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        ResourceCollection rhs = (ResourceCollection)obj;
        return new EqualsBuilder().append((Object)this.getName(), (Object)rhs.getName()).append(this.getLinks(), rhs.getLinks()).append((Object)this.getStart(), (Object)rhs.getStart()).append((Object)this.getLimit(), (Object)rhs.getLimit()).append((Object)this.getCount(), (Object)rhs.getCount()).isEquals();
    }

    @NonNull
    public String toString() {
        return new ToStringBuilder((Object)this).append("name", (Object)this.getName()).append("links", this.getLinks()).append("start", (Object)this.getStart()).append("limit", (Object)this.getLimit()).append("count", (Object)this.getCount()).toString();
    }

    public int hashCode() {
        return new HashCodeBuilder().append((Object)this.links).append(this.items).append((Object)this.name).append((Object)this.accept).append((Object)this.start).append((Object)this.limit).append((Object)this.count).toHashCode();
    }
}

