/*
 * Decompiled with CFR 0.152.
 */
package com.sas.commons.rest.util;

import edu.umd.cs.findbugs.annotations.NonNull;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlSeeAlso;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.jcip.annotations.NotThreadSafe;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.ToStringBuilder;

@XmlRootElement(name="properties")
@XmlSeeAlso(value={Property.class})
@NotThreadSafe
public class Properties {
    private final Map<String, String> map;

    public Properties(@NonNull Map<String, String> properties) {
        this.map = properties;
    }

    public Properties(@NonNull java.util.Properties props) {
        this();
        for (Map.Entry<Object, Object> e : props.entrySet()) {
            String key = (String)e.getKey();
            String value = (String)e.getValue();
            this.put(key, value);
        }
    }

    public Properties(@NonNull List<Property> properties) {
        this();
        for (Property e : properties) {
            this.put(e.getName(), e.getValue());
        }
    }

    public Properties(@NonNull String name, @NonNull String value) {
        this();
        this.put(name, value);
    }

    public Properties() {
        this.map = new HashMap<String, String>();
    }

    public String get(@NonNull String name) {
        return this.map.get(name);
    }

    public void put(@NonNull String name, String value) {
        this.map.put(name, value);
    }

    public int size() {
        return this.map.size();
    }

    public int hashCode() {
        return this.map.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == null || this.getClass() != obj.getClass()) {
            return true;
        }
        return this.map.equals(((Properties)obj).map);
    }

    public String toString() {
        return this.map.toString();
    }

    @XmlElement(name="property")
    @NonNull
    public List<Property> getProperties() {
        ArrayList<Property> list = new ArrayList<Property>(this.map.size());
        for (Map.Entry<String, String> e : this.map.entrySet()) {
            list.add(new Property(e));
        }
        return list;
    }

    @NotThreadSafe
    public static final class Property {
        private String name;
        private String value;

        public Property() {
            this("", "");
        }

        public Property(@NonNull Map.Entry<String, String> e) {
            this(e.getKey(), e.getValue());
        }

        public Property(@NonNull String name, String value) {
            this.name = name;
            this.value = value;
        }

        @XmlAttribute
        @NonNull
        public String getName() {
            return this.name;
        }

        public void setName(@NonNull String name) {
            this.name = name;
        }

        @XmlElement(name="value")
        public String getValue() {
            return this.value;
        }

        public void setValue(String value) {
            this.value = value;
        }

        public int hashCode() {
            return this.getName().hashCode() * 37 + this.getValue().hashCode();
        }

        public boolean equals(Object obj) {
            if (obj == null || obj.getClass() != Property.class) {
                return false;
            }
            if (this == obj) {
                return true;
            }
            Property rhs = (Property)obj;
            return new EqualsBuilder().append((Object)this.name, (Object)rhs.name).append((Object)this.value, (Object)rhs.value).isEquals();
        }

        public String toString() {
            return new ToStringBuilder((Object)this).append("name", (Object)this.name).append("value", (Object)this.value).toString();
        }
    }
}

