/*
 * Decompiled with CFR 0.152.
 */
package com.sas.commons.rest.util;

import com.sas.commons.rest.links.Link;
import com.sas.commons.rest.links.Links;
import edu.umd.cs.findbugs.annotations.NonNull;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlElementWrapper;
import jakarta.xml.bind.annotation.XmlRootElement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.jcip.annotations.NotThreadSafe;
import org.apache.commons.lang.builder.ToStringBuilder;

@XmlRootElement(name="error")
@NotThreadSafe
public class Error {
    public static final int API_VERSION = 1;
    private int statusCode;
    private int errorCode;
    private String message;
    private List<String> details;
    private String remediation;
    private Links links;
    private static final Links EMPTY_LINKS = new Links(Collections.unmodifiableList(new ArrayList(0)));

    public Error() {
        this(400, 0, "", null, null, new Links());
    }

    public Error(int statusCode, int errorCode, @NonNull String message) {
        this(statusCode, errorCode, message, null, null, new Links());
    }

    public Error(int statusCode, int errorCode, @NonNull String message, List<String> details, String remediation, Links links) {
        this.setHttpStatusCode(statusCode);
        this.setErrorCode(errorCode);
        this.setMessage(message);
        this.setDetails(details);
        this.setRemediation(remediation);
        this._setLinks(links);
    }

    @XmlAttribute
    public int getHttpStatusCode() {
        return this.statusCode;
    }

    public void setHttpStatusCode(int statusCode) {
        this.statusCode = statusCode;
    }

    @XmlAttribute
    public int getErrorCode() {
        return this.errorCode;
    }

    public void setErrorCode(int errorCode) {
        this.errorCode = errorCode;
    }

    @NonNull
    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    @XmlElementWrapper(name="details")
    @XmlElement(name="detail")
    @NonNull
    public List<String> getDetails() {
        return this.details;
    }

    public void setDetails(List<String> details) {
        this.details = details == null ? new ArrayList() : details;
    }

    public String getRemediation() {
        return this.remediation;
    }

    public void setRemediation(String remediation) {
        this.remediation = remediation == null ? "" : remediation;
    }

    @XmlElementWrapper(name="links")
    @XmlElement(name="link")
    @NonNull
    public List<Link> getLinks() {
        return this.links.getLinks();
    }

    public void setLinks(List<Link> links) {
        this.links = new Links(links);
    }

    private void _setLinks(Links links) {
        this.links = links == null ? EMPTY_LINKS : links;
    }

    public int getVersion() {
        return 1;
    }

    public void setVersion(int v) {
        assert (v == 1);
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("version", this.getVersion()).append("status", this.getHttpStatusCode()).append("err", this.getErrorCode()).append("message", (Object)this.getMessage()).append("detail", this.getDetails()).append("remediation", (Object)this.getRemediation()).append("links", this.getLinks()).toString();
    }
}

