/*
 * Decompiled with CFR 0.152.
 */
package com.sas.commons.rest.util;

import com.sas.commons.rest.links.Link;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlElementWrapper;
import jakarta.xml.bind.annotation.XmlRootElement;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.ToStringBuilder;

@XmlRootElement(name="resources")
public class Api
implements Serializable {
    private static final long serialVersionUID = 6005689160427817893L;
    public static final String MEDIA_TYPE_BASE_VALUE = "application/vnd.sas.api";
    public static final String MEDIA_TYPE_JSON_VALUE = "application/vnd.sas.api+json";
    public static final String MEDIA_TYPE_XML_VALUE = "application/vnd.sas.api+xml";
    public static final int VERSION = 1;
    private int version = 1;
    private List<Link> links;

    public Api() {
        this(new ArrayList<Link>(4));
    }

    public Api(List<Link> links) {
        this.setLinks(links);
    }

    public Api(Link ... links) {
        this.setLinks(links == null ? new ArrayList<Link>(4) : new ArrayList<Link>(Arrays.asList(links)));
    }

    @XmlAttribute
    public int getVersion() {
        return this.version;
    }

    public void setVersion(int version) {
        if (version != 1) {
            throw new IllegalArgumentException(this.getClass().getName() + " version != " + 1);
        }
        this.version = version;
    }

    @XmlElementWrapper(name="links")
    @XmlElement(name="link")
    public List<Link> getLinks() {
        return this.links;
    }

    public Api add(Link link) {
        this.links.add(link);
        return this;
    }

    public void clear() {
        this.links.clear();
    }

    public int size() {
        return this.links.size();
    }

    public Link get(int i) {
        return this.links.get(i);
    }

    public boolean equals(Object obj) {
        if (obj == null || obj.getClass() != Api.class) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        Api rhs = (Api)obj;
        return new EqualsBuilder().append(this.links, rhs.links).isEquals();
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("elements", this.links).toString();
    }

    public int hashCode() {
        return this.links.hashCode();
    }

    public void setLinks(List<Link> links) {
        this.links = links == null ? new ArrayList<Link>(4) : links;
    }

    public static Api emptyList() {
        return new Api(new ArrayList<Link>());
    }
}

