/*
 * Decompiled with CFR 0.152.
 */
package com.sas.commons.rest.spring;

import com.sas.commons.rest.apimeta.ApiMeta;
import com.sas.commons.rest.apimeta.MediaType;
import com.sas.commons.rest.apimeta.MediaTypes;
import com.sas.commons.rest.links.Link;
import com.sas.commons.rest.links.Links;
import com.sas.commons.rest.spring.Constants;
import com.sas.commons.rest.util.Properties;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.List;
import java.util.Map;
import org.apache.commons.text.StringEscapeUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@RequestMapping(value={"/apiMeta"})
@Controller
public class ApiMetaController {
    private static final Logger logger = LogManager.getLogger(ApiMetaController.class);

    @RequestMapping(value={""}, method={RequestMethod.GET}, produces={"application/xml", "application/json"})
    @ResponseBody
    public ResponseEntity<ApiMeta> getApiMeta() {
        try {
            ApiMeta apiMeta = ApiMeta.getInstance();
            return new ResponseEntity((Object)apiMeta, (HttpStatusCode)HttpStatus.OK);
        }
        catch (IOException e) {
            logger.error((Object)e);
            return new ResponseEntity((HttpStatusCode)HttpStatus.NOT_FOUND);
        }
    }

    @RequestMapping(value={"/versions"}, method={RequestMethod.GET}, produces={"application/xml", "application/json"})
    @ResponseBody
    public ResponseEntity<Properties> getVersions() {
        Properties props = null;
        try {
            ApiMeta apiMeta = ApiMeta.getInstance();
            String version = apiMeta.get("version");
            props = new Properties("version", version);
            for (MediaType mt : apiMeta.getMediaTypes()) {
                version = Integer.toString(mt.getVersion());
                if (mt.isDeprecated()) {
                    props.put(mt.getName(), version + ".deprecated");
                    continue;
                }
                props.put(mt.getName(), version);
            }
        }
        catch (IOException e) {
            logger.error((Object)e);
            return new ResponseEntity((HttpStatusCode)HttpStatus.NOT_FOUND);
        }
        return new ResponseEntity((Object)props, (HttpStatusCode)HttpStatus.OK);
    }

    @RequestMapping(value={"/mediaTypes"}, method={RequestMethod.GET}, produces={"application/xml", "application/json"})
    @ResponseBody
    public ResponseEntity<MediaTypes> getMediaTypes() {
        try {
            ApiMeta apiMeta = ApiMeta.getInstance();
            List<MediaType> vs = apiMeta.getMediaTypes();
            MediaTypes c = new MediaTypes(vs);
            return new ResponseEntity((Object)c, (HttpStatusCode)HttpStatus.OK);
        }
        catch (IOException e) {
            logger.error((Object)e);
            return new ResponseEntity((HttpStatusCode)HttpStatus.NOT_FOUND);
        }
    }

    @RequestMapping(value={"/version"}, method={RequestMethod.GET}, produces={"text/plain"})
    @ResponseBody
    public ResponseEntity<String> getVersionAsText() {
        return this.getPropertyText("version");
    }

    @RequestMapping(value={"/version"}, method={RequestMethod.GET}, produces={"application/xml", "application/json"})
    @ResponseBody
    public ResponseEntity<Properties> getVersionAsXMLorJSON() {
        return this.getProperty("version");
    }

    private ResponseEntity<Properties> getProperty(String propertyName) {
        try {
            ApiMeta apiMeta = ApiMeta.getInstance();
            String val = apiMeta.get(propertyName);
            if (val != null) {
                Properties map = new Properties(propertyName, val);
                return new ResponseEntity((Object)map, (HttpStatusCode)HttpStatus.OK);
            }
        }
        catch (NullPointerException e) {
            logger.error((Object)e);
        }
        catch (IOException e) {
            logger.error((Object)e);
        }
        return new ResponseEntity((HttpStatusCode)HttpStatus.NOT_FOUND);
    }

    @RequestMapping(value={"/properties"}, method={RequestMethod.GET}, produces={"application/xml", "application/json"})
    @ResponseBody
    public ResponseEntity<Properties> getPropertiesAsXmlOrJson() {
        try {
            ApiMeta apiMeta = ApiMeta.getInstance();
            return new ResponseEntity((Object)new Properties(apiMeta.properties()), (HttpStatusCode)HttpStatus.OK);
        }
        catch (IOException e) {
            logger.error((Object)e);
            return new ResponseEntity((HttpStatusCode)HttpStatus.NOT_FOUND);
        }
    }

    @RequestMapping(value={"/properties"}, method={RequestMethod.GET}, produces={"text/html"})
    @ResponseBody
    public ResponseEntity<String> getPropertiesAsHtml() {
        try {
            ApiMeta apiMeta = ApiMeta.getInstance();
            String propsAsHTML = apiMeta.toString();
            return new ResponseEntity((Object)propsAsHTML, (MultiValueMap)Constants.TEXT_HTML_HEADER, (HttpStatusCode)HttpStatus.OK);
        }
        catch (IOException e) {
            logger.error((Object)e);
            return new ResponseEntity((HttpStatusCode)HttpStatus.NOT_FOUND);
        }
    }

    @RequestMapping(value={"/properties/{propertyName}"}, method={RequestMethod.GET}, produces={"application/xml", "application/json"})
    @ResponseBody
    public ResponseEntity<Properties> getPropertyAsXmlOrJson(@PathVariable(value="propertyName") String propertyName) {
        return this.getProperty(propertyName);
    }

    @RequestMapping(value={"/properties/{propertyName}"}, method={RequestMethod.GET}, produces={"text/plain"})
    @ResponseBody
    public ResponseEntity<String> getPropertyTextPlain(@PathVariable(value="propertyName") String propertyName) {
        return this.getPropertyText(StringEscapeUtils.escapeHtml4((String)propertyName));
    }

    private ResponseEntity<String> getPropertyText(String propertyName) {
        try {
            ApiMeta apiMeta = ApiMeta.getInstance();
            String value = apiMeta.get(propertyName);
            if (value != null) {
                return new ResponseEntity((Object)StringEscapeUtils.escapeHtml4((String)value.toString()), (HttpStatusCode)HttpStatus.OK);
            }
        }
        catch (IOException e) {
            logger.error((Object)e);
        }
        return new ResponseEntity((HttpStatusCode)HttpStatus.NOT_FOUND);
    }

    @RequestMapping(value={"/resources"}, method={RequestMethod.GET}, produces={"application/vnd.sas.collection+xml", "application/vnd.sas.collection+json", "application/xml", "application/json"})
    @ResponseBody
    public ResponseEntity<Links> getResources() {
        try {
            ApiMeta apiMeta = ApiMeta.getInstance();
            Links links = new Links();
            for (String resource : apiMeta.getResources()) {
                String uri = '/' + resource;
                links.add(new Link("GET", resource, uri));
            }
            return new ResponseEntity((Object)links, (HttpStatusCode)HttpStatus.OK);
        }
        catch (IOException e) {
            logger.error((Object)e);
            return new ResponseEntity((HttpStatusCode)HttpStatus.NOT_FOUND);
        }
    }

    @RequestMapping(value={"/doc"}, method={RequestMethod.GET}, produces={"application/vnd.sas.collection+xml", "application/vnd.sas.collection+json", "application/xml", "application/json"})
    @ResponseBody
    public ResponseEntity<Links> getDocCollection() {
        try {
            ApiMeta apiMeta = ApiMeta.getInstance();
            Links links = new Links();
            Map<String, String> doc = apiMeta.resourceDocs();
            for (Map.Entry<String, String> e : doc.entrySet()) {
                String resource = e.getKey();
                String docLoc = e.getValue();
                Link l = null;
                try {
                    URL url = new URL(docLoc);
                    l = url.getProtocol() == null ? new Link("GET", resource, url.getPath()) : new Link("GET", resource, url.getPath(), docLoc);
                }
                catch (MalformedURLException m) {
                    if (!docLoc.startsWith("/")) {
                        docLoc = '/' + docLoc;
                    }
                    l = new Link("GET", resource, docLoc);
                }
                links.add(l);
            }
            return new ResponseEntity((Object)links, (HttpStatusCode)HttpStatus.OK);
        }
        catch (IOException e) {
            logger.error((Object)e);
            return new ResponseEntity((HttpStatusCode)HttpStatus.NOT_FOUND);
        }
    }
}

