/*
 * Decompiled with CFR 0.152.
 */
package com.sas.commons.rest.links;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.sas.commons.rest.links.ApplicationBaseUrl;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlRootElement;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.ToStringBuilder;

@XmlRootElement(name="link")
public class Link {
    @NonNull
    private String method;
    @NonNull
    private String rel;
    @NonNull
    private String href;
    @Nullable
    private String uri;
    @Nullable
    private String type;
    @Nullable
    private String responseType;
    @Nullable
    private String itemType;
    @Nullable
    private String responseItemType;
    @Nullable
    private String title;

    public Link() {
    }

    public Link(@Nullable String method, @NonNull String rel, @NonNull String uri) {
        this(method, rel, uri, ApplicationBaseUrl.getUrl() + uri);
        if (uri.length() > 0 && !uri.startsWith("/")) {
            throw new IllegalArgumentException("uri must be \"\" or start with '/'");
        }
    }

    public Link(@Nullable String method, @NonNull String rel, @NonNull String uri, @NonNull String href) {
        this.setMethod(method);
        this.setRel(rel);
        this.setUri(uri);
        this.setHref(href);
    }

    public Link(@Nullable String method, @NonNull String rel, @NonNull String uri, @NonNull String href, @Nullable String title) {
        this.setMethod(method);
        this.setRel(rel);
        this.setUri(uri);
        this.setHref(href);
        this.setTitle(title);
    }

    public Link(String method, @NonNull String rel) {
        this(method, rel, "/");
    }

    @XmlAttribute
    @NonNull
    public String getMethod() {
        return this.method;
    }

    @XmlAttribute(required=true)
    @NonNull
    public String getRel() {
        return this.rel;
    }

    @XmlAttribute(required=true)
    @NonNull
    public String getHref() {
        return this.href != null ? this.href : ApplicationBaseUrl.getUrl() + this.getUri();
    }

    @XmlAttribute
    @NonNull
    public String getUri() {
        return this.uri;
    }

    @XmlAttribute(required=false)
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @Nullable
    public String getType() {
        return this.type;
    }

    @XmlAttribute(required=false)
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @Nullable
    public String getResponseType() {
        return this.responseType;
    }

    @XmlAttribute(required=false)
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @Nullable
    public String getItemType() {
        return this.itemType;
    }

    @XmlAttribute(required=false)
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @Nullable
    public String getResponseItemType() {
        return this.responseItemType;
    }

    @XmlAttribute(required=false)
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @Nullable
    public String getTitle() {
        return this.title;
    }

    public void setMethod(@NonNull String method) {
        this.method = method == null || "".equals(method) ? "GET" : method.toUpperCase();
    }

    public void setRel(@NonNull String rel) {
        assert (rel != null);
        this.rel = rel;
    }

    public void setHref(@NonNull String href) {
        assert (href == null || this.uri == null || href.endsWith(this.uri));
        this.href = href;
    }

    public void setUri(@NonNull String uri) {
        assert (uri != null);
        assert (uri.length() == 0 || uri.startsWith("/"));
        this.uri = uri;
    }

    public void setType(@Nullable String type) {
        this.type = type;
    }

    @Nullable
    public void setResponseType(String responseType) {
        this.responseType = responseType;
    }

    @Nullable
    public void setItemType(String itemType) {
        this.itemType = itemType;
    }

    @Nullable
    public void setResponseItemType(String responseItemType) {
        this.responseItemType = responseItemType;
    }

    public void setTitle(@Nullable String title) {
        this.title = title;
    }

    public boolean equals(Object obj) {
        if (obj == null || obj.getClass() != Link.class) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        Link rhs = (Link)obj;
        return new EqualsBuilder().append((Object)this.method, (Object)rhs.method).append((Object)this.rel, (Object)rhs.rel).append((Object)this.uri, (Object)rhs.uri).append((Object)this.getHref(), (Object)rhs.getHref()).append((Object)this.getType(), (Object)rhs.getType()).append((Object)this.getTitle(), (Object)rhs.getTitle()).isEquals();
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("method", (Object)this.method).append("rel", (Object)this.rel).append("uri", (Object)this.uri).append("href", (Object)this.getHref()).append("type", (Object)this.getType()).append("title", (Object)this.getTitle()).toString();
    }

    public int hashCode() {
        return this.rel.hashCode() + this.method.hashCode() + this.uri.hashCode() + this.getHref().hashCode();
    }
}

