/*
 * Decompiled with CFR 0.152.
 */
package com.sas.commons.rest.links;

import com.sas.commons.rest.links.ApplicationBaseUrl;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.support.ServletUriComponentsBuilder;
import org.springframework.web.util.UriComponents;

public class BaseUrlConfiguration
implements HandlerInterceptor {
    private String baseUrlFormat;

    public void setBaseUrlFormat(String baseUrlFormat) {
        this.baseUrlFormat = baseUrlFormat == null || baseUrlFormat.trim().length() == 0 ? null : baseUrlFormat;
    }

    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {
        String baseUrl = ApplicationBaseUrl.getUrl();
        if (baseUrl == null) {
            baseUrl = this.baseUrlFromContext(request);
        }
        ApplicationBaseUrl.setUrl(baseUrl);
        return true;
    }

    private String baseUrlFromContext(HttpServletRequest request) {
        String baseUrl;
        if (this.baseUrlFormat == null) {
            baseUrl = ServletUriComponentsBuilder.fromContextPath((HttpServletRequest)request).build().toUriString();
        } else {
            UriComponents uric = ServletUriComponentsBuilder.fromContextPath((HttpServletRequest)request).build();
            baseUrl = String.format(this.baseUrlFormat, uric.getScheme(), uric.getHost(), this.portString(uric.getPort()), uric.getPath());
        }
        return baseUrl;
    }

    private String portString(int port) {
        String portStr = port == 8080 ? "8080" : (port == 80 || port == -1 ? "80" : Integer.toString(port));
        return portStr;
    }

    public void afterCompletion(HttpServletRequest request, HttpServletResponse response, Object handler, Exception ex) throws Exception {
        ApplicationBaseUrl.clear();
    }
}

