/*
 * Decompiled with CFR 0.152.
 */
package com.sas.commons.rest.expr;

import com.sas.commons.antlr.ParseException;
import com.sas.commons.expr.BooleanExpression;
import com.sas.commons.expr.Expression;
import com.sas.commons.expr.Function;
import com.sas.commons.expr.SimpleName;
import com.sas.commons.expr.StringExpression;
import com.sas.commons.expr.parser.ExprParser;
import edu.umd.cs.findbugs.annotations.NonNull;
import jakarta.servlet.http.HttpServletRequest;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;

public class QueryExpression {
    private static final SimpleName IN = new SimpleName("in");
    private static final SimpleName AND = new SimpleName("and");
    private static final SimpleName EQ = new SimpleName("eq");
    private static final String[] NONE = new String[0];
    private final String[] queryFields;

    public QueryExpression(String ... queryFields) {
        this.queryFields = queryFields == null ? NONE : queryFields;
    }

    @NonNull
    public Expression build(@NonNull HttpServletRequest request, String queryParameterName) throws ParseException {
        Expression filter = null;
        String filterParam = null;
        if (queryParameterName != null && (filterParam = request.getParameter(queryParameterName)) != null) {
            try {
                filter = this.parseFilterExpression(filterParam);
            }
            catch (IOException e) {
                throw new ParseException(e.getMessage());
            }
        }
        if (this.queryFields.length > 0) {
            filter = this.queryParametersAsExpression(request, filter);
        }
        return filter;
    }

    @NonNull
    private Expression queryParametersAsExpression(@NonNull HttpServletRequest request, Expression seed) throws ParseException {
        ArrayList<Expression> args = new ArrayList<Expression>();
        for (String fieldName : this.queryFields) {
            String[] params = request.getParameterValues(fieldName);
            if (params == null) continue;
            for (String param : params) {
                args.add(this.eq(fieldName, param));
            }
        }
        return this.combine(seed, args);
    }

    @NonNull
    private Expression combine(Expression seed, List<Expression> args) {
        if (args == null) {
            if (seed == null) {
                return BooleanExpression.TRUE();
            }
            return seed;
        }
        if (seed == null) {
            if (args.size() == 1) {
                return args.get(0);
            }
            return new Function(AND, args);
        }
        args.add(seed);
        return new Function(AND, args);
    }

    @NonNull
    private Expression eq(@NonNull String fieldName, @NonNull String param) throws ParseException {
        if (param.indexOf(124) > -1) {
            return this.in(fieldName, param);
        }
        return new Function(EQ, new Expression[]{new SimpleName(fieldName), this.quote(param, fieldName)});
    }

    @NonNull
    private Expression quote(@NonNull String param, String fieldName) throws ParseException {
        if (param.indexOf(34) > -1) {
            throw new ParseException(String.format("Quotes not allowed in query parameter %s=%s", fieldName, param));
        }
        return new StringExpression(param);
    }

    @NonNull
    private Expression in(@NonNull String fieldName, @NonNull String param) {
        StringTokenizer t = new StringTokenizer(param, "|", false);
        ArrayList<Object> es = new ArrayList<Object>();
        es.add(new SimpleName(fieldName));
        while (t.hasMoreTokens()) {
            String token = t.nextToken();
            es.add(new StringExpression(token));
        }
        return new Function(IN, es);
    }

    private Expression parseFilterExpression(String param) throws IOException, ParseException {
        ExprParser parser = this.getParser(param);
        Expression expression = this.getParser(parser);
        return expression;
    }

    private ExprParser getParser(String param) throws IOException {
        return ExprParser.from((String)param);
    }

    private Expression getParser(ExprParser parser) throws ParseException {
        return parser.parse();
    }
}

