/*
 * Decompiled with CFR 0.152.
 */
package com.sas.commons.rest.cas;

import com.sas.commons.rest.cas.CasServiceTicketProvider;
import com.sas.commons.rest.cas.SecurityContextHolderCasTicketProvider;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.http.HttpMethod;
import org.springframework.web.client.RequestCallback;
import org.springframework.web.client.ResponseExtractor;
import org.springframework.web.client.RestClientException;
import org.springframework.web.client.RestTemplate;

public class TicketingRestTemplate
extends RestTemplate {
    public static final String AMP_TICKET = "&ticket=";
    public static final String Q_TICKET = "?ticket=";
    private Logger logger = LogManager.getLogger(((Object)((Object)this)).getClass());
    private CasServiceTicketProvider ticketProvider = new SecurityContextHolderCasTicketProvider();
    private List<String> serviceUriFragments = new ArrayList<String>();

    public TicketingRestTemplate() {
    }

    public TicketingRestTemplate(@NonNull String serviceUriFragment) {
        this();
        this.serviceUriFragments.add(serviceUriFragment);
    }

    public TicketingRestTemplate(@NonNull List<String> serviceUriFragments) {
        this();
        this.serviceUriFragments = serviceUriFragments;
    }

    protected <T> T doExecute(URI uri, String uriTemplate, HttpMethod method, RequestCallback requestCallback, ResponseExtractor<T> responseExtractor) throws RestClientException {
        String restServiceURI = uri.toString();
        URI ticketedUri = uri;
        if (this.needsTicket(uri)) {
            String ticket = this.getServiceTicketFor(restServiceURI);
            if (null != ticket) {
                String ticketedUriStr = restServiceURI.contains("?") ? restServiceURI + AMP_TICKET + ticket : restServiceURI + Q_TICKET + ticket;
                try {
                    ticketedUri = new URI(ticketedUriStr);
                }
                catch (URISyntaxException e) {
                    this.logger.error("Couldn't instantiate a new ticketed URI from \"" + ticketedUriStr + "\".  Falling back to the unticketed version: \"" + restServiceURI + "\"", (Throwable)e);
                    ticketedUri = uri;
                }
            } else {
                this.logger.error("Couldn't get a service ticket for the REST \"" + restServiceURI + "\" service.  The serviceUriFragments=" + this.serviceUriFragments);
            }
        }
        return (T)super.doExecute(ticketedUri, uriTemplate, method, requestCallback, responseExtractor);
    }

    private String getServiceTicketFor(String restServiceURI) {
        String st = this.ticketProvider.getServiceTicketFor(restServiceURI);
        if (null != st) {
            try {
                return URLEncoder.encode(st, "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                this.logger.error("Couldn't URL-encode the service ticket for the REST \"" + restServiceURI + "\" service.  The serviceUriFragments=" + this.serviceUriFragments);
            }
        }
        return null;
    }

    private boolean needsTicket(URI uri) {
        String path = uri.getPath();
        for (String fragment : this.serviceUriFragments) {
            if (!path.startsWith(fragment)) continue;
            return true;
        }
        return false;
    }

    public void setTicketProvider(CasServiceTicketProvider ticketProvider) {
        this.ticketProvider = ticketProvider;
    }
}

