/*
 * Decompiled with CFR 0.152.
 */
package com.sas.commons.rest.apimeta;

import com.sas.commons.rest.apimeta.ApiMeta;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlRootElement;
import net.jcip.annotations.Immutable;

@XmlRootElement(name="mediaType")
@Immutable
public class MediaType {
    public static final String DEPRECATED_SUFFIX = ".deprecated";
    private final ApiMeta apiMeta;
    private final String name;
    private final int version;
    private final boolean deprecated;

    public MediaType() {
        this(null, null, null);
    }

    public MediaType(ApiMeta apiMeta, String name, String version) {
        this.apiMeta = apiMeta;
        this.name = name;
        if (version == null) {
            this.version = 1;
            this.deprecated = false;
        } else {
            version = version.trim();
            this.deprecated = version.endsWith(DEPRECATED_SUFFIX);
            if (this.deprecated) {
                version = version.substring(0, version.length() - DEPRECATED_SUFFIX.length());
            }
            this.version = Integer.valueOf(version);
        }
    }

    @XmlAttribute
    public String getName() {
        return this.name;
    }

    @XmlAttribute
    public int getVersion() {
        return this.version;
    }

    @XmlAttribute
    public boolean isDeprecated() {
        return this.deprecated;
    }

    @XmlAttribute
    public String getDocUrl() {
        return this.apiMeta.get(this.getName() + "." + this.getVersion() + ".docUrl");
    }

    public String toString() {
        return String.format("[%s, version=%d, deprecated=%b]", this.getName(), this.getVersion(), this.isDeprecated());
    }

    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (other.getClass() != MediaType.class) {
            return false;
        }
        MediaType m = (MediaType)other;
        return m.getName().equals(this.getName()) && m.getVersion() == this.getVersion() && m.isDeprecated() == this.isDeprecated();
    }
}

