/*
 * Decompiled with CFR 0.152.
 */
package com.sas.commons.rest.apimeta;

import com.sas.commons.rest.apimeta.MediaType;
import edu.umd.cs.findbugs.annotations.NonNull;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlElementWrapper;
import jakarta.xml.bind.annotation.XmlRootElement;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@XmlRootElement(name="apiMeta")
public class ApiMeta {
    private static final String API_META_CONFIG = "/apiMeta.config";
    private static final Logger logger = LogManager.getLogger(ApiMeta.class);
    private Properties properties;
    private static int API_VERSION = 1;

    @NonNull
    public static ApiMeta getInstance() throws IOException {
        InputStream is = ApiMeta.class.getResourceAsStream(API_META_CONFIG);
        try {
            Properties properties = new Properties();
            properties.load(is);
            return ApiMeta.apiMetaFrom(properties);
        }
        catch (NullPointerException e) {
            logger.error(API_META_CONFIG);
            throw new IOException("/apiMeta.config not found");
        }
        catch (IOException e) {
            logger.error((Object)e);
            throw e;
        }
    }

    @NonNull
    public static ApiMeta apiMetaFrom(Properties properties) throws IOException {
        ApiMeta apimeta = new ApiMeta();
        apimeta.properties = properties;
        return apimeta;
    }

    @XmlElementWrapper(name="resources")
    @XmlElement(name="resource")
    @NonNull
    public List<String> getResources() {
        return this.keyToList("resources");
    }

    @XmlElementWrapper(name="mediaTypeNames")
    @XmlElement(name="mediaTypeName")
    @NonNull
    public List<String> getMediaTypeNames() {
        return this.keyToList("mediaTypes");
    }

    @XmlAttribute
    public int getVersion() {
        return API_VERSION;
    }

    @XmlAttribute
    public int getApiVersion() {
        String vs = this.get("version");
        int v = 0;
        try {
            v = Integer.valueOf(vs);
        }
        catch (NullPointerException npe) {
            ApiMeta.missingProperty("version");
        }
        catch (NumberFormatException n) {
            logger.error(String.format("The version value in in apiMeta.config, '%s', is not an integer value.", vs));
        }
        return v;
    }

    public String get(@NonNull String name) {
        return this.properties.getProperty(name);
    }

    @XmlElementWrapper(name="mediaTypes")
    @XmlElement(name="mediaType")
    public List<MediaType> getMediaTypes() {
        List<String> mts = this.getMediaTypeNames();
        ArrayList<MediaType> mtl = new ArrayList<MediaType>();
        for (String mt : mts) {
            String versions = this.get(mt + ".versions");
            if (versions == null) continue;
            for (String version : versions.split(",")) {
                MediaType t = new MediaType(this, mt, version.trim());
                mtl.add(t);
            }
        }
        return mtl;
    }

    @NonNull
    private List<String> keyToList(@NonNull String key) {
        try {
            String value = this.get(key);
            ArrayList<String> rs = new ArrayList<String>();
            for (String val : value.split(",")) {
                rs.add(val.trim());
            }
            return rs;
        }
        catch (NullPointerException npe) {
            ApiMeta.missingProperty(key);
            return Collections.emptyList();
        }
    }

    private static void missingProperty(@NonNull String key) {
        logger.error(String.format("%s is missing the expected property, '%s'", API_META_CONFIG, key));
    }

    @NonNull
    public Map<String, String> resourceDocs() {
        return this.listToMap(this.getResources(), "docUrl");
    }

    public String resourceDocUrl(@NonNull String resource) {
        return this.get(resource + ".docUrl");
    }

    private Map<String, String> listToMap(@NonNull List<String> keys, @NonNull String subKey) {
        HashMap<String, String> map = new HashMap<String, String>(keys.size());
        for (String k : keys) {
            String compositeKey = k + "." + subKey;
            String val = this.get(compositeKey);
            if (val == null) continue;
            map.put(k, val);
        }
        return map;
    }

    public Properties properties() {
        return this.properties;
    }
}

