/*
 * Decompiled with CFR 0.152.
 */
package com.sas.text;

import java.text.FieldPosition;
import java.text.Format;
import java.text.MessageFormat;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public class LocalizableException
extends Exception {
    private String bundleName;
    private String resourceName;
    private Object[] messageArguments;
    private ClassLoader classLoader;

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public void setClassLoader(ClassLoader _classLoader) {
        this.classLoader = _classLoader;
    }

    public LocalizableException() {
    }

    public LocalizableException(String message) {
        super(message);
    }

    public LocalizableException(String bundleName, String resourceName, Object[] args, ClassLoader classLoader) {
        this.setMessage(bundleName, resourceName, args, classLoader);
    }

    public LocalizableException(String message, Throwable cause) {
        super(message, cause);
    }

    public String getBundleName() {
        return this.bundleName;
    }

    public void setBundleName(String _bundleName) {
        this.bundleName = _bundleName;
    }

    public String getResourceName() {
        return this.resourceName;
    }

    public void setResourceName(String _resourceName) {
        this.resourceName = _resourceName;
    }

    public Object[] getMessageArguments() {
        return this.messageArguments;
    }

    public void setMessageArguments(Object[] _messageArguments) {
        this.messageArguments = _messageArguments;
    }

    public void setMessage(String bundleName, String resourceName, Object[] args) {
        this.setBundleName(bundleName);
        this.setResourceName(resourceName);
        this.setMessageArguments(args);
    }

    public void setMessage(String bundleName, String resourceName, Object[] args, ClassLoader classLoader) {
        this.setBundleName(bundleName);
        this.setResourceName(resourceName);
        this.setMessageArguments(args);
        this.setClassLoader(classLoader);
    }

    protected String getDefaultMessage() {
        if (super.getMessage() != null) {
            return super.getMessage();
        }
        return this.getBundleName() + ": " + this.getResourceName();
    }

    @Override
    public String getMessage() {
        return this.getMessage(Locale.getDefault());
    }

    public String getMessage(Locale locale) {
        String message;
        block10: {
            ResourceBundle bundle = this.getResourceBundle(locale);
            if (null == bundle) {
                bundle = this.getResourceBundle(Locale.ENGLISH);
            }
            String format = null;
            if (null != bundle) {
                try {
                    format = bundle.getString(this.getResourceName());
                }
                catch (MissingResourceException missingResourceException) {
                    // empty catch block
                }
            }
            if (null == format) {
                format = super.getMessage();
            }
            message = null;
            if (null != format) {
                try {
                    int nArgs;
                    MessageFormat msgFmt = new MessageFormat(format);
                    Format[] formats = msgFmt.getFormats();
                    int n = nArgs = null == this.messageArguments ? 0 : this.messageArguments.length;
                    if (formats.length < nArgs) {
                        message = this.constructFallbackMessage();
                        break block10;
                    }
                    message = msgFmt.format(this.messageArguments, new StringBuffer(), (FieldPosition)null).toString();
                }
                catch (IllegalArgumentException ex) {
                    message = this.constructFallbackMessage();
                }
            } else {
                message = this.constructFallbackMessage();
            }
        }
        return message;
    }

    private ResourceBundle getResourceBundle(Locale locale) {
        ResourceBundle bundle = null;
        try {
            bundle = this.getClassLoader() != null ? ResourceBundle.getBundle(this.getBundleName(), locale, this.getClassLoader()) : ResourceBundle.getBundle(this.getBundleName(), locale);
        }
        catch (NullPointerException nullPointerException) {
        }
        catch (MissingResourceException missingResourceException) {
            // empty catch block
        }
        return bundle;
    }

    private String constructFallbackMessage() {
        StringBuffer buf = new StringBuffer();
        buf.append(this.getBundleName());
        buf.append(": ");
        buf.append(this.getResourceName());
        buf.append(" Parameters ");
        Object[] args = this.getMessageArguments();
        if (args != null) {
            for (int i = 0; i < args.length; ++i) {
                if (i != 0) {
                    buf.append(" ");
                }
                buf.append(args[i].toString());
            }
        }
        return buf.toString();
    }
}

