/*
 * Decompiled with CFR 0.152.
 */
package com.sas.entities;

import com.sas.codepolicy.SASScope;
import com.sas.entities.AttributeDescriptorInterface;
import com.sas.entities.AttributeGroupInterface;
import java.util.HashMap;
import java.util.Map;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;

@SASScope
public class EntityUtil {
    public static final String PROMPT_VALUE_UPCASED = "promptValueUpperCased";
    public static final String PROMPT_VALUES_DISPLAY_FORMATTED = "promptValuesDisplayFormatted";
    public static final String MULTIPLE_PROMPT_VALUES_SELECTABLE = "multiplePromptValuesSelectable";
    public static final String MULTI_VALUE_STRUCTURED = "multiValueStructured";
    public static final String SAS_EDITOR_EXTENDED_PROPERTIES = "SASEditorExtendedProperties";
    public static final String SAS_EDITOR_INSTRUCTION_TEXT = "SASEditorInstructionText";

    public static DefaultTreeModel getAttributeGroupsTreeModel(AttributeGroupInterface agi) {
        DefaultMutableTreeNode root = new DefaultMutableTreeNode(agi);
        DefaultTreeModel treeModel = new DefaultTreeModel(root);
        if (agi.isVisible()) {
            EntityUtil.addSubgroupAsNode(root, agi, false, false);
        }
        return treeModel;
    }

    @SASScope
    public static DefaultTreeModel getAttributeGroupsTreeModel(AttributeGroupInterface agi, boolean displayExpert, boolean addNodesToEndOfGroup) {
        DefaultMutableTreeNode root = new DefaultMutableTreeNode(agi);
        DefaultTreeModel treeModel = new DefaultTreeModel(root);
        EntityUtil.addSubgroupAsNode(root, agi, false, addNodesToEndOfGroup);
        return treeModel;
    }

    public static DefaultTreeModel getAttributeGroupsTreeModel(AttributeGroupInterface agi, boolean displayExpert) {
        DefaultMutableTreeNode root = new DefaultMutableTreeNode(agi);
        DefaultTreeModel treeModel = new DefaultTreeModel(root);
        EntityUtil.addSubgroupAsNode(root, agi, displayExpert, false);
        return treeModel;
    }

    protected static void addSubgroupAsNode(DefaultMutableTreeNode parentNode, AttributeGroupInterface agi, boolean displayExpert, boolean addNodesToEndOfGroup) {
        AttributeGroupInterface[] subgroups = agi.getAttributeGroups();
        int subgroupSize = subgroups.length;
        DefaultMutableTreeNode newNode = null;
        for (int i = 0; i < subgroupSize; ++i) {
            if (!displayExpert && (displayExpert || subgroups[i].isExpert())) continue;
            newNode = new DefaultMutableTreeNode(subgroups[i]);
            if (addNodesToEndOfGroup) {
                parentNode.add(newNode);
            } else {
                parentNode.insert(newNode, 0);
            }
            EntityUtil.addSubgroupAsNode(newNode, subgroups[i], displayExpert, addNodesToEndOfGroup);
        }
    }

    protected static void addSubgroupAsNode(DefaultMutableTreeNode parentNode, AttributeGroupInterface agi, boolean displayExpert) {
        EntityUtil.addSubgroupAsNode(parentNode, agi, displayExpert, false);
    }

    public static Map newMap() {
        return new HashMap(8);
    }

    public static boolean attributeDescriptorHasSupplementalProperty(AttributeDescriptorInterface adi, String propertyName) {
        try {
            Object value = adi.getSupplementalProperty(propertyName);
            return true;
        }
        catch (IllegalArgumentException iae) {
            return false;
        }
    }
}

