/*
 * Decompiled with CFR 0.152.
 */
package com.sas.entities;

import com.sas.codepolicy.SASScope;
import java.util.Hashtable;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

@SASScope
public class EntityRBBase {
    private ResourceBundle resourceBundle;
    private Hashtable localeBundles;
    private static final String DEFAULT_RESOURCE_BUNDLE_NAME = "Resources";
    private String resourceBundleName;

    protected EntityRBBase() {
        this(DEFAULT_RESOURCE_BUNDLE_NAME);
    }

    protected EntityRBBase(String resourceBundleName) {
        this.resourceBundleName = resourceBundleName;
    }

    private String resourceName() {
        String className = this.getClass().getName();
        int dot = className.lastIndexOf(46);
        return dot == -1 ? this.resourceBundleName : className.substring(0, dot) + "." + this.resourceBundleName;
    }

    protected final String _getStringResource(String key) {
        return this._getStringResource(key, Locale.getDefault());
    }

    protected final String _getStringResource(String key, Locale locale) {
        try {
            return this._getResources(locale).getString(key);
        }
        catch (MissingResourceException r) {
            throw r;
        }
        catch (Exception e) {
            throw new MissingResourceException(e.getMessage(), this.resourceName(), key);
        }
    }

    protected final ResourceBundle _getResources() {
        return this._getResources(Locale.getDefault());
    }

    protected final ResourceBundle _getResources(Locale locale) {
        if (locale == null || locale.equals(Locale.getDefault())) {
            if (this.resourceBundle == null) {
                this.resourceBundle = ResourceBundle.getBundle(this.resourceName(), locale, this.getClass().getClassLoader());
            }
            return this.resourceBundle;
        }
        ResourceBundle localeBundle = null;
        if (this.localeBundles == null) {
            this.localeBundles = new Hashtable();
        } else {
            localeBundle = (ResourceBundle)this.localeBundles.get(locale);
        }
        if (localeBundle != null) {
            return localeBundle;
        }
        localeBundle = ResourceBundle.getBundle(this.resourceName(), locale, this.getClass().getClassLoader());
        this.localeBundles.put(locale, localeBundle);
        return localeBundle;
    }
}

